#!/bin/bash -eu

source "/usr/share/crypta-cm-tools/utils/cmd_utils.sh"

function print_cmd_arguments {
    local cmd_path="$1"
    local cmd="$(basename "$cmd_path")"
    if [[ $cmd_path == "$CMD_PATH" ]]; then
        cmd="cm"
    fi

    arguments="$(list_cmd_options "$cmd_path" | sed -e 's/ / | /g')"
    echo "Available arguments for '$cmd': <$arguments>"
}


function print_incorrect_cmd_help {
    local cmd_path="$1"
    local last_valid_cmd_path="$(dirname "$cmd_path")"

    print_cmd_arguments "$last_valid_cmd_path"
}


if (( $# < 1 )); then
    print_cmd_arguments "$CMD_PATH"
    exit 1
fi

cmd_script="/usr/share/crypta-cm-tools/cmd"
args="$*"
for arg in "$@"; do
    shift

    cmd_script="$cmd_script/$arg"

    if [[ ! -e "$cmd_script" ]]; then
        echo "Wrong argument given - '$arg'"
        print_incorrect_cmd_help "$cmd_script"
        exit 1
    fi

    if [[ -f "$cmd_script" ]]; then
        "$cmd_script" "$@"
        exit 0
    fi
done

if [[ -d "$cmd_script" ]]; then
    echo "No arguments given for '$args'"
    print_cmd_arguments "$cmd_script" 
    exit 1
fi
