#!/bin/bash -eu

export CMD_PATH="/usr/share/crypta-cm-tools/cmd"

function cmd_from_path() {
    (( $# < 1 )) && echo "Usage: cmd_from_path <path>" && exit 1

    echo "$1" | sed -e "s%^$CMD_PATH/%%g" | sed -e 's%/% %g'
}

function list_cmd_options {
    local cmd_path="$1"
    find "$cmd_path" -mindepth 1 -maxdepth 1 -exec basename {} \; | sort | paste -sd " "
}
