#!/bin/bash -eu

readonly PROD_DCS_REGEX='^(man|sas|vla)$'
readonly TEST_DCS_REGEX='^(man|sas)-test$'


function get_nanny_group {
    local dc_abbrev="$1"
    if [[ "$dc_abbrev" =~ $PROD_DCS_REGEX ]]; then
        echo "n:prod_crypta_cm_api_${dc_abbrev}"
    elif [[ "$dc_abbrev" =~ $TEST_DCS_REGEX ]]; then
        echo "n:test_crypta_cm_api_${dc_abbrev}"
    else
        echo "UNKNOWN_NANNY_GROUP"
    fi
}
