#!/bin/bash -eu

readonly SHMUX_TIMEOUT=3600
readonly TOOLS_EXEC_VERBOSE_MODE=${TOOLS_EXEC_VERBOSE_MODE:-false}
readonly TOOLS_EXEC_DRY_RUN_MODE=${TOOLS_EXEC_DRY_RUN_MODE:-false}
readonly DRY_RUN_ALERT="TOOLS_EXEC_DRY_RUN_MODE=true, no real action performed"

function exec_conditional {
    local command_to_execute="$@"
    [[ -z "$command_to_execute" ]] && echo "Usage: exec_conditional <command_to_execute>" && return 1

    [[ $TOOLS_EXEC_VERBOSE_MODE ]] && echo "running: $command_to_execute" || true
    if [[ $TOOLS_EXEC_DRY_RUN_MODE == true ]] ; then
        echo "$DRY_RUN_ALERT"
    else
        $@
    fi
}

function exec_remote {
    [[ $TOOLS_EXEC_VERBOSE_MODE ]] && echo "executer exec $@" || true
    if [[ $TOOLS_EXEC_DRY_RUN_MODE == false ]] ; then
        run_executer exec false "$@"
    else
        echo "$DRY_RUN_ALERT"
    fi
}

function exec_remote_read {
    run_executer exec true "$@"
}

function p_exec_remote {
    [[ $TOOLS_EXEC_VERBOSE_MODE ]] && echo "executer p_exec $@" || true
    if [[ $TOOLS_EXEC_DRY_RUN_MODE == false ]] ; then
        run_executer p_exec false "$@"
    else
        echo "$DRY_RUN_ALERT"
    fi
}

function p_exec_remote_read {
    run_executer p_exec true "$@"
}

function run_executer {
    local run_mode="$1"
    local verbose_possible="$2"
    local command_with_parameters="${@:3}"
    if [[ $verbose_possible == true && $TOOLS_EXEC_VERBOSE_MODE == true ]] ; then
        echo "executer $run_mode $command_with_parameters"
    fi
    executer_output=$(executer --quiet --shmux-timeout "$SHMUX_TIMEOUT" "$run_mode" "$command_with_parameters" < /dev/null 2>&1)
    echo "$executer_output"
    if (echo "$executer_output" | grep -iP "Summary:.*error" >/dev/null); then
        echo ""
        echo "=================================================="
        echo "↑↑↑  DETECTED ERRORS WHILE EXECUTING COMMAND!  ↑↑↑"
        echo "↑↑↑       See details in the output above!     ↑↑↑"
        echo "=================================================="
	echo ""
    fi
}
