from yt.wrapper import ypath

from crypta.data_import.proto.cars_pb2 import TCars
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import (
    schema_utils,
    yt_helpers,
)


def get_latest_navicarinfo_date(yt_client, config):
    return max(yt_client.list(config.NavicarinfoDir))


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    yt_client.create("map_node", config.Yt.TmpDir, recursive=True, ignore_existing=True)
    date = get_latest_navicarinfo_date(yt_client, config)

    with yt_client.Transaction() as tx, \
            yt_client.TempTable() as prev_data_table:
        yt_client.copy(
            config.DataTable,
            prev_data_table,
            force=True,
        )

        yt_helpers.create_empty_table(
            yt_client=yt_client,
            path=config.DataTable,
            schema=schema_utils.get_schema_from_proto(TCars, key_columns=['UserId', 'UserIdType']),
            force=True,
        )

        yql_helpers.run_query(
            query_template='/query/cars_import.yql',
            yt_config=config.Yt,
            query_params={
                'crypta_identifier_udf_url': config.CryptaIdentifierUdfUrl,
                'date': date,
                'navicarinfo_table': ypath.ypath_join(config.NavicarinfoDir, date),
                'garage_table': config.GarageTable,
                'matching_tables': config.MatchingTables,
                'prev_user_cars_table': prev_data_table,
                'user_cars_table': config.DataTable,
            },
            logger=logger,
            tx=tx,
        )

        yql_helpers.run_query(
            query_template='/query/calc_stats.yql',
            yt_config=config.Yt,
            query_params={
                'input_table': config.DataTable,
                'output_table': config.StatsTable,
                'date': date,
            },
            logger=logger,
            tx=tx,
        )
