from datetime import timedelta as dt

from crypta.lib.python.spine.juggler import juggler_check_generator
from crypta.lib.python.spine.sandbox import sandbox_scheduler


HOUR_1 = dt(hours=1)
HOURS_12 = dt(hours=12)
HOURS_48 = dt(hours=48)


def get_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(tags=["crypta-data-import"], host="crypta-data-import")

    sandbox = sandbox_scheduler.create_default_generator(juggler, ["DATA_IMPORT"])

    sandbox.create_run_universal_bundle_scheduler(
        bundle_name="data-import-realty",
        cmd=["{{cwd}}/crypta-data-import-realty", "--config", "{{cwd}}/config.yaml"],
        schedule_daily_start_time="2021-07-08T00:00:00Z",
        kill_timeout=HOURS_12,
        retry_interval=HOUR_1,
        sequential_run=True,
    ).check(crit_time=HOURS_48)

    sandbox.create_run_universal_bundle_scheduler(
        bundle_name="data-import-cars",
        cmd=["{{cwd}}/crypta-data-import-cars", "--config", "{{cwd}}/config.yaml"],
        schedule_daily_start_time="2021-08-03T12:00:00Z",
        kill_timeout=HOURS_12,
        retry_interval=HOUR_1,
        sequential_run=True,
    ).check(crit_time=HOURS_48)

    return juggler
