from utils import mr_utils as mr

OOM_CHECK = 100


def reduce_yuid_log_events_day(key, recs, dt, id_type, source_type, key_col='yuid'):
    id_values = set()
    id_key = key[key_col]
    for r in recs:
        id_value = r['id_value']
        # for hashed values
        id_prefix = r.get('id_prefix', '')
        id_orig_value = r.get('id_orig_value', '')

        id_values.add((id_value, id_prefix, id_orig_value))

        if len(id_values) > OOM_CHECK:
            return

    for id_value, id_prefix, id_orig_value in id_values:
        out = {
            key_col: id_key, 'id_type': id_type, 'id_value': id_value,
            'source_type': source_type, 'id_count': len(id_values), 'id_date': dt}
        if id_prefix:
            out['id_prefix'] = id_prefix
        if id_orig_value:
            out['id_orig_value'] = id_orig_value
        yield out


def reduce_yuid_log_events_days(key, recs, dt, source_type, id_type_to_idx, key_col='yuid'):
    id_type = key['id_type']
    for rec in reduce_yuid_log_events_day(key, recs, dt, id_type, source_type, key_col):
        rec['@table_index'] = id_type_to_idx[id_type]
        yield rec


def finalize_yuid_with_x_day_tables(tables, key_col='yuid'):
    mr.sort_all(tables, sort_by=[key_col, 'id_date'])


def reduce_device_log_events_day(keys, recs, dt, source_type):
    out_rec = dict(keys)

    hits_count = 0
    last_ts = 0
    for r in recs:
        # ts is sorted in desc order, thus first is latest one
        if not last_ts:
            last_ts = r['ts']
        hits_count += 1

    out_rec['source_type'] = source_type
    out_rec['dt'] = dt
    out_rec['hits_count'] = hits_count
    out_rec['last_ts'] = last_ts
    yield out_rec


def finalize_device_yuid_day_tables(tables):
    mr.merge_chunks_all(tables)


def reduce_change_devid(key, recs):
    devid = ''
    for rec in recs:
        if rec['@table_index'] == 0:
            devid = rec.get('devid', '')
        elif rec['@table_index'] == 1 and devid:
            rec['devid'] = devid
            rec['@table_index'] = 0
            yield rec
        else:
            rec['@table_index'] = 1
            yield rec
            return
