import luigi
import yt.wrapper as yt

from lib.luigi import base_luigi_task
from lib.luigi import yt_luigi
from rtcconf import config
from utils import mr_utils as mr


def map_bb_storage(rec):
    yuid = str(rec['yandexuid'])

    id_types_mapping = [
        (config.FIELD_NEW_SOCDEM_SEX, ['m', 'f'], config.FIELD_SOCDEM_SEX),
        (config.FIELD_NEW_SOCDEM_AGE, ["0_17", "18_24", "25_34", "35_44", "45_99"], config.FIELD_SOCDEM_AGE),
        (config.FIELD_NEW_SOCDEM_INCOME, ['A', 'B', "C"], config.FIELD_SOCDEM_INCOME),
    ]

    out_rec = {'yuid': yuid, 'id_type': config.ID_TYPE_SOCDEM}
    # basic socdem fields, keeping old style format
    for col, key_ordering, old_style_column in id_types_mapping:
        new_style_value = rec.get(col)
        out_rec[col] = new_style_value

        if new_style_value:
            old_style_value = ','.join(str(new_style_value[segment_key]) for segment_key in key_ordering)
        else:
            old_style_value = None
        out_rec[old_style_column] = old_style_value

    # other socdem field as is
    for col in [config.FIELD_PROBABILISTIC_SEGMENTS,
                config.FIELD_HEURISTIC_SEGMENTS,
                config.FIELD_INTERESTS_COMPOSITE,
                config.FIELD_EXACT_SOCDEM]:
        out_rec[col] = rec.get(col)

    yield out_rec


class ImportBBSexAgeTask(base_luigi_task.BaseTask):

    date = luigi.Parameter()

    def requires(self):
        return yt_luigi.ExternalInput(config.BB_STORAGE)

    def run(self):
        dict_folder = config.GRAPH_YT_DICTS_FOLDER
        mr.mkdir(dict_folder + 'yuid_raw')

        yt.run_map(map_bb_storage,
                   config.BB_STORAGE,
                   [dict_folder + 'yuid_raw/yuid_with_sexage'],
                   spec=mr.DATA_SIZE_PER_JOB_2GB_SPEC)

        mr.set_generate_date(dict_folder + 'yuid_raw/yuid_with_sexage', self.date)

    def output(self):
        dict_folder = config.GRAPH_YT_DICTS_FOLDER
        return [yt_luigi.YtDateTarget(dict_folder + 'yuid_raw/yuid_with_sexage', self.date)]


if __name__ == '__main__':
    yt.config.set_proxy(config.MR_SERVER)
    yt.config["tabular_data_format"] = yt.YsonFormat(process_table_index=True)

    yt.run_map(map_bb_storage,
               '//home/crypta/testing/sandbox/bb_storage/storage',
               ['//home/crypta/team/artembelov/' + 'yuid_with_sexage'],
               )
