from functools import partial

import luigi
import yt.wrapper as yt

from lib.luigi import yt_luigi
from rtcconf import config
from v2.soup import soup_config
from v2.soup.soup_tables import SoupDumpTable


def import_phone_email_dump(rec, edge_type):
    yield SoupDumpTable.make_rec(
        # hashes in fact
        rec['email'], rec['phone'], edge_type, []
    )


class ImportEmailPhoneDumpsToSoup(luigi.Task):
    date = luigi.Parameter()

    def __init__(self, *args, **kwargs):
        super(ImportEmailPhoneDumpsToSoup, self).__init__(*args, **kwargs)
        self.ezep_dump_et = SoupDumpTable(soup_config.ezep_dump_et, self.date)
        self.victoria_dump_et = SoupDumpTable(soup_config.victoria_dump_et, self.date)

        self.dumps = {
            self.ezep_dump_et: config.GRAPH_YT_DICTS_FOLDER + 'external_dumps/ezep_secret_dump',
            self.victoria_dump_et: config.GRAPH_YT_DICTS_FOLDER + 'external_dumps/viktoria',
        }

    def requires(self):
        return [yt_luigi.ExternalInput(path) for path in self.dumps.values()]

    def run(self):
        with yt.Transaction() as tr:
            for soup_table, in_table in self.dumps.items():
                yt.run_map(
                    partial(import_phone_email_dump, edge_type=soup_table.edge_type),
                    in_table,
                    soup_table.create(tr)
                )
                soup_table.finalize(tr)

    def output(self):
        return [t.as_target() for t in self.dumps.keys()]
