from v2 import ids

# {
#     1L: 'vk',
#     2L: 'fb',
#     3L: 'tw',
#     4L: 'mr',
#     5L: 'gg',
#     6L: 'ok',
#     7L: 'fs',
#     8L: 'lf',
#     9L: 'ig',
#     10L: 'lj',
#     11L: 'in',
#     12L: 'mt',
#     14L: 'tg',
#     15L: 'ms',
#     16L: 'yh',
#     17L: 'ya',
#     18L: 'vf',
#     19L: 'dz',
#     20L: 'mts-belarus',
#     21L: 'mos-ru',
#     22L: 'amediateka',
#     23L: 'geocell',
#     24L: 'kp',
#     25L: 'fakesocnet'
# }

provider_id_to_id_type = {
    '1': ids.VK_ID,
    '2': ids.FB_ID,
    '6': ids.OK_ID
}

_provider_reports_phone_email = {
    ids.VK_ID: [ids.PHONE + ids.MD5_POSTFIX, ids.EMAIL],
    ids.OK_ID: [],
    ids.FB_ID: [ids.EMAIL],

}


def get_social_edge_types():
    for social_id_type in sorted(provider_id_to_id_type.values()):
        yield (ids.PUID, social_id_type)
        for linked_id_type in _provider_reports_phone_email.get(social_id_type, []):
            yield (social_id_type, linked_id_type)
