# coding=utf-8
import luigi
import yt.wrapper as yt

from lib.luigi import yt_luigi
from rtcconf import config
from v2.soup import soup_config
from v2.soup.soup_tables import SoupDailyLogTable
from utils import utils


def is_proper_yuid(xuniq):
    return utils.get_yuid_creation_date(xuniq) is not None


def map_bs_xuniqs(rec):
    keyword_edgetypes = {
        154: soup_config.yuid_guid_xuniq,
        39: soup_config.yuid_yuid_xuniq,
        245: soup_config.yuid_uuid_xuniq
    }

    try:
        kwid = int(rec['pagekeywordid'])
    except (KeyError, ValueError) as _:
        return

    if kwid in keyword_edgetypes:
        yuid = rec['uniqid']
        xuniq = rec['xuniqid']
        ts = -int(rec['unixtime'])
        edge_type = keyword_edgetypes[kwid]

        if (kwid != 39) or (kwid == 39 and xuniq != yuid and is_proper_yuid(xuniq)):
            if is_proper_yuid(yuid):
                yield SoupDailyLogTable.make_rec(yuid, xuniq, edge_type, ts)


class ImportBsXuniqsLog(luigi.Task):
    date = luigi.Parameter()
    run_date = luigi.Parameter()

    def __init__(self, *args, **kwargs):
        super(ImportBsXuniqsLog, self).__init__(*args, **kwargs)
        self.soup_log = SoupDailyLogTable(soup_config.LOG_SOURCE_XUNIQ, self.date)

    def requires(self):
        return yt_luigi.ExternalInput(self.get_log_table())

    def output(self):
        return self.soup_log.daily_tables_targets()

    def run(self):
        with yt.Transaction():
            self.soup_log.ensure_dir()
            soup_tmp_table = self.soup_log.create()
            yt.run_map(map_bs_xuniqs, self.get_log_table(), soup_tmp_table)
            self.soup_log.prepare_daily_tables_from_log()

    def get_log_table(self):
        return config.LOG_FOLDERS['bs_xuniqs'] + self.date
