#!/usr/bin/python
# coding=utf-8

import os
import subprocess

from collections import defaultdict

import luigi
import yt.wrapper as yt

from lib.luigi import base_luigi_task
from lib.luigi import yt_luigi
from rtcconf import config

# import graph_webvisor
from v2.soup import soup_config
from v2.soup.soup_tables import SoupDailyLogTable

from utils.yql_utils import run_yql


def get_dict_table(name):
    return config.GRAPH_YT_DICTS_FOLDER + name


def mkrec(yuid, id_value, id_type, source_type, date, history_size):
    """ Used in webvisor parser """
    return {config.ID_TYPE_YUID: yuid, 'id_value': id_value,
            'id_type': id_type, 'source_type': source_type,
            'id_date': date, 'id_count': history_size,
            '@table_index': 0}


def reduce_yuid_ids(yuid_key, recs):
    """ Used in webvisor parser """
    yuid = yuid_key['yuid']
    # type -> (id -> count)
    ids_by_t = defaultdict(lambda: defaultdict(lambda: 0))

    id_date = ''
    for rec in recs:
        id_type = rec['id_type']
        source_type = rec['source_type']
        id_value = rec['id_value']
        id_date = rec['id_date']
        id_count = rec['id_count']
        # To prevent OOM
        if len(ids_by_t[(id_type, source_type)]) < 100:
            ids_by_t[(id_type, source_type)][id_value] += id_count

    for (id_type, source_type), ids in ids_by_t.iteritems():
        for id_value, id_count in ids.iteritems():
            yield {'yuid': yuid, 'id_type': id_type, 'source_type': source_type,
                   'id_value': id_value, 'id_date': id_date, 'id_count': id_count}

    ips = ids_by_t[(config.ID_TYPE_IP, config.ID_SOURCE_TYPE_FP)]
    for ip in ips.keys():
        yield {'ip': ip, 'yuid': yuid, '@table_index': 1}


class ImportFPDayTask(base_luigi_task.BaseTask):

    resources = {'import_fp_lock': 1}

    date = luigi.Parameter()
    run_date = luigi.Parameter()

    def __init__(self, *args, **kwargs):
        super(ImportFPDayTask, self).__init__(*args, **kwargs)
        self.soup_log = SoupDailyLogTable(soup_config.LOG_SOURCE_FINGERPRINTS_LOG, self.date)

    def requires(self):
        return [
            # required all external logs
            yt_luigi.ExternalInput(config.LOG_FOLDERS['bs_watch'] + self.date),
            yt_luigi.ExternalInput(config.LOG_FOLDERS['passport'] + self.date),
            yt_luigi.ExternalInput(config.LOG_FOLDERS['bar'] + self.date),
            yt_luigi.ExternalInput(config.LOG_FOLDERS['awaps'] + self.date),
            yt_luigi.ExternalInput(config.LOG_FOLDERS['reqans_new'] + self.date), ]

    def run(self):
        self.soup_log.ensure_dir()

        run_yql('FingerPrintParser', dict(date=self.date), {
            'GRAPH_YT_OUTPUT_FOLDER': config.YT_OUTPUT_FOLDER,
            'BSWATCH_LOG_DIR': config.LOG_FOLDERS['bs_watch'],
            'PASSPORT_LOG_DIR': config.LOG_FOLDERS['passport'],
            'BARNAVIG_LOG_DIR': config.LOG_FOLDERS['bar'],
            'AWAPS_LOG_DIR': config.LOG_FOLDERS['awaps'],
            'REQANS_LOG_DIR': config.LOG_FOLDERS['reqans_new']
        })

        self.soup_log.prepare_daily_tables_from_log()

    def output(self):
        out_folder = config.YT_OUTPUT_FOLDER + self.date + '/'

        last_day_dependencies = []
        if self.date == self.run_date:
            soup_out_tables = self.soup_log.daily_tables_targets()
            last_day_dependencies = soup_out_tables + [
                yt_luigi.YtTarget(out_folder + 'ip_yuid_stream'),
                yt_luigi.YtTarget(out_folder + 'ip_ts_yuid')
            ]

        return [
            yt_luigi.YtTarget(out_folder + 'yuids_ua_day'),
            yt_luigi.YtTarget(out_folder + 'yuids_desk_day'),
            yt_luigi.YtTarget(out_folder + 'yuids_mob_day'),
            yt_luigi.YtTarget(out_folder + 'yuids_rus_ip_day'),
            yt_luigi.YtTarget(out_folder + 'yuid_raw/yuid_with_' + config.ID_SOURCE_TYPE_FP),
            yt_luigi.YtTarget(out_folder + 'yuid_raw/yuid_with_' + config.ID_TYPE_VKCOM + '_' + config.ID_SOURCE_TYPE_FP),
            yt_luigi.YtTarget(out_folder + 'yuid_raw/yuid_with_' + config.ID_TYPE_PUID + '_' + config.ID_SOURCE_TYPE_FP),
            yt_luigi.YtTarget(out_folder + 'yuid_raw/yuid_with_ua')
        ] + last_day_dependencies


if __name__ == '__main__':
    yt.config.set_proxy(config.MR_SERVER)
    yt.config["tabular_data_format"] = yt.YsonFormat(process_table_index=True)

    # dt = sys.argv[1]

    # luigi.build([ImportBBSexAgeTask('2016-07-20')], workers=1, scheduler_port=8083)

    workdir = '//home/crypta/team/artembelov/soup/'
    mr.mkdir(workdir)

    build_raw_links(workdir, '2017-01-10')
