from Crypto.PublicKey import RSA
from Crypto.Cipher import PKCS1_v1_5
from Crypto.Cipher import AES
from base64 import b64decode

import json

def decode_brinfo_di(di, rsa):
    enc_bin = b64decode(di)
    rsa_encrypted = enc_bin[:128]
    aes_msg_encrypted = enc_bin[128:]

    rsa_decrypted = rsa.decrypt(rsa_encrypted, None)

    if rsa_decrypted is None:
        return None

    aes_key = rsa_decrypted[:16]
    aes_iv = rsa_decrypted[16:32]

    aes = AES.new(aes_key, AES.MODE_CBC, aes_iv[:16])
    msg = aes.decrypt(aes_msg_encrypted)

    padlen = ord(msg[-1])   # PKCS7 padding
    return msg[:-padlen]


def parse_browserinfo(s):
    result = dict()
    parts = s.split(':')
    for i in range(len(parts) / 2):
        result[parts[2*i]] = parts[2*i + 1]
    return result


class DecryptMapper(object):
    def __init__(self, rsakey_str):
        self.rsakey_str = rsakey_str
        self.rsa = None

    def __call__(self, rec):
        if self.rsa is None:
            rsakey = RSA.importKey(self.rsakey_str)
            self.rsa = PKCS1_v1_5.new(rsakey)

        try:
            di = parse_browserinfo(rec.get('browserinfo') or '').get('di', '')
            if di:
                msg = decode_brinfo_di(di, self.rsa)
                if msg is not None:
                    jsmsg = json.loads(msg)
                    gaid = jsmsg.get('google_aid', '')
                    idfa = jsmsg.get('ifa', '')
                    uuid = jsmsg.get('uuid', '')
                    yuid = rec.get('uniqid', '')
                    ts = -int(rec['eventtime'])

                    if yuid:
                        if gaid:
                            yield {
                                'yuid': yuid,
                                'ts': ts,
                                'devid': gaid
                            }

                        elif idfa:
                            yield {
                                'yuid': yuid,
                                'ts': ts,
                                'devid': idfa
                            }
    
                        if yuid and uuid:
                            yield {
                                'yuid': yuid,
                                'ts': ts,
                                'uuid': uuid
                            }

        except Exception as e:
            # Sometimes there's some html garbage instead of nice b64-encoded string in
            # browser info
            pass
