import re
from urlparse import urlparse

mac_regex = re.compile(r'mac=(\w{2}-\w{2}-\w{2}-\w{2}-\w{2}-\w{2})')


def map_vmetro_watch_log(rec):
    yuid = rec.get('uniqid')
    referer = rec.get('referer')
    if yuid and yuid != '0' and referer and 'wi-fi.ru' in referer:
        url = urlparse(referer)

        url_without_query_string = url.scheme + "://" + url.netloc + url.path
        m = mac_regex.search(referer)
        if m:
            mac = m.group(1).replace('-', '').lower()
            if mac != '000000000000':
                yield {'id_value': mac, 'yuid': yuid, 'url': url_without_query_string}
                # else:
                #     rec['@table_index'] = 1
                #     yield rec
