#!/usr/bin/python
# coding=utf-8

import luigi
import yt.wrapper as yt

from matching.export.graph_upload_bb import upload_bb
from hh_composition import HHCompositionTask
from lib.luigi import yt_luigi
from rtcconf import config
from utils import mr_utils as mr


class UploadHouseholdsBBTask(yt_luigi.BaseYtTask):
    date = luigi.Parameter()

    def input_folders(self):
        return {
            'hh': config.HH_FOLDER2,
        }

    def output_folders(self):
        return {
            'hh': config.HH_FOLDER2,
        }

    def requires(self):
        return HHCompositionTask(self.date)

    def run(self):
        diff_table = self.in_f('hh') + 'households_to_bb_diff'

        # TODO: turn on upload after switching to graph-households
        if config.CRYPTA_UPLOAD_ENABLED == 'yes':
            upload_bb(diff_table, 'hh_to_bb')

        yt.copy(self.in_f('hh') + 'households_to_bb', self.out_f('hh') + 'households_to_bb_old', force=True)
        mr.set_generate_date(self.out_f('hh') + 'households_to_bb_old', self.date)

    def output(self):
        return yt_luigi.YtDateTarget(self.out_f('hh') + 'households_to_bb_old', self.date)
