import sys

import luigi
import yt.wrapper as yt

from utils import mr_utils as mr
from utils import utils
from data_imports.import_logs import graph_access
from rtcconf import config


class RunAllDayTasks(luigi.WrapperTask):
    date = luigi.Parameter()
    run_date = luigi.Parameter()
    drop = False  # change it!

    def requires(self):
        tasks = []
        for date in utils.get_dates_before(self.date, int(config.STORE_DAYS)):
            #tasks.append(graph_barnavig.ImportBarNavigDayTask(date=date, run_date=self.run_date))
            tasks.append(graph_access.ImportAccessLogsDayTask(date=date, run_date=self.run_date))
            #tasks.append(graph_sbapi_lookup.ImportSbApiAccessLogDayTask(date=date, run_date=self.run_date))
            #tasks.append(log_watch.ImportWatchLogDayTask(date=date, run_date=self.run_date))
            #tasks.append(graph_passport.ImportPassportPhoneDayTask(date=date, run_date=self.run_date))
            # tasks.append(graph_import_fp_bb.ImportFPDayTask(date=date, run_date=self.run_date))
            #tasks.append(device_yuids_oauth_redir.ImportOauthAndRedirLogsDayTask(date=date, run_date=self.run_date))
            # tasks.append(device_yuids_tracking.ImportMobileTrackingLogsDayTask(date=date, run_date=self.run_date))

        # force drop to make luigi think that it needs to re-create tables
        if self.drop:
            for task in tasks:
                for outp in utils.flatten(task.output()):
                    print 'Dropping %s' % outp.table
                    mr.drop(outp.table)
            self.drop = False

        return tasks


if __name__ == '__main__':
    yt.config.set_proxy(config.MR_SERVER)
    yt.config["tabular_data_format"] = yt.YsonFormat(process_table_index=True)

    dt = sys.argv[1]

    luigi.build([RunAllDayTasks(date=dt, run_date=dt)], workers=5, scheduler_port=int(config.LUIGID_PORT))


