import logging

import sys
import yt.wrapper as yt
from yt.transfer_manager.client import TransferManager

from rtcconf import config
import luigi
from lib.luigi import base_luigi_task
from lib.luigi import yt_luigi
from utils import utils
from utils import mr_utils as mr


class CopyWebvisorFreshFromHahnToSmith(base_luigi_task.BaseTask):
    # WARNING (ikutukov): working properly only for production, for testing copying
    # will be performed by WebVisorInputCopyTask
    def __init__(self, *args, **kwargs):
        self.fresh_tables = mr.ls('//home/crypta/production/storage/fresh/webvisor/', absolute_path=False)
        logging.info('Found fresh tables: %s' % self.fresh_tables)

        super(CopyWebvisorFreshFromHahnToSmith, self).__init__(*args, **kwargs)

    def run(self):
        logging.info("Running webvisor_fresh_dispenser...")
        mr.mkdir('//home/crypta/production/storage/fresh/webvisor_copy/')

        for t in sorted(self.fresh_tables):
            # Copy production, until patch with task performing copy is delivered
            yt.copy('//home/crypta/production/storage/fresh/webvisor/' + t,
                    '//home/crypta/production/storage/fresh/webvisor_copy/' + t, force=True)
            logging.info('%s copied locally' % t)

            yt.remove('//home/crypta/production/storage/fresh/webvisor/' + t)
            logging.info('%s removed' % t)

        logging.info('webvisor_fresh_dispenser done.\n')

    def output(self):
        for t in self.fresh_tables:
            yield yt_luigi.YtTarget('//home/crypta/production/storage/fresh/webvisor_copy/' + t)


@base_luigi_task.BaseTask.event_handler(luigi.Event.FAILURE)
def celebrate_failure(task, e):
    utils.monrun_luigi_error(task, e)


@base_luigi_task.BaseTask.event_handler(luigi.Event.SUCCESS)
def mourn_success(task):
    utils.monrun_luigi_ok(task)


if __name__ == '__main__':
    yt.config.set_proxy('hahn.yt.yandex.net')
    logging.basicConfig(level='INFO', format='%(asctime)s %(message)s')

    if luigi.run(['CopyWebvisorFreshFromHahnToSmith', '--workers', '1', '--scheduler-port', config.LUIGID_PORT]):
        utils.monrun_ok()
        sys.exit(0)
    else:
        utils.monrun_error()
        sys.exit(1)
