import requests


def dict_str(orig_dict):
    return {str(k): str(v) for k, v in orig_dict.iteritems()}


class CryptaTaskStatusApi(object):
    def __init__(self, oauth_token, environment, crypta_api_url=None):
        self._environment = environment
        self.__oauth_header = {'Authorization': 'OAuth %s' % oauth_token}

        if crypta_api_url:
            self.crypta_api_url = crypta_api_url
        else:
            self.crypta_api_url = "https://api.crypta.yandex-team.ru"

        self.crypta_task_api_url = self.crypta_api_url + '/task/status'

    def report_task_status(self, task_type, task_status, parent_task_instances, task_params):
        response = requests.post(self.crypta_task_api_url,
                                 headers=self.__oauth_header,
                                 params={
                                     "taskType": task_type,
                                     "taskStatus": task_status,
                                     "parentTaskInstances": parent_task_instances,
                                     "environment": self._environment
                                 },
                                 json=dict_str(task_params),
                                 verify=False)
        response.raise_for_status()

        task_instance = response.json()
        return task_instance["taskInstanceId"]

    def update_task_status(self, task_instance_id, task_type, task_status, task_params):
        response = requests.put(self.crypta_task_api_url + "/" + task_instance_id,
                                headers=self.__oauth_header,
                                params={
                                    "taskInstanceId": task_instance_id,
                                    "taskType": task_type,
                                    "taskStatus": task_status,
                                    "environment": self._environment
                                },
                                json=dict_str(task_params),
                                verify=False)
        response.raise_for_status()


if __name__ == '__main__':
    api = CryptaTaskStatusApi("dsf", "testing")

    api.report_task_status(
        "LuigiTask123", "OK",
        [],
        {"first_param": "sdf", "second_param": "sdfd"}
    )
