import socket
import time
import logging

from datetime import datetime

logger = logging.getLogger('graphite-sender')


def to_graphite_sender_batch(metric_name, kv_batch, date=None):
    """
    Sends batch of metrics to local directly to yabs-graphite-sender via socket.

    :param metric_name: metric name
    :param kv_batch: [field, value]
    :param date: metric timestample will be calculated from this date
    """
    metric_name = metric_name.replace('.', '_')
    metrics = [(metric_name, k.replace('.', '_'), v) for k, v in kv_batch]
    to_graphite_sender(metrics, date)


def to_graphite_sender(metrics, date=None):
    """
    Sends metrics to local directly to yabs-graphite-sender via socket. Use for performance
    Simplified version of yabs-graphite-client.

    :param date: metric timestample will be calculated from this date
    :param metrics: [metrics, field, value]
    :return: success or not
    """
    status = False

    hostname = get_hostname()
    if not date:
        timestamp = time.time()
    else:
        timestamp = time.mktime(datetime.strptime(date, '%Y-%m-%d').timetuple())

    # Open sock from server
    logger.info('Connecting to socket to send graphite metrics...')
    sock = None
    try:
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.settimeout(1.0)
        sock.connect(('localhost', 42000))
        send_count = 0
        for metric_name, field_name, value in metrics:
            send_line = '%s.%s.%s.%s %s %d\n' % \
                        ('one_min', hostname, metric_name,
                         field_name, value, timestamp)
            logger.debug('Sending: ' + send_line)
            sock.send(send_line)
            send_count += 1

        status = True
        logger.info('Success send %d params to sender' % send_count)
    except Exception, err:
        logger.error('Cannot send data to sender: %s' % err.message)
    finally:
        if sock:
            sock.close()
    return status


def get_hostname():
    return socket.getfqdn().replace('.', '_')
