#!/usr/bin/pyhton
"""
Crypta graph base luigi task
"""

import luigi
import logging


class BaseTask(luigi.Task):
    def on_success(self):
        return "Success"

    def log_yt_targets_check(self, targets):
        targets = list(targets)

        logging.info("Checking %s targets:" % self.get_task_family())

        for t in targets:
            if t.exists():
                logging.info("%s target exists: %s" % (self.get_task_family(), t.table))
            else:
                logging.info("%s target is missing: %s" % (self.get_task_family(), t.table))

        return targets
