"""
Tasks for testing error scenarios and monrun error reporting.

Could be run by setting TEST_FAIL_REPORTING env var to 'yes'.
"""

import luigi
import yt.wrapper as yt

from lib.luigi import base_luigi_task
from lib.luigi import yt_luigi


class FailingTask(base_luigi_task.BaseTask):
    date = luigi.Parameter()

    def run(self):
        raise Exception("Im da pain in ur arse")


def fail_mapper(rec):
    return rec["NOT EXISTING FIELD"]


class FailingInsideYTTask(yt_luigi.BaseYtTask):
    date = luigi.Parameter()

    def input_folders(self):
        return {
            'test_input': '//home/x-products/clients_data/alfabank/XPROD-38/XPROD-38.by_yuid_id'
        }

    def output_folders(self):
        return {
            'test_output': '//home/x-products/clients_data/alfabank/XPROD-38/XPROD-38.by_yuid_id.testfail'
        }

    def run(self):
        yt.run_map(
            fail_mapper,
            '//home/x-products/clients_data/alfabank/XPROD-38/XPROD-38.by_yuid_id',
            '//home/x-products/clients_data/alfabank/XPROD-38/XPROD-38.by_yuid_id.testfail'
        )


class FailingYTTask(yt_luigi.BaseYtTask):
    date = luigi.Parameter()

    def input_folders(self):
        return {
            'test_input': '//im_not_exists_i'
        }

    def output_folders(self):
        return {
            'test_output': '//im_not_exists_o'
        }

    def run(self):
        yt.run_sort('//im_not_exist', sort_by='yuid')
