from Crypto.PublicKey import RSA
from Crypto.Cipher import AES, PKCS1_v1_5
from Crypto.Protocol.KDF import PBKDF2
from base64 import b64decode
import struct

from rsa_key import KEY as RSA_KEY

def decode(data, aes_pass, aes_salt=None, rsa_key=RSA_KEY):
    rsakey = RSA.importKey(rsa_key)
    rsa_encoded = b64decode(data)

    pkcs = PKCS1_v1_5.new(rsakey)
    chunks = [rsa_encoded[i:i + 256] for i in range(0, len(rsa_encoded), 256)]
    decrypted_chunks = [pkcs.decrypt(c, None) for c in chunks]
    rsa_decrypted = ''.join(decrypted_chunks)

    aes_block_size = 16
    pad_len = aes_block_size - len(rsa_decrypted) % aes_block_size
    if pad_len > 0:
        rsa_decrypted += chr(0) * pad_len

    if aes_salt is None:
        salt_bytes = [0, 20, 30, 101, 17, 23, 109, 15, 11, 65, 127]
    else:
        salt_bytes = aes_salt
    salt = struct.pack(str(len(salt_bytes)) + 'b', *salt_bytes)

    aes_key = PBKDF2(aes_pass, salt, aes_block_size, 198)
    aes = AES.new(aes_key)

    return aes.decrypt(rsa_decrypted[:-pad_len])

