#!/usr/bin/python
# coding=utf-8

__author__ = 'shiryaev'

import os
import time
from collections import defaultdict
from datetime import datetime

# ----- Constants -----
time_hist_interval = 5*60


# ----- Utils -----
def parse_tskv(s, sep='\t', kv_sep='=') :
    return dict([(p.split(kv_sep, 1) if kv_sep in p else [p, ""]) for p in s.split(sep)])

def get_ts_format(timestamp, timezone, dateformat):
    if not os.environ.get('TZ', ''):
        os.environ['TZ'] = 'GMT'
        time.tzset()
    date = datetime.strptime(timestamp, dateformat)
    timezone = timezone.replace(':', '')
    timezone = -1 * int(timezone)
    gmt_offset_seconds = (timezone / 100) * 60 * 60
    return int(time.mktime(date.timetuple())) + gmt_offset_seconds


# ----- Classes -----
class TCountDict(dict) :
    def __init__(self, s=None) :
        dict.__init__(self)
    def add(self, k, v=1) :
        self[k] += v
    def __getitem__(self, k) :
        if k not in self :
            self[k] = 0
        return dict.__getitem__(self, k)
    def merge(self, cd) :
        for k, v in cd.iteritems() :
            self.add(k, v)

class TTimeHistogram(TCountDict) :
    def __init__(self, s=None) :
        TCountDict.__init__(self)
        if s is not None :
            self.from_string(s)
    def add_ts(self, ts, v=1) :
        k = (ts % (24*3600)) / time_hist_interval
        self.add(k, v)
    def to_string(self) :
        return ','.join(str(k)+':'+str(v) for k, v in self.iteritems())
    def from_string(self, s) :
        self.clear()
        if s :
            for pair in s.split(',') :
                k, v = pair.split(':')
                self[int(k)] = float(v)
    def merge_from_string(self, s) :
        if s :
            for pair in s.split(',') :
                k, v = pair.split(':')
                self.add(int(k), float(v))
    def get_count_list(self) :
        return [self[i] for i in xrange(24*3600/time_hist_interval)]


# ----- Yuid features -----
class TYuidFeatures(object) :
    def __init__(self, s=None) :
        self.hist = TTimeHistogram()
        if s is not None :
            self.from_string(s)
    def parse_fp(self, rec) :
        key_tskv = parse_tskv(rec['key'])
        value_tskv = parse_tskv(rec['value'])
        for h in value_tskv['history'].split(',') :
            self.hist.add_ts(int(h.split(':', 1)[0]))
    def merge(self, rhs) :
        self.hist.merge(rhs.hist)
    def to_string(self) :
        return self.hist.to_string()
    def from_string(self, s) :
        self.hist.from_string(s)
    def empty(self) :
        return len(self.hist) == 0


# ----- Deviceid features -----
class TDevFeatures(object) :
    def __init__(self, s=None) :
        self.hists = defaultdict(TTimeHistogram)
        if s is not None :
            self.from_string(s)
    def parse_mm(self, rec) :
        timestamp = rec.get('timestamp', '')
        ts = get_ts_format(timestamp, '+0000', '%Y-%m-%d %H:%M:%S')
        app = rec.get('AppID', '').replace('-', '_').replace(';', '_')
        self.hists[app].add_ts(ts)
    def load_mm(self, ts, appID) :
        app = appID.replace('-', '_').replace(';', '_')
        self.hists[app].add_ts(ts)
    def merge(self, rhs) :
        for k, hist in rhs.hists.iteritems() :
            self.hists[k].merge(hist)
    def to_string(self):
        return ';'.join(k+'-'+hist.to_string() for k, hist in self.hists.iteritems())
    def from_string(self, s) :
        for part in s.split(';') :
            k, hist_str = part.split('-', 1)
            self.hists[k].from_string(hist_str)
    def empty(self) :
        return len(self.hists) == 0

