import sys

import yt.wrapper as yt

import rtcconf.config
from lib import graphite_sender
from lib.luigi.yt_luigi import PostGraphTask
from matching.device_matching.device_yuid_mix_perfect_fuzzy import DevidYuidMixPerfectFuzzy
from matching.device_matching.perfect.device_yuid_perfect_by_source import DeviceYuidsPerfectBySource
from matching.pairs import graph_pairs_black_list
from matching.pairs import graph_pairs
from rtcconf import config
from utils import mr_utils as mr


def to_graphite(dt, in_graph_f, fuzzy_pairs_table):
    pair_counts = dict()

    # CID
    for pair in config.YUID_PAIR_TYPES_EXACT:
        # different pair types
        for experiment_type, path in [('base', 'yuid_pairs_')]:
            table = in_graph_f + dt + '/pairs/' + path + pair.id_type
            print('Reading table %s' % table)
            if yt.exists(table):
                if pair.is_aggregate():
                    yt.run_map(graph_pairs.expands_source_types, table, table + '_all')
                    mr.count_field_recs(table + '_all', table + '_stat', 'source_type')
                    for r in yt.read_table(table + '_stat', raw=False):
                        source_type = r['source_type']
                        count = r['count']
                        pair_counts['yuid.' + experiment_type + '.' + pair.id_type + '_' + source_type] = count
                else:
                    count = yt.row_count(table)
                    pair_counts['yuid.' + experiment_type + '.' + pair.id_type] = count

        # different reasons why pair was not created
        for throw_reason_type, path in [('single', 'single/yuids_'),
                                        ('overlimit_ids', 'limit/ids_'),
                                        ('overlimit_yuids', 'limit/yuids_'),
                                        ('overlimit_yuids_soft', 'limit/yuids_soft_'),
                                        ('org_yuids', 'orgs/yuids_')]:
            table = in_graph_f + dt + '/pairs/' + path + pair.id_type
            count = yt.row_count(table)
            pair_counts['yuid.' + throw_reason_type + '.' + pair.id_type] = count

    # DEVID
    for pair_name in config.DEVID_PAIRS_NAMES_ALL:
        table = in_graph_f + dt + '/pairs/dev_yuid_pairs_' + pair_name
        print('Reading table %s' % table)
        if yt.exists(table):
            count = yt.row_count(table)
            pair_counts['devid.' + pair_name] = count


    # prob match
    print('Reading table %s' % fuzzy_pairs_table)
    if yt.exists(fuzzy_pairs_table):
        count = yt.row_count(fuzzy_pairs_table)
        pair_counts['yuid.prob.fuzzy'] = count

    print(pair_counts)
    graphite_sender.to_graphite_sender_batch('graph_pairs.count', pair_counts.iteritems(), dt)


class PairsToGraphiteTask(PostGraphTask):
    def __init__(self, date, name):
        super(PairsToGraphiteTask, self).__init__(date=date, name=name)

    def requires(self):
        return [graph_pairs.GraphPairs(self.date),
                DevidYuidMixPerfectFuzzy(self.date),
                DeviceYuidsPerfectBySource(self.date),
                graph_pairs_black_list.GraphPairsBlackList(date=self.date)]

    def run_post_graph(self):
        to_graphite(self.date,
                    config.YT_OUTPUT_FOLDER,
                    rtcconf.config.FUZZY_PAIRS_TABLE_NEW)


if __name__ == '__main__':
    yt.config.set_proxy(config.MR_SERVER)

    dt = sys.argv[1]

    to_graphite(dt,
                config.YT_OUTPUT_FOLDER,
                rtcconf.config.FUZZY_PAIRS_TABLE_NEW)
