import yt.wrapper as yt

from rtcconf import config


def freq_metric(login_dates, all_dates, max_dates):
    """
    Function to compare current login activity with others.
    We are trying to approximate dates sequence by exponential function.
    Finally, recent frequent hits get more weight than older non-frequent.
    :param login_dates: dates of current login
    :param all_dates: dates of all logins
    :param max_dates: how much dates are possible
    :return: weight of current login comparing to others
    """

    # a denotes how much we believe in frequency comparing to recent hits
    # it represents (1 - decay rate) of exponential decreasing function
    # we choose it heuristically between 0.7 and 0.9 depending on the number of dates (checked for 1-30 days range)
    if len(all_dates) >= max_dates:
        a_delta = 0.2
    else:
        a_delta = 0.2 / max_dates * len(all_dates)
    a = 0.7 + a_delta

    all_dates = sorted(all_dates, reverse=True)

    weight = 0
    for t, date in enumerate(all_dates):  # 0 for today and >0 for older dates
        if date not in login_dates:
            pass
        elif t == len(all_dates) - 1:
            # this is the weight of the 'tail' of a sequence, fitting the sum of weights to 1
            weight += a ** t
        else:
            weight += (1 - a) * (a ** t)
            # print weight

    return weight


if __name__ == '__main__':
    yt.config.set_proxy(config.MR_SERVER)
