#!/usr/bin/python
# -*- coding: utf-8 -*-


# sqlite> .tables
# task_events      task_parameters  tasks


# sqlite> .schema task_events
# CREATE TABLE task_events (
#   id INTEGER NOT NULL,
#   task_id INTEGER,
#   event_name VARCHAR(20),
#   ts TIMESTAMP NOT NULL,
#   PRIMARY KEY (id),
#   FOREIGN KEY(task_id) REFERENCES tasks (id)
# );
# CREATE INDEX ix_task_events_task_id ON task_events (task_id);
# CREATE INDEX ix_task_events_ts ON task_events (ts);


# sqlite> .schema task_parameters
# CREATE TABLE task_parameters (
#   task_id INTEGER NOT NULL,
#   name VARCHAR(128) NOT NULL,
#   value VARCHAR(256),
#   PRIMARY KEY (task_id, name),
#   FOREIGN KEY(task_id) REFERENCES tasks (id)
# );


# sqlite> .schema tasks
# CREATE TABLE tasks (
#   id INTEGER NOT NULL,
#   task_id VARCHAR(200),
#   name VARCHAR(128),
#   host VARCHAR(128),
#   PRIMARY KEY (id)
# );
# CREATE INDEX ix_tasks_task_id ON tasks (task_id);
# CREATE INDEX ix_tasks_name ON tasks (name);

from itertools import imap, dropwhile, islice
import datetime
import sqlite3
import sys



def parse_time(s):
    # return s.split('.')[0]  # 2017-06-21 03:00:11.831476
    pattern = '%Y-%m-%d %H:%M:%S'
    return datetime.datetime.strptime(s.split('.')[0], pattern)



def filter_first_pendings(rec_list):
    return list(dropwhile(lambda x: x[0]==u'PENDING', rec_list))



def get_gant_diaps(rec_list):
    if not len(rec_list) or not len(rec_list[0]):
        return []
    if rec_list[0][0] != u'RUNNING':
        print 'WE HAVE UNREAL SITUATON!', rec_list

    primary_ts = parse_time(rec_list[0][1])
    all_diaps = []
    ind = 1

    while ind < len(rec_list):
        if rec_list[ind][0] == u'RUNNING':
            ind += 1
            continue
        elif rec_list[ind][0] in (u'PENDING',u'DONE',u'FAILED'):
            all_diaps.append(
                (
                    primary_ts,
                    parse_time(rec_list[ind][1]),
                    rec_list[ind][0] # 'PENDING'  # blue  # 'DONE'  # green  # 'FAILED'  # red
                )
            )
            rec_list = filter_first_pendings(rec_list[ind+1:])
            if not rec_list:
                primary_ts = 0
                break
            if rec_list[0][0] != u'RUNNING':
                print 'WE HAVE UNREAL SITUATON!', rec_list
            primary_ts = parse_time(rec_list[0][1])
            ind = 1
            continue
        else:
            print 'WE HAVE UNREAL SITUATON!', rec_list
            break
    if primary_ts:
        all_diaps.append((primary_ts,primary_ts+datetime.timedelta(0,0,0,1,0,0),u'NOT FIN'))  # purple
    return all_diaps



def get_gant(target_date, db_addr='/usr/share/crypta-luigid/sql/luigi-task-hist.db'):
    """
    :param target_date: date in YYYY-MM-dd format
    :param db_addr: path to luigi history db (luigi-task-hist.db)
    :return:
    """
    con = sqlite3.connect(db_addr)
    cursor = con.cursor()

    all_day_tasks_query = '''
        SELECT id,name
        FROM tasks
        WHERE task_id LIKE '%_{target_date}_%';
    '''
    statuses_query = '''
        SELECT event_name,ts
        FROM task_events
        WHERE task_id=={task_id};
    '''

    container = []
    min_datetime = datetime.datetime(2100,1,1)
    target_date_formatted = target_date.replace("-", '_')
    query_main = all_day_tasks_query.format(target_date=target_date_formatted)

    for task_record in cursor.execute(query_main).fetchall():  # for all tasks

        event_list = []
        task_name = task_record[1]
        task_id = task_record[0]
        query_string = statuses_query.format(task_id=task_id)

        for event_record in cursor.execute(query_string).fetchall():  # getting all events for this task
            event_list.append([event_record[0],event_record[1]])  # remebering name of event and ts

        event_list = filter_first_pendings(event_list)  # dropping first 'pending' states

        if len(event_list) == 1:  # filtering tasks which already complete
            continue

        diaps = get_gant_diaps(event_list)
        container.append((task_name, diaps))

        min_local_datetime = min(reduce(lambda x,y: x + [y[0],y[1]], diaps,[datetime.datetime(2100,1,1)]))
        if min_datetime > min_local_datetime:
            min_datetime = min_local_datetime

    return min_datetime, container

usage = "Usage: build_gant_from_sqlite.py YYYY-MM-dd [target picture file]"

if __name__ == '__main__':
    try:
        target_date = sys.argv[1]
        if len(sys.argv) > 2:
            target_file = sys.argv[2]
        else:
            target_file = '/home/crypta/tasks_%s.png' % target_date
    except:
        raise Exception(usage)


    min_datetime, results = get_gant(target_date)


    import matplotlib.pyplot as plt

    color = {u'PENDING': 'blue', u'DONE': 'green', u'FAILED': 'red', u'NOT FIN': 'purple'}
    fig,ax=plt.subplots(figsize=(100,100))

    labels=[]
    xticks = set()
    for i, task in enumerate(results):
        labels.append(task[0])
        for r in task[1]:
            t_start = int((r[0] - min_datetime).total_seconds()) | 1
            t_end = int((r[1] - min_datetime).total_seconds()) | 1
            t_dist = int((r[1]-r[0]).total_seconds()) | 1
            data = [[t_start, t_dist]]
            xticks.add(t_start)
            xticks.add(t_end)
            ax.broken_barh(data, (i-0.4,0.8), color=color[r[2]] )
    # critical_path
    all_diaps = []
    for i, task in enumerate(results):
        for val_s, val_e, _ in task[1]:
            all_diaps.append( (val_s,val_e,i) )
    all_diaps = sorted(all_diaps, key=lambda x: x[1])
    target = all_diaps[-1][1]
    def binary_search(a, x, lo=0, hi=None):
        if hi is None:
            hi = len(a)
        while lo < hi:
            mid = (lo+hi)//2
            midval = a[mid][1]
            if midval < x:
                lo = mid+1
            elif midval > x:
                hi = mid
            else:
                return mid
        return lo-1
    while True:
        ind = binary_search(all_diaps, target)
        if ind == -1:
            break
        r = all_diaps[ind]
        t_start = int((r[0] - min_datetime).total_seconds()) | 1
        t_dist = int((r[1]-r[0]).total_seconds()) | 1
        data = [[t_start, t_dist]]
        ax.broken_barh(data, (r[2]-0.3,0.6), color='orange' )
        target = r[0]


    font = {'family' : 'normal',
            'weight' : 'bold',
            'size'   : 22}
    ax.set_yticks(range(len(labels)))
    ax.set_xticks(list(xticks))
    ax.set_yticklabels(labels)
    ax.set_xlabel("time [ms]")
    plt.tight_layout()
    plt.rc('font', **font)
    plt.grid(True, which='both', color='#000000', linestyle='-', linewidth=5,zorder=-1)

    try:
        plt.savefig(target_file)
    except Exception as e:
        print usage
        raise e

    print "Diagram is saved to " + target_file




    # plt.rc('grid', linestyle="-", color='black')
    # plt.rcParams['axes.facecolor'] = 'white'
    # plt.rcParams['axes.edgecolor'] = 'white'
    # plt.rcParams['grid.alpha'] = 1
    # plt.rcParams['grid.color'] = "#cccccc"
    # plt.grid(True)
    # plt.show()

    # example start

    # inp = u"""a0:86:c6:52:4e:e8,0.006568,0.006620,Out
    # a0:86:c6:52:4e:e8,0.006663,0.006695,In
    # a0:86:c6:52:4e:e8,0.008089,0.008141,Out
    # a0:86:c6:52:4e:e8,0.008185,0.008217,In
    # 01:00:5e:00:00:fb,0.033096,0.035016,Out
    # 33:33:00:00:00:fb,0.034997,0.037077,Out
    # 01:00:5e:7f:ff:fa,0.039969,0.042057,Out
    # ff:ff:ff:ff:ff:ff,0.059823,0.061639,Out
    # a0:86:c6:52:4e:e8,0.068865,0.068917,Out
    # a0:86:c6:52:4e:e8,0.068962,0.068994,In
    # a0:86:c6:52:4e:e8,0.083492,0.083544,Out
    # a0:86:c6:52:4e:e8,0.083588,0.083620,In"""

    # import pandas as pd
    # import io
    # import matplotlib.pyplot as plt

    # df = pd.read_csv(io.StringIO(inp), header=None, names=["Task", "Start", "Finish", "Resource"] )
    # df["Diff"] = df.Finish - df.Start

    # color = {"In":"turquoise", "Out":"crimson"}
    # fig,ax=plt.subplots(figsize=(6,3))

    # labels=[]
    # for i, task in enumerate(df.groupby("Task")):
    #     labels.append(task[0])
    #     for r in task[1].groupby("Resource"):
    #         data = r[1][["Start", "Diff"]]
    #         ax.broken_barh(data.values, (i-0.4,0.8), color=color[r[0]] )

    # ax.set_yticks(range(len(labels)))
    # ax.set_yticklabels(labels)
    # ax.set_xlabel("time [ms]")
    # plt.tight_layout()
    # plt.show()

    # example end

    # howto use:
    # http://www.clowersresearch.com/main/gantt-charts-in-matplotlib/














    # now used:


    # import plotly.plotly as py
    # import plotly.figure_factory as ff

    # df = []
    # for task,work_diaps in results:
    #     for diap in work_diaps:
    #         df.append(
    #             dict(Task=task, Start=diap[0], Finish=diap[1], Resource=diap[2])
    #         )

    # colors = {
    #     'PENDING': '#0000FF',
    #     'FAILED': '#00FF00',
    #     'DONE': '#FF0000',
    #     'NOT FIN': '#7109AA',
    # }
    # fig = ff.create_gantt(df, colors=colors, index_col='Resource', show_colorbar=True, group_tasks=True)
    # py.iplot(fig, filename=target_date+'_gant', world_readable=True)


    # import gantt
    # gantt.define_font_attributes(fill='black', stroke='black', stroke_width=0, font_family="Verdana")
    # proj = gantt.Project(name=target_date)
    # today = datetime.datetime.strptime(target_date, '%Y_%m_%d')
    # for task,work_diaps in results:
    #     print task
    #     for diap in work_diaps:
    #         print '\t', diap
    #         proj.add_task(
    #             gantt.Task(name=task, start=diap[0], duration=(diap[1]-diap[0]).total_seconds(), color=diap[2])
    #         )
    # proj.make_svg_for_tasks(filename=target_date+'.svg') #, today=today, start=today, end=today+datetime.timedelta(0,0,2))
