import urllib3
from startrek_client import Startrek

# coding=utf-8

CSV_SEPARATOR = ';'


def process_queue(client, queue, all_links, edges_file, vertices_file):
    print 'links processed: %d' % len(all_links)
    print '=========%s==========' % queue

    cryptais_issues = client.issues.find(
        filter={'queue': queue}
    )

    for i in cryptais_issues:
        from_issue = i.key
        from_issue_name = i.summary

        print from_issue + ': ' + from_issue_name
        vertices_file.write(
            CSV_SEPARATOR.join([
                from_issue.encode('utf-8'),
                from_issue_name.encode('utf-8'),
                queue
            ]) + '\n'
        )

        for l in i.links:

            to_issue = l.object.key
            to_issue_name = l.object.display.encode('utf-8')
            link_type = l.type.id

            print '\t{}: {} ({})'.format(
                to_issue,
                to_issue_name,
                link_type
            )

            if (from_issue, to_issue) not in all_links and (to_issue, from_issue) not in all_links:
                all_links.add((from_issue, to_issue))

                line = CSV_SEPARATOR.join([
                    from_issue,
                    to_issue,
                    link_type
                ])

                edges_file.write(line + '\n')


if __name__ == '__main__':

    queues = ['CRYPTAYT', 'CRYPTAIS', 'CRYPTAUP', 'CRYPTADUTY', 'CRYPTABT']

    urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

    client = Startrek(useragent='what', token='YOUR_TOKEN')
    all_links = set()

    with open('export_edges.csv', 'w') as edges_file, \
            open('export_vertices.csv', 'w') as vertices_file:

        edges_header = CSV_SEPARATOR.join(['Source', 'Target', 'Label']) + '\n'
        edges_file.write(edges_header)
        vertices_header = CSV_SEPARATOR.join(['Id', 'Label', 'Queue']) + '\n'
        vertices_file.write(vertices_header)

        for queue in queues:
            process_queue(client, queue, all_links, edges_file, vertices_file)
