"""
    This looks for errors in (BB|IS)TransportStreaming logs and returns the first error found.
    Return codes are:
        0 if no errors are found
        1 if an error is found in the log file
        2 if some other error occurred
"""
import os
import re
import sys

STATUS_OK = 0
STATUS_ERROR_FOUND = 1
STATUS_OTHER = 2

ERROR_REGEXPS = [
    re.compile(r'^(.*) ERROR (.*)$'),
    re.compile(r'^(.*) FATAL (.*)$')
]


def get_error(line):
    for r in ERROR_REGEXPS:
        m = r.match(line)
        if m:
            error_msg = m.group(1) + m.group(2)
            return error_msg
    return ''


def run_check(filename):
    with open(filename, 'r') as f:
        for line in f:
            error = get_error(line)
            return error


if '__main__' == __name__:
    if len(sys.argv) < 2:
        print 'Usage: upload_logchecker.py [log_file_name]'
        sys.exit(STATUS_OTHER)

    if not os.path.exists(sys.argv[1]):
        print 'Log not found: %s' % sys.argv[1]
        sys.exit(STATUS_OTHER)

    error = run_check(sys.argv[1])
    if error:
        print error
        sys.exit(STATUS_ERROR_FOUND)

    sys.exit(STATUS_OK)
