import os
import subprocess

import yt.wrapper as yt

from rtcconf import config
import logging


def run_yql(class_name=None, params=None, add_env=None, query=None):

    assert class_name is not None or query is not None

    if params is None:
        params = {}

    if query is not None:
        class_name = 'YqlRunner'

    args = [
        '/opt/crypta/yql_runner/yql_runner',
        '--task-class', class_name,
        '--cluster', yt._get_proxy_url(),
    ]

    if config.CRYPTA_ENV == 'development' or class_name == 'YqlRunner':
        args.extend([
            '--mrjob', '/opt/crypta/yql/tools/mrjob/mrjob',
            '--udfr', '/opt/crypta/yql/tools/udf_resolver/udf_resolver',
            '--udfsdir', '/opt/crypta/yql/udfs/common',
        ])
    else:
        args.append('--client')

    if params:
        args.append('--task-params')
        for k, v in params.iteritems():
            args.append("%s=%s" % (k, v))

    env = {
        'YT_TOKEN': os.environ.get('YT_TOKEN'),
        'YQL_TOKEN': os.environ.get('YQL_TOKEN'),
        'ENV_TYPE': config.CRYPTA_ENV
    }

    if add_env:
        env.update(add_env)

    if class_name == 'YqlRunner':
        env['VERBOSE'] = '1'

    logging.info('{} subprocess starts, params: {}'.format(class_name, params))

    p = subprocess.Popen(args, env=env, stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    out, err = p.communicate(input=query)

    logging.info('{} subprocess done,\nstdout: {}\nstderr: {}'.format(class_name, out, err))

    assert p.returncode == 0, '{} subprocess failed. Exit code {}'.format(class_name, p.returncode)
