import sys

import luigi
import yt.wrapper as yt

from lib.luigi import yt_luigi
from rtcconf import config
from utils import utils
from v2.soup import graph_soup
from v2.soup import soup_config
from v2.soup.supometr import supometr

SUPOMETRIYA_TYPE_DAY = 'day'
SUPOMETRIYA_TYPE_ALL = 'all'
SUPOMETRIYA_TYPES = (SUPOMETRIYA_TYPE_DAY, SUPOMETRIYA_TYPE_ALL,)


class GraphSupometriyaTask(yt_luigi.BaseYtTask):
    date = luigi.Parameter()

    def requires(self):
        return graph_soup.SoupIsReady(date=self.date)

    def input_folders(self):
        return {
            'soup_' + SUPOMETRIYA_TYPE_DAY: '/'.join([soup_config.SOUP_DAY_DIR.rstrip('/'), self.date]),
            'soup_' + SUPOMETRIYA_TYPE_ALL: '/'.join([soup_config.SOUP_DIR.rstrip('/')])
        }

    def output_folders(self):
        return {
            'supometriya_' + supometriya_type:
                '/'.join([
                    soup_config.SOUP_DIR.rstrip('/'), 'supometriya', self.date, supometriya_type
                ])
            for supometriya_type in SUPOMETRIYA_TYPES
        }

    def output(self):
        return [
            yt_luigi.YtTarget(
                '/'.join([
                    soup_config.SOUP_DIR.rstrip('/'), 'supometriya', self.date, supometriya_type
                ]))
            for supometriya_type in SUPOMETRIYA_TYPES
        ]

    def run(self):
        for supometriya_type in SUPOMETRIYA_TYPES:
            args = {
                "date": self.date,
                "skip_cleanup": True,
                "source": self.in_f('soup_' + supometriya_type),
                "target": self.out_f('supometriya_' + supometriya_type),
                "yt_proxy": None,
                "yt_job_max_memory_bytes": config.YT_JOB_MAX_MEMORY_BYTES,
                "split_data": False
            }
            supometr.do_supometriya(**args)
            utils.monrun_ok()


if __name__ == '__main__':
    yt.config.set_proxy(config.MR_SERVER)

    if config.MR_SERVER == 'smith.yt.yandex.net':
        yt.config["pickling"]["enable_tmpfs_archive"] = False
    luigi.build([GraphSupometriyaTask('2017-06-06')], local_scheduler=True)
    sys.exit(1)
