import os
from collections import defaultdict
from itertools import chain

import v2.ids as ids
import rtcconf.config as config
from data_imports.import_dumps.social.social_auth_providers import get_social_edge_types
from v2.soup.soup_edge_type import EdgeType, SupplyType

V2_DIR = str(config.YT_OUTPUT_FOLDER) + 'v2/'
# V2_DIR = '//home/crypta/team/artembelov/passport_social/'
SOUP_DIR = V2_DIR + 'soup/'
SOUP_DAY_DIR = V2_DIR + 'soup/day/'
SOUP_DUMPS_DIR = V2_DIR + 'soup/dumps/'
SOUP_DAY_LOGS_DIR = V2_DIR + 'soup/day/tmp/'  # todo: change dir name

MATCHING_DIR = V2_DIR + 'matching/'
MATCHING_STATS_DIR = V2_DIR + 'matching/stats/'

GRAPH_2_JAVA_EXEC = os.getenv('GRAPH_2_JAVA_EXEC')
GRAPH_2_DICTS_JAVA_EXEC = os.getenv('GRAPH_2_DICTS_JAVA_EXEC')

DEFAULT_TZ = '+0300'
DEFAULT_TIME = '00:04:01'  # Should not be affected by any TZ moves

# ======== SOURCE LOGS ========

LOG_SOURCE_WATCH_LOG = 'wl'  # WATCH_LOG                     "//statbox/bs-watch-log"
LOG_SOURCE_ACCESS_LOG = 'access'  # ACCESS_LOG                    "//statbox/access-log"
LOG_SOURCE_BAR_NAVIG_LOG = 'bar'  # BAR_NAVIG_LOG                 "//statbox/bar-navig-log"
LOG_SOURCE_FINGERPRINTS_LOG = 'fp'  # FINGERPRINTS                  "//home/crypta/production/storage/storage/fp"
LOG_SOURCE_MOBILE_METRIKA = 'mm'  # METRIKA_MOBILE_LOG            "//statbox/metrika-mobile-log"
LOG_SOURCE_MOBILE_REDIRECT_BIND_ID_LOG = 'mobile-redir-bind'  # MOBILE_REDIRECT_BIND_ID_LOG   "//statbox/mobile-redirect-bind-id-log"
LOG_SOURCE_OAUTH = 'oauth'  # OAUTH_LOG                     "//statbox/oauth-log"
LOG_SOURCE_REDIR = 'redir'  # REDIR_LOG                     "//statbox/redir-log"
LOG_SOURCE_PASSPORT_DICT = 'passport-dict'  # PASSPORT_DICT                 "//statbox/heavy-dict/passport_userdata"
LOG_SOURCE_PASSPORT_PHONE = 'passport-phone'  # PASSPORT_PHONE_LOG            "//statbox/passport-phone-log"
LOG_SOURCE_PASSPORT_PHONE_BINDINGS = 'passport-sensitive'  # PASSPORT_SENSITIVE_LOG        "//statbox/passport-sensitive-log"
LOG_SOURCE_PASSDUMP = 'passport-phone-dump'  # PASSPORT_PHONE_DUMP           "//home/crypta/production/state/graph/dicts/external_dumps"
LOG_SOURCE_SBAPIMITBLOG = 'sbapi-mitb'  # SBAPI_MITB_LOG                "//logs/sbapi-access-mitb-log"
LOG_SOURCE_SBAPIACCESSLOG = 'sbapi-lookup'  # SBAPI_ACCESS_LOG              "//statbox/sbapi-lookup-access-log"
LOG_SOURCE_MOBILE_REPORT = 'mob-report'  # MOBILE_REPORT                 "//logs/mobreport-access-log"
LOG_SOURCE_EAL = 'eal'  # EXPORT_ACCESS_LOG             "//statbox/export-access-log"
LOG_SOURCE_PREPROCESSING = 'preproc'  # SOUP_PREPROCESSING            "//home/crypta/production/state/graph/v2/soup"
LOG_SOURCE_PEOPLE_SEARCH = 'people-search-dump'  # PEOPLE_SEARCH_DUMP            "//home/freshness/crypta/users_birth_dates"
LOG_SOURCE_MOBILE_TRACKING = 'mob-tracking'  # MOBILE_TRACKING               "//statbox/mobile-tracking-log"
LOG_SOURCE_TICKETS = 'ya-tickets-dump'  # YANDEX_TICKETS_DUMP           "//home/tickets/production"
LOG_SOURCE_SOCIALDB = 'socialdb'  # STBX_SOCIAL_AUTH_PROFILES     "//home/crypta/production/bindings"
LOG_SOURCE_SENDERDAY = 'sender'  # SENDER                        "//statbox/sendr-click-log"
LOG_SOURCE_POSTCLICK = 'metrica-postclick'  # POSTCLICK                      "//logs/metrika-postclicks-log"
LOG_SOURCE_YAMONEY = 'ya-money-dump'  # YANDEX_MONEY_DUMP             "//home/crypta/production/state/graph/dicts/yamoney"
LOG_SOURCE_WEBVISOR = 'webvisor'  # WEBVISOR                      "//home/crypta/production/state/webvisor_processed"
LOG_SOURCE_PARTNERS_AUDIENCE = 'partners-audience'  # PARTNERS                      "//home/x-products/production/partners_data/audience/*"
LOG_SOURCE_DITMSK = 'dit-msk'  # DIT_MSK_DUMP                  "//home/crypta/production/dmp/dmp-ditmsk/conveyor/dit-yuid-for-graph"
LOG_SOURCE_SHERLOCK = 'sherlock'  # "//home/sherlock/export/crypta"
LOG_SOURCE_EXTERNAL_DUMPS = 'external-dumps'
LOG_SOURCE_SOVETNIK = 'sovetnik'
LOG_SOURCE_IDSERV = 'idserv'  # "//logs/crypta-id-access-log"
LOG_SOURCE_XUNIQ = 'xuniq'  # "//logs/bs-xuniqs-log"
LOG_SOURCE_BS_HITLOG = 'bs-hit-log'  # //logs/bs-hit-log
LOG_SOURCE_BS_RTBLOG = 'bs-rtb-log'  # //logs/bs-rtb-log

LOG_SOURCE_HOUSEHOLDS = 'hh'

LOG_SOURCE_FUZZY_INDEV = 'crypta-indevice'
LOG_SOURCE_FUZZY2_INDEV = 'fuzzy2-indevice'

# ======== SOURCE TYPES ========

# web logs and metrika
ID_SOURCE_TYPE_PAGE_TITLE = "page-title"  # "Emails parsed from page title in specific sites only"
ID_SOURCE_TYPE_VMETRO = "vmetro"  # "wi-fi.ru Metrica counter"
ID_SOURCE_TYPE_ADV_BLOCK = "adv-block"  # "Identifiers parsed by custom Metrica counter code in adv block at some specified sites"
ID_SOURCE_TYPE_HTTP_HEADER_COOKIE = "cookie"  # "Yandex-set cookie from HTTP header from Metrica"
ID_SOURCE_TYPE_MAIL_RU_FROM_PAGE_TITLE = "mailru"  # "Mail.ru emails parsed from page title in Metrica (FP only). DEPRECATED!"
ID_SOURCE_TYPE_VK_APPS_REDIR = "vk-apps"  # "Vk apps can redirect to web page with Metrica"
ID_SOURCE_TYPE_WEBVISOR = 'webvisor'  # "Webvisor stores html field inputs"
ID_SOURCE_TYPE_WATCH_YP_IOS = 'watch-yp-did-ios'  # "Permanent y-Cookies"
ID_SOURCE_TYPE_WATCH_YP_ANDROID = 'watch-yp-did-android'  # "Permanent y-Cookies"
ID_SOURCE_TYPE_ACCESS_YP = 'access-yp-did'

# MobApp -> Web redirects
ID_SOURCE_TYPE_SEARCH_APP_STARTUP_REDIR = "search-app-startup"  # "SearchApp start up parsed by specific url pattern"
ID_SOURCE_TYPE_SEARCH_APP_MOB_REPORT = "search-app-mobreport"  # "SearchApp uses java mob report and it calls are tracked at server-side"
ID_SOURCE_TYPE_APP_URL_REDIR = "app-url-redir"  # "MobApp redirect to web page"

# passport
ID_SOURCE_TYPE_SOCIAL_AUTH = "social-auth"  # "Yandex social auth"
ID_SOURCE_TYPE_PASSPORT_AUTH = "passport-auth"  # "Yandex passport authentication"
ID_SOURCE_TYPE_APP_PASSPORT_AUTH = "app-auth"  # "MobApp Yandex passport authentication"
ID_SOURCE_TYPE_PASSPORT_PROFILE = "passport-profile"  # "Additional data linked to passport profile"

# app metrica
ID_SOURCE_TYPE_APP_METRICA = "app-metrica"  # "Data from App Metrica"
ID_SOURCE_TYPE_APP_METRICA_SDK = "app-metrica-sdk"  # "Collected by app metrica sdk installation"
ID_SOURCE_TYPE_APP_METRICA_SOCKETS_ANDROID = "app-metrica-socket-android"  # "Collected by app metrica sdk installation via socket"
ID_SOURCE_TYPE_APP_METRICA_SOCKETS_IOS = "app-metrica-socket-ios"  # "Collected by app metrica sdk installation via socket"
ID_SOURCE_TYPE_ACCOUNT_MANAGER = "account-manager"  # "Android account manager data parsed from App Metrica"
ID_SOURCE_TYPE_TRACK = 'track'  # "I have no idea what tracking is. CRYPTAIS-648"

# yasoft
ID_SOURCE_TYPE_YABRO_AJAX = "yabro-ajax"  # "Yandex.Browser ajax queries parsing"
ID_SOURCE_TYPE_YABRO_ANDROID = "yabro-android"  # "Reported by Android Yandex.Browser"
ID_SOURCE_TYPE_YABRO_IOS = "yabro-ios"  # "Yandex passport authentication"
ID_SOURCE_TYPE_YABRO_EXTERNAL_BROWSERS = "yabro-ext-bro"  # "Info about external browsers"
ID_SOURCE_TYPE_YASOFT = "yasoft"  # "Data reported by Yandex soft"
ID_SOURCE_TYPE_YASOFT_PUNTO_SWITCHER = "yasoft-punto"  # "Reported by Punto Switcher"
ID_SOURCE_TYPE_YASOFT_BROWSER_MANAGER = "yasoft-browser-manager"  # "Reported by Browser Manager"

# our own soup pre-processing
ID_SOURCE_TYPE_LOGIN_TO_EMAIL = 'login-to-email'  # "Each Yandex login corresponds to email"
ID_SOURCE_TYPE_MD5_HASH = 'md5'  # "Identifier md5 hash"

# inner and outer yandex services
ID_SOURCE_TYPE_PEOPLE_SEARCH = "people-search"  # "People search social profiles"
ID_SOURCE_TYPE_KINOPOISK = "kinopoisk"  # "Kinopoisk.ru logs"
ID_SOURCE_TYPE_YANDEX_MONEY = "ya-money"  # "Yandex.Money data"
ID_SOURCE_TYPE_YANDEX_TICKETS = "ya-tickets"  # "Yandex.Tickets data"
ID_SOURCE_TYPE_SENDERDAY = 'sender'  # "Redirects from email newsletters"
ID_SOURCE_TYPE_SOVETNIK = 'sovetnik'  # "Redirects from email newsletters"
ID_SOURCE_TYPE_IDSERV = 'idserv'  # Realtime matches from idservice's clients

# unclassified
ID_SOURCE_TYPE_DITMSK = 'ditmsk'
ID_SOURCE_TYPE_MAIL_TEMPLATE = 'mail-template'

# external
ID_SOURCE_EZEP_DUMP = 'ezep'
ID_SOURCE_VICTORIA_DUMP = 'victoria'

ID_SOURCE_POSTCLICK = 'app-install-tracker'

# bs xuniq
ID_SOURCE_TYPE_XUNIQ = 'xuniq'

# avito
ID_SOURCE_TYPE_AVITO = 'avito'

# households
ID_SOURCE_TYPE_SMART_TV = 'smart-tv'

# fuzzy
ID_SOURCE_TYPE_FUZZY = 'fuzzy'
ID_SOURCE_TYPE_FUZZY2 = 'fuzzy2'

# Partners
ID_SOURCE_TYPE_PARTNER_ALFA = 'partner_alfabank'
ID_SOURCE_TYPE_PARTNER_EQUIFAX = 'partner_equifax'
ID_SOURCE_TYPE_PARTNER_HCB = 'partner_homecredit'
ID_SOURCE_TYPE_PARTNER_MINDBOX = 'partner_mindbox_adamas'
ID_SOURCE_TYPE_PARTNER_RENINS = 'partner_renins'
ID_SOURCE_TYPE_PARTNER_PMI = 'partner_pmi'
ID_SOURCE_TYPE_PARTNER_TCS = 'partner_tcs'
ID_SOURCE_TYPE_PARTNER_URALSIB = 'partner_uralsib'
ID_SOURCE_TYPE_PARTNER_OPENBANK = 'partner_openbank'
ID_SOURCE_TYPE_PARTNER_5KA = 'partner_5ka'
ID_SOURCE_TYPE_PARTNER_BCAR = 'partner_bcar'
ID_SOURCE_TYPE_PARTNER_E96 = 'partner_e96'
ID_SOURCE_TYPE_PARTNER_KASSIR_RU = 'partner_kassir_ru'
ID_SOURCE_TYPE_PARTNER_PSBANK = 'partner_psbank'
ID_SOURCE_TYPE_PARTNER_A101 = 'partner_a101'
ID_SOURCE_TYPE_PARTNER_TOCHKA_BANK = 'partner_tochka_bank'
ID_SOURCE_TYPE_PARTNER_OKB = 'partner_okb'
ID_SOURCE_TYPE_PARTNER_BCS_BROKER = 'partner_bcs_broker'
ID_SOURCE_TYPE_PARTNER_SPORTMASTER = 'partner_sportmaster'
ID_SOURCE_TYPE_PARTNER_FINSTAR = 'partner_finstar'
ID_SOURCE_TYPE_PARTNER_HOLODILNIK_RU = 'partner_holodilnik_ru'
ID_SOURCE_TYPE_PARTNER_VALTERA = 'partner_valtera'
ID_SOURCE_TYPE_PARTNER_KIDERIA = 'partner_kideria'
ID_SOURCE_TYPE_PARTNER_SIMALAND = 'partner_simaland'
ID_SOURCE_TYPE_PARTNER_PANASONIC = 'partner_panasonic'
ID_SOURCE_TYPE_PARTNER_SPOK_UA = 'partner_spok_ua'
ID_SOURCE_TYPE_PARTNER_UFS = 'partner_ufs'
ID_SOURCE_TYPE_PARTNER_RAIFFEISEN = 'partner_raiffeisen'
ID_SOURCE_TYPE_PARTNER_SBERBANK = 'partner_sberbank'
ID_SOURCE_TYPE_PARTNER_OBI = 'partner_obi'
ID_SOURCE_TYPE_PARTNER_SOVEST = 'partner_sovest'
ID_SOURCE_TYPE_PARTNER_BCSPREMIER = 'partner_bcspremier'

# ID_SOURCE_TYPE_PARTNER_INTERNAL = 'partner_internal'  # Internal audience data
# ID_SOURCE_TYPE_PARTNER_STAFF = 'staff'                # Stuff wil be used for quality control


GROUP_ID_SOURCE_TYPE_PARTNERS_AUDIENCE = {
    ID_SOURCE_TYPE_PARTNER_ALFA,
    ID_SOURCE_TYPE_PARTNER_EQUIFAX,
    ID_SOURCE_TYPE_PARTNER_HCB,
    ID_SOURCE_TYPE_PARTNER_MINDBOX,
    ID_SOURCE_TYPE_PARTNER_RENINS,
    ID_SOURCE_TYPE_PARTNER_PMI,
    ID_SOURCE_TYPE_PARTNER_TCS,
    ID_SOURCE_TYPE_PARTNER_URALSIB,
    ID_SOURCE_TYPE_PARTNER_OPENBANK,
    ID_SOURCE_TYPE_PARTNER_5KA,
    ID_SOURCE_TYPE_PARTNER_BCAR,
    ID_SOURCE_TYPE_PARTNER_E96,
    ID_SOURCE_TYPE_PARTNER_KASSIR_RU,
    ID_SOURCE_TYPE_PARTNER_PSBANK,
    ID_SOURCE_TYPE_PARTNER_A101,
    ID_SOURCE_TYPE_PARTNER_TOCHKA_BANK,
    ID_SOURCE_TYPE_PARTNER_OKB,
    ID_SOURCE_TYPE_PARTNER_BCS_BROKER,
    ID_SOURCE_TYPE_PARTNER_SPORTMASTER,
    ID_SOURCE_TYPE_PARTNER_FINSTAR,
    ID_SOURCE_TYPE_PARTNER_HOLODILNIK_RU,
    ID_SOURCE_TYPE_PARTNER_VALTERA,
    ID_SOURCE_TYPE_PARTNER_KIDERIA,
    ID_SOURCE_TYPE_PARTNER_SIMALAND,
    ID_SOURCE_TYPE_PARTNER_PANASONIC,
    ID_SOURCE_TYPE_PARTNER_SPOK_UA,
    ID_SOURCE_TYPE_PARTNER_UFS,
    ID_SOURCE_TYPE_PARTNER_RAIFFEISEN,
    ID_SOURCE_TYPE_PARTNER_SBERBANK,
    ID_SOURCE_TYPE_PARTNER_OBI,
    ID_SOURCE_TYPE_PARTNER_SOVEST,
    ID_SOURCE_TYPE_PARTNER_BCSPREMIER
    # ID_SOURCE_TYPE_PARTNER_INTERNAL,  # Should not be used in processing
    # ID_SOURCE_TYPE_PARTNER_STAFF
}

# Mapping of Audience table name to source types
AUDIENCE_TABLE_TO_SOURCE_TYPE = {
    partner_source_type.replace('partner_', ''): partner_source_type
    for partner_source_type in GROUP_ID_SOURCE_TYPE_PARTNERS_AUDIENCE
}

ID_HASH_MAPPING = {
    ids.EMAIL: ids.EMAIL + ids.MD5_POSTFIX,
    ids.PHONE: ids.PHONE + ids.MD5_POSTFIX,
}

HASH_ID_MAPPING = {v: k for k, v in ID_HASH_MAPPING.items()}

# ======== EDGES ========

# watch log
yuid_page_title_email_wl = EdgeType(ids.YANDEXUID, ids.EMAIL,
                                    ID_SOURCE_TYPE_PAGE_TITLE, LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_mac_vmetro_wl = EdgeType(ids.YANDEXUID, ids.MAC,
                              ID_SOURCE_TYPE_VMETRO, LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_mail_ru_social_adv_wl = EdgeType(ids.YANDEXUID, ids.EMAIL,
                                      ID_SOURCE_TYPE_ADV_BLOCK, LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_vk_social_adv_wl = EdgeType(ids.YANDEXUID, ids.VK_ID,
                                 ID_SOURCE_TYPE_ADV_BLOCK, LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_ok_social_adv_wl = EdgeType(ids.YANDEXUID, ids.OK_ID,
                                 ID_SOURCE_TYPE_ADV_BLOCK, LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_avito_social_adv_wl = EdgeType(ids.YANDEXUID, ids.AVITO_ID,
                                    ID_SOURCE_TYPE_ADV_BLOCK, LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_uuid_app_redir_wl = EdgeType(ids.YANDEXUID, ids.UUID,
                                  ID_SOURCE_TYPE_APP_URL_REDIR, LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_devid_yp_ios_wl = EdgeType(ids.YANDEXUID, ids.MM_DEVICE_ID,
                                ID_SOURCE_TYPE_WATCH_YP_IOS, LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_devid_yp_android_wl = EdgeType(ids.YANDEXUID, ids.MM_DEVICE_ID,
                                    ID_SOURCE_TYPE_WATCH_YP_ANDROID, LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_icookie_wl = EdgeType(
    ids.YANDEXUID, ids.ICOOKIE,
    ID_SOURCE_TYPE_HTTP_HEADER_COOKIE, LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)

# fingerprints
yuid_fuid_fp = EdgeType(ids.YANDEXUID, ids.FUID,
                        ID_SOURCE_TYPE_HTTP_HEADER_COOKIE, LOG_SOURCE_FINGERPRINTS_LOG, SupplyType.DAILY)
yuid_login_fp = EdgeType(ids.YANDEXUID, ids.LOGIN,
                         ID_SOURCE_TYPE_HTTP_HEADER_COOKIE, LOG_SOURCE_FINGERPRINTS_LOG, SupplyType.DAILY)
yuid_puid_fp = EdgeType(ids.YANDEXUID, ids.PUID,
                        ID_SOURCE_TYPE_PASSPORT_AUTH, LOG_SOURCE_FINGERPRINTS_LOG, SupplyType.DAILY)
yuid_mailru_fp = EdgeType(ids.YANDEXUID, ids.EMAIL,
                          ID_SOURCE_TYPE_MAIL_RU_FROM_PAGE_TITLE, LOG_SOURCE_FINGERPRINTS_LOG, SupplyType.DAILY)
yuid_vk_fp = EdgeType(ids.YANDEXUID, ids.VK_ID,
                      ID_SOURCE_TYPE_VK_APPS_REDIR, LOG_SOURCE_FINGERPRINTS_LOG, SupplyType.DAILY)

# mobile metrika
idfa_mmid_mm = EdgeType(
    ids.IDFA, ids.MM_DEVICE_ID,
    ID_SOURCE_TYPE_APP_METRICA, LOG_SOURCE_MOBILE_METRIKA, SupplyType.DAILY)
gaid_mmid_mm = EdgeType(
    ids.GAID, ids.MM_DEVICE_ID,
    ID_SOURCE_TYPE_APP_METRICA, LOG_SOURCE_MOBILE_METRIKA, SupplyType.DAILY)
mmid_uuid_mm = EdgeType(
    ids.MM_DEVICE_ID, ids.UUID,
    ID_SOURCE_TYPE_APP_METRICA, LOG_SOURCE_MOBILE_METRIKA, SupplyType.DAILY)
mmid_mmhash_mm = EdgeType(
    ids.MM_DEVICE_ID, ids.MM_DEVICE_ID_HASH,
    ID_SOURCE_TYPE_APP_METRICA, LOG_SOURCE_MOBILE_METRIKA, SupplyType.DAILY)
mmid_mac_mm = EdgeType(
    ids.MM_DEVICE_ID, ids.MAC,
    ID_SOURCE_TYPE_APP_METRICA, LOG_SOURCE_MOBILE_METRIKA, SupplyType.DAILY)
gaid_email_am = EdgeType(
    ids.GAID, ids.EMAIL + ids.MD5_POSTFIX,
    ID_SOURCE_TYPE_ACCOUNT_MANAGER, LOG_SOURCE_MOBILE_METRIKA, SupplyType.DUMP)
gaid_phone_am = EdgeType(
    ids.GAID, ids.PHONE + ids.MD5_POSTFIX,
    ID_SOURCE_TYPE_ACCOUNT_MANAGER, LOG_SOURCE_MOBILE_METRIKA, SupplyType.DUMP)

# mobile sdk
yuid_uuid_sdk = EdgeType(ids.YANDEXUID, ids.UUID, ID_SOURCE_TYPE_APP_METRICA_SDK,
                         LOG_SOURCE_MOBILE_REDIRECT_BIND_ID_LOG, SupplyType.DAILY)
yuid_uuid_socket_android = EdgeType(ids.YANDEXUID, ids.UUID, ID_SOURCE_TYPE_APP_METRICA_SOCKETS_ANDROID,
                                    LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_devid_socket_android = EdgeType(
    ids.YANDEXUID, ids.GAID, ID_SOURCE_TYPE_APP_METRICA_SOCKETS_ANDROID,
    LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_uuid_socket_ios = EdgeType(ids.YANDEXUID, ids.UUID, ID_SOURCE_TYPE_APP_METRICA_SOCKETS_IOS,
                                LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)
yuid_devid_socket_ios = EdgeType(
    ids.YANDEXUID, ids.IDFA, ID_SOURCE_TYPE_APP_METRICA_SOCKETS_IOS,
    LOG_SOURCE_WATCH_LOG, SupplyType.DAILY)

# access log
yuid_uuid_al = EdgeType(ids.YANDEXUID, ids.UUID,
                        ID_SOURCE_TYPE_SEARCH_APP_STARTUP_REDIR, LOG_SOURCE_ACCESS_LOG, SupplyType.DAILY)
yuid_uuid_sal = EdgeType(ids.YANDEXUID, ids.UUID,
                         ID_SOURCE_TYPE_APP_URL_REDIR, LOG_SOURCE_ACCESS_LOG, SupplyType.DAILY)
yuid_kpid_al = EdgeType(ids.YANDEXUID, ids.KINOPOISK_ID,
                        ID_SOURCE_TYPE_KINOPOISK, LOG_SOURCE_ACCESS_LOG, SupplyType.DAILY)
yuid_devid_yp_al = EdgeType(ids.YANDEXUID, ids.MM_DEVICE_ID,
                            ID_SOURCE_TYPE_ACCESS_YP, LOG_SOURCE_ACCESS_LOG, SupplyType.DAILY)

# oauth
puid_uuid_oauth = EdgeType(ids.PUID, ids.UUID,
                           ID_SOURCE_TYPE_APP_PASSPORT_AUTH, LOG_SOURCE_OAUTH, SupplyType.DAILY)
puid_devid_oauth = EdgeType(ids.PUID, ids.MM_DEVICE_ID,
                            ID_SOURCE_TYPE_APP_PASSPORT_AUTH, LOG_SOURCE_OAUTH, SupplyType.DAILY)

# barnavig
yuid_vkcom_barnavig = EdgeType(ids.YANDEXUID, ids.VK_ID,
                               ID_SOURCE_TYPE_YABRO_AJAX, LOG_SOURCE_BAR_NAVIG_LOG, SupplyType.DAILY)
yuid_okru_barnavig = EdgeType(ids.YANDEXUID, ids.OK_ID,
                              ID_SOURCE_TYPE_YABRO_AJAX, LOG_SOURCE_BAR_NAVIG_LOG, SupplyType.DAILY)
yuid_mailru_barnavig = EdgeType(ids.YANDEXUID, ids.EMAIL,
                                ID_SOURCE_TYPE_YABRO_AJAX, LOG_SOURCE_BAR_NAVIG_LOG, SupplyType.DAILY)
yuid_r1_barnavig = EdgeType(ids.YANDEXUID, ids.DISTR_R1,
                            ID_SOURCE_TYPE_YASOFT, LOG_SOURCE_BAR_NAVIG_LOG, SupplyType.DAILY)
yuid_ui_barnavig = EdgeType(ids.YANDEXUID, ids.DISTR_UI,
                            ID_SOURCE_TYPE_YASOFT, LOG_SOURCE_BAR_NAVIG_LOG, SupplyType.DAILY)
yuid_uuid_barnavig = EdgeType(ids.YANDEXUID, ids.UUID,
                              ID_SOURCE_TYPE_YABRO_ANDROID, LOG_SOURCE_BAR_NAVIG_LOG, SupplyType.DAILY)

# redir
yuid_uuid_redir = EdgeType(ids.YANDEXUID, ids.UUID,
                           ID_SOURCE_TYPE_APP_URL_REDIR, LOG_SOURCE_REDIR, SupplyType.DAILY)

# passport dump
puid_phhash_passdump = EdgeType(ids.PUID, ids.PHONE + ids.MD5_POSTFIX,
                                ID_SOURCE_TYPE_PASSPORT_PROFILE, LOG_SOURCE_PASSDUMP, SupplyType.DUMP)

# sbapimitblogdattask (ha-ha)
yuid_ui_sbapimitblog = EdgeType(ids.YANDEXUID, ids.DISTR_UI,
                                ID_SOURCE_TYPE_YASOFT_BROWSER_MANAGER, LOG_SOURCE_SBAPIMITBLOG, SupplyType.DAILY)

# sbapiaccesslogdaytask (ha-ha)
yuid_uuid_sbapial = EdgeType(ids.YANDEXUID, ids.UUID,
                             ID_SOURCE_TYPE_YABRO_IOS, LOG_SOURCE_SBAPIACCESSLOG, SupplyType.DAILY)

# eal
yuid_ui_ealeal = EdgeType(ids.YANDEXUID, ids.DISTR_UI,
                          ID_SOURCE_TYPE_YASOFT, LOG_SOURCE_EAL, SupplyType.DAILY)
yuid_ui_puntoeal = EdgeType(ids.YANDEXUID, ids.DISTR_UI,
                            ID_SOURCE_TYPE_YASOFT_PUNTO_SWITCHER, LOG_SOURCE_EAL, SupplyType.DAILY)
yuid_ui_extbrows = EdgeType(ids.YANDEXUID, ids.DISTR_UI,
                            ID_SOURCE_TYPE_YABRO_EXTERNAL_BROWSERS, LOG_SOURCE_EAL, SupplyType.DAILY)

# Sovetnik
yuid_okru_sovetnik_sovetnik = EdgeType(
    ids.YANDEXUID, ids.OK_ID, ID_SOURCE_TYPE_SOVETNIK, LOG_SOURCE_SOVETNIK, SupplyType.DAILY)
yuid_facebook_id_sovetnik_sovetnik = EdgeType(
    ids.YANDEXUID, ids.FB_ID, ID_SOURCE_TYPE_SOVETNIK, LOG_SOURCE_SOVETNIK, SupplyType.DAILY)
yuid_vkcom_sovetnik_sovetnik = EdgeType(
    ids.YANDEXUID, ids.VK_ID, ID_SOURCE_TYPE_SOVETNIK, LOG_SOURCE_SOVETNIK, SupplyType.DAILY)
yuid_vkcom_name_sovetnik_sovetnik = EdgeType(
    ids.YANDEXUID, ids.VK_NAME, ID_SOURCE_TYPE_SOVETNIK, LOG_SOURCE_SOVETNIK, SupplyType.DAILY)

# xuniqs
yuid_yuid_xuniq = EdgeType(ids.YANDEXUID, ids.YANDEXUID,
                           ID_SOURCE_TYPE_XUNIQ, LOG_SOURCE_XUNIQ, SupplyType.DAILY)
yuid_guid_xuniq = EdgeType(ids.YANDEXUID, ids.XUNIQ_GUID,
                           ID_SOURCE_TYPE_XUNIQ, LOG_SOURCE_XUNIQ, SupplyType.DAILY)
yuid_uuid_xuniq = EdgeType(ids.YANDEXUID, ids.UUID,
                           ID_SOURCE_TYPE_XUNIQ, LOG_SOURCE_XUNIQ, SupplyType.DAILY)

# phones and email hashes from avito from rtb log
yuid_avito_hash_avito_rtb = EdgeType(ids.YANDEXUID, ids.AVITO_HASH,
                                     ID_SOURCE_TYPE_AVITO, LOG_SOURCE_BS_RTBLOG, SupplyType.DAILY)
yuid_phone_avito_rtb = EdgeType(ids.YANDEXUID, ids.PHONE,
                                ID_SOURCE_TYPE_AVITO, LOG_SOURCE_BS_RTBLOG, SupplyType.DAILY)
uuid_avito_hash_avito_rtb = EdgeType(ids.UUID, ids.AVITO_HASH,
                                     ID_SOURCE_TYPE_AVITO, LOG_SOURCE_BS_RTBLOG, SupplyType.DAILY)
uuid_phone_avito_rtb = EdgeType(ids.UUID, ids.PHONE,
                                ID_SOURCE_TYPE_AVITO, LOG_SOURCE_BS_RTBLOG, SupplyType.DAILY)
# phones and email hashes from avito from hit log
yuid_avito_hash_avito_hit = EdgeType(ids.YANDEXUID, ids.AVITO_HASH,
                                     ID_SOURCE_TYPE_AVITO, LOG_SOURCE_BS_HITLOG, SupplyType.DAILY)
yuid_phone_avito_hit = EdgeType(ids.YANDEXUID, ids.PHONE,
                                ID_SOURCE_TYPE_AVITO, LOG_SOURCE_BS_HITLOG, SupplyType.DAILY)
uuid_avito_hash_avito_hit = EdgeType(ids.UUID, ids.AVITO_HASH,
                                     ID_SOURCE_TYPE_AVITO, LOG_SOURCE_BS_HITLOG, SupplyType.DAILY)
uuid_phone_avito_hit = EdgeType(ids.UUID, ids.PHONE,
                                ID_SOURCE_TYPE_AVITO, LOG_SOURCE_BS_HITLOG, SupplyType.DAILY)
# avito preproc for our emails
email_avito_hash = EdgeType(ids.EMAIL, ids.AVITO_HASH,
                            ID_SOURCE_TYPE_AVITO, LOG_SOURCE_PREPROCESSING,
                            SupplyType.PREPROC)

# Partners
partners_edges_types = [
    et
    for src in sorted(GROUP_ID_SOURCE_TYPE_PARTNERS_AUDIENCE)
    for et in (
        EdgeType(ids.PARTNER_RECORD_ID, ids.EMAIL,
                 src, LOG_SOURCE_PARTNERS_AUDIENCE, SupplyType.DUMP),
        EdgeType(ids.PARTNER_RECORD_ID, ids.PHONE,
                 src, LOG_SOURCE_PARTNERS_AUDIENCE, SupplyType.DUMP)
    )
]

partners_hash_edges_types = [
    et for src in sorted(GROUP_ID_SOURCE_TYPE_PARTNERS_AUDIENCE)
    for et in (
        EdgeType(ids.PARTNER_RECORD_ID, ids.EMAIL + ids.MD5_POSTFIX,
                 src, LOG_SOURCE_PARTNERS_AUDIENCE, SupplyType.DUMP),
        EdgeType(ids.PARTNER_RECORD_ID, ids.PHONE + ids.MD5_POSTFIX,
                 src, LOG_SOURCE_PARTNERS_AUDIENCE, SupplyType.DUMP)
    )
]

ezep_dump_et = EdgeType(ids.EMAIL + ids.MD5_POSTFIX, ids.PHONE + ids.MD5_POSTFIX,
                        ID_SOURCE_EZEP_DUMP, LOG_SOURCE_EXTERNAL_DUMPS, SupplyType.DUMP)

victoria_dump_et = EdgeType(ids.EMAIL + ids.MD5_POSTFIX, ids.PHONE + ids.MD5_POSTFIX,
                            ID_SOURCE_VICTORIA_DUMP, LOG_SOURCE_EXTERNAL_DUMPS, SupplyType.DUMP)

# passport phone day
puid_phonehash_psphn = EdgeType(ids.PUID, ids.PHONE + ids.MD5_POSTFIX,
                                ID_SOURCE_TYPE_PASSPORT_PROFILE, LOG_SOURCE_PASSPORT_PHONE, SupplyType.DAILY)

# passport phone bindings day
puid_phonehash_psphnbind = EdgeType(ids.PUID, ids.PHONE + ids.MD5_POSTFIX,
                                    ID_SOURCE_TYPE_PASSPORT_PROFILE, LOG_SOURCE_PASSPORT_PHONE_BINDINGS,
                                    SupplyType.DAILY)

puid_login_passport = EdgeType(ids.PUID, ids.LOGIN,
                               ID_SOURCE_TYPE_PASSPORT_PROFILE, LOG_SOURCE_PASSPORT_DICT, SupplyType.DUMP)

# mobile tracking
yuid_devid_mobtrack = EdgeType(
    ids.YANDEXUID, ids.MM_DEVICE_ID,
    ID_SOURCE_TYPE_TRACK, LOG_SOURCE_MOBILE_TRACKING, SupplyType.DAILY)
yuid_uuid_mobtrack = EdgeType(
    ids.YANDEXUID, ids.UUID,
    ID_SOURCE_TYPE_TRACK, LOG_SOURCE_MOBILE_TRACKING, SupplyType.DAILY)

# mobile report
yuid_uuid_mobreport = EdgeType(ids.YANDEXUID, ids.UUID,
                               ID_SOURCE_TYPE_SEARCH_APP_MOB_REPORT, LOG_SOURCE_MOBILE_REPORT, SupplyType.DAILY)

# people search
email_pridvk_psearch = EdgeType(ids.EMAIL, ids.VK_ID,
                                ID_SOURCE_TYPE_PEOPLE_SEARCH, LOG_SOURCE_PEOPLE_SEARCH, SupplyType.DUMP)
phone_pridvk_psearch = EdgeType(ids.PHONE, ids.VK_ID,
                                ID_SOURCE_TYPE_PEOPLE_SEARCH, LOG_SOURCE_PEOPLE_SEARCH, SupplyType.DUMP)
email_pridok_psearch = EdgeType(ids.EMAIL, ids.OK_ID,
                                ID_SOURCE_TYPE_PEOPLE_SEARCH, LOG_SOURCE_PEOPLE_SEARCH, SupplyType.DUMP)
phone_pridok_psearch = EdgeType(ids.PHONE, ids.OK_ID,
                                ID_SOURCE_TYPE_PEOPLE_SEARCH, LOG_SOURCE_PEOPLE_SEARCH, SupplyType.DUMP)

# yandex money dump
phone_yamoneyid_yamoney = EdgeType(ids.PHONE, ids.YAMONEY_ID,
                                   ID_SOURCE_TYPE_YANDEX_MONEY, LOG_SOURCE_YAMONEY, SupplyType.DUMP)
email_yamoneyid_yamoney = EdgeType(ids.EMAIL, ids.YAMONEY_ID,
                                   ID_SOURCE_TYPE_YANDEX_MONEY, LOG_SOURCE_YAMONEY, SupplyType.DUMP)
puid_yamoneyid_yamoney = EdgeType(ids.PUID, ids.YAMONEY_ID,
                                  ID_SOURCE_TYPE_YANDEX_MONEY, LOG_SOURCE_YAMONEY, SupplyType.DUMP)
yuid_yamoneyid_yamoney = EdgeType(ids.YANDEXUID, ids.YAMONEY_ID,
                                  ID_SOURCE_TYPE_YANDEX_MONEY, LOG_SOURCE_YAMONEY, SupplyType.DUMP)
yuid_phone_yamoney = EdgeType(ids.YANDEXUID, ids.PHONE,
                              ID_SOURCE_TYPE_YANDEX_MONEY, LOG_SOURCE_YAMONEY, SupplyType.DUMP)

# yandex tickets dump
# for left in [ids.PUID, ids.YANDEXUID]:
#     for right in [ids.EMAIL, ids.PHONE]:
puid_email_yatickets = EdgeType(ids.PUID, ids.EMAIL,
                                ID_SOURCE_TYPE_YANDEX_TICKETS, LOG_SOURCE_TICKETS, SupplyType.DUMP)
puid_phone_yatickets = EdgeType(ids.PUID, ids.PHONE,
                                ID_SOURCE_TYPE_YANDEX_TICKETS, LOG_SOURCE_TICKETS, SupplyType.DUMP)
yuid_email_yatickets = EdgeType(ids.YANDEXUID, ids.EMAIL,
                                ID_SOURCE_TYPE_YANDEX_TICKETS, LOG_SOURCE_TICKETS, SupplyType.DUMP)
yuid_phone_yatickets = EdgeType(ids.YANDEXUID, ids.PHONE,
                                ID_SOURCE_TYPE_YANDEX_TICKETS, LOG_SOURCE_TICKETS, SupplyType.DUMP)

# social auth ids
social_auth_puid_email = EdgeType(ids.PUID, ids.EMAIL,
                                  ID_SOURCE_TYPE_SOCIAL_AUTH, LOG_SOURCE_SOCIALDB, SupplyType.DUMP)
social_auth_puid_phone = EdgeType(ids.PUID, ids.PHONE + ids.MD5_POSTFIX,
                                  ID_SOURCE_TYPE_SOCIAL_AUTH, LOG_SOURCE_SOCIALDB, SupplyType.DUMP)
social_auth_social_id_pairs = [EdgeType(id1_type, id2_type,
                                        ID_SOURCE_TYPE_SOCIAL_AUTH,
                                        LOG_SOURCE_SOCIALDB,
                                        SupplyType.DUMP)
                               for id1_type, id2_type in get_social_edge_types()]

# dit msk dpm
yuid_ditid_ditmskdmp = EdgeType(ids.YANDEXUID, ids.DIT_ID,
                                ID_SOURCE_TYPE_DITMSK, LOG_SOURCE_DITMSK, SupplyType.DAILY)
emailhash_ditid_ditmskdmp = EdgeType(ids.EMAIL + ids.MD5_POSTFIX, ids.DIT_ID,
                                     ID_SOURCE_TYPE_DITMSK, LOG_SOURCE_DITMSK, SupplyType.DAILY)
phonehash_ditid_ditmskdmp = EdgeType(ids.PHONE + ids.MD5_POSTFIX, ids.DIT_ID,
                                     ID_SOURCE_TYPE_DITMSK, LOG_SOURCE_DITMSK, SupplyType.DAILY)

# pochta dumps
puid_vkcom_maildump = EdgeType(ids.PUID, ids.VK_ID,
                               ID_SOURCE_TYPE_MAIL_TEMPLATE, LOG_SOURCE_SHERLOCK, SupplyType.DUMP)
puid_insta_login_maildump = EdgeType(ids.PUID, ids.INSTAGRAM_LOGIN,
                                     ID_SOURCE_TYPE_MAIL_TEMPLATE, LOG_SOURCE_SHERLOCK, SupplyType.DUMP)
puid_insta_id_maildump = EdgeType(ids.PUID, ids.INSTAGRAM_ID,
                                  ID_SOURCE_TYPE_MAIL_TEMPLATE, LOG_SOURCE_SHERLOCK, SupplyType.DUMP)

# import sender day
yuid_email_senderday = EdgeType(ids.YANDEXUID, ids.EMAIL,
                                ID_SOURCE_TYPE_SENDERDAY, LOG_SOURCE_SENDERDAY, SupplyType.DAILY)

# webvisor
yuid_phone_webvisor = EdgeType(ids.YANDEXUID, ids.PHONE,
                               ID_SOURCE_TYPE_WEBVISOR, LOG_SOURCE_WEBVISOR, SupplyType.DAILY)
yuid_email_webvisor = EdgeType(ids.YANDEXUID, ids.EMAIL,
                               ID_SOURCE_TYPE_WEBVISOR, LOG_SOURCE_WEBVISOR, SupplyType.DAILY)

# postback daily
yuid_idfa_postclick = EdgeType(
    ids.YANDEXUID, ids.IDFA,
    ID_SOURCE_POSTCLICK, LOG_SOURCE_POSTCLICK, SupplyType.DAILY)

yuid_gaid_postclick = EdgeType(
    ids.YANDEXUID, ids.GAID,
    ID_SOURCE_POSTCLICK, LOG_SOURCE_POSTCLICK, SupplyType.DAILY)

# preproc
md5_hash_preproc_edges = [EdgeType(id_type, id_type_hashed,
                                   ID_SOURCE_TYPE_MD5_HASH, LOG_SOURCE_PREPROCESSING,
                                   SupplyType.PREPROC)
                          for id_type, id_type_hashed in ID_HASH_MAPPING.items()]

login_to_email_et = EdgeType(ids.LOGIN, ids.EMAIL,
                             ID_SOURCE_TYPE_LOGIN_TO_EMAIL, LOG_SOURCE_PREPROCESSING,
                             SupplyType.PREPROC)

# fuzzy
devid_yuid_ios_fuzzy_indev = EdgeType(
    ids.IDFA, ids.YANDEXUID,
    ID_SOURCE_TYPE_FUZZY, LOG_SOURCE_FUZZY_INDEV, SupplyType.DUMP)
devid_yuid_andoroid_fuzzy_indev = EdgeType(
    ids.GAID, ids.YANDEXUID,
    ID_SOURCE_TYPE_FUZZY, LOG_SOURCE_FUZZY_INDEV, SupplyType.DUMP)

idfa_yuid_fuzzy2_indev = EdgeType(
    ids.IDFA, ids.YANDEXUID,
    ID_SOURCE_TYPE_FUZZY2, LOG_SOURCE_FUZZY2_INDEV, SupplyType.DUMP)
gaid_yuid_fuzzy2_indev = EdgeType(
    ids.GAID, ids.YANDEXUID,
    ID_SOURCE_TYPE_FUZZY2, LOG_SOURCE_FUZZY2_INDEV, SupplyType.DUMP)

# households
yuid_yuid_smart_tv_hh = EdgeType(
    ids.YANDEXUID, ids.YANDEXUID,
    ID_SOURCE_TYPE_SMART_TV, LOG_SOURCE_HOUSEHOLDS, SupplyType.DUMP)

# idserv
IDSERV_IDS = [
    ids.YANDEXUID,
    ids.MM_DEVICE_ID,
    ids.GAID,
    ids.IDFA,
    ids.UUID,
]

idserv_edge_types = [
    EdgeType(ids.YANDEXUID, ids.MM_DEVICE_ID, ID_SOURCE_TYPE_IDSERV, LOG_SOURCE_IDSERV, SupplyType.DAILY),
    EdgeType(ids.YANDEXUID, ids.IDFA, ID_SOURCE_TYPE_IDSERV, LOG_SOURCE_IDSERV, SupplyType.DAILY),
    EdgeType(ids.YANDEXUID, ids.GAID, ID_SOURCE_TYPE_IDSERV, LOG_SOURCE_IDSERV, SupplyType.DAILY),
    EdgeType(ids.YANDEXUID, ids.UUID, ID_SOURCE_TYPE_IDSERV, LOG_SOURCE_IDSERV, SupplyType.DAILY),
    EdgeType(ids.MM_DEVICE_ID, ids.IDFA, ID_SOURCE_TYPE_IDSERV, LOG_SOURCE_IDSERV, SupplyType.DAILY),
    EdgeType(ids.MM_DEVICE_ID, ids.GAID, ID_SOURCE_TYPE_IDSERV, LOG_SOURCE_IDSERV, SupplyType.DAILY),
    EdgeType(ids.MM_DEVICE_ID, ids.UUID, ID_SOURCE_TYPE_IDSERV, LOG_SOURCE_IDSERV, SupplyType.DAILY),
    EdgeType(ids.GAID, ids.UUID, ID_SOURCE_TYPE_IDSERV, LOG_SOURCE_IDSERV, SupplyType.DAILY),
    EdgeType(ids.IDFA, ids.UUID, ID_SOURCE_TYPE_IDSERV, LOG_SOURCE_IDSERV, SupplyType.DAILY),
]

# ======== ADDITIONAL ========


# take all EdgeType variables and all lists with EdgeTypes from this module
# and put it together as dictionary
# it will look like { 'yuid_email_auto_autoru_front_log' : yuid_email_autorufrontlog, ...}
ALL_EDGES_DICT = {
    e.key(): e
    for e in chain.from_iterable(
    (
        (e,) if isinstance(e, EdgeType) else (
            e if e and isinstance(e[0], EdgeType) else []
        )
    )
    for e in locals().itervalues()
    if isinstance(e, (EdgeType, list))
)
}
ALL_EDGES = ALL_EDGES_DICT.values()
ALL_EDGES_BY_LOG_DICT = defaultdict(list)
for et in ALL_EDGES:
    ALL_EDGES_BY_LOG_DICT[et.log_source].append(et)
