
class EdgeType(object):
    def __init__(self,
                 id1_type,
                 id2_type,
                 source,
                 log_source,
                 supply_type,
                 yandex_source=True):
        self.id1_type = id1_type
        self.id2_type = id2_type
        self.source = source
        self.log_source = log_source
        self.supply_type = supply_type
        self.yandex_source = yandex_source

    def name(self):
        return '%s_%s_%s_%s' % (self.id1_type, self.id2_type, self.source, self.log_source)

    def key(self):
        return self.id1_type, self.id2_type, self.source, self.log_source

    def __eq__(self, another):
        other_key = another.key() if another else None
        return self.key() == other_key

    def __hash__(self):
        return hash(self.key())


class SupplyType(object):
    """
    The way specific edge is added to soup
    """
    DAILY = 'daily'
    DUMP = 'dump'
    PREPROC = 'preproc'


def get_all_soup_id_types():
    from v2.soup.soup_config import ALL_EDGES
    id_types = set()
    for e in ALL_EDGES:
        id_types.add(e.id1_type)
        id_types.add(e.id2_type)
    return sorted(id_types)

def get_edge_type(id1_type, id2_type, source, log_source):
    """
    :rtype: soup.soup_edge_type.EdgeType
    """
    from v2.soup.soup_config import ALL_EDGES_DICT
    et = ALL_EDGES_DICT.get((id1_type, id2_type, source, log_source))
    if et:
        return et
    else:
        raise Exception('EdgeType %s_%s_%s_%s is not supported' % (id1_type, id2_type, source, log_source))
