import string

import white

import v2.ids as ids
from utils import utils
from v2.soup import soup_config


class DefaultSoupValue(white.WhiteBase):
    allowed_types = (str, unicode)
    normalization_params = {
        "strip_spaces": True,
        "remove_double_quotes": True
    }


class WhitePUID(DefaultSoupValue):
    normalization_params = {
        "only_digits": True
    }


class WhiteLogin(DefaultSoupValue):
    normalization_params = {
        "lowercase": True,
        "remove_spaces": True,
        "remove_curly_braces": True,
        "remove_round_braces": True,
        "remove_double_quotes": True
    }

    def _normalize(self, value):
        result = super(WhiteLogin, self)._normalize(value)
        value = result[white.consts.DEFAULT_VALUE_FIELD]
        if value:
            result[white.consts.DEFAULT_VALUE_FIELD] = utils.norm_login(value)

        return result


ID_TYPE_TO_WHITE = {
    ids.YANDEXUID: white.WhiteYandexUID(),
    ids.PUID: WhitePUID(),

    ids.UUID: white.WhiteUUID(),

    ids.LOGIN: WhiteLogin(),
    ids.EMAIL: white.WhiteEmail(),
    ids.EMAIL + ids.MD5_POSTFIX: white.WhiteEmail(),  # ?

    ids.PHONE: white.WhitePhone(),
    ids.PHONE + ids.MD5_POSTFIX: white.WhitePhone(),  # ?

    ids.MAC: white.WhiteMAC()
}

allowed_symbols = set(string.printable) - set(string.whitespace)


# CRYPTAYT-2563
def remove_non_allowed(str_value):
    return filter(lambda ch: ch in allowed_symbols, str_value)


def normalize(id_type, id_value):
    """
    :return: normalized value is validation is succeeded, otherwise None
    """
    # CRYPTAYT-2563
    id_value = remove_non_allowed(id_value)
    if not id_value or len(id_value) > 200:
        return ""

    wp = ID_TYPE_TO_WHITE.get(id_type, DefaultSoupValue())

    white_result = wp.process(id_value)
    if id_type in soup_config.ID_HASH_MAPPING.values():
        return white_result["hash"]
    else:
        return white_result["value"]


def normalize_rec(rec):
    id1 = normalize(rec['id1Type'], rec['id1'])
    id2 = normalize(rec['id2Type'], rec['id2'])
    if id1 and id2:
        rec['id1'] = id1
        rec['id2'] = id2
        return rec
    else:
        return None
