import collections
from datetime import datetime, timedelta
import hashlib
import os
import json
from testdata_patterns import PASSPORT_SENS, PASSPORT_PHONE, \
    FP, ACCESS_LOG, EXPORT_ACCESS_LOG, PASSPORT_USER_DATA, KINOPOISK_LOG, \
    AUTORU_LOG, WATCH_LOG, PEOPLE_SEARCH_DICT, VK_PROFILES_DUMP, \
    YAMONEY_LOG, YAMONEY_PHONE_LOG, DEV_YUID_INDEVICE_PERFECT_NO_LIMIT, \
    MOB_REPORT_LOG, PUID_LOGIN_DICT_LOG, CUBE_LOG, WEBVISOR_DATES_PROCESSED_LOG, \
    APPSFLYER_LOG, POSTCLICK_LOG, YUID_WITH_ALL, MOBILE_REDIRECT_BIND_LOG, MOBILE_REDIRECT_LOG, \
    TICKETS_ORDER_LOG, DICTS_INCOME_DATA_WITH_DEV_INFO, DICTS_PASSPORT_DUMP, DICTS_PUID_YUID, \
    DICTS_PUID_YUID_YT, DICTS_YUID_REGS, YAMONEY_YAMONEY_IN_V1, DEV_INFO_WITH_INCOME, \
    BS_RTB_LOG, SBAPI_MITB_LOG, AUDIMVIDEO_EMAILS_LOG, SBER_PHONES_LOG, LAL_MANAGER_DATA_TO_CLASSIFY, \
    INSTAGRAM_PUID_LOG, WEBVISOR_COPY, DICTS_DEV_INFO, DICTS_YUID_WITH_ALL_GOOD, RADIUS_LOG, \
    STATBOX_SQL_PASSPORT_ACCOUNTS, SENDR_CLICK_LOG, SBAPI_LOOKUP_ACCESS_LOG, YABS_EVENT_LOG, BAR_NAVIG_LOG, \
    ISCRYPTA_MATCHING_LOG, DITMSK_COOKIEMATCHING, DITMSK_DAY_DUMP, MAIL_VKIDS_DAYDUMP, \
    MOBILE_TRACKING_LOG, MOBILE_TRACKING_PRIVATE_LOG, OAUTH_LOG, REDIR_LOG, PASSPORT_LOG, \
    DICTS_YUID_IDS, DICTS_YUID_UA, CRYPTA_RT_GEO_LOG, BS_CHEVENT_LOG, HOUSEHOLD_MERGED_HOUSEHOLDS, \
    METRIKA_MOBILE_LOG, WEBVISOR_STREAM_ALIVE, PASSPORT_SOCIAL, IDSERV_ACCESS_LOG, FUZZY_PAIRS, SMART_TV_HH_PAIRS,\
    CRYPTA_YANDEXUID_PROFILES_LOG

import white

from testdata_helper import BaseLog, FPLog, AccessLog, SingleTableLog, metrica_crypt, ComplexParametersLog
from Crypto.PublicKey import RSA


def convert_old_fp_to_watch_log(target, source, date):
    """ Unwrap old fp format log back to primary logs to make tests pass """
    for data in source:
        history = data['history']
        for timestamp in history.split(','):
            timestamp, _ = timestamp.split(':', 1)
            row = dict(
                _date=date, clientip=data.get('ip', ''),
                uniqid=data.get('yandexuid', ''), cookiei=data.get('yandexuid', ''),
                useragent=data.get('user_agent', ''), login=data.get('login', ''),
                _logfeller_timestamp=int(timestamp))
            if 'vk_com_id' in data:
                row['referer'] = 'https://vk.com/?mid={}'.format(data['vk_com_id'])
            target.add_row(**row)


SOME_PREV_DATE = "2016-02-10"
TEST_RUN_DATE_STR = "2016-04-10"

dir_path = os.path.dirname(os.path.realpath(__file__))

with open(os.getenv('METRICA_RSA_KEY_PATH')) as f:
    from Crypto.Cipher import PKCS1_v1_5
    rsakey = RSA.importKey(f.read())
    rsa = PKCS1_v1_5.new(rsakey)

DESK_UA = "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.2.0.3539 Yowser/2.5 Safari/537.36"
SMARTTV_UA = "Mozilla/5.0 (SMART-TV; X11; Linux armv7l) AppleWebkit/537.42 (KHTML, like Gecko) Chromium/25.0.1349.2 Chrome/25.0.1349.2 Safari/537.42"
IPHONE_UA = "Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"
YABRO_UA = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7146 Yowser/2.5 Safari/537.36"
ANDROID_UA = "Mozilla/5.0 (Linux; Android 4.4.2; Ixion ML145 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36"
ANDROID_HTC = "Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; HTC Desire 310 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30 YandexSearch/5.45"

PARTNERS_AUDIENCE_FIXTURES_PATH = 'fixtures/partners_audience.json'
PARTNERS_FLAT_FIXTURES_PATH = 'fixtures/partners_flat.json'

PEOPLE_SEARCH_FIXTURES_PATH = 'fixtures/people_search.json'

rawdata_fp = list()
rawdata_fp.append(dict(ip="85.174.38.23", yandexuid="2577188551456167601", user_agent=DESK_UA, login="Lagutin2008", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.38.23", yandexuid="2577188551456167611", user_agent=DESK_UA, login="Lagutin2008", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="31.173.80.25", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="cfd36eb292d2d747435a6e31b5aadb26", history="1460326111:mm:55.6563968:37.3975021,1460327989:mm:55.6513844:37.387669,1460354373:mm:55.6513844:37.387669,1460354373:mm:55.6513844:37.387669,1460354373:mm:55.6513844:37.387669,1460354376:mm:55.6572839:37.4029805"))
rawdata_fp.append(dict(ip="78.106.126.12", yandexuid="7074010371428486964", fuid="1030195971384194234", history="1460382176:r,1460382185:r"))
rawdata_fp.append(dict(ip="5.165.39.55", yandexuid="6927584441427992515", fuid="13348466971424465160", user_agent="Mozilla/5.0 (SMART-TV; X11; Linux armv7l) AppleWebkit/537.42 (KHTML, like Gecko) Chromium/25.0.1349.2 Chrome/25.0.1349.2 Safari/537.42", java="1", plugin_hash="156769251001", b_lang="c", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp.append(dict(ip="93.185.197.39", yandexuid="7520203571383726763", puid="19150427", history="1460374280:p,1460374280:p,1460374280:p"))
rawdata_fp.append(dict(ip="213.87.162.157", uuid="13cc284f279bd1702a1adb429ba68298", deviceid="404693f45cc376674266202bbc3b982d", history="1460366028:mm,1460366028:mm"))
rawdata_fp.append(dict(ip="91.204.176.18", yandexuid="1358811251455881991", fuid="283613721457621670", user_agent="Opera/9.80 (Android; Opera Mini/15.0.2125/37.8157; U; ru) Presto/2.12.423 Version/12.16", plugin_hash="383305183401", xoperaminiphoneua="Mozilla/5.0 (Linux; Android 4.4.2; Ixion ML145 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", login="bars12@161.ru", history="1460357845:m,1460357853:m,1460357969:m"))
rawdata_fp.append(dict(ip="88.85.195.48", yandexuid="1495205931451997969", fuid="16416450621445877538", mail_ru_login="anoshko_yana@mail.ru", user_agent="Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7146 Yowser/2.5 Safari/537.36", plugin_hash="417650996401", login="anoshko.av", history="1460365678:m,1460379333:m"))
rawdata_fp.append(dict(ip="88.85.195.48", yandexuid="601826891455547779", fuid="3644952421455693848", user_agent="Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.110 Safari/537.36", plugin_hash="97806405901", vk_com_id="27627371", history="1460370877:m"))
rawdata_fp.append(dict(ip="176.125.194.65", yandexuid="6619110241447613888", fuid="5987103671447613889", user_agent="Mozilla/5.0 (Linux; Android 5.1; Lenovo A2010-a Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.105 Mobile Safari/537.36", plugin_hash="216613626101", login="stoltat", history="1460348138:m,1460348138:m,1460348243:m,1460348243:m,1460348246:m,1460348246:m,1460348246:m"))
rawdata_fp.append(dict(ip="46.72.214.19", yandexuid="8887683331441813775", fuid="81155321441814303", user_agent="Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.157 YaBrowser/15.9.2403.3043 Safari/537.36", java="1", plugin_hash="247168530901", login="aashinova", history="1460360148:m,1460360148:m,1460360152:m"))
rawdata_fp.append(dict(ip="92.101.247.246", yandexuid="7249027431455393740", user_agent="Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; GT-P5100 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Safari/534.30", history="1460322066:a,1460324212:a,1460324212:a,1460324212:a,1460324213:a,1460324219:a,1460324219:a"))
rawdata_fp.append(dict(ip="46.187.50.11", yandexuid="9574390901437926574", user_agent=IPHONE_UA, puid="194502233", history="1460390405:m,1460390542:m,1460396965:m"))

rawdata_fp.append(dict(ip="78.25.121.32", yandexuid="5860408211418147506", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1", history="1460238040:a,1460238040:a,1460238041:a"))
rawdata_fp.append(dict(ip="79.165.27.223", yandexuid="7740095711445945300", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_3 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13E233 Safari/601.1", history="1460292286:a"))
rawdata_fp.append(dict(ip="95.153.131.5", yandexuid="8540896401445067609", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 8_4 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H143 Safari/600.1.4", history="1460311814:a,1460311850:a"))
rawdata_fp.append(dict(ip="85.140.2.211", yandexuid="5299407961448206668", fuid="10729360511448206684", history="1460308429:b,1460308444:b,1460308448:b,1460310099:b,1460310117:b,1460310371:b,1460310536:b,1460310598:b,1460310694:b,1460310713:b,1460310796:b"))
rawdata_fp.append(dict(ip="91.146.45.152", yandexuid="354879291458845025", fuid="11215910881458847387", history="1460237478:r,1460240877:r,1460263057:r,1460263058:r,1460263073:r,1460263075:r,1460263272:r,1460263288:r,1460263293:r,1460263669:r,1460264506:r,1460264625:r,1460275104:r,1460278732:r,1460278740:r,1460281163:r,1460286988:r"))
rawdata_fp.append(dict(ip="194.226.49.43", yandexuid="46069391421503557", screen_size="360x640x32", fuid="11902130281425890162", user_agent="Mozilla/5.0 (Linux; Android 5.0; SAMSUNG SM-N900 Build/LRX21V) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36", java="1", plugin_hash="216613626101", login="ev0ngertlt", history="1460274628:m,1460274726:m,1460274727:m,1460274727:m"))
rawdata_fp.append(dict(ip="37.122.26.189", yandexuid="1169456551460062417", fuid="15331651941460069458", user_agent="Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7146 Yowser/2.5 Safari/537.36", history="1460234435:m,1460241403:m,1460242349:m,1460242603:m"))
rawdata_fp.append(dict(ip="46.138.212.193", yandexuid="4422446881454020740", fuid="18244561191454709601", user_agent="Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7146 Safari/537.36", login="andrei.ponomareff-1997", history="1460235744:m,1460241680:m,1460243026:m,1460287022:m,1460289701:m,1460301929:m"))
rawdata_fp.append(dict(ip="5.142.37.166", yandexuid="5308405301441752808", screen_size="1280x800x32", fuid="18860585511441752811", user_agent="Mozilla/5.0 (Linux; Android 5.1.1; SGP521 Build/23.4.A.1.232) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.2.1.7529.01 Safari/537.36", plugin_hash="216613626101", login="modsever", history="1460242522:m,1460242532:m,1460242546:m,1460242552:m,1460242556:m,1460242612:m,1460242617:m,1460242617:m,1460242624:m,1460242624:m,1460242624:m,1460242636:m,1460242640:m,1460242640:m,1460242640:m,1460242647:m,1460242649:m,1460242679:m,1460242682:m,1460242821:m,1460242826:m"))
rawdata_fp.append(dict(ip="31.47.170.199", yandexuid="2512730601443681995", screen_size="1920x1080x24", fuid="19282323511434881385", user_agent="Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.87 Safari/537.36 OPR/36.0.2130.46", plugin_hash="238476119301", login="evarcher", history="1460276786:m,1460276796:m,1460296477:m"))
rawdata_fp.append(dict(ip="109.187.220.93", yandexuid="6779234761452927619", screen_size="360x640x32", fuid="20634471291452927637", user_agent="Mozilla/5.0 (Linux; Android 4.4.2; PSP5470DUO Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.2.1.7529.00 Mobile Safari/537.36", plugin_hash="216613626101", login="sveta.aleshina2015", history="1460244176:m,1460244299:m,1460244345:m,1460244345:m,1460244351:m,1460244428:m,1460244437:m,1460254016:m,1460254023:m,1460254023:m,1460254139:m,1460254160:m,1460254208:m,1460254225:m,1460254246:m,1460254268:m"))

rawdata_fp.append(dict(ip="217.13.91.184", yandexuid="1000011459458000", fuid="1313103671447613889", user_agent="Mozilla/5.0 (Linux; Android 5.1; Lenovo A2010-a Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.105 Mobile Safari/537.36", plugin_hash="216613626101", history="1460348138:m,1460348138:m,1460348243:m,1460348243:m,1460348246:m,1460348246:m,1460348246:m"))
rawdata_fp.append(dict(ip="217.13.91.184", yandexuid="1000021459458000", fuid="1313103671447613889", user_agent="Mozilla/5.0 (Linux; Android 5.1; Lenovo A2010-a Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.105 Mobile Safari/537.36", plugin_hash="216636333101", history="1460348138:m,1460348138:m,1460348243:m,1460348243:m,1460348246:m,1460348246:m,1460348246:m"))
rawdata_fp.append(dict(ip="217.13.91.184", yandexuid="1000031459458000", fuid="1313103671447613889", user_agent="Mozilla/5.0 (Linux; Android 5.1; Lenovo A2010-a Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.105 Mobile Safari/537.36", plugin_hash="216613644401", history="1460348138:m,1460348138:m,1460348243:m,1460348243:m,1460348246:m,1460348246:m,1460348246:m"))
rawdata_fp.append(dict(ip="217.13.91.184", yandexuid="1000041459458000", fuid="1313103671447613889", user_agent="Mozilla/5.0 (Linux; Android 5.1; Lenovo A2010-a Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.105 Mobile Safari/537.36", plugin_hash="216613655501", history="1460348138:m,1460348138:m,1460348243:m,1460348243:m,1460348246:m,1460348246:m,1460348246:m"))

#for new mtrika_mobile_log
rawdata_fp.append(dict(ip="31.173.80.25", yandexuid="2577188551456167771", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="00002907a397aea15dbfbdcf0472a111", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.3.1 Mobile/13E233 Safari/601.1"))
rawdata_fp.append(dict(ip="31.173.80.25", yandexuid="2577188551456167771", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="00002907a397aea15dbfbdcf0472a111", history="1397034612:mm:55.6563968:37.3975021,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.3.1 Mobile/13E233 Safari/601.1"))
rawdata_fp.append(dict(ip="31.173.80.25", yandexuid="2577188551456167772", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="00002907a397aea15dbfbdcf0472a111", history="1397035812:mm:55.6563968:37.3975021,1397035812:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.3.1 Mobile/13E233 Safari/601.1"))
rawdata_fp.append(dict(ip="31.173.80.26", yandexuid="2577188551456167772", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="00002907a397aea15dbfbdcf0472a121", history="1397033772:mm:55.6563968:37.3975021,1397033772:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.3.1 Mobile/13E233 Safari/601.1"))
rawdata_fp.append(dict(ip="31.173.80.26", yandexuid="2577188551456167773", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="00002907a397aea15dbfbdcf0472a131", history="1397033772:mm:55.6563968:37.3975021,1397033772:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.3.1 Mobile/13E233 Safari/601.1"))

#for webvisor ecomerce mobile and desk
rawdata_fp.append(dict(ip="31.173.80.25", yandexuid="222221455542221", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="00002907a397aea15dbfbdcf0472a111", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent=DESK_UA))
rawdata_fp.append(dict(ip="31.173.80.25", yandexuid="222221455542221", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="00002907a397aea15dbfbdcf0472a111", history="1397034612:mm:55.6563968:37.3975021,1397034612:mm:55.6513844:37.387669", user_agent=DESK_UA))


#for fuzzy merged_hh vs yuid_with_all
rawdata_fp.append(dict(ip="111.22.11.11", yandexuid='157564101446625111',  user_agent=IPHONE_UA, login="test_login111", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.11", yandexuid='157564101446625112',  user_agent=DESK_UA, login="test_login111", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.12", yandexuid='157564101446625113',  user_agent=IPHONE_UA, login="test_login113", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.12", yandexuid='157564101446625114',  user_agent=DESK_UA, login="test_login114", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.13", yandexuid='157564101446625121',  user_agent=IPHONE_UA, login="test_login115", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.13", yandexuid='157564101446625122',  user_agent=DESK_UA, login="test_login115", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.14", yandexuid='157564101446625123',  user_agent=IPHONE_UA, login="test_login116", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.14", yandexuid='157564101446625124',  user_agent=DESK_UA, history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.15", yandexuid='157564101446629164',  user_agent=IPHONE_UA, history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.15", yandexuid='1813903801458090754', user_agent=DESK_UA, login="test_login0754", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.21", yandexuid='213261281388846262',  user_agent=DESK_UA, history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.21", yandexuid='2263475241459074652', user_agent=DESK_UA, history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.22", yandexuid='2565999051458967148', user_agent=IPHONE_UA, history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.22", yandexuid='7065602181459495311', user_agent=IPHONE_UA, login="test_login311", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.23", yandexuid='7065602181459495312', user_agent=IPHONE_UA, login="test_login311", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.23", yandexuid='7065602181459495313', user_agent=IPHONE_UA, login="test_login313", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.24", yandexuid='7065602181459495314', user_agent=IPHONE_UA, login="test_login314", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.24", yandexuid='7065602181459495321', user_agent=IPHONE_UA, login="test_login315", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.25", yandexuid='7065602181459495322', user_agent=IPHONE_UA, login="test_login315", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.25", yandexuid='7065602181459495323', user_agent=IPHONE_UA, login="test_login316", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.31", yandexuid='7065602181459495324', user_agent=IPHONE_UA, login="test_login316", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.31", yandexuid='7065602181459495331', user_agent=IPHONE_UA, history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.32", yandexuid='7065602181459495332', user_agent=IPHONE_UA, login="test_login317", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.32", yandexuid='7065602181459495333', user_agent=IPHONE_UA, login="test_login318", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.33", yandexuid='7065602181459495334', user_agent=IPHONE_UA, login="test_login318", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.33", yandexuid='7065602181459497865', user_agent=IPHONE_UA, history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.34", yandexuid='9731293591459364411', user_agent=DESK_UA, login="test_login4411", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.34", yandexuid='9731293591459364422', user_agent=DESK_UA, login="test_login4422", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.35", yandexuid='9731293591459364433', user_agent=DESK_UA, login="test_login4433", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="111.22.11.35", yandexuid='9731293591459364477', user_agent=DESK_UA, login="test_login4477", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.41", yandexuid='9731293591459365211', user_agent=DESK_UA, login="test_login211", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.41", yandexuid='9731293591459365212', user_agent=DESK_UA, login="test_login211", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.42", yandexuid='9731293591459365213', user_agent=DESK_UA, login="test_login213", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.42", yandexuid='9731293591459365214', user_agent=DESK_UA, login="test_login214", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.43", yandexuid='9731293591459365221', user_agent=DESK_UA, login="test_login215", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.43", yandexuid='9731293591459365222', user_agent=DESK_UA, login="test_login215", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.44", yandexuid='9731293591459365223', user_agent=DESK_UA, login="test_login216", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.44", yandexuid='9731293591459365224', user_agent=DESK_UA, login="test_login216", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.45", yandexuid='9731293591459365231', user_agent=DESK_UA, login="test_login217", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.45", yandexuid='9731293591459365232', user_agent=DESK_UA, login="test_login217", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.51", yandexuid='9731293591459365233', user_agent=DESK_UA, login="test_login218", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="85.174.11.51", yandexuid='9731293591459365234', user_agent=DESK_UA, history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))

#for pairs black list
rawdata_fp.append(dict(ip="77.22.11.11", yandexuid='222564101446625991',  user_agent=IPHONE_UA, login="pairs_bl_login111", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="77.22.11.11", yandexuid='222564101446625992',  user_agent=DESK_UA, login="pairs_bl_login111", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="77.22.11.11", yandexuid='222564101446625993',  user_agent=IPHONE_UA, login="pairs_bl_login222", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="77.22.11.11", yandexuid='222564101446625994',  user_agent=DESK_UA, login="pairs_bl_login222", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="77.22.11.11", yandexuid='222564101446625995',  user_agent=IPHONE_UA, login="pairs_bl_login333", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))
rawdata_fp.append(dict(ip="77.22.11.11", yandexuid='222564101446625996',  user_agent=DESK_UA, login="pairs_bl_login333", history="1460322914:m,1460322929:m,1460322953:m,1460323018:m,1460323053:m,1460323065:m,1460323145:m,1460323156:m,1460323199:m,1460323204:m,1460323226:m"))


rawdata_fp3 = list()
# data for radius metrics
rawdata_fp3.append(dict(ip="85.174.38.23", yandexuid="601826891455541112", mail_ru_login="mail_login", user_agent=DESK_UA, deviceid="1670a3e6c91fba9d07c53d02a551632c", login="WatchRadius", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.23", yandexuid="601826891455541113", user_agent=DESK_UA, deviceid="1670a3e6c91fba9d07c53d02a551632c", vk_com_id="11111", login="WatchRadius", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.25", yandexuid="601826891455541113", mail_ru_login="mail_login", user_agent=DESK_UA, history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.25", yandexuid="601826891455541113", user_agent=DESK_UA, vk_com_id="11111", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.23", yandexuid="601826891455542222", mail_ru_login="mail_login2", user_agent=DESK_UA, deviceid="1670a3e6c91fba9d07c53d02a551632c", login="WatchRadius2", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.23", yandexuid="601826891455542223", mail_ru_login="mail_login2", user_agent=DESK_UA, deviceid="1670a3e6c91fba9d07c53d02a551632c", login="WatchRadius2", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.23", yandexuid="601826891455541114", mail_ru_login="mail_login_mob", user_agent=IPHONE_UA, login="WatchRadiusMob", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.23", yandexuid="601826891455541115", user_agent=IPHONE_UA, vk_com_id="11112", login="WatchRadiusMob", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.25", yandexuid="601826891455541115", mail_ru_login="mail_login_mob", user_agent=IPHONE_UA, history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.25", yandexuid="601826891455541115", user_agent=IPHONE_UA, vk_com_id="11112", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.23", yandexuid="601826891455542224", mail_ru_login="mail_login_mob2", user_agent=IPHONE_UA, login="WatchRadiusMob2", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.23", yandexuid="601826891455542225", user_agent=IPHONE_UA, vk_com_id="11113", login="WatchRadiusMob2", history="1460390405:m,1460390542:m,1460396965:m"))

rawdata_fp3.append(dict(ip="85.174.38.33", yandexuid="1748232901455365413", user_agent="Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7146 Yowser/2.5 Safari/537.36", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp3.append(dict(ip="85.174.38.33", yandexuid="5726075371455990918", user_agent=IPHONE_UA, history="1460390405:m,1460390542:m,1460396965:m"))

#for did pairs
rawdata_fp3.append(dict(ip="31.173.11.99", yandexuid="222221455549999", uuid="bf62d1b137388c21ddb64090dd02c111", deviceid="77772907a397aea15dbfbdcf0472a111", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"))
rawdata_fp3.append(dict(ip="31.173.22.99", yandexuid="222221455548889", uuid="bf62d1b137388c21ddb64090dd02c112", deviceid="77772907a397aea15dbfbdcf0472a122", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"))
rawdata_fp3.append(dict(ip="31.173.33.99", yandexuid="222221455548887", uuid="bf62d1b137388c21ddb64090dd02c113", deviceid="77772907a397aea15dbfbdcf0472a133", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"))
rawdata_fp3.append(dict(ip="31.173.44.99", yandexuid="222221455548886", uuid="bf62d1b137388c21ddb64090dd02c114", deviceid="77772907a397aea15dbfbdcf0472a144", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"))
rawdata_fp3.append(dict(ip="31.173.55.99", yandexuid="222221455549991", uuid="bf62d1b137388c21ddb64090dd02c115", deviceid="77772907a397aea15dbfbdcf0472a155", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"))
rawdata_fp3.append(dict(ip="31.173.66.99", yandexuid="222221455548884", uuid="bf62d1b137388c21ddb64090dd02c116", deviceid="77772907a397aea15dbfbdcf0472a166", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"))
rawdata_fp3.append(dict(ip="31.173.77.99", yandexuid="2410530891459150418", uuid="bf62d1b137388c21ddb64090dd02c117", deviceid="77772907a397aea15dbfbdcf0472a177", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"))
rawdata_fp3.append(dict(ip="31.173.88.99", yandexuid="2410530891459150411", uuid="bf62d1b137388c21ddb64090dd02c118", deviceid="77772907a397aea15dbfbdcf0472a188", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"))
rawdata_fp3.append(dict(ip="31.173.99.99", yandexuid="2410530891459150413", uuid="bf62d1b137388c21ddb64090dd02c119", deviceid="77772907a397aea15dbfbdcf0472a199", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"))
rawdata_fp3.append(dict(ip="31.173.10.99", yandexuid="2410530891459150414", uuid="bf62d1b137388c21ddb64090dd02c110", deviceid="77772907a397aea15dbfbdcf0472a110", history="1397034612:mm:55.6563968:37.6563968,1397034612:mm:55.6513844:37.387669", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53"))

rawdata_fp3.append(dict(ip="31.173.80.26", yandexuid="222221455542223", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="00002907a397aea15dbfbdcf0472a121", history="1397033772:mm:55.6563968:37.3975021,1397033772:mm:55.6513844:37.387669", user_agent=IPHONE_UA))
rawdata_fp3.append(dict(ip="31.173.80.26", yandexuid="222221455542223", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="00002907a397aea15dbfbdcf0472a131", history="1397033772:mm:55.6563968:37.3975021,1397033772:mm:55.6513844:37.387669", user_agent=IPHONE_UA))


rawdata_fp2 = list()
# data for radius metrics
rawdata_fp2.append(dict(ip="15.174.38.23", yandexuid="101826891455541112", mail_ru_login="mail_login", user_agent=DESK_UA, deviceid="1670a3e6c91fba9d07c53d02a551632c", login="WatchRadius", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.23", yandexuid="101826891455541113", user_agent=DESK_UA, deviceid="1670a3e6c91fba9d07c53d02a551632c", vk_com_id="11111", login="WatchRadius", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.25", yandexuid="101826891455541113", mail_ru_login="mail_login", user_agent=DESK_UA, history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.25", yandexuid="101826891455541113", user_agent=DESK_UA, vk_com_id="11111", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.23", yandexuid="101826891455542222", mail_ru_login="mail_login2", user_agent=DESK_UA, deviceid="1670a3e6c91fba9d07c53d02a551632c", login="WatchRadius2", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.23", yandexuid="101826891455542223", mail_ru_login="mail_login2", user_agent=DESK_UA, deviceid="1670a3e6c91fba9d07c53d02a551632c", login="WatchRadius2", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.23", yandexuid="101826891455541114", mail_ru_login="mail_login_mob", user_agent=IPHONE_UA, login="WatchRadiusMob", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.23", yandexuid="101826891455541115", user_agent=IPHONE_UA, vk_com_id="11112", login="WatchRadiusMob", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.25", yandexuid="101826891455541115", mail_ru_login="mail_login_mob", user_agent=IPHONE_UA, history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.25", yandexuid="101826891455541115", user_agent=IPHONE_UA, vk_com_id="11112", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.23", yandexuid="101826891455542224", mail_ru_login="mail_login_mob2", user_agent=IPHONE_UA, login="WatchRadiusMob2", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.23", yandexuid="101826891455542225", user_agent=IPHONE_UA, vk_com_id="11113", login="WatchRadiusMob2", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.33", yandexuid="2748232901455365413", user_agent="Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7146 Yowser/2.5 Safari/537.36", history="1460390405:m,1460390542:m,1460396965:m"))
rawdata_fp2.append(dict(ip="15.174.38.33", yandexuid="1726075371455990918", user_agent=IPHONE_UA, history="1460390405:m,1460390542:m,1460396965:m"))

rawdata_fp2.append(dict(ip="31.173.80.25", yandexuid="222221455542222", uuid="bf62d1b137388c21ddb64090dd02c94c", deviceid="00002907a397aea15dbfbdcf0472a111", history="1397035812:mm:55.6563968:37.3975021,1397035812:mm:55.6513844:37.387669", user_agent=IPHONE_UA))


testdata_passport_sens = BaseLog(
    path="//statbox/passport-sensitive-log",
    date="2016-04-09",
    default_data=PASSPORT_SENS
)
testdata_passport_sens.add_row(attribute="confirmed")
testdata_passport_sens.add_row(attribute="bound")
testdata_passport_sens.add_row(attribute="secured")
testdata_passport_sens.add_row(_date="2016-04-10", attribute="confirmed")
testdata_passport_sens.add_row(_date="2016-04-10", attribute="bound")
testdata_passport_sens.add_row(_date="2016-04-10", attribute="secured")
testdata_passport_sens.add_row(_date="2016-04-11", attribute="confirmed")
testdata_passport_sens.add_row(_date="2016-04-11", attribute="bound")
testdata_passport_sens.add_row(_date="2016-04-11", attribute="secured")


testdata_passport_phone = BaseLog(
    path="//statbox/passport-phone-log",
    date="2016-04-09",
    default_data=PASSPORT_PHONE
)
testdata_passport_phone.add_row(yandexuid="7383335981460211111", uid="28467361", phone="+79522511111")
testdata_passport_phone.add_row(yandexuid="7383335981460211111", uid="28467361", phone="+79522522222")
testdata_passport_phone.add_row(_date="2016-04-10", yandexuid="7383335981460211111", uid="28467361", phone="+79522511111")
testdata_passport_phone.add_row(_date="2016-04-10", yandexuid="7383335981460211111", uid="28467361", phone="+79522522222")
testdata_passport_phone.add_row(_date="2016-04-11", yandexuid="7383335981460211111", uid="28467361", phone="+79522511111")
testdata_passport_phone.add_row(_date="2016-04-11", yandexuid="7383335981460211111", uid="28467361", phone="+79522522222")

testdata_access = AccessLog(
    path="//statbox/access-log",
    date="2016-04-09",
    default_data=ACCESS_LOG
)
testdata_access.add_row(cookies={"refresh_yandexuid": "111", "yandexuid": "9574390901437926574", "uid": "5470947"})
testdata_access.add_row(stbx_ip="::ffff:94.45.57.12", ip="94.45.57.12", cookies={"yandexuid": "7249027431455393740", "uid": "600251"})
testdata_access.add_row(stbx_ip="::ffff:94.45.57.13", ip="94.45.57.13", cookies={"yandexuid": "6619110241447613888", "uid": "1104722"}, raw_yandexuid="6619110241447613888")
testdata_access.add_row(stbx_ip="::ffff:94.45.57.14", ip="94.45.57.14", cookies={"yandexuid": "1495205931451997969", "uid": "1104722"}, raw_yandexuid="1495205931451997969")
testdata_access.add_row(stbx_ip="::ffff:178.64.134.57", ip="2a02:6b8:b000:172:922b:34ff:fecf:24b6", yandexuid="-", cookies={"yandexuid": "601826891455541113"})
testdata_access.add_row(_date="2016-04-10", stbx_ip="::ffff:46.133.27.214", ip="46.133.27.214", cookies={"yandexuid": "137418131459737825"})
testdata_access.add_row(_date="2016-04-10", stbx_ip="::ffff:46.133.56.232", ip="127.0.0.1", cookies={"yandexuid": "9672732681428384566"})
testdata_access.add_row(_date="2016-04-10", stbx_ip="::ffff:46.133.64.253", ip="127.0.0.1", cookies={"yandexuid": "683580251415739703"})
testdata_access.add_row(_date="2016-04-11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150428"})
testdata_access.add_row(_date="2016-04-11", stbx_ip="::ffff:217.66.157.42", cookies={"raw_yandexuid": "2918597931460386402", "yandexuid": "2918597931460386402"})
testdata_access.add_row(_date="2016-04-11", stbx_ip="::ffff:78.25.123.196", cookies={"raw_yandexuid": "2925551651460374938", "yandexuid": "2925551651460374938"})

#test did from cookies yp
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:16:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150418", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc1#2147481111.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (Linux; Android 4.4.2; Ixion ML145 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36")
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:26:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150418", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc1#2147481111.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (Linux; Android 4.4.2; Ixion ML145 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36")
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:16:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150418", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc2#2147482222.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (iPad; CPU OS 8_1_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) YaBrowser/15.4.2272.3000.11 Mobile/12B440 Safari/600.1.4")
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:26:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150418", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc2#2147482222.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (iPad; CPU OS 8_1_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) YaBrowser/15.4.2272.3000.11 Mobile/12B440 Safari/600.1.4")
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:16:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150418", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc3#2147483333.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (Linux; Android 4.4.2; Ixion ML145 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36")
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:16:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150418", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc4#2147484444.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (iPad; CPU OS 8_1_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) YaBrowser/15.4.2272.3000.11 Mobile/12B440 Safari/600.1.4")

testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:16:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150411", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc1#2147481111.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (Linux; Android 4.4.2; Ixion ML145 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36")
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:26:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150412", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc1#2147481111.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (Linux; Android 4.4.2; Ixion ML145 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36")
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:16:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150413", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc2#2147482222.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (iPad; CPU OS 8_1_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) YaBrowser/15.4.2272.3000.11 Mobile/12B440 Safari/600.1.4")
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:26:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150414", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc2#2147482222.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (iPad; CPU OS 8_1_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) YaBrowser/15.4.2272.3000.11 Mobile/12B440 Safari/600.1.4")
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:16:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150415", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc3#2147483333.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (Linux; Android 4.4.2; Ixion ML145 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36")
testdata_access.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 16:16:11", stbx_ip="::ffff:178.64.134.57", cookies={"yandexuid": "2410530891459150416", "yp": "1518447753.andrid.91124fd3631f22e#2147483648.did.53b84e78dbf8e7aa77ac092137057bc4#2147484444.ybrod.3#1534104691.sz.640x360x2"}, user_agent="Mozilla/5.0 (iPad; CPU OS 8_1_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) YaBrowser/15.4.2272.3000.11 Mobile/12B440 Safari/600.1.4")

testdata_export_access = AccessLog(
    path="//statbox/export-access-log",
    date="2016-04-09",
    default_data=EXPORT_ACCESS_LOG
)
testdata_export_access.add_row(stbx_ip="::ffff:37.162.163.201", ip="37.162.163.202")
testdata_export_access.add_row(stbx_ip="::ffff:37.162.163.202", ip="62.33.91.130", cookies={"yandexuid": "9574390901437926574"})
testdata_export_access.add_row(stbx_ip="::ffff:37.162.163.203", ip="62.33.91.130", cookies={"yandexuid": "7249027431455393740"})
testdata_export_access.add_row(_date="2016-04-10", ip="62.33.91.130", cookies={"yandexuid": "276293831437323260"})
testdata_export_access.add_row(_date="2016-04-10", ip="62.33.91.131", cookies={"yandexuid": "3301925781456769239"})
testdata_export_access.add_row(_date="2016-04-10", ip="62.33.91.132", cookies={"yandexuid": "8589802631446573763"})
testdata_export_access.add_row(_date="2016-04-11", stbx_ip="::ffff:37.162.163.202", ip="62.33.91.130", cookies={"yandexuid": "1357088951430906528"})
testdata_export_access.add_row(_date="2016-04-11", stbx_ip="::ffff:37.162.163.203", ip="91.196.123.9",)
testdata_export_access.add_row(_date="2016-04-11", ip="134.249.169.141",)

testdata_passport_user_data = BaseLog(
    path="//statbox/heavy-dict/passport_userdata",
    date="2016-05-31",
    default_data=PASSPORT_USER_DATA
)
testdata_passport_user_data.add_row(secure_phone_id="25499399", uid="194502233", suid="596374937", country="RU", reg_date="2012-12-24 08:48:57", login="ingvr80", karma="0")
testdata_passport_user_data.add_row(uid="134614616", firstname="Larisa", lastname="Serzhantova", birthday="1972-01-14", reg_date="2011-10-17 16:40:16", language="RU", suid="393750996", gender="f", question="1", karma="6000", answer="1", login="roscosh8", country="RU")
testdata_passport_user_data.add_row(uid="134648582", firstname="firstname", lastname="lastname", secure_phone_id="16293612", reg_date="2011-10-17 22:48:02", language="RU", suid="393883669", country="RU", question="1", karma="6000", answer="1", login="e222mn")
testdata_passport_user_data.add_row(gender="m", uid="15033290", language="RU", suid="35371078", firstname="firstname", lastname="lastname", question="1", secure_phone_id="116556247", birthday="1969-11-12", reg_date="2005-11-22 17:10:12", answer="1", login="mouradian", country="RU", karma="0")
testdata_passport_user_data.add_row(gender="m", uid="2687", language="RU", suid="35323438", firstname="keker", lastname="lalker", question="1", secure_phone_id="116556237", birthday="1967-12-11", reg_date="2007-01-21 17:11:12", answer="1", login="govshit", country="RU", karma="0")
testdata_passport_user_data.add_row(gender="m", uid="2861", language="RU", suid="39983438", firstname="ferstode", lastname="seconde", question="1", secure_phone_id="118956237", birthday="1965-02-14", reg_date="2006-10-23 17:12:12", answer="1", login="govst@mail.ru", country="RU", karma="0")

testdata_kinopoisk = BaseLog(
    path="//crypta/production/state/graph/dicts",
    table_name="kinopoisk",
    default_data=KINOPOISK_LOG
)
testdata_kinopoisk.add_row(kp_uid=5470947, id_value="5470947")
testdata_kinopoisk.add_row(kp_uid=600251, id_value="600251")
testdata_kinopoisk.add_row(kp_uid=1104722, id_value="1104722", email="new_email@bbb.ru")
testdata_kinopoisk.add_row(kp_uid=1104722, id_value="1104722", email="new_email@bbb.ru")


testdata_autoru = BaseLog(
    path="//statbox/autoru-front-log",
    date="2016-04-11",
    default_data=AUTORU_LOG
)
testdata_autoru.add_row(user_yandex_uid="2257673341447602723", email="elavrenov@gmail.com", phone_number="79052795112")
testdata_autoru.add_row(user_yandex_uid="2417029131465202997", email="Ssimonovs3@gmail.com", phone_number="79160550044")
testdata_autoru.add_row(user_yandex_uid="2661050951457334113", email="alepko.i83@gmail.com", phone_number="79062634636")

testdata_autoru.add_row(user_yandex_uid="340781281465314773", email="akram.talibov@gmail.com", phone_number="89263699221")
testdata_autoru.add_row(user_yandex_uid="6167654001394007167", email="0818359@gmail.com", phone_number="79281960833")
testdata_autoru.add_row(user_yandex_uid="9640378551397559582", email="mlogvinenko@gmail.com", phone_number="79686354236")

testdata_autoru.add_row(user_yandex_uid="9885733981468347246", email="trifonova78@gmail.com", phone_number="79091502295")
testdata_autoru.add_row(user_yandex_uid="9885733981468347246", email="trifonova78@gmail.com", phone_number="79096517840")
testdata_autoru.add_row(user_yandex_uid="632886781434121228", email="lsksputnik@gmail.com", phone_number="79518545837")


testdata_sherlock_mail_vk_dump = BaseLog(
    path="//home/sherlock/export/crypta",
    table_name="vk_ids",
    default_data=MAIL_VKIDS_DAYDUMP  # nude pattern
)

testdata_sherlock_mail_vk_dump.add_row(uid=2460, vk_id="chingol")
testdata_sherlock_mail_vk_dump.add_row(uid=2687, vk_id="id174282522")
testdata_sherlock_mail_vk_dump.add_row(uid=2861, vk_id="cc00ffee")
testdata_sherlock_mail_vk_dump.add_row(uid=4611, vk_id="iliannaili")
testdata_sherlock_mail_vk_dump.add_row(uid=4880, vk_id="tulaman")
testdata_sherlock_mail_vk_dump.add_row(uid=5656, vk_id="kurbanov56")
testdata_sherlock_mail_vk_dump.add_row(uid=6075, vk_id="seredailya")
testdata_sherlock_mail_vk_dump.add_row(uid=6336, vk_id="giddom")
testdata_sherlock_mail_vk_dump.add_row(uid=6943, vk_id="id292652960")
testdata_sherlock_mail_vk_dump.add_row(uid=8322, vk_id="take_care_yourself")
testdata_sherlock_mail_vk_dump.add_row(uid=12355, vk_id="asmekh")

testdata_ditmsk_cookiematching = SingleTableLog(
    path="//crypta/production/dmp/dmp-ditmsk/cookies_matches",
    default_data=DITMSK_COOKIEMATCHING
)

testdata_ditmsk_cookiematching.add_row(key="CgMCH1U%2B%2F7MjAnoNBDpzAgA%3D", value="yuid=1907967751360172097\ttag=ditmsk\tts=1525709103")
testdata_ditmsk_cookiematching.add_row(key="CgMCH1U%2B1ZMjAnoNBDm0AgA%3D", value="yuid=3502086411377199278\ttag=ditmsk\tts=1525709103")
testdata_ditmsk_cookiematching.add_row(key="CgMCH1U%2B1ZMjAnoNBDm0AgA%3D", value="yuid=1817745901457477516\ttag=ditmsk\tts=1525709103")
testdata_ditmsk_cookiematching.add_row(key="CgMCH1U%2B1ZMjAnoNBDm0AgA%3D", value="yuid=7086307901319910628\ttag=ditmsk\tts=1525709103")
testdata_ditmsk_cookiematching.add_row(key="CgMCH1U%2B338jGXoLBDmrAgA%3D", value="yuid=8493830551509391626\ttag=ditmsk\tts=1525709103")

testdata_ditmsk_emails1 = SingleTableLog(
    path="//crypta/production/dmp/dmp-ditmsk/raw-schematized/emails/1493363073",
    default_data=DITMSK_DAY_DUMP
)
testdata_ditmsk_emails2 = SingleTableLog(
    path="//crypta/production/dmp/dmp-ditmsk/raw-schematized/emails/1493363075",
    default_data=DITMSK_DAY_DUMP
)

testdata_ditmsk_emails1.add_row(dit_id="00011d93b4f44c742ec2e5ef96dfe8b2", dit_cookie="CgMCH1U%2B%2F7MjAnoNBDpzAgA%3D",
                               email_md5="4810e421f86f0c8093fe611cb89e67e4", date="2017-04-11", ts="234234", src="emails")
testdata_ditmsk_emails1.add_row(dit_id="00011d93b4f44c742ec2e5ef96dfe8b2", dit_cookie="CgMCH1U%2B1ZMjAnoNBDm0AgA%3D",
                               email_md5="d03d8913d7627e1a9e19e69ddb2763d5", date="2017-04-11", ts="234234", src="emails")
testdata_ditmsk_emails2.add_row(dit_id="00029835e7bade3fe55df4ee8e4988f1", dit_cookie="CgMCH1U%2B1ZMjAnoNBDm0AgA%3D",
                               email_md5="fb49df70e32e828b3fa39a777acba733", date="2017-04-11", ts="234234", src="emails")

testdata_ditmsk_phones1 = SingleTableLog(
    path="//crypta/production/dmp/dmp-ditmsk/raw-schematized/phones/1493363073",
    default_data=DITMSK_DAY_DUMP
)
testdata_ditmsk_phones2 = SingleTableLog(
    path="//crypta/production/dmp/dmp-ditmsk/raw-schematized/phones/1493363075",
    default_data=DITMSK_DAY_DUMP
)

testdata_ditmsk_phones1.add_row(dit_id="00028f32d33461ea05f050382cedf480", dit_cookie="CgMCH1U%2B1ZMjAnoNBDm0AgA%3D",
                                phone_md5="75fac33c1c22838a2e08a142496d09cc", date="2017-04-11", ts="234234", src="phones")
testdata_ditmsk_phones2.add_row(dit_id="00011d93b4f44c742ec2e5ef96dfe8b2", dit_cookie="CgMCH1U%2B338jGXoLBDmrAgA%3D",
                                phone_md5="bddbaa034bea7aa369753d7a751d03a5", date="2017-04-11", ts="234234", src="phones")
testdata_ditmsk_phones2.add_row(dit_id="11111d93b4f44c742ec2e5ef96dfe8b2", dit_cookie="XXMCH1U%2B338jGXoLBDmrAgA%3D",
                                phone_md5="40ee5690438a7da84802f789829de1dc", date="2017-04-11", ts="234234", src="phones")


WATCH_LOG_MAILRU = [
    ("wp/Cm8KqwpPCm8KewpFja2JqcsKfwpPCm8KeYMKkwqc=", "mixail_1908@mail.ru"),
    ("wpPCoMKWwqTCpcKXwqRywp/Ck8Kbwp5gwqTCpw==", "andrser@mail.ru"),
    ("wqLCnsKhwqbCkcKfcsKfwpPCm8KeYMKkwqc=", "plot_m@mail.ru")
]
WATCH_LOG_VK = [
    ("ZmVoY2VnZmdl", "436135453"),
    ("Y2dqZmRkaWpr", "158422789"),
    ("aWVrYmtrZmI=", "73909940")
]
WATCH_LOG_OK = [
    ("ZmllZ2JnZWtlamJn", "473505393805"),
    ("Z2dnaWtpaGpiZWlr", "555797680379"),
    ("Z2dqaGRmamtjYmpp", "558624891087")
]
WATCH_LOG_AVITO = [
    ("aWNrZ2RoZms=", "71952649"),
    ("aWlrY2JpZWQ=", "77910732"),
    ("aWhkZWtrYg==", "7623990")
]
testdata_watch_log = BaseLog(
    path="//statbox/bs-watch-log",
    date="2016-04-11",
    default_data=WATCH_LOG
)

testdata_watch_log.add_row(remoteip='127.0.0.1', clientip='217.118.90.186', remoteip6='::ffff:127.0.0.1', regionid='168', url='https://e.mail.ru/thread/1:c526343afd3058be:0/', clientip6='::ffff:46.130.14.174', useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', uniqid='601826891455541112', cookiei='601826891455541112', watchid='4340609126817335168')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:mue:supervnyki@mail.ru:z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455541113', cookiei='601826891455541113', watchid='4344315929855004562')
testdata_watch_log.add_row(eventtime='1469820260', browserinfo='s:1366x768x24:sk:1:f:22.0.0:fpr:280672867801:cn:1:w:1349x668:mue:kds-82@mail.ru:z:480:i:20160730032409:et:1469820249:en:utf-8:v:700:c:1:la:ru:ar:1:pv:1:ls:531503482006:rqn:502:rn:227642568:hid:887360742:ds:5,181,172,168,0,0,,2582,2051,,,,2950:fp:248776783:rqnl:1:st:1469820249:u:1462190808985248003', unixtime='1469820260', source_uri='prt://yabs-rt@2a02:6b8:0:872:0:0:3c:4unknown', headerargs='293: fuid01=5460f0de62f7a7e9.6BvdCMm3qI52ew7dJWd6bdjU3T2RHc47MFs-DLpo0yuPub7SqmOj11z5NXD7KAL4VXV8r2bKC3mo7IdIMPbFrM7Ds1PK5C4GYDTumAzXhXfLhUqqBXsc6wC-RG0V561h; L=AV9DeGtlYEdccnJDBkpwaEcNf3sHSQZ1AQMXE19FASkDWQZ8.1443641139.11951.333685.576ba9e9b2bef5f0f2ab117888006fcd; yandex_login=saprovec2015; yandexuid=658314781415709679; _ym_uid=1456040833775074822; __utma=190882677.1177133303.1466535850.1466535850.1466535850.1; __utmz=190882677.1466535850.1.1.utmcsr=paymaster.ru|utmccn=(referral)|utmcmd=referral|utmcct=/ru-RU/Payment/Process/f95d4245-e78c-4994-aebc-a54b5b9987e7; __utmv=190882677.|3=Login=Yes=1; yabs-sid=2603634431469652581; Cookie_check=CheckCookieCheckCookie; Session_id=3:1469737686.5.0.1443641139373:b8ZK1A:10.0|336319132.0.2|149276.602758.liwIatMvJXdoCgLaWKxILye7sOM; sessionid2=3:1469737686.5.0.1443641139373:b8ZK1A:10.1|336319132.0.2|149276.200975._8R45orwfLFn8EaiuCZRpuKrYK4; yabs-frequency=/4/0W0c0A4OarV97OvN/LIDoS8Gb8G00/; yp=1759001139.udn.cDpzYXByb3ZlYzIwMTU%3D#1483510635.szm.1%3A1366x768%3A1366x668#1499386537.st_soft_stripe_s.74#1499387100.st_promobar_s.16#1495981786.st_browser_s.12#1497119368.st_browser_cl.1#1469978503.gpauto.53_363037299999995%3A83_6906791%3A6325%3A1%3A1469805703#1469892107.nps.8069216278%3Aclose; ys=wprid.1469807003881051-17626762553484740692140308-sas1-1990; _ym_isad=2', referer='https://mail.ru/', remoteip='127.0.0.1', iso_eventtime='2016-04-10 21:14:20', funiqid='6080124334883973097', cookiegpauto='53_363037299999995:83_6906791:6325:1:1469805703', remoteip6='::ffff:127.0.0.1', regionid='197', url='https://e.mail.ru/messages/inbox/', sessid='2603634431469652581', clientip6='95.78.13.90', useragent='Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36 OPR/38.0.2220.41', uniqid='601826891455541113', cookiei='601826891455541113', watchid='4344318555701903480')
testdata_watch_log.add_row(remoteip='127.0.0.1', clientip='217.118.90.186', remoteip6='::ffff:127.0.0.1', regionid='168', url='https://e.mail.ru/thread/1:c526343afd3058be:0/', clientip6='::ffff:46.130.14.174', useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', uniqid='601826891455542222', cookiei='601826891455542222', watchid='4340609126817335168')
testdata_watch_log.add_row(remoteip='127.0.0.1', clientip='176.59.7.165', remoteip6='::ffff:127.0.0.1', regionid='168', url='https://e.mail.ru/thread/1:c526343afd3058be:0/', clientip6='::ffff:46.130.14.174', useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', uniqid='601826891455541114', cookiei='601826891455541114', watchid='4340609126817335168')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:mue:supervnyki@mail.ru:z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='176.59.7.165', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455541115', cookiei='601826891455541115', watchid='4344315929855004562')
testdata_watch_log.add_row(eventtime='1469820260', browserinfo='s:1366x768x24:sk:1:f:22.0.0:fpr:280672867801:cn:1:w:1349x668:mue:kds-82@mail.ru:z:480:i:20160730032409:et:1469820249:en:utf-8:v:700:c:1:la:ru:ar:1:pv:1:ls:531503482006:rqn:502:rn:227642568:hid:887360742:ds:5,181,172,168,0,0,,2582,2051,,,,2950:fp:248776783:rqnl:1:st:1469820249:u:1462190808985248003', unixtime='1469820260', source_uri='prt://yabs-rt@2a02:6b8:0:872:0:0:3c:4unknown', headerargs='293: fuid01=5460f0de62f7a7e9.6BvdCMm3qI52ew7dJWd6bdjU3T2RHc47MFs-DLpo0yuPub7SqmOj11z5NXD7KAL4VXV8r2bKC3mo7IdIMPbFrM7Ds1PK5C4GYDTumAzXhXfLhUqqBXsc6wC-RG0V561h; L=AV9DeGtlYEdccnJDBkpwaEcNf3sHSQZ1AQMXE19FASkDWQZ8.1443641139.11951.333685.576ba9e9b2bef5f0f2ab117888006fcd; yandex_login=saprovec2015; yandexuid=658314781415709679; _ym_uid=1456040833775074822; __utma=190882677.1177133303.1466535850.1466535850.1466535850.1; __utmz=190882677.1466535850.1.1.utmcsr=paymaster.ru|utmccn=(referral)|utmcmd=referral|utmcct=/ru-RU/Payment/Process/f95d4245-e78c-4994-aebc-a54b5b9987e7; __utmv=190882677.|3=Login=Yes=1; yabs-sid=2603634431469652581; Cookie_check=CheckCookieCheckCookie; Session_id=3:1469737686.5.0.1443641139373:b8ZK1A:10.0|336319132.0.2|149276.602758.liwIatMvJXdoCgLaWKxILye7sOM; sessionid2=3:1469737686.5.0.1443641139373:b8ZK1A:10.1|336319132.0.2|149276.200975._8R45orwfLFn8EaiuCZRpuKrYK4; yabs-frequency=/4/0W0c0A4OarV97OvN/LIDoS8Gb8G00/; yp=1759001139.udn.cDpzYXByb3ZlYzIwMTU%3D#1483510635.szm.1%3A1366x768%3A1366x668#1499386537.st_soft_stripe_s.74#1499387100.st_promobar_s.16#1495981786.st_browser_s.12#1497119368.st_browser_cl.1#1469978503.gpauto.53_363037299999995%3A83_6906791%3A6325%3A1%3A1469805703#1469892107.nps.8069216278%3Aclose; ys=wprid.1469807003881051-17626762553484740692140308-sas1-1990; _ym_isad=2', referer='https://mail.ru/', remoteip='127.0.0.1', iso_eventtime='2016-04-10 21:14:20', funiqid='6080124334883973097', cookiegpauto='53_363037299999995:83_6906791:6325:1:1469805703', remoteip6='::ffff:127.0.0.1', regionid='197', url='https://e.mail.ru/messages/inbox/', sessid='2603634431469652581', clientip6='46.147.147.143', useragent='Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36 OPR/38.0.2220.41', uniqid='601826891455541115', cookiei='601826891455541115', watchid='4344318555701903480')
testdata_watch_log.add_row(remoteip='127.0.0.1', clientip='176.59.7.165', remoteip6='::ffff:127.0.0.1', regionid='168', url='https://e.mail.ru/thread/1:c526343afd3058be:0/', clientip6='::ffff:46.130.14.174', useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', uniqid='601826891455542224', cookiei='601826891455542224', watchid='4340609126817335168')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:mue:supervnyki@mail.ru:z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='176.59.7.165', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455542225', cookiei='601826891455542225', watchid='4344315929855004562')
testdata_watch_log.add_row(uniqid='222221455542222', cookiei='222221455542222', browserinfo='di:' + metrica_crypt("{\"android_id\":\"62ce0fd6fb939cf2\",\"google_aid\":\"1190cb06-34ea-4995-8a68-8ceed2e55760\",\"device_id\":\"a6d1d72b02f423452320a5901cd1c4c6\",\"uuid\":\"35a6b993b6771036cda94cf37d507d6c\"}", rsa))

testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:mue:' + WATCH_LOG_MAILRU[0][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:mue:' + WATCH_LOG_MAILRU[1][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:mue:' + WATCH_LOG_MAILRU[2][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')

testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:vid:' + WATCH_LOG_VK[0][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:vid:' + WATCH_LOG_VK[1][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:vid:' + WATCH_LOG_VK[2][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')

testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:oid:' + WATCH_LOG_OK[0][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:oid:' + WATCH_LOG_OK[1][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:oid:' + WATCH_LOG_OK[2][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')

testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:aid:' + WATCH_LOG_AVITO[0][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:aid:' + WATCH_LOG_AVITO[1][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:aid:' + WATCH_LOG_AVITO[2][0] + ':z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=8935802481455087719; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='217.118.90.186', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', uniqid='601826891455547777', cookiei='601826891455547777', watchid='4344315929855004777')
testdata_watch_log.add_row(eventtime='1469820260', browserinfo='s:1366x768x24:sk:1:f:22.0.0:fpr:280672867801:cn:1:w:1349x668:mue:kds-82@mail.ru:z:480:i:20160730032409:et:1469820249:en:utf-8:v:700:c:1:la:ru:ar:1:pv:1:ls:531503482006:rqn:502:rn:227642568:hid:887360742:ds:5,181,172,168,0,0,,2582,2051,,,,2950:fp:248776783:rqnl:1:st:1469820249:u:1462190808985248003', unixtime='1469820260', source_uri='prt://yabs-rt@2a02:6b8:0:872:0:0:3c:4unknown', headerargs='293: fuid01=5460f0de62f7a7e9.6BvdCMm3qI52ew7dJWd6bdjU3T2RHc47MFs-DLpo0yuPub7SqmOj11z5NXD7KAL4VXV8r2bKC3mo7IdIMPbFrM7Ds1PK5C4GYDTumAzXhXfLhUqqBXsc6wC-RG0V561h; L=AV9DeGtlYEdccnJDBkpwaEcNf3sHSQZ1AQMXE19FASkDWQZ8.1443641139.11951.333685.576ba9e9b2bef5f0f2ab117888006fcd; yandex_login=login-for-avito; yandexuid=5555551400000008; _ym_uid=1456040833775074822; __utma=190882677.1177133303.1466535850.1466535850.1466535850.1; __utmz=190882677.1466535850.1.1.utmcsr=paymaster.ru|utmccn=(referral)|utmcmd=referral|utmcct=/ru-RU/Payment/Process/f95d4245-e78c-4994-aebc-a54b5b9987e7; __utmv=190882677.|3=Login=Yes=1; yabs-sid=2603634431469652581; Cookie_check=CheckCookieCheckCookie; Session_id=3:1469737686.5.0.1443641139373:b8ZK1A:10.0|336319132.0.2|149276.602758.liwIatMvJXdoCgLaWKxILye7sOM; sessionid2=3:1469737686.5.0.1443641139373:b8ZK1A:10.1|336319132.0.2|149276.200975._8R45orwfLFn8EaiuCZRpuKrYK4; yabs-frequency=/4/0W0c0A4OarV97OvN/LIDoS8Gb8G00/; yp=1759001139.udn.cDpzYXByb3ZlYzIwMTU%3D#1483510635.szm.1%3A1366x768%3A1366x668#1499386537.st_soft_stripe_s.74#1499387100.st_promobar_s.16#1495981786.st_browser_s.12#1497119368.st_browser_cl.1#1469978503.gpauto.53_363037299999995%3A83_6906791%3A6325%3A1%3A1469805703#1469892107.nps.8069216278%3Aclose; ys=wprid.1469807003881051-17626762553484740692140308-sas1-1990; _ym_isad=2', referer='https://mail.ru/', remoteip='127.0.0.1', iso_eventtime='2016-04-10 21:14:20', funiqid='6080124334883973097', cookiegpauto='53_363037299999995:83_6906791:6325:1:1469805703', remoteip6='::ffff:127.0.0.1', regionid='197', url='https://e.mail.ru/messages/inbox/', sessid='2603634431469652581', clientip6='95.78.13.90', useragent='Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36 OPR/38.0.2220.41', uniqid='5555551400000008', cookiei='601826891455541113', watchid='4344318555701903480')

# graphv2 data for radius metrics
# 1748232901455365413
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:mue:234@mail.ru:z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=1748232901455365413; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='176.59.7.165', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7146 Yowser/2.5 Safari/537.36', uniqid='1748232901455365413', cookiei='1748232901455365413', watchid='1748232901455365413')
# 5726075371455990918
testdata_watch_log.add_row(eventtime='1469820250', browserinfo='s:1366x768x24:sk:1:adb:2:f:22.0.0:fpr:352710240801:cn:1:w:1349x667:mue:2sdfs@mail.ru:z:180:i:20160729222410:et:1469820251:en:utf-8:v:700:c:1:la:ru:ar:1:nb:1:cl:198:ls:769919691117:rqn:202:rn:854091256:hid:144894966:ds:,,,,,,,8922,2331,18611,18611,12,11861:rqnl:1:st:1469820251:u:1455182046612414', unixtime='1469820250', source_uri='prt://yabs-rt@bsmc20e.yandex.ru/home/yabs/server/log.rtmr/watch.1.tskv', headerargs='293: fuid01=56bae06c543fb6d6.CrKHjKDmLMiYqT05ef9YMqmAYS1eny_X1Or_PCm3_mrMzrPYhd-SF4FxmfXQ_wNTihE5qfVy3zyQLl0ji0yVQYomLfJgvaei5VI_MVC-P65qo6ps3ZHNiDvu2kf13Vob; yandexuid=5726075371455990918; spravka=dD0xNDM1ODQ0NTE2O2k9ODMuMTQ5LjQ2LjIwMTt1PTE0MzU4NDQ1MTY1MzE4MDMxMjU7aD02NDQxOWE3OTJjYmEyYjYwNGE3MDQ1NWVlMThiNGFmMA==; yandex_gid=6; yabs-frequency=/4/1m0G0FZMc5TpoPTN/AIvoS7mbDGSeSd1y9IT0xHjFVoLS0002sInoS70bRiv5i71m9MUm979mO2LLGoXoS5WbLG00/; zm=m-white_bender.flex.webp.css-https%3Awww_3hm-b9Ujf4TQ9bJ2osYjORCueWs%3Al; yabs-sid=2511260481469708320; _ym_uid=1469732738856911669; yp=1500184898.dsws.22#1500184898.dswa.0#1485500740.szm.1_00:1366x768:1366x667#1474977291.ww.1#1500738139.st_soft_stripe_s.70#1494429862.st_set_s.41#1491844864.st_home_s.8#1494328734.st_promobar_s.7#1500116922.st_vb_s.10#1493128273.st_set_home_s.13#1498304852.dwss.55#1500184898.dwys.27#1499866280.st_browser_s.25#1469990458.clh.1975319#1499868603.st_browser_cl.1#1472229142.ygu.1; _ga=GA1.2.913351433.1469732761; ys=homesearchextchrome.8-19-0#wprid.1469732558021614-242874010728671787017346-man1-3572', remoteip='127.0.0.1', clientip='176.59.7.165', iso_eventtime='2016-04-10 21:14:10', funiqid='6249554188804536022', remoteip6='::ffff:127.0.0.1', url='https://e.mail.ru/messages/inbox/', sessid='2511260481469708320', clientip6='::ffff:83.149.47.85', useragent='Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53', uniqid='5726075371455990918', cookiei='5726075371455990918', watchid='5726075371455990918')


# social ids from watch log
testdata_watch_log.add_row(browserinfo='s:800x600x32:sk:1:fpr:401684195901:cn:1:w:749x478:vid:Z2NpY2dn:z:180:i:20161002224303:et:1475437384:en:windows-1251:v:723:c:1:la', uniqid='123666666', cookiei='123666666', )
testdata_watch_log.add_row(browserinfo='j:1:s:1920x1080x24:sk:1:adb:2:f:23.0.0.162:fpr:319325903901:cn:1:w:1903x914:vid:Z2NpY2dn:z:180:i:20161002120351:et:1475399031:en:windows-1251:v:723:c:1:la:ru-ru:ar', uniqid='124666666', cookiei='124666666', )
testdata_watch_log.add_row(browserinfo='j:1:s:1920x1080x24:sk:1:adb:2:f:23.0.0.162:oid:319901:cn:1:w:1903x914:vid:Z2NpY2dn:z:180:i:20161002120351:et:1475399031:en:windows-1251:v:723:c:1:la:ru-ru:ar', uniqid='123666666', cookiei='123666666', )
testdata_watch_log.add_row(browserinfo='j:1:s:1920x1080x24:sk:1:adb:2:f:23.0.0.162:aid:303901:cn:1:w:1903x914:vid:aGloaWljamY=:z:180:i:20161002120351:et:1475399031:en:windows-1251:v:723:c:1:la:ru-ru:ar', uniqid='123666666', cookiei='123666666', )

# vmetro testing
watch_log_vmetro_mac_addresses = ['f4-09-d8-d1-a3-73', 'd8-3c-69-31-2f-a4']
mobile_metrika_mac_names = "[\"wlan0\",\"p2p0\",\"ifb0\",\"ifb1\",\"ccmni0\",\"ccmni1\",\"ccmni2\"]"
mobile_metrika_macs = "[\"F4:09:D8:D1:A3:73\",\"A2:32:99:5C:F8:DC\",\"12:CE:92:EF:0F:34\",\"2E:19:E3:6E:4C:1D\",\"1A:47:AF:49:B4:7E\",\"7E:2F:30:09:E1:29\",\"BE:FA:1B:05:5F:17\"]"
# f4-09-d8-d1-a3-73 should intersect with F4:09:D8:D1:A3:73
vmetro_yuid1 = '543555'
vmetro_yuid2 = '543556'

testdata_watch_log.add_row(browserinfo='s:800x600x32:sk:1:fpr:401684195901:cn:1:w:749x478:et:1475437384:en:windows-1251:v:723:c:1:la', referer='https://login.wi-fi.ru/am/UI/Login?org=mac&service=coa&client_mac=%s&ForceAuth=true' % watch_log_vmetro_mac_addresses[0], uniqid=vmetro_yuid1)
testdata_watch_log.add_row(browserinfo='j:1:s:1920x1080x24:sk:1:adb:2:f:23.0.0.162:fpr:319325903901:cn:1:w:1903x914:z:180:i:20161002120351:et:1475399031:en:windows-1251:v:723:c:1:la:ru-ru:ar', referer='http://login.wi-fi.ru/am/UI/Login?org=mac&service=coa&client_mac=%s&ForceAuth=true' % watch_log_vmetro_mac_addresses[1], uniqid=vmetro_yuid2)
#purchase
testdata_watch_log.add_row(uniqid='222221455542223', cookiei='222221455542223', clientip='217.118.90.186', iso_eventtime="2016-04-11 12:44:46", params="{\"__ym\":{\"ecommerce\":[{\"purchase\":{\"actionField\":{\"id\":251407497},\"products\":[{\"id\":1112223,\"price\":\"5348\",\"quantity\":1}]}}]}}", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-10 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")
testdata_watch_log.add_row(uniqid='222221455542223', cookiei='222221455542223', clientip='217.118.90.186', iso_eventtime="2016-04-11 12:44:46", params="{\"__ym\":{\"ecommerce\":[{\"purchase\":{\"actionField\":{\"id\":\"0033349283\",\"affiliation\":\"site\"},\"products\":[{\"id\":\"885786\",\"name\":\"TestProduct\",\"category\":\"TestCategory\",\"price\":\"2870.00\",\"brand\":\"Molecula\",\"quantity\":1}]}}]}}", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-09 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")
testdata_watch_log.add_row(uniqid='222221455542223', cookiei='222221455542223', clientip='217.118.90.186', iso_eventtime="2016-04-11 12:44:46", params="{\"__ym\":{\"ecommerce\":[{\"purchase\":{\"actionField\":{\"id\":\"0033349283\",\"revenue\":\"22520\",\"affiliation\":\"site\"},\"products\":[{\"id\":\"885786\",\"name\":\"MoleculaGHMM3\",\"category\":\"Dich\",\"price\":\"2870.00\",\"brand\":\"Molecula\",\"quantity\":1}]}}]}}", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-10 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")

# did from yp
testdata_watch_log.add_row(uniqid='222221455549999', cookiei='222221455549999', eventtime="1460373600", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc111d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53")
testdata_watch_log.add_row(uniqid='222221455549999', cookiei='222221455549999', eventtime="1460373610", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc111d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53")
testdata_watch_log.add_row(uniqid='222221455548889', cookiei='222221455548889', eventtime="1460373611", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc222d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53")
testdata_watch_log.add_row(uniqid='222221455548887', cookiei='222221455548887', eventtime="1460373622", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc333d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; HTC Desire 310 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30 YandexSearch/5.45")
testdata_watch_log.add_row(uniqid='222221455548887', cookiei='222221455548887', eventtime="1460373632", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc333d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; HTC Desire 310 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30 YandexSearch/5.45")
testdata_watch_log.add_row(uniqid='222221455548886', cookiei='222221455548886', eventtime="1460373633", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc444d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; HTC Desire 310 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30 YandexSearch/5.45")

testdata_watch_log.add_row(uniqid='222221455549991', cookiei='222221455549991', eventtime="1460373600", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc111d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53")
testdata_watch_log.add_row(uniqid='222221455549991', cookiei='222221455549991', eventtime="1460373610", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc111d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53")
testdata_watch_log.add_row(uniqid='222221455548883', cookiei='222221455548883', eventtime="1460373611", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc222d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_1 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D201 Safari/9537.53")
testdata_watch_log.add_row(uniqid='222221455548884', cookiei='222221455548884', eventtime="1460373622", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc333d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; HTC Desire 310 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30 YandexSearch/5.45")
testdata_watch_log.add_row(uniqid='222221455548885', cookiei='222221455548885', eventtime="1460373632", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc333d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; HTC Desire 310 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30 YandexSearch/5.45")
testdata_watch_log.add_row(uniqid='222221455548811', cookiei='222221455548811', eventtime="1460373633", headerargs="293: i=qMC6KcWQaSBoTRy2qCskjcluLx2lQRbHUaP4kMGEGlvPELBxnh3hxLpXONAYkpgkKjNsY99SsuncdQx0oYdBtMRQE9U=; yp=2147483648.andrid.309d596917f40e02#2147483648.did.886f3cd0a0fa93a19f9d35362dcc444d#2147483648.ybrod.3#1521053305.shlos.1#1531381181.sz.640x360x2#1519812568.ygu.1#1532815624.szm.2%3A640x360%3A360x562; _ym_isad=2; usst=EAAAAAAAAADwAQoOCgJkcxIIMjUzMDc2NDM", useragent="Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; HTC Desire 310 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30 YandexSearch/5.45")


testdata_watch_log.add_row(_date="2016-04-09", uniqid='222221455542222', cookiei='222221455542222', clientport="42138", clientip='217.118.90.186', clientip6="::ffff:109.173.43.153", iso_eventtime="2016-04-09 21:40:20", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', browserinfo="s:320x568x32:sk:2:adb:2:fpr:216613626101:cn:1:w:980x1409:z:180:i:20160409214019:et:1460227220:en:utf-8:v:682:c:1:la:ru-ru:ls:1359029062124:rqn:20:rn:228539826:hid:2893278:ds:48,52,410,92,0,0,,1349,542,,,,2705:wn:44569:hl:1:rqnl:1:st:1460227220:u:146020227479937061:t:Rus-Massage.com", timestamp="2016-04-09 21:40:20", source_uri="prt://yabs-rt@bsmc04i.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", headerargs="293: yabs-sid=2313691931460227219; L=ey1cUQZJXQJjRAlFAHdiUGIEQk1OB3IGK1sZJwMmGREhLyUmNyYuGjZGO2soAg==.1419411098.11391.314408.07ad3cdab90f21737fefbb5143535e51; Session_id=3:1433059288.5.1.1379594369273:2O7cUw:6.0|206744251.0.2|1130000010571739.39816729.2|128933.667099.rkW_tzsWQaRPFZXjblgkCZvf644; _ym_isad=2; _ym_uid=1460191197322006264; fuid01=5130e63214d544d4.RWFdE_mgYY8VqQTZz8BouT1dzbgStpdFVYbT_DAy2JQS-_V4nrlXzNymb_fP_0nyeT3vHHIKyy5WkS3yNX6nBUrd5g6DiDlzEnaJHs0XiLKf1K1OvuAld2rvB0DlZXA8; my=YzYBAQA=; sessionid2=3:1433059288.5.0.1379594369273:2O7cUw:6.1|1130000010571739.39816729.2|128933.122480.a5LWqFGormPXIounfv6lP5SkLtA; yabs-frequency=/4/000700000007UVbM/xyznSAmZZW00/; yandex_gid=213; yandex_login=r.amiraslanov@dveri.ru; uniqid=3460322961362159108; yp=1734771098.udn.cDpyLmFtaXJhc2xhbm92QGR2ZXJpLnJ1#2147483647.xsz.320#1734771098.multib.1#1469135632.sz.320x568x2#1475350969.szm.2:320x568:320x529#1462174965.ygu.1", referer="http://rus-massage.com/list/city-1/area-6/district-123/subway-74/", remoteip6="::1", url="http://rus-massage.com/profile/1115")
testdata_watch_log.add_row(_date="2016-04-09", clientport="42138", clientip='176.59.7.165', clientip6="::ffff:109.173.43.153", iso_eventtime="2016-04-09 21:40:20", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', browserinfo="s:320x568x32:sk:2:adb:2:fpr:216613626101:cn:1:w:980x1409:z:180:i:20160409214019:et:1460227220:en:utf-8:v:682:c:1:la:ru-ru:ls:1359029062124:rqn:20:rn:228539826:hid:2893278:ds:48,52,410,92,0,0,,1349,542,,,,2705:wn:44569:hl:1:rqnl:1:st:1460227220:u:146020227479937061:t:Rus-Massage.com", timestamp="2016-04-09 21:40:20", source_uri="prt://yabs-rt@bsmc04i.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", headerargs="293: yabs-sid=2313691931460227219; L=ey1cUQZJXQJjRAlFAHdiUGIEQk1OB3IGK1sZJwMmGREhLyUmNyYuGjZGO2soAg==.1419411098.11391.314408.07ad3cdab90f21737fefbb5143535e51; Session_id=3:1433059288.5.1.1379594369273:2O7cUw:6.0|206744251.0.2|1130000010571739.39816729.2|128933.667099.rkW_tzsWQaRPFZXjblgkCZvf644; _ym_isad=2; _ym_uid=1460191197322006264; fuid01=5130e63214d544d4.RWFdE_mgYY8VqQTZz8BouT1dzbgStpdFVYbT_DAy2JQS-_V4nrlXzNymb_fP_0nyeT3vHHIKyy5WkS3yNX6nBUrd5g6DiDlzEnaJHs0XiLKf1K1OvuAld2rvB0DlZXA8; my=YzYBAQA=; sessionid2=3:1433059288.5.0.1379594369273:2O7cUw:6.1|1130000010571739.39816729.2|128933.122480.a5LWqFGormPXIounfv6lP5SkLtA; yabs-frequency=/4/000700000007UVbM/xyznSAmZZW00/; yandex_gid=213; yandex_login=r.amiraslanov@dveri.ru; uniqid=3460322961362159108; yp=1734771098.udn.cDpyLmFtaXJhc2xhbm92QGR2ZXJpLnJ1#2147483647.xsz.320#1734771098.multib.1#1469135632.sz.320x568x2#1475350969.szm.2:320x568:320x529#1462174965.ygu.1", referer="http://rus-massage.com/list/city-1/area-6/district-123/subway-74/", remoteip6="::1", url="http://rus-massage.com/profile/1115")
testdata_watch_log.add_row(_date="2016-04-09", uniqid='601826891455541112', cookiei='601826891455541112', clientport="56886", clientip='217.118.90.186', clientip6="::ffff:31.173.84.197", cookieys="wprid.1460202261559492-627982-ws27-406-TCH2", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', iso_eventtime="2016-04-09 14:44:34", ip_numeric="531453125", watch_id="1823021268362332001", browserinfo="s:320x568x32:sk:2:fpr:216613626101:cn:1:w:980x1409:z:180:i:20160409144433:et:1460202274:en:utf-8:v:682:c:1:la:ru-ru:ls:1359029062124:rqn:1:rn:96276557:hid:241135602:ds:3,101,306,335,1,0,,927,456,,,,1661:wn:15389:hl:1:rqnl:1:st:1460202274:u:146020227479937061:t:Rus-Massage.com", timestamp="2016-04-09 14:44:34", source_uri="prt://yabs-rt@bsmc05f.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", headerargs="293: yabs-sid=2533070101460186273; L=ey1cUQZJXQJjRAlFAHdiUGIEQk1OB3IGK1sZJwMmGREhLyUmNyYuGjZGO2soAg==.1419411098.11391.314408.07ad3cdab90f21737fefbb5143535e51; Session_id=3:1433059288.5.1.1379594369273:2O7cUw:6.0|206744251.0.2|1130000010571739.39816729.2|128933.667099.rkW_tzsWQaRPFZXjblgkCZvf644; _ym_isad=2; _ym_uid=1460191197322006264; fuid01=5130e63214d544d4.RWFdE_mgYY8VqQTZz8BouT1dzbgStpdFVYbT_DAy2JQS-_V4nrlXzNymb_fP_0nyeT3vHHIKyy5WkS3yNX6nBUrd5g6DiDlzEnaJHs0XiLKf1K1OvuAld2rvB0DlZXA8; my=YzYBAQA=; sessionid2=3:1433059288.5.0.1379594369273:2O7cUw:6.1|1130000010571739.39816729.2|128933.122480.a5LWqFGormPXIounfv6lP5SkLtA; yabs-frequency=/4/000700000007UVbM/xyznSAmZZW00/; yandex_gid=213; yandex_login=r.amiraslanov@dveri.ru; uniqid=3460322961362159108; yp=1734771098.udn.cDpyLmFtaXJhc2xhbm92QGR2ZXJpLnJ1#2147483647.xsz.320#1734771098.multib.1#1469135632.sz.320x568x2#1475350969.szm.2:320x568:320x529#1462174965.ygu.1; ys=wprid.1460202261559492-627982-ws27-406-TCH2", referer="https://yandex.ru/search/touch/?text=sss&lr=213&suggest_reqid=346032296136215910819942704808449", remoteip6="::1", url="http://rus-massage.com/list/city-1/area-6/district-123/subway-74/")
testdata_watch_log.add_row(_date="2016-04-09", clientport="42138", clientip='176.59.7.165', clientip6="::ffff:109.173.43.153", iso_eventtime="2016-04-09 21:40:20", browserinfo="s:320x568x32:sk:2:adb:2:fpr:216613626101:cn:1:w:980x1409:z:180:i:20160409214019:et:1460227220:en:utf-8:v:682:c:1:la:ru-ru:ls:1359029062124:rqn:20:rn:228539826:hid:2893278:ds:48,52,410,92,0,0,,1349,542,,,,2705:wn:44569:hl:1:rqnl:1:st:1460227220:u:146020227479937061:t:Rus-Massage.com", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', timestamp="2016-04-09 21:40:20", source_uri="prt://yabs-rt@bsmc04i.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", headerargs="293: yabs-sid=2313691931460227219; L=ey1cUQZJXQJjRAlFAHdiUGIEQk1OB3IGK1sZJwMmGREhLyUmNyYuGjZGO2soAg==.1419411098.11391.314408.07ad3cdab90f21737fefbb5143535e51; Session_id=3:1433059288.5.1.1379594369273:2O7cUw:6.0|206744251.0.2|1130000010571739.39816729.2|128933.667099.rkW_tzsWQaRPFZXjblgkCZvf644; _ym_isad=2; _ym_uid=1460191197322006264; fuid01=5130e63214d544d4.RWFdE_mgYY8VqQTZz8BouT1dzbgStpdFVYbT_DAy2JQS-_V4nrlXzNymb_fP_0nyeT3vHHIKyy5WkS3yNX6nBUrd5g6DiDlzEnaJHs0XiLKf1K1OvuAld2rvB0DlZXA8; my=YzYBAQA=; sessionid2=3:1433059288.5.0.1379594369273:2O7cUw:6.1|1130000010571739.39816729.2|128933.122480.a5LWqFGormPXIounfv6lP5SkLtA; yabs-frequency=/4/000700000007UVbM/xyznSAmZZW00/; yandex_gid=213; yandex_login=r.amiraslanov@dveri.ru; uniqid=3460322961362159108; yp=1734771098.udn.cDpyLmFtaXJhc2xhbm92QGR2ZXJpLnJ1#2147483647.xsz.320#1734771098.multib.1#1469135632.sz.320x568x2#1475350969.szm.2:320x568:320x529#1462174965.ygu.1", referer="http://rus-massage.com/list/city-1/area-6/district-123/subway-74/", remoteip6="::1", url="http://rus-massage.com/profile/1115")
testdata_watch_log.add_row(_date="2016-04-09", uniqid='222221455542222', cookiei='222221455542222', clientport="56886", clientip='217.118.90.186', clientip6="::ffff:31.173.84.197", cookieys="wprid.1460202261559492-627982-ws27-406-TCH2", iso_eventtime="2016-04-09 14:44:34", ip_numeric="531453125", watch_id="1823021268362332001", browserinfo="s:320x568x32:sk:2:fpr:216613626101:cn:1:w:980x1409:z:180:i:20160409144433:et:1460202274:en:utf-8:v:682:c:1:la:ru-ru:ls:1359029062124:rqn:1:rn:96276557:hid:241135602:ds:3,101,306,335,1,0,,927,456,,,,1661:wn:15389:hl:1:rqnl:1:st:1460202274:u:146020227479937061:t:Rus-Massage.com", timestamp="2016-04-09 14:44:34", source_uri="prt://yabs-rt@bsmc05f.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", headerargs="293: yabs-sid=2533070101460186273; L=ey1cUQZJXQJjRAlFAHdiUGIEQk1OB3IGK1sZJwMmGREhLyUmNyYuGjZGO2soAg==.1419411098.11391.314408.07ad3cdab90f21737fefbb5143535e51; Session_id=3:1433059288.5.1.1379594369273:2O7cUw:6.0|206744251.0.2|1130000010571739.39816729.2|128933.667099.rkW_tzsWQaRPFZXjblgkCZvf644; _ym_isad=2; _ym_uid=1460191197322006264; fuid01=5130e63214d544d4.RWFdE_mgYY8VqQTZz8BouT1dzbgStpdFVYbT_DAy2JQS-_V4nrlXzNymb_fP_0nyeT3vHHIKyy5WkS3yNX6nBUrd5g6DiDlzEnaJHs0XiLKf1K1OvuAld2rvB0DlZXA8; my=YzYBAQA=; sessionid2=3:1433059288.5.0.1379594369273:2O7cUw:6.1|1130000010571739.39816729.2|128933.122480.a5LWqFGormPXIounfv6lP5SkLtA; yabs-frequency=/4/000700000007UVbM/xyznSAmZZW00/; yandex_gid=213; yandex_login=r.amiraslanov@dveri.ru; uniqid=3460322961362159108; yp=1734771098.udn.cDpyLmFtaXJhc2xhbm92QGR2ZXJpLnJ1#2147483647.xsz.320#1734771098.multib.1#1469135632.sz.320x568x2#1475350969.szm.2:320x568:320x529#1462174965.ygu.1; ys=wprid.1460202261559492-627982-ws27-406-TCH2", referer="https://yandex.ru/search/touch/?text=sss&lr=213&suggest_reqid=346032296136215910819942704808449", remoteip6="::1", url="http://rus-massage.com/list/city-1/area-6/district-123/subway-74/")
#purchase
testdata_watch_log.add_row(_date="2016-04-09", uniqid='222221455542221', cookiei='222221455542221', clientip='217.118.90.186', iso_eventtime="2016-04-09 12:44:46", params="{\"__ym\":{\"ecommerce\":[{\"purchase\":{\"actionField\":{\"id\":251407497},\"products\":[{\"id\":1112223,\"price\":\"5348\",\"quantity\":1}]}}]}}", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-10 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")
testdata_watch_log.add_row(_date="2016-04-09", uniqid='222221455542221', cookiei='222221455542221', clientip='217.118.90.186', iso_eventtime="2016-04-09 12:44:46", params="{\"__ym\":{\"ecommerce\":[{\"purchase\":{\"actionField\":{\"id\":\"0033349283\",\"affiliation\":\"site\"},\"products\":[{\"id\":\"885786\",\"name\":\"TestProduct\",\"category\":\"TestCategory\",\"price\":\"2870.00\",\"brand\":\"Molecula\",\"quantity\":1}]}}]}}", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-09 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")
testdata_watch_log.add_row(_date="2016-04-09", uniqid='222221455542221', cookiei='222221455542221', clientip='217.118.90.186', iso_eventtime="2016-04-09 12:44:46", params="{\"__ym\":{\"ecommerce\":[{\"purchase\":{\"actionField\":{\"id\":\"0033349283\",\"revenue\":\"22520\",\"affiliation\":\"site\"},\"products\":[{\"id\":\"885786\",\"name\":\"MoleculaGHMM3\",\"category\":\"Dich\",\"price\":\"2870.00\",\"brand\":\"Molecula\",\"quantity\":1}]}}]}}", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-10 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")


testdata_watch_log.add_row(_date="2016-04-10", uniqid='222221455542222', cookiei='222221455542222', clientport="34986", clientip='217.118.90.186', iso_eventtime="2016-04-10 12:44:46", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-10 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")
testdata_watch_log.add_row(_date="2016-04-10", clientport="34986", clientip='176.59.7.165', iso_eventtime="2016-04-10 12:44:46", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-10 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")
testdata_watch_log.add_row(_date="2016-04-10", uniqid='601826891455542222', cookiei='601826891455542222', clientport="57406", clientip='217.118.90.186', iso_eventtime="2016-04-10 12:44:46", watch_id="1843786225552199373", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2408:rn:137781372:hid:934923750:ds:,,,,,,,,,,,,:rqnl:1:st:1460281481:u:1455701456680556087", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', timestamp="2016-04-10 12:44:46", source_uri="prt://yabs-rt@bsmc09i.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_add")
testdata_watch_log.add_row(_date="2016-04-10", clientport="34986", clientip='176.59.7.165', iso_eventtime="2016-04-10 12:44:46", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-10 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")
testdata_watch_log.add_row(_date="2016-04-10", clientport="57406", clientip='176.59.7.165', iso_eventtime="2016-04-10 12:44:46", watch_id="1843786225552199373", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2408:rn:137781372:hid:934923750:ds:,,,,,,,,,,,,:rqnl:1:st:1460281481:u:1455701456680556087", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', timestamp="2016-04-10 12:44:46", source_uri="prt://yabs-rt@bsmc09i.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_add")
testdata_watch_log.add_row(_date="2016-04-10", uniqid='601826891455542222', cookiei='601826891455542222', clientport="34986", clientip='217.118.90.186', iso_eventtime="2016-04-10 12:44:46", watch_id="1843786190089097103", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144440:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ls:1420450784463:rqn:2406:rn:192191027:hid:934923750:ds:232,118,54,1,0,0,,,,,,,:rqnl:1:st:1460281481:u:1455701456680556087", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', timestamp="2016-04-10 12:44:46", source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://vk.com/elka_game", remoteip6="::ffff:127.0.0.1", url="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=")
#purchase
testdata_watch_log.add_row(_date="2016-04-10", uniqid='222221455542222', cookiei='222221455542222', clientip='217.118.90.186', iso_eventtime="2016-04-10 12:44:46", params="{\"__ym\":{\"ecommerce\":[{\"purchase\":{\"actionField\":{\"id\":251407497},\"products\":[{\"id\":1112223,\"price\":\"5348\",\"quantity\":1}]}}]}}", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-10 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")
testdata_watch_log.add_row(_date="2016-04-10", uniqid='222221455542222', cookiei='222221455542222', clientip='217.118.90.186', iso_eventtime="2016-04-10 12:44:46", params="{\"__ym\":{\"ecommerce\":[{\"purchase\":{\"actionField\":{\"id\":\"0033349283\",\"affiliation\":\"site\"},\"products\":[{\"id\":\"885786\",\"name\":\"TestProduct\",\"category\":\"TestCategory\",\"price\":\"2870.00\",\"brand\":\"Molecula\",\"quantity\":1}]}}]}}", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-10 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")
testdata_watch_log.add_row(_date="2016-04-10", uniqid='222221455542222', cookiei='222221455542222', clientip='217.118.90.186', iso_eventtime="2016-04-10 12:44:46", params="{\"__ym\":{\"ecommerce\":[{\"purchase\":{\"actionField\":{\"id\":\"0033349283\",\"revenue\":\"22520\",\"affiliation\":\"site\"},\"products\":[{\"id\":\"885786\",\"name\":\"MoleculaGHMM3\",\"category\":\"Dich\",\"price\":\"2870.00\",\"brand\":\"Molecula\",\"quantity\":1}]}}]}}", browserinfo="s:1280x1024x24:sk:1:ifr:1:f:21.0.0:fpr:97806405901:cn:1:w:1000x978:z:300:i:20160410144441:et:1460281481:en:utf-8:v:682:c:1:la:ru:wh:1:ar:1:ls:1420450784463:rqn:2407:rn:268872224:hid:934923750:ds:,,,,,,,280,,,,,690:rqnl:1:st:1460281481:u:1455701456680556087", timestamp="2016-04-10 12:44:46", useragent='Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', source_uri="prt://yabs-rt@bsmc17e.yandex.ru/home/yabs/server/log.rtmr/watch.tskv", referer="https://elka2016-vk.ereality.org/iframe?api_url=https://api.vk.com/api.php&api_id=5124326&api_settings=2367495&viewer_id=27627371&viewer_type=0&sid=1bdb5cf1fcca5a988b0a5f967f99f68d79d2a64eda4ef1c55a975e89cfff78f2f6dddf34c7a77b7e9c1ca&secret=a896078edb&access_token=55dfe0ac6ee01891eb0aa9cd14220f274d2944d0fa174fbc19c30689b64aecceed116ce28d36b8b180f04&user_id=0&group_id=0&is_app_user=1&auth_key=76ed1db554d2e99e0618ae79d1e8ca24&language=0&parent_language=0&ad_info=ElsdCQNbR1djBgNaAwJSXHt5B0Q8HTJXUVBBJRVBNwoIFjI2HA8H&is_secure=1&ads_app_id=5124326_d5b166fc4e1a5244fe&referrer=unknown&lc_name=792224cc&hash=", remoteip6="::ffff:127.0.0.1", url="goal://elka2016-vk.ereality.org/flash_start")

convert_old_fp_to_watch_log(testdata_watch_log, rawdata_fp, '2016-04-09')
convert_old_fp_to_watch_log(testdata_watch_log, rawdata_fp2, '2016-04-10')
convert_old_fp_to_watch_log(testdata_watch_log, rawdata_fp3, '2016-04-11')

testdata_awaps_log_09 = BaseLog(
    path="//statbox/awaps-log",
    date="2016-04-09",
    default_data={}
)

testdata_awaps_log_09.add_row(**{'_date': '2016-04-09', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217744', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '4612179381520084205', 'sd_age_35': '0', 'height': '90', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Chrome&BrowserVersion=64.0.3282.186&OSFamily=Windows&OSName=Windows 8.1&OSVersion=6.3&isMobile=false&isTouch=false&accept-language=ru-ru&&ref=del_147&charset=utf-8&duid=MTUyMDEwNzI3NDU4NTk1NzYwNA==&id=10&highlight=1&tag=41235981008898&id=649301520107283085&version=4171&ver=0&width=1000&grab=del_2048&config=del_188&callback=Ya[1520107285330]', 'rtb_imp_id': '10', 'awapsid': '4001c0b60be2aced', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086341205936440', 'referer': 'http://cursorinfo.co.il/putinskomu-hvastovstvu-ne-poverili-dazhe-sobstvennye-uchenye/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '587', 'tskv_format': 'awaps-log', 'geo_zone': '2', 'user_regular_location_txt': '', 'ip_number': '2035185369', 'rtb_slice_id': '0', 'rtb_user_id': '4612179381520084205', 'ua_browser_name_nmb': '4', 'mime_type': '0', 'yandexuid': '4612179381520084205', 'rtb_site_id': '176480', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520114700/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.186 Safari/537.36', 'lon': '', 'user_id_type': '1', 'ipv6': '::ffff:217.118.78.121', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '97390', 'unitnmb': '910625707', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS26.ld.yandex.ru/crypta_export/crypta0.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '1052', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341284', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3325830', 'global_request_id': '3781474757419337376', 'sd_age_18': '0', 'user_search_cats': 'BfXhZwX14XEF9eF2BfXhewX14Y4F9eGPBfXhqAX14akF9eGqBfXhrwX14bkF9eHOBfXh0wX14dUF9eHmBfXh6QX14e4F9eIABfXiFgX14hgF9eIlBfXiMgX14jcF9eI4BfXiPwX14lYF9eJwBfXilwX14qQF9eK9BfXi8wX14wIF9eMPBfXjFgX14xsF9eMcBfXjIAX14yEF9eMjBfXjJAX14yUF9eMnBfXjLAX14y4F9eMwBfXjNgX140gF9eNK', 'sectionid': '9090', 'rtb_reserve_price': '100', 'width': '728'})
testdata_awaps_log_09.add_row(**{'_date': '2016-04-09', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1212395', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '8', 'rtb_deal_nmb': '0', 'userid': '1970796351508170551', 'sd_age_35': '100', 'height': '400', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '7', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=MobileSafari&BrowserVersion=11.0&DeviceModel=iPad&DeviceName=iPad&DeviceVendor=Apple&OSFamily=iOS&OSVersion=11.2.5&isMobile=true&isTablet=true&isTouch=true&accept-language=ru&&ref=del_71&ref=del_71&charset=utf-8&duid=MTUxNzgzMzQwMTc4NzkzOTkxNg==&id=11&highlight=1&tag=37387690311682&id=6849411520110800270&version=4164&ver=0&width=300&grab=del_204&config=del_185&callback=Ya[1520110810229]', 'rtb_imp_id': '11', 'awapsid': '1b59acd70847c737', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086294426335738', 'referer': 'https://music.yandex.ru/users/uid-2ho7pirg/playlists/1009', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '1274', 'tskv_format': 'awaps-log', 'geo_zone': '11', 'user_regular_location_txt': '[[55.751618;37.566315]]', 'ip_number': '373541723', 'rtb_slice_id': '0', 'rtb_user_id': '1970796351508170551', 'ua_browser_name_nmb': '6', 'mime_type': '0', 'yandexuid': '1970796351508170551', 'rtb_site_id': '136563', 'sd_user_events': '6369:1519381792,6373:1519381792', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (iPad; CPU OS 11_2_5 like Mac OS X) AppleWebKit/604.5.6 (KHTML, like Gecko) Version/11.0 Mobile/15D60 Safari/604.1', 'lon': '', 'user_id_type': '1', 'ipv6': '::ffff:91.203.67.22', 'unixtime': '1520110800', 'sd_app_hashes': '48601714,127479454,279688290,293237581,344033223,434536299,460115031,472381211,514066329,525700451,558213177,570392451,667414256,692920334,774162588,858175948,915905643,942804783,1007774637,1052389471,1128771526,1166851452,1188096764,1232483726,1235034899,1370781831,1448028013,1491176382,1506397672,1550559104,1554321029,1614439145,1667871747,1706232971,1796065578,1803411425,1808036939,1852338105,1900464940,1953301021,2047317490,2047593510,2072947012,2085219943,2090130729,2120744166,2123741216,2142044537,2194338079,2213758016,2260651456,2311025784,2336963338,2377075764,2386943871,2448498603,2490477568,2558205106,2669044287,2861126552,2868276598,2926080368,2952987727,3057752544,3178410019,3295117466,3332906229,3356119129,3376141145,3381249149,3416741637,3564549875,3653721913,3668429583,3713566355,3741129771,3751041160,3910820935,4009197237,4031802127,4056251228,4122756139,4208980957,4228920843,4230426703,4241264962,4265085433,4276644023', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '8863', 'unitnmb': '910625720', 'user_regular_location': 'ITsFlBZkKi4=', 'source_uri': 'prt://crypta-awaps@MINILOGS39.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '5970', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '1', 'uniq_nmb': '37829341232', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '3309942', 'global_request_id': '3781474754849277600', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14WcF9eFvBfXhcQX14X0F9eGOBfXhpAX14acF9eGqBfXhuQX14b0F9eHIBfXhygX14c0F9eHOBfXh0wX14dUF9eHiBfXh5gX14ekF9eIWBfXiJQX14igF9eI3BfXiPQX14j4F9eI/BfXiXgX14nAF9eJ7BfXilwX14pgF9eK9BfXi8wX14w4F9eMPBfXjFQX14xcF9eMYBfXjIgX14yQF9eMnBfXjKQX14ywF9eMtBfXjLgX14y8F9eMwBfXjNwX140o=', 'sectionid': '9007', 'rtb_reserve_price': '100', 'width': '240'})
testdata_awaps_log_09.add_row(**{'_date': '2016-04-09', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217295', 'actionid': '11', 'sd_gender_m': '100', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '1721888085390194561', 'sd_age_35': '0', 'height': '400', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Firefox&BrowserVersion=51.0&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru-ru&lat=45.062038&lon=42.020671&&ref=del_58&ref=del_68&charset=utf-8&duid=MTUxMTg5NDM4MjY5Mjg4NTI4MA==&id=73&id=100000939&highlight=1&tag=41238128492642&id=8239071520110821024&version=4171&ver=0&token=yabs.MTI4OTgwMDYzMQo1Mzc3MTEyNTE1CjUyMTUyNjg2OTkKNTMwMzcwMDk5NQ==&grab=del_1420&config=del_186&callback=Ya[1520110834034]', 'rtb_imp_id': '73', 'awapsid': '17e5601738a8f781', 'sd_age_45_55': '100', 'subkey': '', 'rtb_request_id': '971086358371645622', 'referer': 'https://www.avito.ru/rossiya/avtomobili/saturn', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '61', 'tskv_format': 'awaps-log', 'geo_zone': '36', 'user_regular_location_txt': '[[45.062054;42.020687]]', 'ip_number': '-536336563', 'rtb_slice_id': '0', 'rtb_user_id': '1721888085390194561', 'ua_browser_name_nmb': '2', 'mime_type': '0', 'yandexuid': '4029119221511770153', 'rtb_site_id': '189903', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 'lon': '42.02067000', 'user_id_type': '2', 'ipv6': '::ffff:77.39.8.224', 'unixtime': '1520110800', 'sd_app_hashes': '71079357,169819488,478387569,525700451,558213177,605371663,692920334,724757188,783153971,942804783,957224700,1341744642,1448028013,1718585212,1803411425,1808036939,1883594588,2018383299,2047317490,2047593510,2070207248,2072947012,2076029250,2090130729,2120744166,2213758016,2230472277,2306374503,2385088622,2440523967,2448498603,2669044287,2878699766,2886741245,2952987727,2994798818,3125829330,3150602779,3214412614,3216818075,3301399303,3356119129,3381249149,3416741637,3564549875,3596270024,3668429583,3713566355,3834227468,3910820935,3994884419,4131938128,4241264962,4265920265', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '69882', 'unitnmb': '910625718', 'user_regular_location': 'GtvsfBkL2RY=', 'source_uri': 'prt://crypta-awaps@MINILOGS37.ld.yandex.ru/crypta_export/crypta1.txt', 'sd_income_c': '100', 'lat': '45.06204000', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '1271', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341307', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3320838', 'global_request_id': '3781474758762890912', 'sd_age_18': '0', 'user_search_cats': 'BfXhZwX14XEF9eF0BfXheAX14XsF9eGFBfXhhwX14aEF9eGkBfXhqAX14aoF9eG2BfXhuQX14coF9eHOBfXh0QX14dMF9eHVBfXh5wX14egF9eIABfXiGAX14iUF9eIqBfXiMgX14jMF9eI3BfXiQAX14l4F9eJpBfXibAX14nAF9eKQBfXimQX14qUF9eK1BfXiuAX14ssF9eLyBfXi8wX14vkF9eMSBfXjEwX14xYF9eMbBfXjHQX14x4F9eMiBfXjJwX14ywF9eMtBfXjLgX14zAF9eM3BfXjSQX140o=', 'sectionid': '9090', 'rtb_reserve_price': '1261', 'width': '240'})
testdata_awaps_log_09.add_row(**{'_date': '2016-04-09', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1219555', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '8760001243509038040', 'sd_age_35': '0', 'height': '90', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '100', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=17.11.1.990&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru&&ref=del_127&ref=del_170&charset=utf-8&duid=MTUxOTkyMjE0NTMyODEwNjIwMA==&id=61&highlight=1&tag=41235981008898&id=6712901520110807774&version=4171&ver=0&width=740&grab=del_984&config=del_187&callback=Ya[1520110810775]', 'rtb_imp_id': '61', 'awapsid': '7991c6b7ef561bd8', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086230350470595', 'referer': 'http://www.starhit.ru/novosti/emmanuil-vitorgan-ya-prihodil-k-jene-v-palatu-a-potom-bilsya-golovoy-ob-stenu-130628/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '1739', 'tskv_format': 'awaps-log', 'geo_zone': '969', 'user_regular_location_txt': '', 'ip_number': '-1808255393', 'rtb_slice_id': '0', 'rtb_user_id': '8760001243509038040', 'ua_browser_name_nmb': '16', 'mime_type': '0', 'yandexuid': '8760001241509038040', 'rtb_site_id': '126929', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 YaBrowser/17.11.1.990 Yowser/2.5 Safari/537.36', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:95.54.56.148', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '135233', 'unitnmb': '910625716', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS35.ld.yandex.ru/crypta_export/crypta2.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '2012', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341143', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '3343992', 'global_request_id': '3781474750280435360', 'sd_age_18': '0', 'user_search_cats': 'BfXhcQX14XYF9eGLBfXhjgX14Y8F9eGQBfXhmQX14akF9eGqBfXhtgX14dEF9eHhBfXh4wX14eoF9eH6BfXiBAX14hgF9eIlBfXiKAX14ikF9eI3BfXiXgX14mUF9eJsBfXipAX14qUF9eK5BfXi7wX14vIF9eLzBfXjDwX14xEF9eMVBfXjFwX14xsF9eMcBfXjHQX14yAF9eMhBfXjIwX14yQF9eMlBfXjJwX14ywF9eMtBfXjMAX140oF9eNV', 'sectionid': '9090', 'rtb_reserve_price': '855', 'width': '728'})
testdata_awaps_log_09.add_row(**{'_date': '2016-04-09', 'rtb_host_id': '2', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '100', 'ua_os_family_nmb': '11', 'rtb_deal_nmb': '0', 'userid': '935089865373625639', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=18.1.1.841&OSFamily=MacOS&OSName=Mac OS X High Sierra&OSVersion=10.13.3&isMobile=false&isTouch=false&accept-language=ru&&ref=del_82&ref=del_367&charset=utf-8&duid=MTUxMTc2NzI4MjEwNjQyNTgzMTE=&id=7&highlight=1&tag=38487201939554&id=3624311520108551281&version=4166&ver=0&token=awaps.MTg0MDE2OzIwMjExNTsyMDg0MjU7MjIxMDg0OzIzMTU4NDsyMzYyNjg7MjM2NTY1OzIzNjc1MzsyMzcwMTc7MjM3MTgzOzIzNzMyNzsyMzc1Njc7MjM4MjgzOzIzODkwMTsyMzk3OTM7MjM5OTY3OzI0MDM0NTsyNDA4NDM7MjQwOTQxOw==:yabs.MjI3NjQxNzU0OQoyMzgyMTMyNzE2CjIzODM5MjQ2NjIKMjc5MzEyMTE2MAoyNzk0OTAxMTEyCjI3OTQ5MjQ5MTYKMjkzNTE5NDQ2NQoyOTc4MDQ2OTE4CjMzNzU3MzUxOTMKMzc0OTc5Nzk4NwozODA1MTY2ODcyCjM5ODY1NTU5MDQKMzk4NzI2NzQwOQo0MTk0MTg4OTc3CjQ2NDU2NzUxNTMKNTc5NTc4MTIyMAo1Nzk4NjY5NzYwCjU3OTg0NjY3NjAKNDM2Mzc2MDc3Ngo0NTIwNDA1NjE4CjQ5OTg0MzM2NDUKNDk5ODQzMzcxMAo1MTU4MjY5NDA2CjUyMDIwNjQ5NDEKNTIwMjA2NDk2MAo1MjAyMDY0OTY4CjUyMDIwNjQ5NzYKNTIwMjA2NTEyNAo1MjAyMDY1MjgxCjUyMjUyMzUxMTEKNTM2MTIwMDc5MAo0NTkwOTk0MDAxCjU3OTA2NTM5NzkKNTc1OTUwMTQzMAo1NzI5NzkxODM0CjU3MTY0NTE5ODkKNDU4MTg0Nzc1NTQxMjE3MQo0Mjk1NjIzMzMyNjUwMzE4&grab=del_528&config=del_187&callback=Ya[1520110803029]', 'rtb_imp_id': '7', 'awapsid': 'cfa1b473aa9ad27', 'sd_age_45_55': '100', 'subkey': '', 'rtb_request_id': '971086366070806843', 'referer': 'https://auto.ru/cars/used/sale/dodge/stratus/1070234581-5c2c3/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '98', 'tskv_format': 'awaps-log', 'geo_zone': '213', 'user_regular_location_txt': '[[55.857875;37.565047];[55.7894;37.711319];[55.856733;37.560827]]', 'ip_number': '-693429922', 'rtb_slice_id': '0', 'rtb_user_id': '935089865373625639', 'ua_browser_name_nmb': '16', 'mime_type': '0', 'yandexuid': '3090933141471899331', 'rtb_site_id': '148440', 'sd_user_events': '6369:1520007115,6371:1520007115,6372:1520007115,6373:1520007115,6374:1520007115,6377:1520007115,6379:1520007115', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.1.841 Yowser/2.5 Safari/537.36', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:94.25.171.214', 'unixtime': '1520110800', 'sd_app_hashes': '14938493,37548216,129216775,135039294,162183626,167850790,169420841,186257271,220965583,270313332,289560633,311782531,353998586,364347159,377782831,427176595,431733902,462945431,525063560,539063625,555385183,558213177,568436147,570392451,603866800,607382348,688302987,690301532,692920334,701572721,724757188,736046990,773907122,785980639,812897175,832703584,841424629,845769836,858175948,873641472,875199612,875598038,880265348,905411996,908489162,912868405,929105432,942804783,960131092,991212977,1005672442,1010079442,1052389471,1060538229,1098545240,1130009756,1155122338,1166851452,1216645183,1253542509,1265775363,1270427349,1289191926,1338380693,1414524964,1420356614,1426836534,1430875870,1438243397,1458557607,1483056019,1506397672,1554321029,1577606181,1580684943,1587975572,1615271914,1657133457,1661642138,1673341864,1699889852,1724752960,1725269253,1735847067,1797236189,1798430623,1803411425,1808036939,1813876334,1820542703,1821907912,1824697786,1857387529,1920949112,1925775697,1926588157,1952695436,1960638779,1969428879,1977033744,1988662142,2045044657,2047593510,2063309954,2085219943,2090130729,2120744166,2138799454,2157114697,2185100095,2194164051,2213758016,2227942036,2236149985,2244839292,2260651456,2276496148,2278854939,2279672871,2307066304,2366667574,2377075764,2395052192,2397143032,2448498603,2469178880,2521520882,2521909122,2560843468,2586747934,2622807395,2664741887,2669044287,2670252020,2781796948,2786030271,2791566947,2826212303,2861126552,2868276598,2878581067,2892337202,2901144658,2914670156,2952987727,3018554016,3057752544,3104973233,3113830435,3147352603,3150602779,3153355610,3161966845,3180184195,3194734416,3198835439,3252688027,3258295395,3262358512,3269880911,3271406603,3309273458,3352619716,3356119129,3369929978,3373751574,3381249149,3451100047,3473814298,3476945653,3494657323,3544979193,3570885413,3592378865,3602355338,3626283695,3640416757,3653721913,3663958485,3664085375,3668429583,3679650631,3700926310,3741129771,3753189015,3758775996,3767604742,3780116822,3832305314,3887639901,3910820935,3951877041,3985328653,3993279540,3994884419,3998291075,4002108050,4031373429,4057085482,4105531469,4119851171,4132246087,4170562239,4208980957,4210709565,4215818591,4219807213,4220463190,4222280816,4235901571,4276644023', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '24218', 'unitnmb': '910625721', 'user_regular_location': 'IUs8PhZj+KYhQMlwFnpKZiFLD6IWY1PO', 'source_uri': 'prt://crypta-awaps@MINILOGS40.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341325', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474759586154144', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14WcF9eFsBfXhcQX14XIF9eF+BfXhhQX14aQF9eGqBfXhrwX14bQF9eHBBfXhwgX14cgF9eHKBfXhzQX14dMF9eHUBfXh1QX14d4F9eIABfXiAgX14h0F9eIlBfXiNwX14jwF9eI9BfXiPgX14j8F9eJBBfXiQwX14kwF9eJeBfXiYQX14nAF9eKCBfXipAX14qUF9eLWBfXi4gX14vMF9eL1BfXjDQX14xIF9eMVBfXjGwX14x8F9eMkBfXjJwX14ygF9eMqBfXjKwX14ywF9eMtBfXjLgX14zAF9eM7BfXjSg==', 'sectionid': '29317', 'rtb_reserve_price': '0', 'width': '0'})

testdata_awaps_log_10 = BaseLog(
    path="//statbox/awaps-log",
    date="2016-04-10",
    default_data={}
)

testdata_awaps_log_10.add_row(**{'_date': '2016-04-10', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217744', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '4612179381520084205', 'sd_age_35': '0', 'height': '90', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Chrome&BrowserVersion=64.0.3282.186&OSFamily=Windows&OSName=Windows 8.1&OSVersion=6.3&isMobile=false&isTouch=false&accept-language=ru-ru&&ref=del_147&charset=utf-8&duid=MTUyMDEwNzI3NDU4NTk1NzYwNA==&id=10&highlight=1&tag=41235981008898&id=649301520107283085&version=4171&ver=0&width=1000&grab=del_2048&config=del_188&callback=Ya[1520107285330]', 'rtb_imp_id': '10', 'awapsid': '4001c0b60be2aced', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086341205936440', 'referer': 'http://cursorinfo.co.il/putinskomu-hvastovstvu-ne-poverili-dazhe-sobstvennye-uchenye/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '587', 'tskv_format': 'awaps-log', 'geo_zone': '2', 'user_regular_location_txt': '', 'ip_number': '2035185369', 'rtb_slice_id': '0', 'rtb_user_id': '4612179381520084205', 'ua_browser_name_nmb': '4', 'mime_type': '0', 'yandexuid': '4612179381520084205', 'rtb_site_id': '176480', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520114700/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.186 Safari/537.36', 'lon': '', 'user_id_type': '1', 'ipv6': '::ffff:217.118.78.121', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '97390', 'unitnmb': '910625707', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS26.ld.yandex.ru/crypta_export/crypta0.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '1052', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341284', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3325830', 'global_request_id': '3781474757419337376', 'sd_age_18': '0', 'user_search_cats': 'BfXhZwX14XEF9eF2BfXhewX14Y4F9eGPBfXhqAX14akF9eGqBfXhrwX14bkF9eHOBfXh0wX14dUF9eHmBfXh6QX14e4F9eIABfXiFgX14hgF9eIlBfXiMgX14jcF9eI4BfXiPwX14lYF9eJwBfXilwX14qQF9eK9BfXi8wX14wIF9eMPBfXjFgX14xsF9eMcBfXjIAX14yEF9eMjBfXjJAX14yUF9eMnBfXjLAX14y4F9eMwBfXjNgX140gF9eNK', 'sectionid': '9090', 'rtb_reserve_price': '100', 'width': '728'})
testdata_awaps_log_10.add_row(**{'_date': '2016-04-10', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1212395', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '8', 'rtb_deal_nmb': '0', 'userid': '1970796351508170551', 'sd_age_35': '100', 'height': '400', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '7', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=MobileSafari&BrowserVersion=11.0&DeviceModel=iPad&DeviceName=iPad&DeviceVendor=Apple&OSFamily=iOS&OSVersion=11.2.5&isMobile=true&isTablet=true&isTouch=true&accept-language=ru&&ref=del_71&ref=del_71&charset=utf-8&duid=MTUxNzgzMzQwMTc4NzkzOTkxNg==&id=11&highlight=1&tag=37387690311682&id=6849411520110800270&version=4164&ver=0&width=300&grab=del_204&config=del_185&callback=Ya[1520110810229]', 'rtb_imp_id': '11', 'awapsid': '1b59acd70847c737', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086294426335738', 'referer': 'https://music.yandex.ru/users/uid-2ho7pirg/playlists/1009', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '1274', 'tskv_format': 'awaps-log', 'geo_zone': '11', 'user_regular_location_txt': '[[55.751618;37.566315]]', 'ip_number': '373541723', 'rtb_slice_id': '0', 'rtb_user_id': '1970796351508170551', 'ua_browser_name_nmb': '6', 'mime_type': '0', 'yandexuid': '1970796351508170551', 'rtb_site_id': '136563', 'sd_user_events': '6369:1519381792,6373:1519381792', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (iPad; CPU OS 11_2_5 like Mac OS X) AppleWebKit/604.5.6 (KHTML, like Gecko) Version/11.0 Mobile/15D60 Safari/604.1', 'lon': '', 'user_id_type': '1', 'ipv6': '::ffff:91.203.67.22', 'unixtime': '1520110800', 'sd_app_hashes': '48601714,127479454,279688290,293237581,344033223,434536299,460115031,472381211,514066329,525700451,558213177,570392451,667414256,692920334,774162588,858175948,915905643,942804783,1007774637,1052389471,1128771526,1166851452,1188096764,1232483726,1235034899,1370781831,1448028013,1491176382,1506397672,1550559104,1554321029,1614439145,1667871747,1706232971,1796065578,1803411425,1808036939,1852338105,1900464940,1953301021,2047317490,2047593510,2072947012,2085219943,2090130729,2120744166,2123741216,2142044537,2194338079,2213758016,2260651456,2311025784,2336963338,2377075764,2386943871,2448498603,2490477568,2558205106,2669044287,2861126552,2868276598,2926080368,2952987727,3057752544,3178410019,3295117466,3332906229,3356119129,3376141145,3381249149,3416741637,3564549875,3653721913,3668429583,3713566355,3741129771,3751041160,3910820935,4009197237,4031802127,4056251228,4122756139,4208980957,4228920843,4230426703,4241264962,4265085433,4276644023', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '8863', 'unitnmb': '910625720', 'user_regular_location': 'ITsFlBZkKi4=', 'source_uri': 'prt://crypta-awaps@MINILOGS39.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '5970', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '1', 'uniq_nmb': '37829341232', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '3309942', 'global_request_id': '3781474754849277600', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14WcF9eFvBfXhcQX14X0F9eGOBfXhpAX14acF9eGqBfXhuQX14b0F9eHIBfXhygX14c0F9eHOBfXh0wX14dUF9eHiBfXh5gX14ekF9eIWBfXiJQX14igF9eI3BfXiPQX14j4F9eI/BfXiXgX14nAF9eJ7BfXilwX14pgF9eK9BfXi8wX14w4F9eMPBfXjFQX14xcF9eMYBfXjIgX14yQF9eMnBfXjKQX14ywF9eMtBfXjLgX14y8F9eMwBfXjNwX140o=', 'sectionid': '9007', 'rtb_reserve_price': '100', 'width': '240'})
testdata_awaps_log_10.add_row(**{'_date': '2016-04-10', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217295', 'actionid': '11', 'sd_gender_m': '100', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '1721888085390194561', 'sd_age_35': '0', 'height': '400', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Firefox&BrowserVersion=51.0&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru-ru&lat=45.062038&lon=42.020671&&ref=del_58&ref=del_68&charset=utf-8&duid=MTUxMTg5NDM4MjY5Mjg4NTI4MA==&id=73&id=100000939&highlight=1&tag=41238128492642&id=8239071520110821024&version=4171&ver=0&token=yabs.MTI4OTgwMDYzMQo1Mzc3MTEyNTE1CjUyMTUyNjg2OTkKNTMwMzcwMDk5NQ==&grab=del_1420&config=del_186&callback=Ya[1520110834034]', 'rtb_imp_id': '73', 'awapsid': '17e5601738a8f781', 'sd_age_45_55': '100', 'subkey': '', 'rtb_request_id': '971086358371645622', 'referer': 'https://www.avito.ru/rossiya/avtomobili/saturn', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '61', 'tskv_format': 'awaps-log', 'geo_zone': '36', 'user_regular_location_txt': '[[45.062054;42.020687]]', 'ip_number': '-536336563', 'rtb_slice_id': '0', 'rtb_user_id': '1721888085390194561', 'ua_browser_name_nmb': '2', 'mime_type': '0', 'yandexuid': '4029119221511770153', 'rtb_site_id': '189903', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 'lon': '42.02067000', 'user_id_type': '2', 'ipv6': '::ffff:77.39.8.224', 'unixtime': '1520110800', 'sd_app_hashes': '71079357,169819488,478387569,525700451,558213177,605371663,692920334,724757188,783153971,942804783,957224700,1341744642,1448028013,1718585212,1803411425,1808036939,1883594588,2018383299,2047317490,2047593510,2070207248,2072947012,2076029250,2090130729,2120744166,2213758016,2230472277,2306374503,2385088622,2440523967,2448498603,2669044287,2878699766,2886741245,2952987727,2994798818,3125829330,3150602779,3214412614,3216818075,3301399303,3356119129,3381249149,3416741637,3564549875,3596270024,3668429583,3713566355,3834227468,3910820935,3994884419,4131938128,4241264962,4265920265', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '69882', 'unitnmb': '910625718', 'user_regular_location': 'GtvsfBkL2RY=', 'source_uri': 'prt://crypta-awaps@MINILOGS37.ld.yandex.ru/crypta_export/crypta1.txt', 'sd_income_c': '100', 'lat': '45.06204000', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '1271', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341307', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3320838', 'global_request_id': '3781474758762890912', 'sd_age_18': '0', 'user_search_cats': 'BfXhZwX14XEF9eF0BfXheAX14XsF9eGFBfXhhwX14aEF9eGkBfXhqAX14aoF9eG2BfXhuQX14coF9eHOBfXh0QX14dMF9eHVBfXh5wX14egF9eIABfXiGAX14iUF9eIqBfXiMgX14jMF9eI3BfXiQAX14l4F9eJpBfXibAX14nAF9eKQBfXimQX14qUF9eK1BfXiuAX14ssF9eLyBfXi8wX14vkF9eMSBfXjEwX14xYF9eMbBfXjHQX14x4F9eMiBfXjJwX14ywF9eMtBfXjLgX14zAF9eM3BfXjSQX140o=', 'sectionid': '9090', 'rtb_reserve_price': '1261', 'width': '240'})
testdata_awaps_log_10.add_row(**{'_date': '2016-04-10', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1219555', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '8760001243509038040', 'sd_age_35': '0', 'height': '90', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '100', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=17.11.1.990&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru&&ref=del_127&ref=del_170&charset=utf-8&duid=MTUxOTkyMjE0NTMyODEwNjIwMA==&id=61&highlight=1&tag=41235981008898&id=6712901520110807774&version=4171&ver=0&width=740&grab=del_984&config=del_187&callback=Ya[1520110810775]', 'rtb_imp_id': '61', 'awapsid': '7991c6b7ef561bd8', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086230350470595', 'referer': 'http://www.starhit.ru/novosti/emmanuil-vitorgan-ya-prihodil-k-jene-v-palatu-a-potom-bilsya-golovoy-ob-stenu-130628/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '1739', 'tskv_format': 'awaps-log', 'geo_zone': '969', 'user_regular_location_txt': '', 'ip_number': '-1808255393', 'rtb_slice_id': '0', 'rtb_user_id': '8760001243509038040', 'ua_browser_name_nmb': '16', 'mime_type': '0', 'yandexuid': '8760001241509038040', 'rtb_site_id': '126929', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 YaBrowser/17.11.1.990 Yowser/2.5 Safari/537.36', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:95.54.56.148', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '135233', 'unitnmb': '910625716', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS35.ld.yandex.ru/crypta_export/crypta2.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '2012', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341143', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '3343992', 'global_request_id': '3781474750280435360', 'sd_age_18': '0', 'user_search_cats': 'BfXhcQX14XYF9eGLBfXhjgX14Y8F9eGQBfXhmQX14akF9eGqBfXhtgX14dEF9eHhBfXh4wX14eoF9eH6BfXiBAX14hgF9eIlBfXiKAX14ikF9eI3BfXiXgX14mUF9eJsBfXipAX14qUF9eK5BfXi7wX14vIF9eLzBfXjDwX14xEF9eMVBfXjFwX14xsF9eMcBfXjHQX14yAF9eMhBfXjIwX14yQF9eMlBfXjJwX14ywF9eMtBfXjMAX140oF9eNV', 'sectionid': '9090', 'rtb_reserve_price': '855', 'width': '728'})
testdata_awaps_log_10.add_row(**{'_date': '2016-04-10', 'rtb_host_id': '2', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '100', 'ua_os_family_nmb': '11', 'rtb_deal_nmb': '0', 'userid': '935089865373625639', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=18.1.1.841&OSFamily=MacOS&OSName=Mac OS X High Sierra&OSVersion=10.13.3&isMobile=false&isTouch=false&accept-language=ru&&ref=del_82&ref=del_367&charset=utf-8&duid=MTUxMTc2NzI4MjEwNjQyNTgzMTE=&id=7&highlight=1&tag=38487201939554&id=3624311520108551281&version=4166&ver=0&token=awaps.MTg0MDE2OzIwMjExNTsyMDg0MjU7MjIxMDg0OzIzMTU4NDsyMzYyNjg7MjM2NTY1OzIzNjc1MzsyMzcwMTc7MjM3MTgzOzIzNzMyNzsyMzc1Njc7MjM4MjgzOzIzODkwMTsyMzk3OTM7MjM5OTY3OzI0MDM0NTsyNDA4NDM7MjQwOTQxOw==:yabs.MjI3NjQxNzU0OQoyMzgyMTMyNzE2CjIzODM5MjQ2NjIKMjc5MzEyMTE2MAoyNzk0OTAxMTEyCjI3OTQ5MjQ5MTYKMjkzNTE5NDQ2NQoyOTc4MDQ2OTE4CjMzNzU3MzUxOTMKMzc0OTc5Nzk4NwozODA1MTY2ODcyCjM5ODY1NTU5MDQKMzk4NzI2NzQwOQo0MTk0MTg4OTc3CjQ2NDU2NzUxNTMKNTc5NTc4MTIyMAo1Nzk4NjY5NzYwCjU3OTg0NjY3NjAKNDM2Mzc2MDc3Ngo0NTIwNDA1NjE4CjQ5OTg0MzM2NDUKNDk5ODQzMzcxMAo1MTU4MjY5NDA2CjUyMDIwNjQ5NDEKNTIwMjA2NDk2MAo1MjAyMDY0OTY4CjUyMDIwNjQ5NzYKNTIwMjA2NTEyNAo1MjAyMDY1MjgxCjUyMjUyMzUxMTEKNTM2MTIwMDc5MAo0NTkwOTk0MDAxCjU3OTA2NTM5NzkKNTc1OTUwMTQzMAo1NzI5NzkxODM0CjU3MTY0NTE5ODkKNDU4MTg0Nzc1NTQxMjE3MQo0Mjk1NjIzMzMyNjUwMzE4&grab=del_528&config=del_187&callback=Ya[1520110803029]', 'rtb_imp_id': '7', 'awapsid': 'cfa1b473aa9ad27', 'sd_age_45_55': '100', 'subkey': '', 'rtb_request_id': '971086366070806843', 'referer': 'https://auto.ru/cars/used/sale/dodge/stratus/1070234581-5c2c3/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '98', 'tskv_format': 'awaps-log', 'geo_zone': '213', 'user_regular_location_txt': '[[55.857875;37.565047];[55.7894;37.711319];[55.856733;37.560827]]', 'ip_number': '-693429922', 'rtb_slice_id': '0', 'rtb_user_id': '935089865373625639', 'ua_browser_name_nmb': '16', 'mime_type': '0', 'yandexuid': '3090933141471899331', 'rtb_site_id': '148440', 'sd_user_events': '6369:1520007115,6371:1520007115,6372:1520007115,6373:1520007115,6374:1520007115,6377:1520007115,6379:1520007115', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.1.841 Yowser/2.5 Safari/537.36', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:94.25.171.214', 'unixtime': '1520110800', 'sd_app_hashes': '14938493,37548216,129216775,135039294,162183626,167850790,169420841,186257271,220965583,270313332,289560633,311782531,353998586,364347159,377782831,427176595,431733902,462945431,525063560,539063625,555385183,558213177,568436147,570392451,603866800,607382348,688302987,690301532,692920334,701572721,724757188,736046990,773907122,785980639,812897175,832703584,841424629,845769836,858175948,873641472,875199612,875598038,880265348,905411996,908489162,912868405,929105432,942804783,960131092,991212977,1005672442,1010079442,1052389471,1060538229,1098545240,1130009756,1155122338,1166851452,1216645183,1253542509,1265775363,1270427349,1289191926,1338380693,1414524964,1420356614,1426836534,1430875870,1438243397,1458557607,1483056019,1506397672,1554321029,1577606181,1580684943,1587975572,1615271914,1657133457,1661642138,1673341864,1699889852,1724752960,1725269253,1735847067,1797236189,1798430623,1803411425,1808036939,1813876334,1820542703,1821907912,1824697786,1857387529,1920949112,1925775697,1926588157,1952695436,1960638779,1969428879,1977033744,1988662142,2045044657,2047593510,2063309954,2085219943,2090130729,2120744166,2138799454,2157114697,2185100095,2194164051,2213758016,2227942036,2236149985,2244839292,2260651456,2276496148,2278854939,2279672871,2307066304,2366667574,2377075764,2395052192,2397143032,2448498603,2469178880,2521520882,2521909122,2560843468,2586747934,2622807395,2664741887,2669044287,2670252020,2781796948,2786030271,2791566947,2826212303,2861126552,2868276598,2878581067,2892337202,2901144658,2914670156,2952987727,3018554016,3057752544,3104973233,3113830435,3147352603,3150602779,3153355610,3161966845,3180184195,3194734416,3198835439,3252688027,3258295395,3262358512,3269880911,3271406603,3309273458,3352619716,3356119129,3369929978,3373751574,3381249149,3451100047,3473814298,3476945653,3494657323,3544979193,3570885413,3592378865,3602355338,3626283695,3640416757,3653721913,3663958485,3664085375,3668429583,3679650631,3700926310,3741129771,3753189015,3758775996,3767604742,3780116822,3832305314,3887639901,3910820935,3951877041,3985328653,3993279540,3994884419,3998291075,4002108050,4031373429,4057085482,4105531469,4119851171,4132246087,4170562239,4208980957,4210709565,4215818591,4219807213,4220463190,4222280816,4235901571,4276644023', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '24218', 'unitnmb': '910625721', 'user_regular_location': 'IUs8PhZj+KYhQMlwFnpKZiFLD6IWY1PO', 'source_uri': 'prt://crypta-awaps@MINILOGS40.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341325', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474759586154144', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14WcF9eFsBfXhcQX14XIF9eF+BfXhhQX14aQF9eGqBfXhrwX14bQF9eHBBfXhwgX14cgF9eHKBfXhzQX14dMF9eHUBfXh1QX14d4F9eIABfXiAgX14h0F9eIlBfXiNwX14jwF9eI9BfXiPgX14j8F9eJBBfXiQwX14kwF9eJeBfXiYQX14nAF9eKCBfXipAX14qUF9eLWBfXi4gX14vMF9eL1BfXjDQX14xIF9eMVBfXjGwX14x8F9eMkBfXjJwX14ygF9eMqBfXjKwX14ywF9eMtBfXjLgX14zAF9eM7BfXjSg==', 'sectionid': '29317', 'rtb_reserve_price': '0', 'width': '0'})

testdata_awaps_log = BaseLog(
    path="//statbox/awaps-log",
    date="2016-04-11",
    default_data={}
)

testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217744', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '4612179381520084205', 'sd_age_35': '0', 'height': '90', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Chrome&BrowserVersion=64.0.3282.186&OSFamily=Windows&OSName=Windows 8.1&OSVersion=6.3&isMobile=false&isTouch=false&accept-language=ru-ru&&ref=del_147&charset=utf-8&duid=MTUyMDEwNzI3NDU4NTk1NzYwNA==&id=10&highlight=1&tag=41235981008898&id=649301520107283085&version=4171&ver=0&width=1000&grab=del_2048&config=del_188&callback=Ya[1520107285330]', 'rtb_imp_id': '10', 'awapsid': '4001c0b60be2aced', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086341205936440', 'referer': 'http://cursorinfo.co.il/putinskomu-hvastovstvu-ne-poverili-dazhe-sobstvennye-uchenye/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '587', 'tskv_format': 'awaps-log', 'geo_zone': '2', 'user_regular_location_txt': '', 'ip_number': '2035185369', 'rtb_slice_id': '0', 'rtb_user_id': '4612179381520084205', 'ua_browser_name_nmb': '4', 'mime_type': '0', 'yandexuid': '4612179381520084205', 'rtb_site_id': '176480', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520114700/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.186 Safari/537.36', 'lon': '', 'user_id_type': '1', 'ipv6': '::ffff:217.118.78.121', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '97390', 'unitnmb': '910625707', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS26.ld.yandex.ru/crypta_export/crypta0.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '1052', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341284', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3325830', 'global_request_id': '3781474757419337376', 'sd_age_18': '0', 'user_search_cats': 'BfXhZwX14XEF9eF2BfXhewX14Y4F9eGPBfXhqAX14akF9eGqBfXhrwX14bkF9eHOBfXh0wX14dUF9eHmBfXh6QX14e4F9eIABfXiFgX14hgF9eIlBfXiMgX14jcF9eI4BfXiPwX14lYF9eJwBfXilwX14qQF9eK9BfXi8wX14wIF9eMPBfXjFgX14xsF9eMcBfXjIAX14yEF9eMjBfXjJAX14yUF9eMnBfXjLAX14y4F9eMwBfXjNgX140gF9eNK', 'sectionid': '9090', 'rtb_reserve_price': '100', 'width': '728'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1212395', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '8', 'rtb_deal_nmb': '0', 'userid': '1970796351508170551', 'sd_age_35': '100', 'height': '400', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '7', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=MobileSafari&BrowserVersion=11.0&DeviceModel=iPad&DeviceName=iPad&DeviceVendor=Apple&OSFamily=iOS&OSVersion=11.2.5&isMobile=true&isTablet=true&isTouch=true&accept-language=ru&&ref=del_71&ref=del_71&charset=utf-8&duid=MTUxNzgzMzQwMTc4NzkzOTkxNg==&id=11&highlight=1&tag=37387690311682&id=6849411520110800270&version=4164&ver=0&width=300&grab=del_204&config=del_185&callback=Ya[1520110810229]', 'rtb_imp_id': '11', 'awapsid': '1b59acd70847c737', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086294426335738', 'referer': 'https://music.yandex.ru/users/uid-2ho7pirg/playlists/1009', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '1274', 'tskv_format': 'awaps-log', 'geo_zone': '11', 'user_regular_location_txt': '[[55.751618;37.566315]]', 'ip_number': '373541723', 'rtb_slice_id': '0', 'rtb_user_id': '1970796351508170551', 'ua_browser_name_nmb': '6', 'mime_type': '0', 'yandexuid': '1970796351508170551', 'rtb_site_id': '136563', 'sd_user_events': '6369:1519381792,6373:1519381792', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (iPad; CPU OS 11_2_5 like Mac OS X) AppleWebKit/604.5.6 (KHTML, like Gecko) Version/11.0 Mobile/15D60 Safari/604.1', 'lon': '', 'user_id_type': '1', 'ipv6': '::ffff:91.203.67.22', 'unixtime': '1520110800', 'sd_app_hashes': '48601714,127479454,279688290,293237581,344033223,434536299,460115031,472381211,514066329,525700451,558213177,570392451,667414256,692920334,774162588,858175948,915905643,942804783,1007774637,1052389471,1128771526,1166851452,1188096764,1232483726,1235034899,1370781831,1448028013,1491176382,1506397672,1550559104,1554321029,1614439145,1667871747,1706232971,1796065578,1803411425,1808036939,1852338105,1900464940,1953301021,2047317490,2047593510,2072947012,2085219943,2090130729,2120744166,2123741216,2142044537,2194338079,2213758016,2260651456,2311025784,2336963338,2377075764,2386943871,2448498603,2490477568,2558205106,2669044287,2861126552,2868276598,2926080368,2952987727,3057752544,3178410019,3295117466,3332906229,3356119129,3376141145,3381249149,3416741637,3564549875,3653721913,3668429583,3713566355,3741129771,3751041160,3910820935,4009197237,4031802127,4056251228,4122756139,4208980957,4228920843,4230426703,4241264962,4265085433,4276644023', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '8863', 'unitnmb': '910625720', 'user_regular_location': 'ITsFlBZkKi4=', 'source_uri': 'prt://crypta-awaps@MINILOGS39.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '5970', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '1', 'uniq_nmb': '37829341232', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '3309942', 'global_request_id': '3781474754849277600', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14WcF9eFvBfXhcQX14X0F9eGOBfXhpAX14acF9eGqBfXhuQX14b0F9eHIBfXhygX14c0F9eHOBfXh0wX14dUF9eHiBfXh5gX14ekF9eIWBfXiJQX14igF9eI3BfXiPQX14j4F9eI/BfXiXgX14nAF9eJ7BfXilwX14pgF9eK9BfXi8wX14w4F9eMPBfXjFQX14xcF9eMYBfXjIgX14yQF9eMnBfXjKQX14ywF9eMtBfXjLgX14y8F9eMwBfXjNwX140o=', 'sectionid': '9007', 'rtb_reserve_price': '100', 'width': '240'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217295', 'actionid': '11', 'sd_gender_m': '100', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '1721888085390194561', 'sd_age_35': '0', 'height': '400', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Firefox&BrowserVersion=51.0&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru-ru&lat=45.062038&lon=42.020671&&ref=del_58&ref=del_68&charset=utf-8&duid=MTUxMTg5NDM4MjY5Mjg4NTI4MA==&id=73&id=100000939&highlight=1&tag=41238128492642&id=8239071520110821024&version=4171&ver=0&token=yabs.MTI4OTgwMDYzMQo1Mzc3MTEyNTE1CjUyMTUyNjg2OTkKNTMwMzcwMDk5NQ==&grab=del_1420&config=del_186&callback=Ya[1520110834034]', 'rtb_imp_id': '73', 'awapsid': '17e5601738a8f781', 'sd_age_45_55': '100', 'subkey': '', 'rtb_request_id': '971086358371645622', 'referer': 'https://www.avito.ru/rossiya/avtomobili/saturn', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '61', 'tskv_format': 'awaps-log', 'geo_zone': '36', 'user_regular_location_txt': '[[45.062054;42.020687]]', 'ip_number': '-536336563', 'rtb_slice_id': '0', 'rtb_user_id': '1721888085390194561', 'ua_browser_name_nmb': '2', 'mime_type': '0', 'yandexuid': '4029119221511770153', 'rtb_site_id': '189903', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 'lon': '42.02067000', 'user_id_type': '2', 'ipv6': '::ffff:77.39.8.224', 'unixtime': '1520110800', 'sd_app_hashes': '71079357,169819488,478387569,525700451,558213177,605371663,692920334,724757188,783153971,942804783,957224700,1341744642,1448028013,1718585212,1803411425,1808036939,1883594588,2018383299,2047317490,2047593510,2070207248,2072947012,2076029250,2090130729,2120744166,2213758016,2230472277,2306374503,2385088622,2440523967,2448498603,2669044287,2878699766,2886741245,2952987727,2994798818,3125829330,3150602779,3214412614,3216818075,3301399303,3356119129,3381249149,3416741637,3564549875,3596270024,3668429583,3713566355,3834227468,3910820935,3994884419,4131938128,4241264962,4265920265', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '69882', 'unitnmb': '910625718', 'user_regular_location': 'GtvsfBkL2RY=', 'source_uri': 'prt://crypta-awaps@MINILOGS37.ld.yandex.ru/crypta_export/crypta1.txt', 'sd_income_c': '100', 'lat': '45.06204000', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '1271', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341307', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3320838', 'global_request_id': '3781474758762890912', 'sd_age_18': '0', 'user_search_cats': 'BfXhZwX14XEF9eF0BfXheAX14XsF9eGFBfXhhwX14aEF9eGkBfXhqAX14aoF9eG2BfXhuQX14coF9eHOBfXh0QX14dMF9eHVBfXh5wX14egF9eIABfXiGAX14iUF9eIqBfXiMgX14jMF9eI3BfXiQAX14l4F9eJpBfXibAX14nAF9eKQBfXimQX14qUF9eK1BfXiuAX14ssF9eLyBfXi8wX14vkF9eMSBfXjEwX14xYF9eMbBfXjHQX14x4F9eMiBfXjJwX14ywF9eMtBfXjLgX14zAF9eM3BfXjSQX140o=', 'sectionid': '9090', 'rtb_reserve_price': '1261', 'width': '240'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1219555', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '8760001243509038040', 'sd_age_35': '0', 'height': '90', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '100', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=17.11.1.990&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru&&ref=del_127&ref=del_170&charset=utf-8&duid=MTUxOTkyMjE0NTMyODEwNjIwMA==&id=61&highlight=1&tag=41235981008898&id=6712901520110807774&version=4171&ver=0&width=740&grab=del_984&config=del_187&callback=Ya[1520110810775]', 'rtb_imp_id': '61', 'awapsid': '7991c6b7ef561bd8', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086230350470595', 'referer': 'http://www.starhit.ru/novosti/emmanuil-vitorgan-ya-prihodil-k-jene-v-palatu-a-potom-bilsya-golovoy-ob-stenu-130628/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '1739', 'tskv_format': 'awaps-log', 'geo_zone': '969', 'user_regular_location_txt': '', 'ip_number': '-1808255393', 'rtb_slice_id': '0', 'rtb_user_id': '8760001243509038040', 'ua_browser_name_nmb': '16', 'mime_type': '0', 'yandexuid': '8760001241509038040', 'rtb_site_id': '126929', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 YaBrowser/17.11.1.990 Yowser/2.5 Safari/537.36', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:95.54.56.148', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '135233', 'unitnmb': '910625716', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS35.ld.yandex.ru/crypta_export/crypta2.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '2012', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341143', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '3343992', 'global_request_id': '3781474750280435360', 'sd_age_18': '0', 'user_search_cats': 'BfXhcQX14XYF9eGLBfXhjgX14Y8F9eGQBfXhmQX14akF9eGqBfXhtgX14dEF9eHhBfXh4wX14eoF9eH6BfXiBAX14hgF9eIlBfXiKAX14ikF9eI3BfXiXgX14mUF9eJsBfXipAX14qUF9eK5BfXi7wX14vIF9eLzBfXjDwX14xEF9eMVBfXjFwX14xsF9eMcBfXjHQX14yAF9eMhBfXjIwX14yQF9eMlBfXjJwX14ywF9eMtBfXjMAX140oF9eNV', 'sectionid': '9090', 'rtb_reserve_price': '855', 'width': '728'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '2', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '100', 'ua_os_family_nmb': '11', 'rtb_deal_nmb': '0', 'userid': '935089865373625639', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=18.1.1.841&OSFamily=MacOS&OSName=Mac OS X High Sierra&OSVersion=10.13.3&isMobile=false&isTouch=false&accept-language=ru&&ref=del_82&ref=del_367&charset=utf-8&duid=MTUxMTc2NzI4MjEwNjQyNTgzMTE=&id=7&highlight=1&tag=38487201939554&id=3624311520108551281&version=4166&ver=0&token=awaps.MTg0MDE2OzIwMjExNTsyMDg0MjU7MjIxMDg0OzIzMTU4NDsyMzYyNjg7MjM2NTY1OzIzNjc1MzsyMzcwMTc7MjM3MTgzOzIzNzMyNzsyMzc1Njc7MjM4MjgzOzIzODkwMTsyMzk3OTM7MjM5OTY3OzI0MDM0NTsyNDA4NDM7MjQwOTQxOw==:yabs.MjI3NjQxNzU0OQoyMzgyMTMyNzE2CjIzODM5MjQ2NjIKMjc5MzEyMTE2MAoyNzk0OTAxMTEyCjI3OTQ5MjQ5MTYKMjkzNTE5NDQ2NQoyOTc4MDQ2OTE4CjMzNzU3MzUxOTMKMzc0OTc5Nzk4NwozODA1MTY2ODcyCjM5ODY1NTU5MDQKMzk4NzI2NzQwOQo0MTk0MTg4OTc3CjQ2NDU2NzUxNTMKNTc5NTc4MTIyMAo1Nzk4NjY5NzYwCjU3OTg0NjY3NjAKNDM2Mzc2MDc3Ngo0NTIwNDA1NjE4CjQ5OTg0MzM2NDUKNDk5ODQzMzcxMAo1MTU4MjY5NDA2CjUyMDIwNjQ5NDEKNTIwMjA2NDk2MAo1MjAyMDY0OTY4CjUyMDIwNjQ5NzYKNTIwMjA2NTEyNAo1MjAyMDY1MjgxCjUyMjUyMzUxMTEKNTM2MTIwMDc5MAo0NTkwOTk0MDAxCjU3OTA2NTM5NzkKNTc1OTUwMTQzMAo1NzI5NzkxODM0CjU3MTY0NTE5ODkKNDU4MTg0Nzc1NTQxMjE3MQo0Mjk1NjIzMzMyNjUwMzE4&grab=del_528&config=del_187&callback=Ya[1520110803029]', 'rtb_imp_id': '7', 'awapsid': 'cfa1b473aa9ad27', 'sd_age_45_55': '100', 'subkey': '', 'rtb_request_id': '971086366070806843', 'referer': 'https://auto.ru/cars/used/sale/dodge/stratus/1070234581-5c2c3/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '98', 'tskv_format': 'awaps-log', 'geo_zone': '213', 'user_regular_location_txt': '[[55.857875;37.565047];[55.7894;37.711319];[55.856733;37.560827]]', 'ip_number': '-693429922', 'rtb_slice_id': '0', 'rtb_user_id': '935089865373625639', 'ua_browser_name_nmb': '16', 'mime_type': '0', 'yandexuid': '3090933141471899331', 'rtb_site_id': '148440', 'sd_user_events': '6369:1520007115,6371:1520007115,6372:1520007115,6373:1520007115,6374:1520007115,6377:1520007115,6379:1520007115', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.1.841 Yowser/2.5 Safari/537.36', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:94.25.171.214', 'unixtime': '1520110800', 'sd_app_hashes': '14938493,37548216,129216775,135039294,162183626,167850790,169420841,186257271,220965583,270313332,289560633,311782531,353998586,364347159,377782831,427176595,431733902,462945431,525063560,539063625,555385183,558213177,568436147,570392451,603866800,607382348,688302987,690301532,692920334,701572721,724757188,736046990,773907122,785980639,812897175,832703584,841424629,845769836,858175948,873641472,875199612,875598038,880265348,905411996,908489162,912868405,929105432,942804783,960131092,991212977,1005672442,1010079442,1052389471,1060538229,1098545240,1130009756,1155122338,1166851452,1216645183,1253542509,1265775363,1270427349,1289191926,1338380693,1414524964,1420356614,1426836534,1430875870,1438243397,1458557607,1483056019,1506397672,1554321029,1577606181,1580684943,1587975572,1615271914,1657133457,1661642138,1673341864,1699889852,1724752960,1725269253,1735847067,1797236189,1798430623,1803411425,1808036939,1813876334,1820542703,1821907912,1824697786,1857387529,1920949112,1925775697,1926588157,1952695436,1960638779,1969428879,1977033744,1988662142,2045044657,2047593510,2063309954,2085219943,2090130729,2120744166,2138799454,2157114697,2185100095,2194164051,2213758016,2227942036,2236149985,2244839292,2260651456,2276496148,2278854939,2279672871,2307066304,2366667574,2377075764,2395052192,2397143032,2448498603,2469178880,2521520882,2521909122,2560843468,2586747934,2622807395,2664741887,2669044287,2670252020,2781796948,2786030271,2791566947,2826212303,2861126552,2868276598,2878581067,2892337202,2901144658,2914670156,2952987727,3018554016,3057752544,3104973233,3113830435,3147352603,3150602779,3153355610,3161966845,3180184195,3194734416,3198835439,3252688027,3258295395,3262358512,3269880911,3271406603,3309273458,3352619716,3356119129,3369929978,3373751574,3381249149,3451100047,3473814298,3476945653,3494657323,3544979193,3570885413,3592378865,3602355338,3626283695,3640416757,3653721913,3663958485,3664085375,3668429583,3679650631,3700926310,3741129771,3753189015,3758775996,3767604742,3780116822,3832305314,3887639901,3910820935,3951877041,3985328653,3993279540,3994884419,3998291075,4002108050,4031373429,4057085482,4105531469,4119851171,4132246087,4170562239,4208980957,4210709565,4215818591,4219807213,4220463190,4222280816,4235901571,4276644023', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '24218', 'unitnmb': '910625721', 'user_regular_location': 'IUs8PhZj+KYhQMlwFnpKZiFLD6IWY1PO', 'source_uri': 'prt://crypta-awaps@MINILOGS40.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341325', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474759586154144', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14WcF9eFsBfXhcQX14XIF9eF+BfXhhQX14aQF9eGqBfXhrwX14bQF9eHBBfXhwgX14cgF9eHKBfXhzQX14dMF9eHUBfXh1QX14d4F9eIABfXiAgX14h0F9eIlBfXiNwX14jwF9eI9BfXiPgX14j8F9eJBBfXiQwX14kwF9eJeBfXiYQX14nAF9eKCBfXipAX14qUF9eLWBfXi4gX14vMF9eL1BfXjDQX14xIF9eMVBfXjGwX14x8F9eMkBfXjJwX14ygF9eMqBfXjKwX14ywF9eMtBfXjLgX14zAF9eM7BfXjSg==', 'sectionid': '29317', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217295', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '6733723345408296818', 'sd_age_35': '0', 'height': '400', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Chrome&BrowserVersion=64.0.3282.186&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru-ru&lat=55.602836&lon=37.593360&&ref=del_83&ref=del_268&charset=utf-8&duid=MTUwNjQ1NDgyNzY2ODM1ODgxNw==&id=7&highlight=1&tag=28041841475682&id=3852541520029669518&version=4147&ver=0&token=awaps.MjM5NTA1OzIzOTY0NTsyMzk3MTU7MjM3MzI3Ow==:yabs.MjM1NTg4NTU2NQoyNDA2NDc1NzMwCjM5NTE4MzU5NTAKNDE1MTc1OTgzOAoxMTE0OTU5NDExNDkwNDQ5MgoyNjI0Njk3NDY0MTUzNTcKMzUzNTU2MjYwMTgxNzI0CjQyOTU2MjMzMzI2NTAzMTgKNDMwMDE3OTE4OTAwNDM0NzMKNDQ2ODIwOTYyOQo1MDczNDk5MjkzNzE0Mjk4Ngo1MjQ0NTcwNjg3CjUyODU1MTE4MTYKNTM5MTMzNjM0Ngo1NzA4ODY1MDE0CjU3NTA5MDk4NTEKNTU0NDkyNjE1OQo1NTQ0OTI2MTU1CjU1Mjg0ODAyMzEKNTUwNTA1Mzg0NAo1NTA1MDUzODQyCjU1MDUwNTM4NDEKNTUwNTA1MzgzOAo1NDY2MjMxMjkzCjU0NjYyMzEyOTIKNTQ2NjIzMTI5MQo1MjAyOTA2ODAwCjU3NTk1MDE0MzgKNTc2NzgxNjUzMAo1NzkxMzU3OTc5CjU3OTQ4NDEwNzEKNTc5NjM4NzkyMAo1NDM2NDY3Nzg5CjU3OTg0NjY3NjAKNTk2OTY3NjExNzA1ODM0MTgKNjAxMTQ0OTUzNDMzMzQ3OTAKNjA5MDQ0NTg0NjMwOTYwNDAKNjIzNTIwMjA1MTk4NjMyNDEKNjMwMzI2NTgzNzk4NTI2NDYKNjY5MDgwNTE4NDM1MDg4NDQKNjcxNTY0NjE1NDE5NTE0MDcKNjg0NzM2NjEyMjg4NDEyOTUKNTc5ODY2OTc1Mgo1Nzk0Mjk0MTU3CjU3ODg4MzA1MzgKNTcyOTc5MTgzNAo1NzE2NzYzODU4CjU2NjkzMTc3MzIKNTY0OTgyNDY5Nwo0ODY2NDIyMzUzCjQ3NDQ2MDEyNDYwNjMyMzk3CjI1MzQyMzE0NjA5OTMyODM4CjI0NzQwNDQ5Nzc4MDcwOTA5CjI0MzI1ODIzODI0NDM3MjY4CjIzNzkyODY1OTUwMzgxNTI3CjIzNjc5MTk3MDE1MjI4MjUzCjIzNjY4NjA1OTQzMjM4NTQ4CjIzNDIzNDI0NTUwMDU5NTcyCjIzMzk2MDMzNjI1MDEzMDUyCjIzMTYxNjQ2MjkyMzg3MzM2CjIzMDE4NDUyMzU0MDE4MDc2&grab=del_436&config=del_186&callback=Ya[1520110801897]', 'rtb_imp_id': '7', 'awapsid': '5d72fdb4b2d10772', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086449428929761', 'referer': 'https://auto.ru/cars/used/sale/dodge/caravan/1070808605-1f3cc3/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '0', 'tskv_format': 'awaps-log', 'geo_zone': '213', 'user_regular_location_txt': '[[55.602848;37.593283]]', 'ip_number': '-546511867', 'rtb_slice_id': '0', 'rtb_user_id': '6733723345408296818', 'ua_browser_name_nmb': '4', 'mime_type': '0', 'yandexuid': '3706825451506334404', 'rtb_site_id': '148440', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520114700/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.186 Safari/537.36', 'lon': '37.59336000', 'user_id_type': '2', 'ipv6': '::ffff:5.228.108.223', 'unixtime': '1520110800', 'sd_app_hashes': '12427356,14938493,71079357,215978082,232948197,242218070,270916051,281652629,525700451,531273730,554812833,558213177,570392451,605371663,632824516,692920334,724757188,745351606,777743333,796097128,845282112,853844669,942804783,1307250636,1313756684,1341744642,1366762641,1448028013,1554321029,1668125310,1702265575,1718585212,1803411425,1808036939,1852765470,1910054079,1953301021,1969428879,2018383299,2047317490,2047593510,2070207248,2072947012,2085219943,2090130729,2194338079,2213758016,2252299850,2270699816,2307066304,2353107453,2377075764,2393778273,2433376779,2440523967,2448498603,2496896777,2567412768,2631029850,2669044287,2730088717,2878699766,2886741245,2911149398,2926080368,2952987727,2961620339,3018457173,3067080143,3084328649,3101346567,3105689792,3105796105,3150602779,3279186847,3309273458,3330077344,3356119129,3381249149,3416741637,3469171283,3564549875,3612505383,3616654217,3668429583,3713566355,3838078041,3910820935,3922969145,3986520368,3994884419,4149149957,4208980957,4241264962,4265920265', 'sd_age_25': '100', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '24217', 'unitnmb': '910625707', 'user_regular_location': 'ISRSQBZoR54=', 'source_uri': 'prt://crypta-awaps@MINILOGS26.ld.yandex.ru/crypta_export/crypta0.txt', 'sd_income_c': '0', 'lat': '55.60284000', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '1271', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341469', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3320811', 'global_request_id': '3781474765970212512', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14WcF9eFxBfXhdgX14YEF9eGkBfXhqQX14aoF9eGsBfXhtAX14bYF9eG5BfXhwgX14ccF9eHIBfXhygX14c0F9eHOBfXh0QX14dMF9eHUBfXh1QX14dkF9eHeBfXh5AX14egF9eITBfXiKAX14jcF9eI8BfXiPQX14j4F9eJABfXiRgX14kcF9eJeBfXipQX14r0F9eLyBfXi8wX14w8F9eMVBfXjHQX14yEF9eMlBfXjKgX14ywF9eMtBfXjLgX14zAF9eNK', 'sectionid': '21621', 'rtb_reserve_price': '621', 'width': '240'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '0', 'ua_os_family_nmb': '14', 'rtb_deal_nmb': '0', 'userid': '7598197945515486751', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '20', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Unknown&DeviceModel=SM-J320F&DeviceName=Galaxy J3&DeviceVendor=samsung&OSFamily=android&OSName=Android Lollipop&OSVersion=5.1.1&isMobile=true&isTouch=true&accept-language=ru_ru&&ref=del_41&android_id=8e97143f6f19d60b&carrier=MegaFon&charset=UTF-8&device_type=4&dnt=0&height=360&id=9&environment=4&locale=ru_RU&manufacturer=samsung&mcc=250&mnc=2&carrier=MegaFon&type=5&devicetype=4&ifa=3c04c830-4c50-4d94-a0be-2efcb18d2766&language=ru_RU&make=samsung&model=SM-J320F&orientation=1&os=android&osv=5.1.1&model=SM-J320F&type=5&orientation=1&os_name=android&os_version=5.1.1&setuniq=1&height=720&width=1280&uuid=676c039a894246c0ac26c34db2b8d18b&width=640', 'rtb_imp_id': '9', 'awapsid': '697238c6438dae1f', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086384718944257', 'referer': 'http://com.game.office_rush.google/nanpu/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '0', 'tskv_format': 'awaps-log', 'geo_zone': '225', 'user_regular_location_txt': '', 'ip_number': '-758928708', 'rtb_slice_id': '0', 'rtb_user_id': '7598197945515486751', 'ua_browser_name_nmb': '5', 'mime_type': '0', 'yandexuid': '6244303261518388248', 'rtb_site_id': '244799', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'com.yandex.mobile.metrica.ads.sdk/2.50.18(Samsung SM-J320F; Android 5.1.1)', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:188.170.195.210', 'unixtime': '1520110800', 'sd_app_hashes': '71079357,232948197,243592565,472381211,525700451,558213177,605371663,692920334,724757188,745351606,863871130,942804783,1014837418,1341744642,1448028013,1554321029,1656241795,1718585212,1803411425,1808036939,1953301021,2047317490,2047593510,2063309954,2070207248,2072947012,2085219943,2194338079,2220829740,2353107453,2448498603,2669044287,2861126552,2878699766,2886741245,2952987727,3105689792,3150602779,3356119129,3416741637,3564549875,3713566355,3910820935,3994884419,4125587519,4126589341,4208980957,4241264962,4265920265', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '105495', 'unitnmb': '910625720', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS39.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341332', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474759922222752', 'sd_age_18': '0', 'user_search_cats': '', 'sectionid': '45298', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1219558', 'actionid': '11', 'sd_gender_m': '100', 'ua_os_family_nmb': '14', 'rtb_deal_nmb': '0', 'userid': '8446589995513185581', 'sd_age_35': '0', 'height': '250', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '48', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=ChromeMobile&BrowserVersion=64.0.3282&DeviceModel=F3311&DeviceName=F3311&DeviceVendor=Sony&OSFamily=Android&OSName=Android Marshmallow&OSVersion=6.0&isMobile=true&isTablet=false&isTouch=true&accept-language=ru-ru&lat=55.202231&lon=30.245746&&id=10&charset=UTF-8&ref=del_76&id=1000&id=7492241520110799992&bid=&dl=https://www.vokrug.tv/person/show/pavel_chinaryv/&extid_loader=MTUyMDExMDMxOTY5NzU5MDEyNA==&extid_tag_loader=www.vokrug.tv&grab=del_202&isTurbo=0&config=del_166&p1=bxmgs&p2=fqhj&pd=4&pdh=640&pdw=360&pr=1724751896&pr1=4098071600&pv=0&pw=0&token=&utf8=?&ybv=0.668&ylv=0.668&ytt=5&adfox_info=0;auction,media;0;2fDFHg8AAADQDJtaILVdeFBY_URdym_v', 'rtb_imp_id': '10', 'awapsid': '753850d955ee852d', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086468574359537', 'referer': 'https://www.vokrug.tv/person/show/pavel_chinaryv/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '0', 'tskv_format': 'awaps-log', 'geo_zone': '154', 'user_regular_location_txt': '[[55.201563;30.245935];[55.202491;30.248177];[55.20179;30.247907]]', 'ip_number': '249376351', 'rtb_slice_id': '0', 'rtb_user_id': '8446589995513185581', 'ua_browser_name_nmb': '23', 'mime_type': '0', 'yandexuid': '8446589991513185581', 'rtb_site_id': '243954', 'sd_user_events': '6369:1519592243,6372:1519592243,6373:1519592243', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Linux; Android 6.0; F3311 Build/37.0.A.2.248) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.137 Mobile Safari/537.36', 'lon': '30.24575000', 'user_id_type': '2', 'ipv6': '::ffff:95.46.221.14', 'unixtime': '1520110800', 'sd_app_hashes': '113183018,139678807,243592565,275303889,323666831,371581988,455654347,472381211,496556224,558213177,570392451,630848966,692920334,724757188,786909141,858175948,896748342,939065601,939649949,942804783,1026277719,1041476103,1061292064,1120381913,1152292407,1194431300,1227332918,1263223487,1316160862,1336551005,1388378544,1450294262,1791696249,1803411425,1808036939,1811705231,1963278468,2009601130,2047593510,2074430250,2120744166,2213758016,2252299850,2317411838,2332408735,2448498603,2520288831,2609050863,2669044287,2685104135,2700251001,2727119249,2795029408,2813704846,2864836101,2952987727,3115370977,3120311309,3220070798,3356119129,3361827647,3402204678,3435599545,3472521067,3585734715,3708367349,3751768098,3910820935,3935675784,3971186132,3994884419,3999252693,4002108050,4031373429,4072740219,4086325378,4223906685', 'sd_age_25': '100', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '111659', 'unitnmb': '910625718', 'user_regular_location': 'IOcXDhIHKdYg5ztOEgeBaiDnH+wSB3be', 'source_uri': 'prt://crypta-awaps@MINILOGS37.ld.yandex.ru/crypta_export/crypta1.txt', 'sd_income_c': '0', 'lat': '55.20223000', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '792', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '0', 'uniq_nmb': '37829341462', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3344014', 'global_request_id': '3781474765886129824', 'sd_age_18': '0', 'user_search_cats': 'BfXhbwX14X0F9eGOBfXhpwX14eEF9eHiBfXh6wX14igF9eI3BfXirgX14u8F9eMOBfXjDwX14xIF9eMVBfXjGAX14xwF9eMkBfXjLAX14zAF9eNV', 'sectionid': '9090', 'rtb_reserve_price': '100', 'width': '300'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '100', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '8644407775449106840', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '100', 'parameterstr': 'BrowserName=Firefox&BrowserVersion=58.0&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru-ru&&id=157&charset=UTF-8&id=1000&id=8928721520110323672&bid=NzQwNjA5PS0x&csl=brksj&dl=https://mirtesen.ru/pad/43386283214?from=mail&dsend=1520104146&utm_campaign=daily_more&utm_medium=email&utm_source=mirtesen&extid_loader=MTUwNjgwODY2OTEwMTQ2NDg2MDE=&extid_tag_loader=mirtesen.ru&grab=del_1406&isTurbo=0&config=del_172&lvlfrom=20&p1=bzmpc&p2=fpde&pd=4&pdh=1080&pdw=1920&pr=753226636&pr1=1888517694&pv=6&pw=0&rqs=-P0gHAsAAACADJtaWy3wnPOtwJD1A9MA&token=&usgn=AVIfHqNd5EeeKbquaF5nBlQW4RoD4UI5sI3jqpJcber1&utf8=?&ybv=0.668&ylv=0.668&ytt=5&adfox_info=0;auction,media;0;-P0gHAsAAACADJtaWy3wnPOtwJD1A9MA', 'rtb_imp_id': '157', 'awapsid': '77f71b125d44c998', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086387266983967', 'referer': 'https://mirtesen.ru/pad/43386283214', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '347', 'tskv_format': 'awaps-log', 'geo_zone': '11409', 'user_regular_location_txt': '[[43.166676;131.938068];[43.154829;131.925583];[43.165278;131.937962]]', 'ip_number': '-968321319', 'rtb_slice_id': '0', 'rtb_user_id': '8644407775449106840', 'ua_browser_name_nmb': '2', 'mime_type': '0', 'yandexuid': '4162988691506765903', 'rtb_site_id': '91685', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; rv:58.0) Gecko/20100101 Firefox/58.0', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:217.150.72.198', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '142705', 'unitnmb': '910625716', 'user_regular_location': 'Gbq2SE6kJsgZuOeCTqI/Fhm6f6xOpCKk', 'source_uri': 'prt://crypta-awaps@MINILOGS35.ld.yandex.ru/crypta_export/crypta2.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341338', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474760224605856', 'sd_age_18': '0', 'user_search_cats': 'BfXhfQX14acF9eHhBfXiKAX14jcF9eL1BfXjEQX14xUF9eMYBfXjGwX14x8F9eMkBfXjLAX140g=', 'sectionid': '9090', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '0', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217205', 'actionid': '52', 'sd_gender_m': '100', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '2404719555487282342', 'sd_age_35': '100', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=18.1.1.839&OSFamily=Windows&OSName=Windows 10&OSVersion=10.0&isMobile=false&isTouch=false&accept-language=ru,en;q=0.9&ad=3336600&pl=1217205&sdp_ver=36899940&subsection=0&ad_place=0&from_ssi=1&sel_geo=20010&cryptaid=2404719555487282342&global_id=3781474631912229344&slice_id=0&bid_price=31612&resource_id=120430&r_host_id=10&r_site_id=252720&engc_id=12206&c_id=239205&fint=1209600', 'rtb_imp_id': '', 'awapsid': '215f47b1e94134a6', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971084419067557218', 'referer': 'https://imasdk.tvzavr.ru/js/core/bridge3.192.0_ru.html', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '0', 'tskv_format': 'awaps-log', 'geo_zone': '20010', 'user_regular_location_txt': '[[54.037916;44.92838];[54.036287;44.929557];[54.03847;44.931373]]', 'ip_number': '198603952', 'rtb_slice_id': '0', 'rtb_user_id': '', 'ua_browser_name_nmb': '16', 'mime_type': '1', 'yandexuid': '2752160291487529092', 'rtb_site_id': '', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.1.839 Yowser/2.5 Safari/537.36', 'lon': '44.92806000', 'user_id_type': '2', 'ipv6': '::ffff:176.116.214.11', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '120430', 'unitnmb': '910625721', 'user_regular_location': 'IDWIGBrHhtggNUh2Gse00iA1nbwax/vC', 'source_uri': 'prt://crypta-awaps@MINILOGS40.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '100', 'lat': '54.03752000', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '31612', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341464', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3336600', 'global_request_id': '3781474631912229344', 'sd_age_18': '0', 'user_search_cats': '', 'sectionid': '45586', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '100', 'ua_os_family_nmb': '14', 'rtb_deal_nmb': '0', 'userid': '1664486193396729209', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '20', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=AndroidBrowser&BrowserVersion=4.1.2&DeviceModel=GT-N8000&DeviceName=Galaxy Note 10.1&DeviceVendor=SAMSUNG&OSFamily=Android&OSName=Android Jelly Bean&OSVersion=4.1.2&isMobile=true&isTablet=true&isTouch=true&accept-language=bg-bg&&ref=del_55&charset=utf-8&duid=MTQ3NzM1NDQwODIyNDQ3NTQzNA==&id=7&id=1&highlight=1&tag=37387690311682&id=4913121520110790133&version=4164&ver=0&width=240&grab=del_1844&config=del_184&callback=Ya[1520110798137]', 'rtb_imp_id': '7', 'awapsid': '1719715fc2f44579', 'sd_age_45_55': '100', 'subkey': '', 'rtb_request_id': '971086368551480835', 'referer': 'https://vz.ru/news/2018/3/3/910947.html', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '0', 'tskv_format': 'awaps-log', 'geo_zone': '115', 'user_regular_location_txt': '', 'ip_number': '-707850977', 'rtb_slice_id': '0', 'rtb_user_id': '1664486193396729209', 'ua_browser_name_nmb': '13', 'mime_type': '0', 'yandexuid': '1664486191396729209', 'rtb_site_id': '245341', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520114700/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Linux; U; Android 4.1.2; bg-bg; GT-N8000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Safari/534.30', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:31.13.207.213', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '118123', 'unitnmb': '910625707', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS26.ld.yandex.ru/crypta_export/crypta0.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '1', 'uniq_nmb': '37829341324', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474759502202528', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14YEF9eGkBfXhrAX14b0F9eHIBfXhzQX14hgF9eIlBfXiXgX14uEF9eMRBfXjGwX14yQF9eMnBfXjKgX14y0F9eMuBfXjMA==', 'sectionid': '9090', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '9', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '4308643833520106174', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=18.1.1.839&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru&&ref=del_387&ref=del_403&charset=utf-8&duid=MTUyMDEwOTk2NTY2ODU3OTYyMQ==&id=4&highlight=1&tag=38487201939554&id=4103161520110299347&version=4166&ver=0&token=yabs.MzM2ODgyODY2MzM5MDkyOQo0MzQxOTk1NjAz&awaps_section=29337&ascii=HYUNDAI|MEDIUM&mark=HYUNDAI&segment=MEDIUM&pageNumber=18&grab=del_312&config=del_184&callback=Ya[1520110798362]', 'rtb_imp_id': '4', 'awapsid': '3bcb60bd08a4aabe', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086419196131154', 'referer': 'https://auto.ru/moskovskaya_oblast/cars/hyundai/sonata/all/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '155', 'tskv_format': 'awaps-log', 'geo_zone': '2', 'user_regular_location_txt': '', 'ip_number': '1922843353', 'rtb_slice_id': '0', 'rtb_user_id': '4308643833520106174', 'ua_browser_name_nmb': '16', 'mime_type': '0', 'yandexuid': '4308643831520106174', 'rtb_site_id': '148422', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.1.839 Yowser/2.5 Safari/537.36', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:217.66.156.114', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '27066', 'unitnmb': '910625720', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS39.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341386', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474762173580960', 'sd_age_18': '0', 'user_search_cats': 'BfXhZwX14Y8F9eHKBfXh7AX14gAF9eIEBfXiPAX14j0F9eJwBfXjHAX14yIF9eMlBfXjLgX14zc=', 'sectionid': '0', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1208924', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '14', 'rtb_deal_nmb': '0', 'userid': '5720030715515439940', 'sd_age_35': '100', 'height': '50', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '225', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Unknown&DeviceModel=Redmi+4X&DeviceVendor=Xiaomi&OSFamily=android&OSName=Android Nougat&OSVersion=7.1.2&isMobile=true&isTouch=true&accept-language=ru_ru&&ref=del_44&carrier=MTS+RUS&charset=UTF-8&device_type=4&dnt=0&height=50&id=4&environment=4&locale=ru_RU&manufacturer=Xiaomi&mcc=250&mnc=1&carrier=MTS+RUS&type=2&devicetype=4&ifa=bae0c56a-ba28-4129-bae5-0e7564fb5419&language=ru_RU&make=Xiaomi&model=Redmi+4X&orientation=0&os=android&osv=7.1.2&model=Redmi+4X&type=2&orientation=0&os_name=android&os_version=7.1.2&setuniq=1&height=640&width=360&token=yabs.MzI2NDM4OTYwMA==&uuid=0d2bbd8e10eb37d7485ede8aeed977cf&width=320', 'rtb_imp_id': '4', 'awapsid': '4f61a1a1369f0b44', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086458325054820', 'referer': 'http://com.merigotech.fillwordsthemes/nanpu/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '77', 'tskv_format': 'awaps-log', 'geo_zone': '213', 'user_regular_location_txt': '[[55.739877;37.768268]]', 'ip_number': '-852296595', 'rtb_slice_id': '0', 'rtb_user_id': '5720030715515439940', 'ua_browser_name_nmb': '5', 'mime_type': '0', 'yandexuid': '2267493391516552876', 'rtb_site_id': '247930', 'sd_user_events': '6369:1520018886,6372:1520018886,6373:1520018886', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'com.yandex.mobile.metrica.ads.sdk/2.61.9999(Xiaomi Redmi 4X; Android 7.1.2)', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:109.252.50.205', 'unixtime': '1520110800', 'sd_app_hashes': '14938493,129216775,266335242,278997933,293943771,311782531,377782831,404536741,431733902,460115031,472381211,558213177,570392451,679621180,688302987,690301532,692920334,724757188,845769836,858175948,873641472,875155252,912868405,942804783,1166851452,1228887226,1235034899,1289641192,1298848856,1430875870,1452576730,1458557607,1526168591,1554321029,1661642138,1724752960,1803411425,1808036939,1945055233,2047593510,2085219943,2090130729,2157114697,2174498669,2252299850,2278854939,2341148923,2395052192,2436438197,2448498603,2616456277,2622807395,2669044287,2669376545,2680783075,2826212303,2892337202,3031721059,3058984062,3064457898,3111775127,3120311309,3180184195,3271406603,3333299616,3356119129,3390703889,3431932575,3468813673,3473814298,3527343333,3668429583,3691696237,3758775996,3767604742,3910820935,3933092124,3994884419,4177537880,4208980957,4215818591', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '111559', 'unitnmb': '910625716', 'user_regular_location': 'ITk68haC+vg=', 'source_uri': 'prt://crypta-awaps@MINILOGS35.ld.yandex.ru/crypta_export/crypta2.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '609', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341443', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '3240527', 'global_request_id': '3781474764945229472', 'sd_age_18': '0', 'user_search_cats': 'BfXheAX14foF9eI3BfXjEQX14xMF9eMs', 'sectionid': '45298', 'rtb_reserve_price': '100', 'width': '320'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '0', 'ua_os_family_nmb': '14', 'rtb_deal_nmb': '0', 'userid': '3918954240516017639', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '182', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Unknown&DeviceModel=P01Y&DeviceVendor=asus&OSFamily=android&OSName=Android Lollipop&OSVersion=5.0.2&isMobile=true&isTouch=true&accept-language=ru_ru&&ref=del_30&charset=UTF-8&device_type=5&dnt=0&height=976&id=11&environment=4&locale=ru_RU&manufacturer=asus&type=2&devicetype=5&ifa=35285b5d-ef6f-4f60-8ab4-557ab958c655&language=ru_RU&make=asus&model=P01Y&orientation=0&os=android&osv=5.0.2&model=P01Y&type=2&orientation=0&os_name=android&os_version=5.0.2&setuniq=1&height=976&width=600&uuid=ffbecefd41217cccf5f4b760e01fa3dd&width=600', 'rtb_imp_id': '11', 'awapsid': '3662ec1e44f7cde7', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086409521442487', 'referer': 'http://com.nektome.talk/nanpu/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '0', 'tskv_format': 'awaps-log', 'geo_zone': '2', 'user_regular_location_txt': '', 'ip_number': '1117536985', 'rtb_slice_id': '0', 'rtb_user_id': '3918954240516017639', 'ua_browser_name_nmb': '5', 'mime_type': '0', 'yandexuid': '1965392241516017701', 'rtb_site_id': '177433', 'sd_user_events': '6369:1519680058,6372:1519680058,6373:1519680058,6378:1519680058', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'com.yandex.mobile.metrica.ads.sdk/2.50.18(Asus P01Y; Android 5.0.2)', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:217.66.156.66', 'unixtime': '1520110800', 'sd_app_hashes': '239104838,243592565,342690611,460115031,472381211,558213177,573709868,919839371,942804783,1289191926,2047593510,2063309954,2090130729,2120744166,2151719452,2448498603,2508586408,2669044287', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '35245', 'unitnmb': '910625721', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS40.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341383', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474762089432736', 'sd_age_18': '0', 'user_search_cats': '', 'sectionid': '45298', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '2', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '1676769673520016218', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Chrome&BrowserVersion=64.0.3282.186&OSFamily=Windows&OSName=Windows 10&OSVersion=10.0&isMobile=false&isTouch=false&accept-language=ru-ru&lat=60.012540&lon=30.361361&&id=104&charset=UTF-8&ref=del_30&id=1000&floor=39&units=1&cur=rub&id=578641520110798595&bid=&dl=https://www.drive2.ru/r/lada/459292671152801432/&extid_loader=MTUyMDA4OTI1MDEwNjE1MTYxMzM=&extid_tag_loader=www.drive2.ru&grab=del_130&isTurbo=0&config=del_167&p2=emuv&pd=3&pdh=768&pdw=1366&pp=g&pr=4131929109&pr1=3398925080&ps=nkx&puid11=notbranded&puid2=lada&puid3=largus_cross&puid4=largus_cross&puid5=guest&pv=23&pw=6&token=&utf8=?&ybv=0.668&ylv=0.668&ytt=5&adfox_info=1;auction,media;0;t4QpGBEAAADQDJtaqu4Ihu81YSFdcXjy&id=39000', 'rtb_imp_id': '104', 'awapsid': '17451522584eeb5a', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086371454197169', 'referer': 'https://www.drive2.ru/r/lada/459292671152801432/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '181', 'tskv_format': 'awaps-log', 'geo_zone': '2', 'user_regular_location_txt': '', 'ip_number': '-97762638', 'rtb_slice_id': '0', 'rtb_user_id': '1676769673520016218', 'ua_browser_name_nmb': '4', 'mime_type': '0', 'yandexuid': '1676769671520016218', 'rtb_site_id': '142545', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520114700/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.186 Safari/537.36', 'lon': '30.36136000', 'user_id_type': '2', 'ipv6': '::ffff:178.66.44.250', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '132667', 'unitnmb': '910625707', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS26.ld.yandex.ru/crypta_export/crypta0.txt', 'sd_income_c': '0', 'lat': '60.01254000', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341315', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474759233242784', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14WcF9eFpBfXhcQX14YIF9eGEBfXhhQX14aQF9eGlBfXhqgX14a8F9eG0BfXhvQX14cgF9eHNBfXh0wX14dQF9eHVBfXh3gX14eQF9eHoBfXh7gX14gAF9eICBfXiFAX14iYF9eI+BfXiTAX14nAF9eKCBfXikQX14qUF9eK9BfXi4gX14vMF9eMDBfXjDQX14xAF9eMRBfXjHAX14y4F9eMw', 'sectionid': '46016', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1142982', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '14', 'rtb_deal_nmb': '0', 'userid': '2096042951468613104', 'sd_age_35': '0', 'height': '250', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '20', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=ChromeMobile&BrowserVersion=64.0.3282&DeviceModel=SM-G531H&DeviceName=Galaxy Grand Prime&DeviceVendor=SAMSUNG&OSFamily=Android&OSName=Android Lollipop&OSVersion=5.1.1&isMobile=true&isTablet=false&isTouch=true&accept-language=ru-ru&&id=12&charset=UTF-8&ref=del_156&id=1000&id=4793161520110891698&bid=&dl=https://russian.rt.com/russia/news/488358-utechka-vooruzhenie-2007-ssha?utm_medium=referral&utm_source=lentainform&utm_campaign=russian.rt.com&utm_term=1259974&utm_content=1&extid_loader=YW1wLVI5X1lySThqRExndUV6YzNnUFhOQ0E=&extid_tag_loader=russian.rt.com&grab=del_444&isTurbo=0&config=del_167&p1=bxrfk&p2=fqqf&pd=4&pdh=640&pdw=360&pr=2701088006&pr1=2127685714&puid1=russia&pv=2&pw=0&token=&utf8=?&ybv=0.668&ylv=0.668&ytt=5&adfox_info=0;auction,media;0;3-_lEAgAAADQDJtafmwsoxmfcaAfbvGZ', 'rtb_imp_id': '12', 'awapsid': '1d16a3f5843f7df0', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086341851593122', 'referer': 'https://russian.rt.com/russia/news/488358-utechka-vooruzhenie-2007-ssha', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '0', 'tskv_format': 'awaps-log', 'geo_zone': '54', 'user_regular_location_txt': '[[56.794796;60.577343];[56.825804;60.603134];[56.796864;60.583735]]', 'ip_number': '746474368', 'rtb_slice_id': '0', 'rtb_user_id': '2096042951468613104', 'ua_browser_name_nmb': '23', 'mime_type': '0', 'yandexuid': '2096042951468613104', 'rtb_site_id': '188279', 'sd_user_events': '6369:1520047795,6372:1515036708', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Linux; Android 5.1.1; SM-G531H Build/LMY48B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.137 Mobile Safari/537.36', 'lon': '', 'user_id_type': '1', 'ipv6': '::ffff:128.75.126.44', 'unixtime': '1520110800', 'sd_app_hashes': '239104838,241658876,243592565,335636307,342690611,377782831,472381211,558213177,570392451,692920334,798469370,811983716,845769836,942804783,1010466205,1098161166,1289191926,1387042863,1526168591,1554321029,1637049563,1718585212,1808036939,1969428879,2063309954,2085219943,2090130729,2366667574,2411435746,2466814331,2669044287,2712029153,2871465483,3011550350,3035246125,3120311309,3161966845,3271406603,3280826380,3356119129,3381249149,3425458216,3456879374,3787975064,3910820935,4208980957,4219807213,4275428850', 'sd_age_25': '100', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '100825', 'unitnmb': '910625720', 'user_regular_location': 'IdoyuCQbXnYh3u34JB9N7CHag4AkHFgm', 'source_uri': 'prt://crypta-awaps@MINILOGS39.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '78526', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '0', 'uniq_nmb': '37829341298', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '3251685', 'global_request_id': '3781474758074435232', 'sd_age_18': '0', 'user_search_cats': 'BfXhbAX14XIF9eGPBfXhkAX14ZUF9eGvBfXhswX14dEF9eHiBfXh7gX14gMF9eIEBfXiBgX14icF9eIpBfXiKgX14i4F9eI3BfXiOAX14kEF9eJFBfXiVgX14nsF9eKCBfXihAX14pcF9eKlBfXiugX14uMF9eL4BfXjDQX14w8F9eMRBfXjFQX14xgF9eMZBfXjGwX14xwF9eMdBfXjHgX14yQF9eMlBfXjKAX14ykF9eMsBfXjLwX14zsF9eNH', 'sectionid': '9090', 'rtb_reserve_price': '11414', 'width': '300'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217744', 'actionid': '11', 'sd_gender_m': '100', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '5076532651464310548', 'sd_age_35': '100', 'height': '400', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Opera&BrowserVersion=51.0.2830.40&OSFamily=Windows&OSName=Windows 10&OSVersion=10.0&isMobile=false&isTouch=false&accept-language=ru-ru&&id=67&charset=UTF-8&id=1000&id=3638601520110795551&bid=&csl=brmye&dl=https://pikabu.ru/tag/%D0%BF%D0%BE%D0%BB%D0%B8%D1%82%D0%B8%D0%BA%D0%B0&extid_loader=MTQ2NDMxMDg1NDI2ODAxMzI5OA==&extid_tag_loader=pikabu.ru&grab=del_56&isTurbo=0&config=del_168&lvlfrom=20&p1=bymrl&p2=frtk&pd=4&pdh=1080&pdw=1920&pr=1624818874&pr1=106658585&pv=1&pw=0&rqs=F9_WDQ0AAADODJtak9wza5Ein9LY_7Pi&token=&usgn=AWMoCtDRmn6umctica4g_8O9x6PzXmm8dzwUnxp9cWtP&utf8=?&ybv=0.668&ylv=0.668&ytt=37&adfox_info=0;auction,media;0;F9_WDQ0AAADODJtak9wza5Ein9LY_7Pi', 'rtb_imp_id': '67', 'awapsid': '4673778cc533bf14', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086248469875032', 'referer': 'https://pikabu.ru/tag/043F043E043B043804420438043A0430', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '370', 'tskv_format': 'awaps-log', 'geo_zone': '52', 'user_regular_location_txt': '[[55.676291;37.559805];[55.78852;37.581207];[55.758165;37.598718]]', 'ip_number': '-1643017131', 'rtb_slice_id': '0', 'rtb_user_id': '5076532651464310548', 'ua_browser_name_nmb': '9', 'mime_type': '0', 'yandexuid': '5076532651464310548', 'rtb_site_id': '56459', 'sd_user_events': '6373:1519376394', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.168 Safari/537.36 OPR/51.0.2830.40', 'lon': '', 'user_id_type': '1', 'ipv6': '::ffff:85.140.17.158', 'unixtime': '1520110800', 'sd_app_hashes': '14938493,105190406,157669898,220845946,290910773,309671765,377782831,558213177,570392451,669280361,692920334,785980639,858175948,914222455,960678886,965484406,1014530974,1166851452,1353191516,1481439083,1554321029,1566713464,1652655284,1808036939,1813876334,1953301021,2090130729,2120744166,2270566096,2297496320,2361511346,2420266356,2526902517,2661982717,2669044287,2704794545,3081046880,3167591177,3271406603,3356119129,3381249149,3405541329,3688190657,3734020997,3841457756,4013314681,4126316811,4208980957,4281656027', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '143278', 'unitnmb': '910625716', 'user_regular_location': 'IS+HHhZjK+IhQKcQFmZv5iE8BVIWaRvs', 'source_uri': 'prt://crypta-awaps@MINILOGS35.ld.yandex.ru/crypta_export/crypta2.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '978', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341191', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3325832', 'global_request_id': '3781474752397444768', 'sd_age_18': '0', 'user_search_cats': 'BfXhcQX14XQF9eF2BfXhewX14aEF9eGoBfXhqQX14aoF9eG1BfXhtgX14dEF9eIoBfXiKgX14jIF9eI3BfXiSgX14l4F9eJkBfXimQX14qUF9eKwBfXivwX14u8F9eLyBfXi8wX14vUF9eMRBfXjFQX14xYF9eMXBfXjGwX14x0F9eMeBfXjHwX14yEF9eMkBfXjJgX14ywF9eMtBfXjMAX140o=', 'sectionid': '9090', 'rtb_reserve_price': '100', 'width': '240'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '100', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '0', 'ua_os_family_nmb': '14', 'rtb_deal_nmb': '0', 'userid': '7405001805512756993', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '130', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Unknown&DeviceModel=ZTE+BLADE+A610&DeviceVendor=ZTE&OSFamily=android&OSName=Android Marshmallow&OSVersion=6.0&isMobile=true&isTouch=true&accept-language=ru_ru&&ref=del_27&carrier=MTS+RUS&charset=UTF-8&device_type=4&dnt=0&height=50&id=1&environment=4&locale=ru_RU&manufacturer=ZTE&mcc=250&mnc=1&carrier=MTS+RUS&type=2&devicetype=4&ifa=547fcbb4-729a-4158-9206-c9c00dd322a6&language=ru_RU&make=ZTE&model=ZTE+BLADE+A610&orientation=0&os=android&osv=6.0&model=ZTE+BLADE+A610&type=2&orientation=0&os_name=android&os_version=6.0&setuniq=1&height=640&width=360&token=yabs.NDQyODEyOTM2Nw==&uuid=807d8781c1677be4489584ce70568d0c&width=320', 'rtb_imp_id': '1', 'awapsid': '66c3d9e8a2b6cf01', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086356926182106', 'referer': 'http://com.perm.kate/nanpu/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '0', 'tskv_format': 'awaps-log', 'geo_zone': '10650', 'user_regular_location_txt': '[[53.618311;34.344072]]', 'ip_number': '297567263', 'rtb_slice_id': '0', 'rtb_user_id': '7405001805512756993', 'ua_browser_name_nmb': '5', 'mime_type': '0', 'yandexuid': '3822138461514789148', 'rtb_site_id': '138230', 'sd_user_events': '6369:1519838183,6372:1519838183,6373:1519838183', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'com.yandex.mobile.metrica.ads.sdk/2.61.9999(Zte blade a610; Android 6.0)', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:31.132.188.17', 'unixtime': '1520110800', 'sd_app_hashes': '41384594,116259747,243592565,287154739,293943771,305056681,342690611,351595249,377782831,396262517,455642752,460115031,460216693,472381211,493892845,524008360,558213177,570392451,692920334,724757188,766918275,845769836,855735698,858175948,942804783,1050022651,1075604059,1227332918,1289191926,1298400488,1407310597,1439846960,1452576730,1507028958,1526168591,1554321029,1808036939,1813876334,1839605534,1863417366,1937097396,1991085549,2015180349,2052540972,2085219943,2090130729,2119271394,2120744166,2367593590,2448498603,2466814331,2484904043,2499572727,2669044287,2720470061,2887587839,2914670156,2952987727,3071176582,3093886724,3120311309,3161966845,3206641823,3260245340,3267713479,3271406603,3356119129,3494708052,3621109805,3690364361,3751041160,3887639901,3910820935,3994884419,4177537880,4208980957,4253835729,4286330235', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '5831', 'unitnmb': '910625721', 'user_regular_location': 'H/WBRhR4fVA=', 'source_uri': 'prt://crypta-awaps@MINILOGS40.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '100', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341302', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474758427018912', 'sd_age_18': '0', 'user_search_cats': 'BfXhdgX14XcF9eGpBfXh+gX14igF9eI3BfXjEAX14xEF9eMgBfXjIQX14yMF9eMs', 'sectionid': '45298', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '2', 'sd_is_full': '1', 'sd_age_0': '100', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '9513147123506678174', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Edge&BrowserVersion=16.16299&OSFamily=Windows&OSName=Windows 10&OSVersion=10.0&isMobile=false&isTouch=false&accept-language=ru-ru&&ref=del_261&charset=utf-8&duid=MTUwNjcwNzQ1MzI0MTY4Njg3Mw==&id=4&highlight=1&tag=37387690311714&id=5045861520108315389&version=4164&ver=0&token=awaps.MjQxMTMxOw==:yabs.NTExNTkwMzQ5NQo0MzExNzY2NjQ0CjQ5ODIyNjgzODgKNDY4MzIxNjk5MQ==&awaps_section=29337&ascii=NISSAN|MEDIUM&mark=NISSAN&segment=MEDIUM&pageNumber=80&grab=del_376&config=del_191&callback=Ya[1520110830843]', 'rtb_imp_id': '4', 'awapsid': '84057ce7f0a5099e', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086444328655101', 'referer': 'https://auto.ru/moskva/cars/nissan/note/used/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '0', 'tskv_format': 'awaps-log', 'geo_zone': '213', 'user_regular_location_txt': '', 'ip_number': '1012268141', 'rtb_slice_id': '0', 'rtb_user_id': '9513147123506678174', 'ua_browser_name_nmb': '92449', 'mime_type': '0', 'yandexuid': '9513147121506678174', 'rtb_site_id': '148422', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36 Edge/16.16299', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:109.252.85.60', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '15175', 'unitnmb': '910625720', 'user_regular_location': '', 'source_uri': 'prt://crypta-awaps@MINILOGS39.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341418', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474763802936992', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14WcF9eGFBfXhpAX14a8F9eG0BfXhvQX14cIF9eHIBfXhygX14c0F9eHTBfXh1QX14eQF9eHoBfXiAAX14j4F9eJwBfXivAX14yIF9eMkBfXjLgX14zAF9eM3', 'sectionid': '29302', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217295', 'actionid': '11', 'sd_gender_m': '100', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '768735555379485334', 'sd_age_35': '0', 'height': '600', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=18.1.1.839&OSFamily=Windows&OSName=Windows 10&OSVersion=10.0&isMobile=false&isTouch=false&accept-language=ru&lat=55.764747&lon=37.737159&&adb_enabled=1&setuniq=1&ref=del_82&ref=del_284&charset=utf-8&duid=MTUxOTQ5NjkzODEyNjU5NjE0Mg==&id=7&id=1999999&highlight=1&tag=604185934430223&id=7486971520099402672&version=4171&ver=0&token=awaps.MjM2MjY4OzIzNjc1MzsyMzY4NzM7MjM3MTgzOzIzNzMyNzsyMzc4NTk7MjM4NzM3OzIzODg0NTsyMzg5NDc7MjQwMDMzOzI0MDEyMTsyNDAyMTU7MjQwMzQ1OzI0MDQ5NTsyNDA4OTc7MjQxMDEzOzI0MTEyMTsyMzYyMjQ7:yabs.MjQ3MDUzMzY5Mwo0MDgzNzY1Mzc0CjQxNTIwMzMwNDcKNDk0Mjg5NDkxOQo1NTk3NTI0NDE1CjU3OTI1MTUyMzQKNTc5MjUxNTIzOQo1NzkyNTE1MjQwCjU4MDA1NDA1MjUKNTgwMDU0MDUyNgoyODY2MjgwNTQxNDQ4MDI1NAo1NTk3NTI0NDA2CjU2NDIxOTQxOTQKNTY0MjE5NDE5NQo1NzgwNzU1NDk3CjU3ODA3NTU0OTgKNTc4MDc1NTUwMAo1Nzg4ODMxMDY5CjUxODEwODI3MzYKNTY2OTI0NDU5NQo1NTk3NTI0NDE5CjU1MDQxODQ5MTMKNTc5MjUxNTIzMgo1NzgwNzU1NDk5CjU3ODA3NTU0OTYKNTgwMDU0MDUzMwo1NzkyNTE1MjMzCjU3OTI1MTUyMzEKNTU5NzUyNDQxNwo1NTk3NTI0NDEx&awaps_section=29337&ascii=TOYOTA|PREMIUM&mark=TOYOTA&segment=PREMIUM&pageNumber=229&grab=del_464&config=del_191&callback=Ya[1520110807678]&tag=partner_tag_name', 'rtb_imp_id': '7', 'awapsid': 'aab18ea289b5a96', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086246605494359', 'referer': 'https://auto.ru/cars/used/sale/toyota/crown/1070122847-9f47da/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '2564', 'tskv_format': 'awaps-log', 'geo_zone': '213', 'user_regular_location_txt': '[[55.764785;37.737362];[55.763272;37.739286];[55.766217;37.738494]]', 'ip_number': '-1914614693', 'rtb_slice_id': '0', 'rtb_user_id': '768735555379485334', 'ua_browser_name_nmb': '16', 'mime_type': '0', 'yandexuid': '1774659471519228620', 'rtb_site_id': '148440', 'sd_user_events': '6369:1517560559,6372:1517560559,6373:1517560559', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.1.839 Yowser/2.5 Safari/537.36', 'lon': '37.73716000', 'user_id_type': '2', 'ipv6': '::ffff:91.76.225.141', 'unixtime': '1520110800', 'sd_app_hashes': '19082874,341803691,342690611,558213177,564584352,570392451,573709868,596908349,610151200,692920334,724757188,826725733,834707383,862925963,865615120,942804783,1052389471,1249264474,1279890116,1285753658,1300439117,1431589663,1433036159,1439724379,1491176382,1551058083,1637987910,1678987599,1689221679,1777464787,1803411425,1808036939,1811040625,1813060977,1953301021,2037354623,2047593510,2090130729,2120744166,2131836205,2151719452,2174353977,2213758016,2309762327,2353107453,2377075764,2405834741,2448498603,2569041347,2665531733,2669044287,2842786960,2938980783,2952987727,3072910651,3154030111,3271368062,3282602859,3356119129,3381249149,3413127393,3446011464,3525089221,3535587999,3596283896,3653721913,3668429583,3690966871,3795412885,3824913319,3910820935,4102183050,4138698951,4209339084,4224429994', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '24217', 'unitnmb': '910625716', 'user_regular_location': 'IT0H6hZ+Q7QhPMzQFn6O3CE9P9oWfm/s', 'source_uri': 'prt://crypta-awaps@MINILOGS35.ld.yandex.ru/crypta_export/crypta2.txt', 'sd_income_c': '0', 'lat': '55.76475000', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '1271', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341183', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '3320842', 'global_request_id': '3781474751910250144', 'sd_age_18': '100', 'user_search_cats': 'BfXhZQX14WYF9eFnBfXhcQX14Y8F9eGkBfXhqgX14a8F9eG2BfXhuAX14bkF9eG/BfXhwQX14cIF9eHIBfXhygX14c0F9eHOBfXh0QX14dMF9eHUBfXh1QX14d4F9eHqBfXh7gX14gAF9eIWBfXiGAX14jcF9eI4BfXiPAX14j0F9eI/BfXiTAX14mkF9eJwBfXipQX14rwF9eK9BfXivwX14tsF9eLyBfXi8wX14xIF9eMVBfXjGwX14xwF9eMdBfXjJQX14ycF9eMsBfXjLgX14zAF9eNEBfXjSg==', 'sectionid': '21621', 'rtb_reserve_price': '100', 'width': '160'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '2', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '583851855448863793', 'sd_age_35': '100', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Chrome&BrowserVersion=64.0.3282.186&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru-ru&lat=60.051572&lon=30.420015&&ref=del_622&ref=del_104&charset=utf-8&duid=MTUwOTcyMjExOTc2ODgzMTQyMA==&id=4&highlight=1&tag=38487201939567&id=6702361520103240540&version=4166&ver=0&token=awaps.MjM0NjI0OzIzODg1Nzs=:yabs.Mjc5MzEwMTI4Ngo1NjY5MzEyOTk1Cjg4ODgxNzg5OTEwMjI2MzYKNTc5ODU0MTA5Ngo1Nzk0NTM5NjMwNzAyOTIyNgo1NTY3OTM4MjQ5CjU1MDc1NDA3ODkKNTQ4Mjk1ODg1Mgo1NDQ2OTM5NTMzCjU0NDA0MTU5NTEKNTQzNDQ0MTI5NAo1Mzg4NjkzMDUwCjUzODgzODI4MTQKNTM4ODM4MjgxMwo1Mzg4MzgyODA5CjUzMDI1Mzc4OTYKNTMwMjM4NjEyMAo1MzAyMzY1NTM1CjUyOTUxODgzNzMKNTI1NTM5NjE4NAo1MjU1Mzk2MTc1CjUyNTUyMDQ3MDAKNTI1NDM5MzUxMAo1MjU0MzkzNTA5CjUyMTU2MDk2MzYKNTE4Mzk0ODQ1Ngo1MTgzNzc2NDM5CjUxMzI2MDMxNjcKNTEzMjYwMjE1NAo1MTMyNjAxNTQzCjUxMzI1OTg5NzEKNTEzMjU5NjQ5NAo1MTMxNjczMjk0CjUxMzE2NzMwMjQKNTEzMTY3MjU2NQo1MTMxNjcyMzAxCjUxMzE2Njk5MjMKNTEzMTY2NzQxMQo1MTMxNjY2NjEyCjUxMzE2NjYyMDcKNTEzMTY2NjEzMQo1MTMxNjIwODY1CjUxMzE2MjA3NjUKNTEzMTYyMDY5OAo1MTMxNjE5NTk4CjUxMzE2MTk1OTQKNTEzMTYxODcwMQo1MTMxNjE4MzE4CjUxMzE2MTc1MDEKNTEzMTYxNzMxMwo1MTMxNjE2NzQ3CjUxMzE2MTU4NzMKNTEzMTYxNTQ5OAo1MTMxNjE0ODE3CjUxMzE2MTQxMTEKNTEyODcyNzA2OQo0OTM5NDI3MjkwMDk0MjA5MgoyNDU4NDU3NzQ1Mzk4MTc5MgozNjM5MzUzMzIxMzM1MDgyCjI3MTYzNjA0MDIwMzUxMDUy&awaps_section=29337&ascii=suv|MEDIUM&type=suv&segment=MEDIUM&pageNumber=250&grab=del_308&config=del_185&callback=Ya[1520110805117]', 'rtb_imp_id': '4', 'awapsid': '81a422b4d7b7431', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086433854430667', 'referer': 'https://auto.ru/sankt-peterburg/cars/vendor15/all/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '0', 'tskv_format': 'awaps-log', 'geo_zone': '2', 'user_regular_location_txt': '[[59.879466;30.265974];[59.836936;30.354102];[59.972618;30.438171]]', 'ip_number': '628286396', 'rtb_slice_id': '0', 'rtb_user_id': '583851855448863793', 'ua_browser_name_nmb': '4', 'mime_type': '0', 'yandexuid': '2301596111509386385', 'rtb_site_id': '148422', 'sd_user_events': '6369:1519753526,6372:1519753526,6373:1519753526,6377:1513157646,6381:1519753526', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.186 Safari/537.36', 'lon': '30.42002000', 'user_id_type': '2', 'ipv6': '::ffff:188.227.114.37', 'unixtime': '1520110800', 'sd_app_hashes': '72443828,84782998,109713367,122172628,151631361,169819488,220965583,287154739,323666831,337812129,377782831,460115031,472381211,558213177,568436147,570392451,692920334,705271391,724757188,777394886,845282112,845769836,858175948,942804783,1031134277,1155122338,1227332918,1289191926,1292086536,1331088534,1336551005,1370781831,1388378544,1427999374,1450294262,1472065606,1554321029,1615939507,1651498387,1654814586,1732944090,1791696249,1797236189,1803411425,1806272576,1806953277,1808036939,1953301021,1969428879,1980401680,2009601130,2011538931,2047593510,2085219943,2090130729,2120744166,2213758016,2252299850,2341148923,2366667574,2416122672,2433360745,2448498603,2466814331,2490477568,2497893652,2520288831,2548149270,2609050863,2662451400,2669044287,2700251001,2725407427,2763158710,2795029408,2813704846,2838673173,2861126552,2952987727,3081046880,3120311309,3149012780,3150602779,3161966845,3180184195,3271406603,3301399303,3356119129,3381249149,3402204678,3472521067,3560096218,3565064653,3590725621,3635306286,3664245283,3668429583,3679650631,3790969336,3901030089,3910820935,3971186132,3994884419,4000543321,4002108050,4046758933,4208980957,4223906685,4226121846,4230426703,4278492086', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '15175', 'unitnmb': '910625721', 'user_regular_location': 'I7DhpBIKOJwjqmRQEherHCO/GGQSJH8O', 'source_uri': 'prt://crypta-awaps@MINILOGS40.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '100', 'lat': '60.05157000', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341426', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474764256577184', 'sd_age_18': '0', 'user_search_cats': 'BfXhZQX14WcF9eFyBfXhcwX14XYF9eGkBfXhqQX14bQF9eG2BfXhuAX14bkF9eHCBfXhygX14c4F9eHRBfXh0wX14dUF9eHZBfXh3gX14gAF9eIWBfXiPAX14j0F9eI+BfXiPwX14kAF9eJBBfXiZAX14nAF9eJ5BfXipQX14q8F9eLaBfXi7wX14vAF9eLyBfXjEAX14xUF9eMcBfXjHQX14yEF9eMkBfXjJQX14ysF9eMuBfXjMAX14zQ=', 'sectionid': '29302', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '2', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '100', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '9639132235400607004', 'sd_age_35': '0', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=18.1.1.839&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru&&ref=del_39&ref=del_26&charset=utf-8&duid=MTUwNDk0NjM0MjQyMTk2Nzkz&id=11&id=10000&highlight=1&tag=28043988959330&id=5514411520110559895&version=4147&ver=0&width=276&height=20&uid=579681782&grab=del_72&config=del_188&callback=Ya[1520110810870]', 'rtb_imp_id': '11', 'awapsid': '85c513b2a211f51c', 'sd_age_45_55': '100', 'subkey': '', 'rtb_request_id': '971086216438748739', 'referer': 'https://mail.yandex.ru/', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '1379', 'tskv_format': 'awaps-log', 'geo_zone': '239', 'user_regular_location_txt': '[[43.599663;39.726906];[43.599871;39.721018]]', 'ip_number': '-1412263131', 'rtb_slice_id': '0', 'rtb_user_id': '9639132235400607004', 'ua_browser_name_nmb': '16', 'mime_type': '0', 'yandexuid': '4508197131504946339', 'rtb_site_id': '92550', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.1.839 Yowser/2.5 Safari/537.36', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:37.147.210.171', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '9871', 'unitnmb': '910625720', 'user_regular_location': 'GfzH1het2EQZ/M/2F6zyRA==', 'source_uri': 'prt://crypta-awaps@MINILOGS39.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '100', 'ua_is_tablet': '', 'uniq_nmb': '37829341137', 'actionid_original': '', 'sd_gender_f': '0', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474750095689376', 'sd_age_18': '0', 'user_search_cats': 'BfXhbwX14Y4F9eGPBfXiKAX14ioF9eI3BfXjDwX14xUF9eMcBfXjHgX14ycF9eMs', 'sectionid': '9010', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1', 'actionid': '130', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '3434130035470219572', 'sd_age_35': '100', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Edge&BrowserVersion=16.16299&OSFamily=Windows&OSName=Windows 10&OSVersion=10.0&isMobile=false&isTouch=false&accept-language=ru-ru&&ref=del_81&charset=utf-8&duid=MTQ5OTAyMTk3NDcyNjUyODQwOQ==&id=11&id=10000&highlight=1&tag=39588861050927&id=7642701519935325225&version=4168&ver=0&width=300&height=20&token=awaps.MjA4NDI1OzIxNjg0ODsyMTgwMzg7MjMxNTg0OzIzNDY1ODsyMzY3NTM7MjM3NDg1OzIzNzU2NzsyMzc3MTk7MjM3NzMzOzIzNzc0NTsyMzc4Mjc7MjM4MTg3OzIzODM0MzsyMzg1Mzc7MjM4NzM3OzIzODc2NjsyMzg4MjU7MjM4ODU3OzIzODg5MTsyMzkyNTE7MjM5MjYzOzIzOTQ0OTsyMzk1MDE7MjM5NTA1OzIzOTU0MzsyMzk2Nzc7MjM5NzU5OzIzOTc4NTsyNDAwNjU7MjQwMTA3OzI0MDExNTsyNDAxMjE7MjQwMzQ1OzI0MDM1MTsyNDA1NzM7MjQwOTc5OzI0MTAxMzsyNDEwNDc7MjQxMTM5OzI0MDQ5NTs=:yabs.MjQ5ODg1NTcxMQozMDQ3MDI5MjU0CjM0MTE4OTU1NjEKMzU0MDU1NTE0OAozODcyMzY4NjczCjM4Nzk3MzAxMDcKNTc5NzM0MDgzMwo1ODAwMTczNzc2CjUyMDcwMzg0MDQKNTM5MTEyNDgxMwo1NTIyMTYyNzM4CjU1NjQ0NDQzMjEKNTYzOTg3MjU5Ngo1NzYyMjI2ODkxCjU3Nzk2NjY1NjEKNTc5MjUxNTIzMgo1Nzk2NDEwMjIwCjU3OTczMjU0ODIKNTc3MTY4MzQ4Mgo1Nzc4MTk3MzE3CjU3OTYzODc5MTkKNTAxMzQ5MjMwOQo1MzI5MDYxMzk4CjU3MjQ0NDgyMTYKNTc5MTM5NTA1OAo1NzkyNDYwODM0CjU3OTM4OTEwNTgKNTc5NTE0MTMwNAo1NzYwMjE1ODcwCjU3MDIyNjc1ODAKNTY2MTg0NzU5Nwo1NjUyMzU5MjQzCjU2MjUxNDY3OTQKNTYxNDYwMzQwMgo1NTg1MjkyMTgwCjU1NTA2NTEyNTYKNTI3NTYwOTMwMwo1MDk1MDYzMjUzCjUwNzYzNjM4MDMKNDk0NjA2NzE4OQo1Nzk5NTQ5NTI4CjQ0MDA1MTg5MzgKNDQwMDUxODkzNwo0NDAwNTE4OTM1CjQ0MDA1MTg5MzQKNDQwMDUxODkzMgo0NDAwNTE4OTMxCjQ0MDA1MTg5MjkKNDQwMDUxODkyOAo0NDAwNTE4OTI2CjQ0MDA1MTg5MjMKNDQwMDUxODkyMgo1Nzk5OTE3Nzc3CjU3OTQyOTQxNjEKNTc5MjEwMTk3Mwo1MDg2ODg0NTcy&uid=43162937&grab=del_72&config=del_190&callback=Ya[1520110805378]', 'rtb_imp_id': '11', 'awapsid': '2fa87b128cb3b934', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086267917808988', 'referer': 'https://mail.yandex.ru/', 'sd_income_b': '100', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '3636', 'tskv_format': 'awaps-log', 'geo_zone': '214', 'user_regular_location_txt': '[[55.936405;37.488896];[55.83884;37.536057];[55.933703;37.483146]]', 'ip_number': '-1787476864', 'rtb_slice_id': '0', 'rtb_user_id': '3434130035470219572', 'ua_browser_name_nmb': '92449', 'mime_type': '0', 'yandexuid': '7046194161498985939', 'rtb_site_id': '92550', 'sd_user_events': '6369:1520085096,6372:1520085096,6373:1520085096', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake', 'user_agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36 Edge/16.16299', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:128.68.117.149', 'unixtime': '1520110800', 'sd_app_hashes': '293237581,311782531,431733902,472381211,558213177,570392451,690301532,692920334,724757188,845769836,858175948,873641472,912868405,942804783,991071060,1166851452,1458557607,1554321029,1661642138,1724752960,1803411425,1808036939,1827529369,2030703509,2047593510,2085219943,2090130729,2120744166,2174498669,2278854939,2366667574,2395052192,2448498603,2622807395,2626435875,2669044287,2674136847,2826212303,2892337202,2914670156,2952987727,3018554016,3057752544,3271406603,3356119129,3381249149,3473814298,3524947233,3527343333,3541872594,3668429583,3679870457,3758775996,3767604742,3910820935,3924940922,3951877041,3994884419,4208980957,4215818591', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '9870', 'unitnmb': '910625723', 'user_regular_location': 'IVc30hZYWgAhSFSwFl+MOiFWzkYWV3lk', 'source_uri': 'prt://crypta-awaps@MINILOGS42.ld.yandex.ru/crypta_export/crypta1.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341202', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '0', 'global_request_id': '3781474753069254304', 'sd_age_18': '0', 'user_search_cats': 'BfXhcQX14XYF9eF4BfXhfgX14YAF9eGOBfXhqQX14aoF9eGrBfXiEwX14hgF9eIlBfXiKAX14ioF9eI3BfXiOAX14kwF9eJeBfXiYAX14mkF9eK9BfXi4gX14vMF9eMDBfXjDwX14xAF9eMRBfXjEwX14xUF9eMeBfXjIQX14ycF9eMsBfXjLQX14y4F9eMwBfXjQAX140oF9eNV', 'sectionid': '9054', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '0', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1219162', 'actionid': '15', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '340492105477259532', 'sd_age_35': '100', 'height': '0', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=Opera&BrowserVersion=36.0.2130.80&OSFamily=Windows&OSName=Windows XP&OSVersion=5.1&isMobile=false&isTouch=false&as_json=1&charset=cp-1251', 'rtb_imp_id': '', 'awapsid': '4b9abc413cc010c', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '', 'referer': '', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '265', 'tskv_format': 'awaps-log', 'geo_zone': '22', 'user_regular_location_txt': '[[54.708815;20.570417];[54.694688;20.479793]]', 'ip_number': '479451987', 'rtb_slice_id': '0', 'rtb_user_id': '', 'ua_browser_name_nmb': '9', 'mime_type': '38', 'yandexuid': '2970947091502540953', 'rtb_site_id': '', 'sd_user_events': '', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112300/1520110800', 'fake_field': 'fake     ', 'user_agent': '20955/162/139|17177/0/118|15548', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:83.219.147.28', 'unixtime': '1520110800', 'sd_app_hashes': '', 'sd_age_25': '0', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '0', 'unitnmb': '910625719', 'user_regular_location': 'IJvnFgxCy+ogmb9ADDT36g==', 'source_uri': 'prt://crypta-awaps@MINILOGS38.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '100', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '0', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341361', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '3340100', 'global_request_id': '3781474761299658400', 'sd_age_18': '0', 'user_search_cats': 'BfXhZQX14WYF9eFnBfXhbwX14XEF9eF/BfXhgAX14YEF9eGFBfXhjgX14Y8F9eGQBfXhpAX14aoF9eGrBfXhrAX14a8F9eG2BfXhvwX14cEF9eHCBfXhyAX14c0F9eHOBfXh0QX14dQF9eHVBfXh3gX14eEF9eHuBfXh+wX14gAF9eIWBfXiJAX14igF9eIpBfXiNwX14jgF9eJWBfXicAX14oAF9eKTBfXimgX14qAF9eKlBfXivAX14tMF9eLpBfXi8gX14vMF9eMPBfXjEQX14xIF9eMVBfXjFwX14xwF9eMdBfXjJAX14yUF9eMqBfXjLAX14y4F9eMvBfXjMAX140oF9eNh', 'sectionid': '44196', 'rtb_reserve_price': '0', 'width': '0'})
testdata_awaps_log.add_row(**{'_date': '2016-04-11', 'rtb_host_id': '1', 'sd_is_full': '1', 'sd_age_0': '0', 'predict_data': '', 'placementid': '1217295', 'actionid': '11', 'sd_gender_m': '0', 'ua_os_family_nmb': '3', 'rtb_deal_nmb': '0', 'userid': '6952475855445673202', 'sd_age_35': '0', 'height': '90', 'instime': '2018-03-04 00:08:16', 'subsection': '0', 'ua_device_vendor_nmb': '', 'sd_age_56_plus': '0', 'parameterstr': 'BrowserName=YandexBrowser&BrowserVersion=18.1.1.839&OSFamily=Windows&OSName=Windows 7&OSVersion=6.1&isMobile=false&isTouch=false&accept-language=ru&&ref=del_37&ref=del_38&charset=utf-8&duid=MTQ2MjIxMjY0ODc3NTY1MzgyMg==&id=99&id=100000034&highlight=1&tag=41238128492642&id=4668651520110795581&version=4171&ver=0&token=yabs.MTQyNDU3MDQyOQozNDgyODExMDMxCjQ5Njg1Mzc2NDA=&grab=del_0&config=del_185&callback=Ya[1520110803083]', 'rtb_imp_id': '99', 'awapsid': '607c27f46951c4f2', 'sd_age_45_55': '0', 'subkey': '', 'rtb_request_id': '971086343437556603', 'referer': 'https://www.avito.ru/furmanov', 'sd_income_b': '0', 'timezone': '+0300', 'http_nmb': '10106', 'bandwidth': '225', 'tskv_format': 'awaps-log', 'geo_zone': '20682', 'user_regular_location_txt': '[[57.250325;41.107925]]', 'ip_number': '-1859051202', 'rtb_slice_id': '0', 'rtb_user_id': '6952475855445673202', 'ua_browser_name_nmb': '16', 'mime_type': '0', 'yandexuid': '363465201455539774', 'rtb_site_id': '106253', 'sd_user_events': '6369:1520082687,6372:1520082687,6373:1520082687', '_logfeller_index_bucket': '//home/logfeller/index/crypta-awaps/awaps-log/1800-1800/1520112600/1520110800', 'fake_field': 'fake', 'user_agent': 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.1.839 Yowser/2.5 Safari/537.36', 'lon': '', 'user_id_type': '2', 'ipv6': '::ffff:62.33.49.145', 'unixtime': '1520110800', 'sd_app_hashes': '98695222,112873714,122172628,195121168,200284863,205133001,243592565,298734828,351595249,377782831,455258755,460115031,472381211,525384149,558213177,652813189,692920334,724757188,828643515,845769836,942804783,991212977,1052389471,1188750472,1208394712,1227332918,1283199013,1289191926,1491176382,1544364601,1614439145,1767483655,1803411425,1808036939,1953301021,2047593510,2090130729,2120744166,2194997179,2213758016,2252299850,2275905010,2340865031,2377075764,2379275945,2448498603,2627999552,2669044287,2694396329,2786030271,2921948208,2952987727,3018457173,3120311309,3161966845,3245288723,3258986891,3271406603,3338465354,3381249149,3653721913,3709857114,3827399550,3887639901,3910820935,3913483939,3933333099,3979668950,3994884419,4091131464,4113344712,4161929635,4201643893,4227262645,4264117171', 'sd_age_25': '100', 'iso_eventtime': '2018-03-04 00:00:00', 'sd_version': '6', 'rtb_resource_id': '3075', 'unitnmb': '910625702', 'user_regular_location': 'Ih+00hiAklI=', 'source_uri': 'prt://crypta-awaps@MINILOGS21.ld.yandex.ru/crypta_export/crypta3.txt', 'sd_income_c': '0', 'lat': '', '_logfeller_timestamp': 1460373610, 'timestamp': '2018-03-04 00:00:00', 'rtb_stlm_price': '0', 'rtb_bid_price': '1271', 'sd_income_a': '0', 'sd_age_45': '0', 'ua_is_tablet': '', 'uniq_nmb': '37829341293', 'actionid_original': '', 'sd_gender_f': '100', 'adplace_nmb': '0', 'adid': '3320812', 'global_request_id': '3781474757805672096', 'sd_age_18': '0', 'user_search_cats': 'BfXhZgX14WcF9eFvBfXhcQX14XQF9eF2BfXhewX14YEF9eGOBfXhjwX14ZkF9eGhBfXhpAX14agF9eGpBfXhqgX14awF9eGvBfXhtgX14b0F9eHIBfXhygX14c0F9eHRBfXh7gX14gAF9eIEBfXiJQX14jMF9eI3BfXiXgX14nAF9eKQBfXipQX14s8F9eLvBfXi8gX14vMF9eMKBfXjDAX14w8F9eMRBfXjFgX14xsF9eMcBfXjHQX14yAF9eMhBfXjIgX14yQF9eMlBfXjJwX14ykF9eMqBfXjLAX14y0F9eMuBfXjMAX14zcF9eNIBfXjSg==', 'sectionid': '9090', 'rtb_reserve_price': '1024', 'width': '728'})

testdata_reqans_new_log_09 = BaseLog(
    path="//home/logfeller/logs/report-web-report-search-reqans-event-log/1d",
    date="2016-04-09",
    default_data={}
)

testdata_reqans_new_log_09.add_row(**{'_date': '2016-04-09', 'userIp': '151.252.108.1', 'requestedPageSize': 10, 'host': 'yandex.ru', 'timestamp': 1520143867604, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 35, '_utc_eventtime': 1520143867, 'userInterface': 'TOUCH', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143866944849-1440579567388437269036183-man1-5900-TCH', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 111920556, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2207000531420180304091107', 'parentRequestId': '1520143825451116-1367227237285576420533739-man1-8205-TCH', 'goodWords': '0441 04340435043D044C 0440043E043604340435043D04380435', 'userAgentRaw': 'Mozilla/5.0 (Linux; Android 6.0.1; Redmi Note 3 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.137 Mobile Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '9317254401483771717', 'platformId': None, 'robotUid': None, 'iCookie': '9317254401483771717', 'uuid': None, 'passportUid': None, 'yandexFuid': '13191192671506352712'}, 'query': '0441 0434043D0435043C 0440043E043604340435043D0438044F', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log_09.add_row(**{'_date': '2016-04-09', 'userIp': '178.120.2.170', 'requestedPageSize': 15, 'host': 'yandex.by', 'timestamp': 1520143867947, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 153, '_utc_eventtime': 1520143867, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867257633-360858531461324532734785-man1-5900', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 149870101, 'domain': 'BY', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2173354170720180304091107', 'parentRequestId': '1520143867257633-360858531461324532734785-man1-5900', 'goodWords': '043F0440043504370435043D0442043004460438044F 043F043E 043C043004420435043C043004420438043A 043C043004420435043C043004420438043A0430 4 043A043B043004410441', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36 OPR/50.0.2762.67', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '5132453271520143867', 'platformId': None, 'robotUid': None, 'iCookie': '5132453271520143867', 'uuid': None, 'passportUid': None, 'yandexFuid': None}, 'query': '043F0440043504370435043D0442043004460438044F 043F043E 043C043004420435043C043004420438043A0435 4 043A043B043004410441', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log_09.add_row(**{'_date': '2016-04-09', 'userIp': '93.125.31.77', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143867990, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 225, '_utc_eventtime': 1520143867, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867421144-1764017909002209350736343-man1-5900', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 191971629, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2124748653620180304091107', 'parentRequestId': '1520143867421144-1764017909002209350736343-man1-5900', 'goodWords': '0432043E0435043D043D044B0439 043E0431043E043704400435043D04380435 udlmdcaefbggafczzzcabizzzmarzzzsun', 'userAgentRaw': 'Python-urllib/2.7', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '2430017281420200028', 'platformId': None, 'robotUid': None, 'iCookie': '2430017281420200028', 'uuid': None, 'passportUid': None, 'yandexFuid': None}, 'query': '0432043E0435043D043D043E0435 043E0431043E043704400435043D04380435 | udlmdcaefbggafczzzcabizzzmarzzzsun', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})

testdata_reqans_new_log_10 = BaseLog(
    path="//home/logfeller/logs/report-web-report-search-reqans-event-log/1d",
    date="2016-04-10",
    default_data={}
)

testdata_reqans_new_log_10.add_row(**{'_date': '2016-04-10', 'userIp': '151.252.108.1', 'requestedPageSize': 10, 'host': 'yandex.ru', 'timestamp': 1520143867604, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 35, '_utc_eventtime': 1520143867, 'userInterface': 'TOUCH', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143866944849-1440579567388437269036183-man1-5900-TCH', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 111920556, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2207000531420180304091107', 'parentRequestId': '1520143825451116-1367227237285576420533739-man1-8205-TCH', 'goodWords': '0441 04340435043D044C 0440043E043604340435043D04380435', 'userAgentRaw': 'Mozilla/5.0 (Linux; Android 6.0.1; Redmi Note 3 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.137 Mobile Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '9317254401483771717', 'platformId': None, 'robotUid': None, 'iCookie': '9317254401483771717', 'uuid': None, 'passportUid': None, 'yandexFuid': '13191192671506352712'}, 'query': '0441 0434043D0435043C 0440043E043604340435043D0438044F', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log_10.add_row(**{'_date': '2016-04-10', 'userIp': '178.120.2.170', 'requestedPageSize': 15, 'host': 'yandex.by', 'timestamp': 1520143867947, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 153, '_utc_eventtime': 1520143867, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867257633-360858531461324532734785-man1-5900', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 149870101, 'domain': 'BY', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2173354170720180304091107', 'parentRequestId': '1520143867257633-360858531461324532734785-man1-5900', 'goodWords': '043F0440043504370435043D0442043004460438044F 043F043E 043C043004420435043C043004420438043A 043C043004420435043C043004420438043A0430 4 043A043B043004410441', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36 OPR/50.0.2762.67', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '5132453271520143867', 'platformId': None, 'robotUid': None, 'iCookie': '5132453271520143867', 'uuid': None, 'passportUid': None, 'yandexFuid': None}, 'query': '043F0440043504370435043D0442043004460438044F 043F043E 043C043004420435043C043004420438043A0435 4 043A043B043004410441', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log_10.add_row(**{'_date': '2016-04-10', 'userIp': '93.125.31.77', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143867990, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 225, '_utc_eventtime': 1520143867, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867421144-1764017909002209350736343-man1-5900', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 191971629, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2124748653620180304091107', 'parentRequestId': '1520143867421144-1764017909002209350736343-man1-5900', 'goodWords': '0432043E0435043D043D044B0439 043E0431043E043704400435043D04380435 udlmdcaefbggafczzzcabizzzmarzzzsun', 'userAgentRaw': 'Python-urllib/2.7', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '2430017281420200028', 'platformId': None, 'robotUid': None, 'iCookie': '2430017281420200028', 'uuid': None, 'passportUid': None, 'yandexFuid': None}, 'query': '0432043E0435043D043D043E0435 043E0431043E043704400435043D04380435 | udlmdcaefbggafczzzcabizzzmarzzzsun', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})

testdata_reqans_new_log = BaseLog(
    path="//home/logfeller/logs/report-web-report-search-reqans-event-log/1d",
    date="2016-04-11",
    default_data={}
)

testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '151.252.108.1', 'requestedPageSize': 10, 'host': 'yandex.ru', 'timestamp': 1520143867604, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 35, '_utc_eventtime': 1520143867, 'userInterface': 'TOUCH', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143866944849-1440579567388437269036183-man1-5900-TCH', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 111920556, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2207000531420180304091107', 'parentRequestId': '1520143825451116-1367227237285576420533739-man1-8205-TCH', 'goodWords': '0441 04340435043D044C 0440043E043604340435043D04380435', 'userAgentRaw': 'Mozilla/5.0 (Linux; Android 6.0.1; Redmi Note 3 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.137 Mobile Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '9317254401483771717', 'platformId': None, 'robotUid': None, 'iCookie': '9317254401483771717', 'uuid': None, 'passportUid': None, 'yandexFuid': '13191192671506352712'}, 'query': '0441 0434043D0435043C 0440043E043604340435043D0438044F', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '178.120.2.170', 'requestedPageSize': 15, 'host': 'yandex.by', 'timestamp': 1520143867947, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 153, '_utc_eventtime': 1520143867, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867257633-360858531461324532734785-man1-5900', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 149870101, 'domain': 'BY', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2173354170720180304091107', 'parentRequestId': '1520143867257633-360858531461324532734785-man1-5900', 'goodWords': '043F0440043504370435043D0442043004460438044F 043F043E 043C043004420435043C043004420438043A 043C043004420435043C043004420438043A0430 4 043A043B043004410441', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36 OPR/50.0.2762.67', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '5132453271520143867', 'platformId': None, 'robotUid': None, 'iCookie': '5132453271520143867', 'uuid': None, 'passportUid': None, 'yandexFuid': None}, 'query': '043F0440043504370435043D0442043004460438044F 043F043E 043C043004420435043C043004420438043A0435 4 043A043B043004410441', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '93.125.31.77', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143867990, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 225, '_utc_eventtime': 1520143867, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867421144-1764017909002209350736343-man1-5900', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 191971629, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2124748653620180304091107', 'parentRequestId': '1520143867421144-1764017909002209350736343-man1-5900', 'goodWords': '0432043E0435043D043D044B0439 043E0431043E043704400435043D04380435 udlmdcaefbggafczzzcabizzzmarzzzsun', 'userAgentRaw': 'Python-urllib/2.7', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '2430017281420200028', 'platformId': None, 'robotUid': None, 'iCookie': '2430017281420200028', 'uuid': None, 'passportUid': None, 'yandexFuid': None}, 'query': '0432043E0435043D043D043E0435 043E0431043E043704400435043D04380435 | udlmdcaefbggafczzzcabizzzmarzzzsun', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '94.154.80.149', 'requestedPageSize': 10, 'host': 'www.yandex.ru', 'timestamp': 1520143868161, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 63, '_utc_eventtime': 1520143868, 'userInterface': 'TOUCH', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867339305-684912850286349192236079-man1-5900-TCH', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://www.yandex.ru/', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 113007396, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2173478018220180304091107', 'parentRequestId': None, 'goodWords': '043A0430043A 04430445043004360438043204300442044C 04370430 043F04400438043C0443043B0430 0432 0434043E043C04300448043D04380435 0434043E043C04300448043D04380439 04430441043B043E043204380435 043F043E0441043B0435 043F043E043A0443043F043A0430', 'userAgentRaw': 'Mozilla/5.0 (Linux; Android 5.0.2; Lenovo S90-A Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2062.124 YaBrowser/14.10.2062.12160.00 Mobile Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '6566147821452826918', 'platformId': None, 'robotUid': None, 'iCookie': '6566147821452826918', 'uuid': None, 'passportUid': None, 'yandexFuid': '2772622121452826923'}, 'query': '043A0430043A 04430445043004360438043204300442044C 04370430 043F04400438043C0443043B043E0439 0432 0434043E043C04300448043D04380445 04430441043B043E04320438044F0445 043F043E0441043B0435 043F043E043A0443043F043A0438', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '109.252.53.151', 'requestedPageSize': 10, 'host': 'yandex.ru', 'timestamp': 1520143868369, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 213, '_utc_eventtime': 1520143868, 'userInterface': 'TOUCH', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867672116-112262845055027852836293-man1-5900-TCH', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 44680040, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2098168144320180304091107', 'parentRequestId': '1520143849500916-497191597900476500935107-man1-3593-TCH', 'goodWords': '04410430043B04300442 04380437 04420443043D04350446 0438 044404300441043E043B044C 043A043B0430044104410438044704350441043A04380439', 'userAgentRaw': 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_2_5 like Mac OS X) AppleWebKit/604.5.6 (KHTML, like Gecko) Version/11.0 Mobile/15D60 Safari/604.1', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '9292589571508404887', 'platformId': None, 'robotUid': None, 'iCookie': '9292589571508404887', 'uuid': None, 'passportUid': '105531119', 'yandexFuid': '20133155891508404888'}, 'query': '04410430043B04300442 04380437 04420443043D04460430 0438 044404300441043E043B0438 043A043B0430044104410438044704350441043A04380439', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '37.23.237.186', 'requestedPageSize': 20, 'host': 'yandex.ru', 'timestamp': 1520143868410, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 197, '_utc_eventtime': 1520143868, 'userInterface': 'TOUCH', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867961187-308551-man1-2009-SAPI', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 348163940, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2173853437120180304091108', 'parentRequestId': None, 'goodWords': 'ass', 'userAgentRaw': 'Apache-HttpClient/4.3.5 (java 1.5)', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '8284772551520143867', 'platformId': None, 'robotUid': None, 'iCookie': None, 'uuid': '71572c206e84028f3cdfd1671e101c6a', 'passportUid': None, 'yandexFuid': None}, 'query': 'ass', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '95.191.162.163', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143867589, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 65, '_utc_eventtime': 1520143867, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-3692.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867073602-1275005717681369404934221-man1-3692', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/search/?text=%D0%B7%D0%BE&lr=65&clid=2242348', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 127274352, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2163788581320180304091107', 'parentRequestId': '1520143867073602-1275005717681369404934221-man1-3692', 'goodWords': '0437043E', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.186 Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '4341176361509778366', 'platformId': None, 'robotUid': None, 'iCookie': '4341176361509778366', 'uuid': None, 'passportUid': None, 'yandexFuid': '1544840681509778403'}, 'query': '0437043E', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '176.59.113.159', 'requestedPageSize': 10, 'host': 'yandex.ru', 'timestamp': 1520143867680, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 47, '_utc_eventtime': 1520143867, 'userInterface': 'TOUCH', 'source_uri': 'prt://search-web@man1-3692.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867082811-737560490949225988735555-man1-3692-TCH-p1', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 180339967, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 1, 'bsBlockId': '2167378212020180304091107', 'parentRequestId': '1520143402581044-1292641920765569306432508-man1-3933-TCH', 'goodWords': '043A0430043A 0441043A0430044704300442044C 04320437043B043E043C 0438043304400430 044804350434043E043B0444043004390442 2', 'userAgentRaw': 'Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; 4027D Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.108 UCBrowser/12.0.0.1088 Mobile Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '5556930641520143402', 'platformId': None, 'robotUid': None, 'iCookie': '5556930641520143402', 'uuid': None, 'passportUid': None, 'yandexFuid': None}, 'query': '043A0430043A 0441043A0430044704300442044C 04320437043B043E043C 043804330440044B 044804350434043E043B0444043004390442 2', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '2.92.193.241', 'requestedPageSize': 10, 'host': 'yandex.ru', 'timestamp': 1520143867831, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 213, '_utc_eventtime': 1520143867, 'userInterface': 'UNKNOWN', 'source_uri': 'prt://search-web@man1-3692.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867358887-156845009775165666734192-man1-3692', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 0, 'domain': 'RU', 'configVersion': 8617, 'groupBy': None, 'pageNo': 0, 'bsBlockId': None, 'parentRequestId': '1520143454952055-607847948167074750836534-sas1-7591-TCH', 'goodWords': '', 'userAgentRaw': 'Mozilla/5.0 (Linux; Android 7.0; MI MAX Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.0.527.00 Mobile Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '8876613391511991912', 'platformId': None, 'robotUid': None, 'iCookie': '8876613391511991912', 'uuid': '2c5200249c55a531db7c2382220c7057', 'passportUid': '7282987', 'yandexFuid': '17862224981511991937'}, 'query': '', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '176.214.158.14', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143868306, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 8, '_utc_eventtime': 1520143868, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-3692.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867772134-1132661225824845627235842-man1-3692', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 2324988605, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2183173639720180304091107', 'parentRequestId': '1520143867772134-1132661225824845627235842-man1-3692', 'goodWords': '0432043A', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.186 Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '4878303371518356848', 'platformId': None, 'robotUid': None, 'iCookie': '4878303371518356848', 'uuid': None, 'passportUid': '14681222', 'yandexFuid': '5804006481518356853'}, 'query': '0432043A', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '128.69.152.15', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143868591, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 213, '_utc_eventtime': 1520143868, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-3692.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143868004857-1291117396758152189134866-man1-3692', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/search/?text=%D0%B0%D0%BD%D0%B4%D1%80%D0%B5%D0%B9%20%D1%80%D1%8F%D0%B1%D0%B8%D0%BD%D1%81%D0%BA%D0%B8%D0%B9&lr=213&clid=1955451&win=116', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 30677343, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2125961652320180304091108', 'parentRequestId': '1520143868004857-1291117396758152189134866-man1-3692', 'goodWords': '0430043D0434044004350439 0440044F04310438043D0441043A04380439', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.1.839 Yowser/2.5 Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '4874078331520089035', 'platformId': None, 'robotUid': None, 'iCookie': '4874078331520089035', 'uuid': None, 'passportUid': None, 'yandexFuid': '3437958931520143012'}, 'query': '0430043D0434044004350439 0440044F04310438043D0441043A04380439', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '93.100.174.61', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143867626, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 2, '_utc_eventtime': 1520143867, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-6003.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143866935652-1005330320761398294333836-man1-6003', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 97802030, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2214261351720180304091107', 'parentRequestId': '1520143866935652-1005330320761398294333836-man1-6003', 'goodWords': '0431043E043B04350442044C 0433043E0440043B043E 0431043E043B044C043D043E 0431043E043B044C043D043E0439 0433043B043E044204300442044C 04470435043C 04470442043E 043B0435044704380442044C 0432 0434043E043C04300448043D04380435 0434043E043C04300448043D04380439 04430441043B043E043204380435', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.186 Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '7429813671519586488', 'platformId': None, 'robotUid': None, 'iCookie': '7429813671519586488', 'uuid': None, 'passportUid': None, 'yandexFuid': '18104267091519588551'}, 'query': '0431043E043B04380442 0433043E0440043B043E 0431043E043B044C043D043E 0433043B043E044204300442044C 04470435043C 043B0435044704380442044C 0432 0434043E043C04300448043D04380445 04430441043B043E04320438044F0445', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '217.114.226.219', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143867687, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 54, '_utc_eventtime': 1520143867, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-6003.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867103364-404136303510543582634211-man1-6003', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/search/?text=http%3A%2F%2Fqps.ru%2Fbp29K&lr=54', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 560, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2055644912620180304091107', 'parentRequestId': '1520143867103364-404136303510543582634211-man1-6003', 'goodWords': 'http qps ru bp29k', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:58.0) Gecko/20100101 Firefox/58.0', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '1851861571519916889', 'platformId': None, 'robotUid': None, 'iCookie': '1851861571519916889', 'uuid': None, 'passportUid': None, 'yandexFuid': '14745379361519999041'}, 'query': 'http://qps.ru/bp29K', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '79.133.148.157', 'requestedPageSize': 10, 'host': 'yandex.ru', 'timestamp': 1520143867884, 'iso_eventtime': '2018-03-04 09:11:07', 'userRegionId': 101235, '_utc_eventtime': 1520143867, 'userInterface': 'MOBILE_APP', 'source_uri': 'prt://search-web@man1-6003.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867194715-614398-vla1-0040-SAPP', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 59657621, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2137726243020180304091107', 'parentRequestId': '1520105442582182-916806-vla1-0562-SAPP', 'goodWords': '1xbet 043704350440043A0430043B043E', 'userAgentRaw': 'Mozilla/5.0 (Linux; Android 5.1; SP52 Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/39.0.0.0 Mobile Safari/537.36 YandexSearch/4.51', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '4327411711498232805', 'platformId': None, 'robotUid': None, 'iCookie': None, 'uuid': 'bcef7d24f1e7e7242876f90bf709bd8e', 'passportUid': None, 'yandexFuid': None}, 'query': '1xbet 043704350440043A0430043B043E', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '2a02:6b8:b000:607f:e61d:2dff:fe6d:cb10', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143868084, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 169270, '_utc_eventtime': 1520143868, 'userInterface': 'UNKNOWN', 'source_uri': 'prt://search-web@man1-6003.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867869037-232457423957090104633823-man1-6003', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 0, 'domain': 'RU', 'configVersion': 8617, 'groupBy': None, 'pageNo': 0, 'bsBlockId': None, 'parentRequestId': None, 'goodWords': '', 'userAgentRaw': 'Mozilla/5.0 (compatible; YandexNews/3.0; +http://yandex.com/bots)', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '2709010461520143867', 'platformId': None, 'robotUid': None, 'iCookie': '2709010461520143867', 'uuid': None, 'passportUid': None, 'yandexFuid': None}, 'query': '', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '31.185.12.140', 'requestedPageSize': 10, 'host': 'yandex.ru', 'timestamp': 1520143868292, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 117931, '_utc_eventtime': 1520143868, 'userInterface': 'TOUCH', 'source_uri': 'prt://search-web@man1-6003.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867601505-1678509202498304856533594-man1-6003-TCH', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 610821, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2108396912720180304091107', 'parentRequestId': '1520083925841081-149011676701870983846591-man1-5378-TCH', 'goodWords': '0444043B0435043C043E043A04410438043D 0441043E043B044E044204300431', 'userAgentRaw': 'Mozilla/5.0 (Linux; U; Android 6.0.1; en-us; Redmi 4 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/53.0.2785.146 Mobile Safari/537.36 XiaoMi/MiuiBrowser/9.4.10', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '8664533871494433753', 'platformId': None, 'robotUid': None, 'iCookie': '8664533871494433753', 'uuid': None, 'passportUid': '137223666', 'yandexFuid': '16008130441494433755'}, 'query': '0424043B0435043C043E043A04410438 043D 0441043E043B044E044204300431', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '213.87.152.112', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143868752, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 213, '_utc_eventtime': 1520143868, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-6003.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867927102-948279670766496136433345-man1-6003', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 113770885, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2105165789920180304091108', 'parentRequestId': '1520143867927102-948279670766496136433345-man1-6003', 'goodWords': '043A0430043D 043A043E04400441043E 043604380442044C 043D0430 0443043B043804460430', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36 OPR/51.0.2830.34 (Edition Yx)', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '8526151551516344699', 'platformId': None, 'robotUid': None, 'iCookie': '8526151551516344699', 'uuid': None, 'passportUid': None, 'yandexFuid': '16347041201516345172'}, 'query': '043A0430043D0435 043A043E04400441043E 04360438043204350442 043D0430 0443043B043804460435', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '85.26.165.216', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143868320, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 48, '_utc_eventtime': 1520143868, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-4365.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867326668-1284884965671515500235378-man1-4365', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/search/?text=%D0%BA%D0%B0%D1%80%D1%82%D0%B8%D0%BD%D0%BA%D0%B8%20%20%D0%BF%D0%BE%D1%86%D0%B5%D0%BB%D1%83%D0%B8%20%D0%BC%D0%BE%D0%BD%D1%82%D0%B5%D1%80%20%D0%BD%D0%B0%20%D1%81%D0%BE%D1%81%D0%B5%D0%B4%D0%BD%D0%B5%D0%B9%20%D0%BF%D0%B0%D1%80%D1%82%D0%B5&lr=48', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 55549284, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2044984781620180304091107', 'parentRequestId': '1520143867326668-1284884965671515500235378-man1-4365', 'goodWords': '043A0430044004420438043D043A0430 043F043E04460435043B04430439 043C043E043D044204350440 043D0430 0441043E044104350434043D04380439 043F0430044004420430', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.100 Safari/534.30', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '866882961357743649', 'platformId': None, 'robotUid': None, 'iCookie': '866882961357743649', 'uuid': None, 'passportUid': None, 'yandexFuid': '17230390821357744989'}, 'query': '043A0430044004420438043D043A0438 043F043E04460435043B04430438 043C043E043D044204350440 043D0430 0441043E044104350434043D04350439 043F0430044004420435', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '195.64.206.243', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143868444, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 11170, '_utc_eventtime': 1520143868, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-4365.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867781140-715587308513778616734557-man1-4365', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 189409270, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2125663209720180304091108', 'parentRequestId': '1520143867781140-715587308513778616734557-man1-4365', 'goodWords': '04351 0435043A04300442043504400438043D0431044304400433', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '4536568031475469190', 'platformId': None, 'robotUid': None, 'iCookie': '4536568031475469190', 'uuid': None, 'passportUid': '30590438', 'yandexFuid': '13928156571440684416'}, 'query': '04351 0435043A04300442043504400438043D0431044304400433', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '83.220.237.0', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143868643, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 213, '_utc_eventtime': 1520143868, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-4365.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867931001-1537512669623056936135668-man1-4365', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 316388650, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2009390757820180304091108', 'parentRequestId': '1520143867931001-1537512669623056936135668-man1-4365', 'goodWords': '043E0434043D043E043A043B043004410441043D0438043A', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 YaBrowser/18.1.1.839 Yowser/2.5 Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '7282075991472838298', 'platformId': None, 'robotUid': None, 'iCookie': '7282075991472838298', 'uuid': None, 'passportUid': '410416214', 'yandexFuid': '14803997591472838619'}, 'query': '043E0434043D043E043A043B043004410441043D0438043A0438', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '77.222.108.191', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143868904, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 11202, '_utc_eventtime': 1520143868, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-4365.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143868254808-845605984832418453836818-man1-4365', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://yandex.ru/search/?text=%D0%A4%D0%B0%D0%BB%D0%B5%D1%81%20%D0%B8%D0%B7%20%D0%9C%D0%B8%D0%BB%D0%B5%D1%82%D0%B0%20%D1%84%D0%BE%D1%82%D0%BE&lr=11202', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 37735557, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2082846317920180304091108', 'parentRequestId': '1520143868254808-845605984832418453836818-man1-4365', 'goodWords': '04440430043B04350441 04380437 043C0438043B04350442 043C0438043B043504420430 0444043E0442043E', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '1572904511425207757', 'platformId': None, 'robotUid': None, 'iCookie': '1572904511425207757', 'uuid': None, 'passportUid': None, 'yandexFuid': '9094566901321280698'}, 'query': '04240430043B04350441 04380437 041C0438043B043504420430 0444043E0442043E', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '212.74.203.201', 'requestedPageSize': 10, 'host': 'yandex.ru', 'timestamp': 1520143868423, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 197, '_utc_eventtime': 1520143868, 'userInterface': 'MOBILE_APP', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867557294-420998-vla1-0336-SAPP', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 11519, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2168810955720180304091107', 'parentRequestId': '1520143250761568-783682-vla1-0562-SAPP', 'goodWords': '0431043B0435043D043404350440 043D0435043F043E0433044004430436043D043E0439 ikook 0430043D0430043B043E0433', 'userAgentRaw': 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900FD Build/MMB29M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/64.0.3282.137 Mobile Safari/537.36 YandexSearch/7.26', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '3017938391449820079', 'platformId': None, 'robotUid': None, 'iCookie': '3017938391449820079', 'uuid': '7b874ccf6b8b4dd0515fd11b89db90ec', 'passportUid': '533747064', 'yandexFuid': '19110500771449820084'}, 'query': '0431043B0435043D043404350440 043D0435043F043E0433044004430436043D043E0439 ikook 0430043D0430043B043E04330438', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '85.93.58.219', 'requestedPageSize': 15, 'host': 'yandex.ru', 'timestamp': 1520143868445, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 46, '_utc_eventtime': 1520143868, 'userInterface': 'DESKTOP', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143867618955-1705351584949349138936942-man1-5900', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 153317034, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2197096552720180304091107', 'parentRequestId': '1520143867618955-1705351584949349138936942-man1-5900', 'goodWords': '04400435043904420438043D0433 043A0430043D04340438043404300442 0432 043F044004350437043804340435043D0442 0440043E044104410438044F 2018 0432 043F0440043E04460435043D0442', 'userAgentRaw': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.168 Safari/537.36 OPR/51.0.2830.40', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '2238746941518543261', 'platformId': None, 'robotUid': None, 'iCookie': '2238746941518543261', 'uuid': None, 'passportUid': None, 'yandexFuid': '2524804471518633879'}, 'query': '04400435043904420438043D0433 043A0430043D04340438043404300442043E0432 0432 043F044004350437043804340435043D0442044B 0440043E0441044104380438 2018 0432 043F0440043E04460435043D044204300445', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '95.26.246.121', 'requestedPageSize': 10, 'host': 'yandex.ru', 'timestamp': 1520143868947, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 213, '_utc_eventtime': 1520143868, 'userInterface': 'TOUCH', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143868209311-232607384231762612337414-man1-5900-TCH', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': None, 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 49443862, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2019498692020180304091108', 'parentRequestId': None, 'goodWords': '043C04400442 043C04430441 043C044304410430 043404360430043B0438043B044C 043404360430043B0438043B044F', 'userAgentRaw': 'Mozilla/5.0 (Linux; Android 5.0.2; SM-A700YD Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.137 Mobile Safari/537.36', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '3196392441518591542', 'platformId': None, 'robotUid': None, 'iCookie': '3196392441518591542', 'uuid': None, 'passportUid': None, 'yandexFuid': None}, 'query': '043C04400442 043C04430441044B 043404360430043B0438043B044F', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})
testdata_reqans_new_log.add_row(**{'_date': '2016-04-11', 'userIp': '94.231.174.126', 'requestedPageSize': 10, 'host': 'www.yandex.ru', 'timestamp': 1520143868958, 'iso_eventtime': '2018-03-04 09:11:08', 'userRegionId': 213, '_utc_eventtime': 1520143868, 'userInterface': 'TOUCH', 'source_uri': 'prt://search-web@man1-5900.search.yandex.net/usr/local/www/logs/current-web-report-search-reqans-event-log-upper-8080', 'requestId': '1520143868249714-755990852675329482135728-man1-5900-TCH', 'provider': 'PERL_REPORT', 'uiLanguage': 'ru', 'scarab:type': 'WEB_REPORT_SEARCH_REQANS_EVENT', 'referer': 'https://www.yandex.ru/', 'serviceKey': 'SEARCH_WWW', 'scarab:version': 4, '_logfeller_timestamp': 1460373610, 'numDocs': 45372973, 'domain': 'RU', 'configVersion': 8617, 'groupBy': 'd', 'pageNo': 0, 'bsBlockId': '2048560135320180304091108', 'parentRequestId': None, 'goodWords': '043C04380440 043D043004380437043D0430043D043A0443', 'userAgentRaw': 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_2_6 like Mac OS X) AppleWebKit/604.5.6 (KHTML, like Gecko) Version/11.0 Mobile/15D100 Safari/604.1', 'userId': {'yandexLogin': None, 'platformId2': None, 'deviceId': None, 'yandexUid': '1532948211520143868', 'platformId': None, 'robotUid': None, 'iCookie': '1532948211520143868', 'uuid': None, 'passportUid': None, 'yandexFuid': None}, 'query': '043C04380440 043D043004380437043D0430043D043A0443', '_logfeller_index_bucket': '//home/logfeller/index/search-web/web-report-search-reqans-event-log/1800-1800/1520144700/1520143200'})

testdata_metrika_mobile = BaseLog(
    path="//statbox/metrika-mobile-log",
    date="2016-04-11",
    default_data=METRIKA_MOBILE_LOG
)

testdata_metrika_mobile_private = BaseLog(
    # same as mmetrika, but in another place
    path="//home/logfeller/logs/metrika-mobile-private-log/1d",
    date="2016-04-11",
    default_data=METRIKA_MOBILE_LOG
)

testdata_metrika_mobile.add_row(UUIDHash='16635953734884673029', DeviceIDHash='18004102793236826873', _logfeller_timestamp=1460216367, DeviceID='00002907a397aea15dbfbdcf0472a111', ClientIP='31.173.80.25')
testdata_metrika_mobile_private.add_row(UUIDHash='16635953734884673029', DeviceIDHash='18004102793236826873', _logfeller_timestamp=1460216367, DeviceID='00002907a397aea15dbfbdcf0472a111', ClientIP='31.173.80.25', OriginalDeviceID='70F890A4-C735-46D4-AD93-98D7C26E90D2')
testdata_metrika_mobile.add_row(UUIDHash='16635953734884673029', DeviceIDHash='18004102793236826873', _logfeller_timestamp=1460216367, DeviceID='00002907a397aea15dbfbdcf0472a121', ClientIP='31.173.80.26', OriginalDeviceID='70F890A4-C735-46D4-AD93-98D7C26E90E3', UUID='06a3907a6eb48f9ae525d6faada22222')
testdata_metrika_mobile_private.add_row(LocationDirection='1', LocationTimestamp='1460216367', RegionID='21621', _logfeller_timestamp=1460205748, DeviceID='00002907a397aea15dbfbdcf0472a121', Latitude='55.76108785689768', ParsedParams_Quantity='[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]', UUIDHash='16635953734884673029', StartDate='2016-04-09', iso_eventtime='2016-04-09 18:42:28', StartTimestamp='1460216547', DeviceIDHash='18004102793236826873', SessionID='1460216547', timestamp_raw='2016-04-09 15:42:28', DeviceIDSessionIDHash='10343212708140499034', ClientIP='31.173.80.25', SendTimestamp='1460216548', LocationAltitude='161', ReceiveTimestamp='1460216548', Longitude='37.84297602448162', EventName='application.start-session', ClientPort='62615', ParsedParams_ValueDouble='[0,0,0,0,0,0,67,0,0,0,0,0,0,0,0]', UUID='06a3907a6eb48f9ae525d6faada26492', EventValue='{"work_added":"false","events_annotation":"voice","auto_zoom":"true","voice_guidance":"true","home_added":"false","sound_lang":"ru","bookmarks_count":"67","authorized":"true","road_alerts":"true","map_caches":"0","traffic":"true","north_is_fixed":"false","sound_scheme":"female","3D_view":"true","voice_activation":"true"}', LocationSpeed='8', _stbx='rt3.fol--mobmetrika--metrika-mobile-log:1:278145033', StartTime='2016-04-09 18:42:27', EventNumber='3')
testdata_metrika_mobile.add_row(LocationDirection='204', LocationTimestamp='1460193372', RegionID='213', _logfeller_timestamp=1460182576, DeviceID='00002907a397aea15dbfbdcf0472a121', LocationPrecision='5', SessionType='SESSION_FOREGROUND', Latitude='55.69233198078561', ParsedParams_Quantity='[1,1,1,1,1,1]', UUIDHash='16635953734884673029', StartDate='2016-04-09', iso_eventtime='2016-04-09 12:16:16', StartTimestamp='1460193371', DeviceIDHash='18004102793236826873', SessionID='1460193371', timestamp_raw='2016-04-09 09:16:16', DeviceIDSessionIDHash='9815156905372936885', ClientIP='31.173.80.25', SendTimestamp='1460193376', source_uri='prt://mobmetrika@mtcalclog03e.yandex.ru/opt/statbox_export_mobile/mobile-events.log', LocationAltitude='119', ReceiveTimestamp='1460193376', Longitude='37.71768555285222', NetworkType='LTE', EventName='route', ClientPort='12856', ParsedParams_ValueDouble='[1460193375,0,55.69231345019476,37.71766415691849,1,1460193375]', UUID='06a3907a6eb48f9ae525d6faada26492', EventValue='{"time":"1460193375","uuid":"06a3907a6eb48f9ae525d6faada26492","lat":"55.692313450194746","lon":"37.717664156918502","log_version":"1","route_start_time":"1460193375"}', LocationSpeed='7', _stbx='rt3.iva--mobmetrika--metrika-mobile-log:1:243268514', EventTimeOffset='4', StartTime='2016-04-09 12:16:11', EventNumber='7')
testdata_metrika_mobile_private.add_row(LocationDirection='179', LocationTimestamp='1460193978', RegionID='213', _logfeller_timestamp=1460183179, DeviceID='00002907a397aea15dbfbdcf0472a131', LocationPrecision='30', SessionType='SESSION_FOREGROUND', Latitude='55.6754823122692', ParsedParams_Quantity='[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]', UUIDHash='16635953734884673029', StartDate='2016-04-09', iso_eventtime='2016-04-09 12:26:19', StartTimestamp='1460193949', DeviceIDHash='18004102793236826873', SessionID='1460193949', timestamp_raw='2016-04-09 09:26:19', DeviceIDSessionIDHash='10103963491011739182', ClientIP='31.173.80.26', SendTimestamp='1460193979', source_uri='prt://mobmetrika@mtcalclog01f.yandex.ru/opt/statbox_export_mobile/mobile-events.log', LocationAltitude='151', ReceiveTimestamp='1460193979', Longitude='37.739414675196386', NetworkType='WCDMA', EventName='ping', ClientPort='5654', ParsedParams_ValueDouble='[0,68.88928990000001,37.739079584255606,58.656105000000004,0,55.69252602708041,992.07782,1460193979,326.97070299999996,37.717636999552184,3437.74194,1.0474243199999997,55.67545548575264,603,1460193375,436.81600999999995,1]', UUID='06a3907a6eb48f9ae525d6faada26492', EventValue='{"uuid":"06a3907a6eb48f9ae525d6faada26492","user_eta":"68.8892899","lon":"37.739079584255606","jams_eta":"58.656105","actual":"0","source_lat":"55.692526027080412","expected_from_start":"992.07782","time":"1460193979","expected":"326.970703","source_lon":"37.717636999552184","length_from_start":"3437.74194","actual_length":"1.04742432","lat":"55.67545548575265","time_from_start":"603","route_start_time":"1460193375","rest_length":"436.81601","log_version":"1"}', LocationSpeed='5', _stbx='rt3.myt--mobmetrika--metrika-mobile-log:1:59877314', EventTimeOffset='29', StartTime='2016-04-09 12:25:49', EventNumber='11')
testdata_metrika_mobile.add_row(LocationDirection='319', LocationTimestamp='1460198917', _logfeller_timestamp=1460188161, DeviceID='00002907a397aea15dbfbdcf0472a131', SessionType='SESSION_FOREGROUND', Latitude='55.691262208908505', ParsedParams_Quantity='[1,1,1,1,1,1]', UUIDHash='16635953734884673029', StartDate='2016-04-09', iso_eventtime='2016-04-09 13:49:21', StartTimestamp='1460198688', DeviceIDHash='18004102793236826873', SessionID='1460198688', timestamp_raw='2016-04-09 10:49:21', DeviceIDSessionIDHash='5325128537412814', ClientIP='31.173.80.26', SendTimestamp='1460198961', source_uri='prt://mobmetrika@mtcalclog01f.yandex.ru/opt/statbox_export_mobile/mobile-events.log', LocationAltitude='140', ReceiveTimestamp='1460198961', Longitude='37.86174863580415', NetworkType='LTE', EventName='route', ClientPort='59791', ParsedParams_ValueDouble='[1460198940,0,55.692026256505315,37.858926382791005,1,1460198940]', UUID='06a3907a6eb48f9ae525d6faada26492', EventValue='{"time":"1460198940","uuid":"06a3907a6eb48f9ae525d6faada26492","lat":"55.692026256505308","lon":"37.858926382791012","log_version":"1","route_start_time":"1460198940"}', LocationSpeed='4', _stbx='rt3.myt--mobmetrika--metrika-mobile-log:5:61419894', EventTimeOffset='251', StartTime='2016-04-09 13:44:48', EventNumber='52')
# vmetro
testdata_metrika_mobile_private.add_row(ADVID='e69067fa-c05b-41d3-a174-f8f48ffeb273', ClientPort='13619', AppBuildNumber='14410', RegionID='57', _logfeller_timestamp=1477111148, DeviceID="00002907a397aea15dbfbdcf0472a4c0", LocationPrecision='1415', SendTimestamp='1477121993', APIKey='1', StartTimestamp='1476677640', NetworksInterfaces_Names=mobile_metrika_mac_names, timestamp_raw='2016-10-22 07:39:08', EventValueJsonReference='{0:"0",1:"1",2:"2",3:"3"}', Longitude='69.54017639160156', LocationSource='LBS', OSVersion='4.4.2', RegionTimeZone='18000', ParsedParams_ValueDouble='[0,2190352,2190351,0]', UUID='0ef2efbfac05d8dab5c2ae03e3f2c335', Cells_AreConnected='[1]', ScreenDPI='320', KitVersion='242', Cells_CellsIDs='[145192169]', SimCards_OperatorsNames="['MTS RUS']", ScreenHeight='720', EventDateTime='2016-10-17 07:14:00', Latitude='60.79316329956055', UUIDHash='8995892949402421839', DeviceIDHash='17322002208583983493', Cells_OperatorsNames="['MTS RUS']", OperatorName='MTS RUS', Cells_Types='[DEFAULT]', source_uri='prt://mobmetrika@2a02:6b8:0:1409:1908:8d:76ff:9589unknown', AppID='com.yandex.store', SendTimeZone='18000', StartTime='2016-10-17 07:14:00', OriginalModel='Lenovo A5000', ParsedParams_Quantity='[1,1,1,1]', StartDate='2016-10-17', Cells_CountriesCodes='[250]', SimCards_IccIDs='['']', AppPlatform='android', Cells_OperatorsIDs='[1]', EventTimestamp='1476677640', DeviceIDSessionIDHash='6642200614567676267', ScreenWidth='1280', Manufacturer='Lenovo', ReceiveTimestamp='1477121948', EventName='dev_enable_report_for_com.yandex.store:courier', SimCards_AreRoaming='[0]', NetworksInterfaces_Macs=mobile_metrika_macs, SimCards_OperatorsIDs='[1]', Cells_SignalsStrengths='[0]', EventValue='{"system_store":"false","billing_clid":"2190352","startup_clid":"2190351","uuid":"0ef2efbfac05d8dab5c2ae03e3f2c335"}', NetworkType='HSPA', StartTimeZone='18000', Cells_PhysicalsCellsIDs='[0]', SessionID='1476677640', EventTimeZone='18000', ClientIP='::ffff:85.140.77.250', ReceiveDate='2016-10-22', OriginalManufacturer='LENOVO', SimCards_CountriesCodes='[250]', AndroidID='f9177c09de09ef35', Model='Lenovo A5000', AppVersionName='2.40', EventID='7469777601410670132', iso_eventtime='2016-10-22 10:39:08', ClientKitVersion='150', Cells_Lacs='[8605]', EventDate='2016-10-17')

# for postback/appsflyer indevice matching:
testdata_metrika_mobile.add_row(UUIDHash='16635953734884555555', DeviceIDHash='18004102793236555555', ClientIP='217.13.91.184', _logfeller_timestamp=1460216367, DeviceID="00002907a397aea15dbfbdcf0472a112", OriginalDeviceID='a89223ba-0a98-4881-8913-c40205a5009e', UUID='06a3907a6eb48f9ae525d66555555555', OriginalManufacturer='LENOVO', Model='Lenovo A5000', AppID='com.yandex.store2')
testdata_metrika_mobile_private.add_row(UUIDHash='16635953734884666666', DeviceIDHash='18004102793236666666', ClientIP='217.13.91.184', _logfeller_timestamp=1460216367, DeviceID="00002907a397aea15dbfbdcf0472a112", OriginalDeviceID='c994d77e-03e0-45ac-98a2-8ea855b58cee', UUID='06a3907a6eb48f9ae525d6f666666666', OriginalManufacturer='LENOVO', Model='Lenovo A5000', AppID='com.yandex.store2')
testdata_metrika_mobile.add_row(UUIDHash='16635953734887777777', DeviceIDHash='18004102793236777777', ClientIP='217.13.91.184', _logfeller_timestamp=1460216367, DeviceID="00002907a397aea15dbfbdcf0472a113", OriginalDeviceID='BCEBAF09-2534-4027-B89A-BCCE1F1AB43A', UUID='06a3907a6eb48f9ae525d6f777777777', OriginalManufacturer='LENOVO', Model='Lenovo A5000', AppID='com.yandex.store2')
testdata_metrika_mobile_private.add_row(UUIDHash='16635953734888888888', DeviceIDHash='18004102793238888888', ClientIP='217.13.91.184', _logfeller_timestamp=1460216367, DeviceID="00002907a397aea15dbfbdcf0472a113", OriginalDeviceID='45B383F0-AA86-41A9-B171-BB18EBAA8B32', UUID='06a3907a6eb48f9ae525d6f888888888', OriginalManufacturer='LENOVO', Model='Lenovo A5000', AppID='com.yandex.store2')

testdata_metrika_mobile.add_row(_date="2016-04-10", ClientPort="53102", _logfeller_timestamp=1397121911, DeviceID="00002907a397aea15dbfbdcf0472a114", RegionID="2", SessionType="SESSION_FOREGROUND", SendTimestamp="1460232486", EventType="EVENT_CLIENT", StartTimestamp="1460232384", DeviceIDSessionIDHash="13388320046212577130", ClientIP="85.174.38.23", OriginalDeviceID='70F890A4-C735-46D4-AD93-98D7C26E9110', source_uri="prt://mobmetrika@mtcalclog03e.yandex.ru/opt/statbox_export_mobile/mobile-events.log", ReceiveTimestamp="1460232384", ConnectionType="CONN_CELL", _stbx="rt3.sas--mobmetrika--metrika-mobile-log:", LocationSource="MISSING", EventName="aaa", iso_eventtime="2016-04-09 23:06:24", StartTime="2016-04-09 23:06:24", NetworkType="Hspa+")
testdata_metrika_mobile_private.add_row(_date="2016-04-10", ClientPort="53102", _logfeller_timestamp=1397120711, DeviceID="00002907a397aea15dbfbdcf0472a114", RegionID="2", SessionType="SESSION_FOREGROUND", SendTimestamp="1460232486", EventType="EVENT_CLIENT", StartTimestamp="1460232384", DeviceIDSessionIDHash="13388320046212577130", ClientIP="85.174.38.23", OriginalDeviceID='70F890A4-C735-46D4-AD93-98D7C26E9110', source_uri="prt://mobmetrika@mtcalclog03e.yandex.ru/opt/statbox_export_mobile/mobile-events.log", ReceiveTimestamp="1460232384", ConnectionType="CONN_CELL", _stbx="rt3.sas--mobmetrika--metrika-mobile-log:", LocationSource="MISSING", EventName="bbb", iso_eventtime="2016-04-09 23:06:24", StartTime="2016-04-09 23:06:24", NetworkType="Hspa+")
testdata_metrika_mobile.add_row(_date="2016-04-10", ClientPort="46553", _logfeller_timestamp=1397122631, DeviceID="00002907a397aea15dbfbdcf0472a114", RegionID="109773", LocationPrecision="140", SessionType="SESSION_BACKGROUND", Latitude="59.699615478515625", LAC="19667", SendTimestamp="1460199437", Wifi_Ssids="['NETGEAR','Daikiri','teyla141','uhbotyrj','dlink']", EventType="EVENT_CLIENT", StartTimestamp="1460199335", SessionID="1460199437", DeviceIDSessionIDHash="12884243185795069733", ClientIP="85.174.38.33", source_uri="prt://mobmetrika@mtcalclog06e.yandex.ru/opt/statbox_export_mobile/mobile-events.log", timestamp_raw="2016-04-09 10:55:35", ReceiveTimestamp="1460199335", Longitude="30.101322174072266", _stbx="rt3.iva--mobmetrika--metrika-mobile-log:", Wifi_Macs="['74440173648A','C8D3A34969B2','90F65279A786','F8C09114EEEB','84C9B259D12E']", LocationSource="LBS", CellID="6102", ConnectionType="CONN_WIFI", EventName="Application is starting", iso_eventtime="2016-04-09 13:55:35", StartTime="2016-04-09 13:55:35", NetworkType="Wifi", Wifi_SignalsStrengths="[-52,-71,-73,-78,-79]")
testdata_metrika_mobile_private.add_row(_date="2016-04-10", ClientPort="53102", _logfeller_timestamp=1397126231, DeviceID="00002907a397aea15dbfbdcf0472a115", RegionID="2", SessionType="SESSION_FOREGROUND", SendTimestamp="1460232486", EventType="EVENT_CLIENT", StartTimestamp="1460232384", DeviceIDSessionIDHash="13388320046212577130", ClientIP="85.174.38.33", OriginalDeviceID='70F890A4-C735-46D4-AD93-98D7C26E9210', source_uri="prt://mobmetrika@mtcalclog03e.yandex.ru/opt/statbox_export_mobile/mobile-events.log", ReceiveTimestamp="1460232384", ConnectionType="CONN_CELL", _stbx="rt3.sas--mobmetrika--metrika-mobile-log:", LocationSource="MISSING", EventName="ccc", iso_eventtime="2016-04-09 23:06:24", StartTime="2016-04-09 23:06:24", NetworkType="Hspa+")
testdata_metrika_mobile.add_row(_date="2016-04-10", ClientPort="46553", _logfeller_timestamp=1397126711, DeviceID="00002907a397aea15dbfbdcf0472a115", RegionID="109773", LocationPrecision="140", SessionType="SESSION_BACKGROUND", Latitude="59.699615478515625", LAC="19667", SendTimestamp="1460199437", Wifi_Ssids="['NETGEAR','Daikiri','teyla141','uhbotyrj','dlink']", EventType="EVENT_CLIENT", StartTimestamp="1460199335", SessionID="1460199437", DeviceIDSessionIDHash="12884243185795069733", source_uri="prt://mobmetrika@mtcalclog06e.yandex.ru/opt/statbox_export_mobile/mobile-events.log", timestamp_raw="2016-04-09 10:55:35", ReceiveTimestamp="1460199335", Longitude="30.101322174072266", _stbx="rt3.iva--mobmetrika--metrika-mobile-log:", Wifi_Macs="['74440173648A','C8D3A34969B2','90F65279A786','F8C09114EEEB','84C9B259D12E']", LocationSource="LBS", CellID="6102", ConnectionType="CONN_WIFI", EventName="Application is starting", iso_eventtime="2016-04-09 13:55:35", StartTime="2016-04-09 13:55:35", NetworkType="Wifi", Wifi_SignalsStrengths="[-52,-71,-73,-78,-79]")

testdata_metrika_mobile_private.add_row(_date="2016-04-09", ClientPort="33872", _logfeller_timestamp=1397040311, DeviceID="00002907a397aea15dbfbdcf0472a116", RegionID="10174", SessionType="SESSION_BACKGROUND", LAC="19667", SendTimestamp="1460179390", EventType="EVENT_CLIENT", StartTimestamp="1460151600", SessionID="1460151600", DeviceIDSessionIDHash="5394072551234437647", ClientIP="31.173.80.26", source_uri="prt://mobmetrika@mtcalclog01f.yandex.ru/opt/statbox_export_mobile/mobile-events.log", timestamp_raw="2016-04-09 05:21:28", ReceiveTimestamp="1460179288", ConnectionType="CONN_CELL", _stbx="rt3.myt--mobmetrika--metrika-mobile-log:", LocationSource="MISSING", CellID="6102", EventName="Application is starting", iso_eventtime="2016-04-09 08:21:28", StartTime="2016-04-09 00:40:00")
testdata_metrika_mobile.add_row(_date="2016-04-09", UUIDHash='16635953734884673029', _logfeller_timestamp=1397036711, DeviceID="00002907a397aea15dbfbdcf0472a116", DeviceIDHash='18004102793236826873')
testdata_metrika_mobile_private.add_row(_date="2016-04-09", UUIDHash='16635953734884673029', _logfeller_timestamp=1397035511, DeviceID="00002907a397aea15dbfbdcf0472a117", DeviceIDHash='18004102793236826873', OriginalDeviceID='70F890A4-C735-46D4-AD93-98D7C26E90D2')
testdata_metrika_mobile.add_row(_date="2016-04-09", UUIDHash='16635953734884673029', _logfeller_timestamp=1397034671, DeviceID="00002907a397aea15dbfbdcf0472a117", DeviceIDHash='18004102793236826873', ClientIP='31.173.80.25', OriginalDeviceID='70F890A4-C735-46D4-AD93-98D7C26E90E3', UUID='06a3907a6eb48f9ae525d6faada22222')

#did access
testdata_metrika_mobile_private.add_row(UUIDHash='16635953734884673020', DeviceIDHash='4451492610968249451', _logfeller_timestamp=1460216367, DeviceID='53b84e78dbf8e7aa77ac092137057bc1', ClientIP='91.173.80.25', OriginalDeviceID='11b22432-0112-4234-a353-c3e98c8baae1')
testdata_metrika_mobile.add_row(UUIDHash='16635953734884673020', DeviceIDHash='4451492610968249452', _logfeller_timestamp=1460216367, DeviceID='53b84e78dbf8e7aa77ac092137057bc2', ClientIP='91.173.80.25', OriginalDeviceID='11b22432-0112-4234-a353-c3e98c8baae2')
testdata_metrika_mobile_private.add_row(UUIDHash='16635953734884673020', DeviceIDHash='4451492610968249453', _logfeller_timestamp=1460216367, DeviceID='53b84e78dbf8e7aa77ac092137057bc3', ClientIP='91.173.80.25', OriginalDeviceID='11b22432-0112-4234-a353-c3e98c8baae3')
testdata_metrika_mobile.add_row(UUIDHash='16635953734884673020', DeviceIDHash='4451492610968249454', _logfeller_timestamp=1460216367, DeviceID='53b84e78dbf8e7aa77ac092137057bc4', ClientIP='91.173.80.25', OriginalDeviceID='11b22432-0112-4234-a353-c3e98c8baae4')

#did wathc-log
testdata_metrika_mobile_private.add_row(UUIDHash='16635953734884673020', DeviceIDHash='4451492610968249451', _logfeller_timestamp=1460216367, DeviceID='886f3cd0a0fa93a19f9d35362dcc111d', ClientIP='91.173.80.25', OriginalDeviceID='11b22432-0112-4234-a353-c3e98c8baae5')
testdata_metrika_mobile.add_row(UUIDHash='16635953734884673020', DeviceIDHash='4451492610968249452', _logfeller_timestamp=1460216367, DeviceID='886f3cd0a0fa93a19f9d35362dcc222d', ClientIP='91.173.80.25', OriginalDeviceID='11b22432-0112-4234-a353-c3e98c8baae6')
testdata_metrika_mobile_private.add_row(UUIDHash='16635953734884673020', DeviceIDHash='4451492610968249453', _logfeller_timestamp=1460216367, DeviceID='886f3cd0a0fa93a19f9d35362dcc333d', ClientIP='91.173.80.25', OriginalDeviceID='11b22432-0112-4234-a353-c3e98c8baae7')
testdata_metrika_mobile.add_row(UUIDHash='16635953734884673020', DeviceIDHash='4451492610968249454', _logfeller_timestamp=1460216367, DeviceID='886f3cd0a0fa93a19f9d35362dcc444d', ClientIP='91.173.80.25', OriginalDeviceID='11b22432-0112-4234-a353-c3e98c8baae8')

testdata_webvisor_dates_processed = BaseLog(
    path="//crypta/production/state/webvisor_date_processed",
    date="2016-04-09",
    default_data=WEBVISOR_DATES_PROCESSED_LOG
)
testdata_webvisor_dates_processed.add_row(domain="uslugi.tatarstan.ru", yuid="1000052961445886879")
testdata_webvisor_dates_processed.add_row(domain="www.dszn.ru", bad_value="True", field_id="birthDate", field_name="birthDate", url="http://www.dszn.ru/vouchers-for-sanatorium-and-spa-treatment.php", ts="1474454184", id_value="19.11.1941", yuid="100028031468503693")
testdata_webvisor_dates_processed.add_row(domain="pass.rzd.ru", field_id="dp1474449617355", field_name="birthdate", url="https://pass.rzd.ru/ticket/secure/ru?STRUCTURE_ID=735&layer_id=5374&refererLayerId=5372", ts="1474449640", id_value="05.04.1960", yuid="1000336971470150294")
testdata_webvisor_dates_processed.add_row(domain="pass.rzd.ru", field_id="date0", url="https://pass.rzd.ru/timetable/public/ru?STRUCTURE_ID=735", ts="1474452292", id_value="24.09.2016", yuid="1000336971470150294")
testdata_webvisor_dates_processed.add_row(domain="pgu.mos.ru", bad_value="True", field_id="dp1474443863219", field_name="field[birthday]", url="https://pgu.mos.ru/ru/application/dzm/clinic_reg/", ts="1474443869", id_value="02.11.2004", yuid="100037551450724851")
testdata_webvisor_dates_processed.add_row(_date="2016-04-10", domain="pass.rzd.ru", field_id="dp1474452565004", field_name="birthdate", url="https://pass.rzd.ru/ticket/secure/ru?STRUCTURE_ID=735&layer_id=5374&refererLayerId=5372", ts="1474452594", id_value="16.10.1958", yuid="1000076611384929726")
testdata_webvisor_dates_processed.add_row(_date="2016-04-10", ddomain="cp-hosting.jino.ru", bad_value="True", field_id="stats-restable-startdate", url="https://cp-hosting.jino.ru/statistics/resources/", ts="1474453687", id_value="21.09.2015", yuid="1000135441314006138")
testdata_webvisor_dates_processed.add_row(_date="2016-04-10", ddomain="pyrus.com", url="https://pyrus.com/t#uf84025", ts="1474448161", id_value="11.07.1971", yuid="1000242611468484359")
testdata_webvisor_dates_processed.add_row(_date="2016-04-10", ddomain="www.webmath.ru", bad_value="True", field_id="deadline", field_name="deadline", url="http://www.webmath.ru/poleznoe/formules8.php", ts="1474454880", id_value="28.09.2016", yuid="100024841469084303")
testdata_webvisor_dates_processed.add_row(_date="2016-04-10", ddomain="lardi-trans.com", bad_value="True", field_id="id_date_to", field_name="date_to", url="https://lardi-trans.com/log/mygruztrans/edit_gruz/?edit=226979725", ts="1474457679", id_value="22.09.2016", yuid="1000276241422830684")
testdata_webvisor_dates_processed.add_row(_date="2016-04-11", ddomain="arteclair.com", bad_value="True", field_id="cart-order_form-delivery-date", field_name="delivery_date", url="http://arteclair.com/ru/", ts="1474456592", id_value="22.09.2016", yuid="1000633551466546965")
testdata_webvisor_dates_processed.add_row(_date="2016-04-11", domain="pgu.mos.ru", bad_value="True", field_id="dp1474449125853", field_name="field[birthday]", url="https://pgu.mos.ru/ru/application/dzm/clinic_reg/", ts="1474449156", id_value="22.10.2010", yuid="1000658411430215967")
testdata_webvisor_dates_processed.add_row(_date="2016-04-11", domain="www.bilesuserviss.lv", bad_value="True", url="http://www.bilesuserviss.lv/", ts="1474450381", id_value="15.10.2016", yuid="1000740161467295104")
testdata_webvisor_dates_processed.add_row(_date="2016-04-11", domain="www.medexpress.ru", field_id="form_date_55KpYjiH", field_name="form_date_12", url="http://www.medexpress.ru/write_to_the_doctor/", ts="1474453902", id_value="19.10.1990", yuid="1000782461456258353")
testdata_webvisor_dates_processed.add_row(_date="2016-04-11", domain="babadu.ru", field_name="flat", url="http://babadu.ru/personal/order/make_new/", ts="1474450481", id_value="01.09.2012", yuid="1000812011440151892")
testdata_webvisor_dates_processed.add_row(_date="2016-04-11", domain="babadu.ru", field_name="flat", url="http://babadu.ru/personal/order/make_new/", ts="1474450481", id_value="01.09.2012", yuid="1000812011440151892")
testdata_webvisor_dates_processed.add_row(_date="2016-04-11", domain="www.webmath.ru", bad_value="True", field_id="deadline", field_name="deadline", url="http://www.webmath.ru/poleznoe/formules_3_1.php", ts="1474449168", id_value="28.09.2016", yuid="1000868701438870100")
testdata_webvisor_dates_processed.add_row(_date="2016-04-11", domain="www.mathforyou.net", bad_value="True", field_id="deadline", field_name="deadline", url="http://www.mathforyou.net/Calculator.html", ts="1474447771", id_value="28.09.2016", yuid="1000896921423999591")
testdata_webvisor_dates_processed.add_row(_date="2016-04-11", domain="pgu.mos.ru", bad_value="True", field_id="dp1474449313296", field_name="field[birthday]", url="https://pgu.mos.ru/ru/application/dzm/clinic_reg/", ts="1474449338", id_value="14.07.2006", yuid="1000989691449425963")
testdata_webvisor_dates_processed.add_row(_date="2016-04-11", domain="pgu.mos.ru", bad_value="True", field_id="dp1474449531845", field_name="field[birthday]", url="https://pgu.mos.ru/ru/application/dzm/clinic_reg/", ts="1474449557", id_value="14.07.2006", yuid="1000989691449425963")

testdata_people_search_dict = BaseLog(
    path="//home/freshness/crypta",
    table_name="users_birth_dates",
    default_data=PEOPLE_SEARCH_DICT
)
testdata_people_search_dict.add_row(key="id517155", value="{\"date\":\"19760830\","
                                                          "\"dateType\":\"from date\"," +
                                                          "\"gender\":\"f\",\"login\":\"\","
                                                          "\"mobile\":[\"+79522522222\"],"
                                                          "\"network\":\"vk\","
                                                          "\"profileID\":\"id517155\","
                                                          "\"url\":\"https://vk.com/id517155\"}")

testdata_vk_profiles_dump = BaseLog(
    path="//crypta/production/state/graph/dicts",
    table_name="profiles",
    default_data=VK_PROFILES_DUMP
)
testdata_vk_profiles_dump.add_row(id_value="id67677184")

testdata_yamoney = BaseLog(
    path="//crypta/production/state/graph/dicts/yamoney",
    table_name="yamoney_in_v2",
    default_data=YAMONEY_LOG
)
testdata_yamoney.add_row(id_type=1)
testdata_yamoney.add_row(id_type=2)
testdata_yamoney.add_row(id_type=3)
testdata_yamoney.add_row(id_type=4)
testdata_yamoney.add_row(id_type=5, id_value='17501517')    # puid
testdata_yamoney.add_row(id_type=6, id_value='321')    # yuid
testdata_yamoney.add_row(id_type=7, yamoney_id=888)
testdata_yamoney.add_row(id_type=1, id_value='bbb')
testdata_yamoney.add_row(id_type=2, id_value='bbb')
testdata_yamoney.add_row(id_type=5, id_value='17501517')    # puid
testdata_yamoney.add_row(id_type=6, id_value='456', yamoney_id=777)    # yuid
testdata_yamoney.add_row(id_type=7, yamoney_id=777)

testdata_yamoney_phone = BaseLog(
    path="//crypta/production/state/graph/dicts/yamoney",
    table_name="yamoney_phone_payment",
    default_data=YAMONEY_PHONE_LOG
)
testdata_yamoney_phone.add_row(phone="9034568763")

testdata_dev_yuid_indevice_perfect_no_limit = BaseLog(
    path="//crypta/production/state/graph/dicts",
    table_name="dev_yuid_indevice_perfect_no_limit",
    default_data=DEV_YUID_INDEVICE_PERFECT_NO_LIMIT
)
testdata_dev_yuid_indevice_perfect_no_limit.add_row(date="2016-03-01", devid="BA5EBA5E-0000-0000-0000-AAAAAAAA0001", mmetric_devid="BA5EBA5E-0000-0000-0000-BBBBBBBB0001", yuid="1111111111465915146")
testdata_dev_yuid_indevice_perfect_no_limit.add_row(date="2016-04-01", devid="BA5EBA5E-0000-0000-0000-AAAAAAAA0002", mmetric_devid="BA5EBA5E-0000-0000-0000-BBBBBBBB0002", yuid="1111111112465915146", yuid_browser="mobilesafari")
testdata_dev_yuid_indevice_perfect_no_limit.add_row(date="2016-04-08", devid="BA5EBA5E-0000-0000-0000-AAAAAAAA0003", mmetric_devid="BA5EBA5E-0000-0000-0000-BBBBBBBB0003", yuid="1111111113465915146")
testdata_dev_yuid_indevice_perfect_no_limit.add_row(date="2016-04-09", devid="BA5EBA5E-0000-0000-0000-AAAAAAAA0004", mmetric_devid="BA5EBA5E-0000-0000-0000-BBBBBBBB0004", yuid="1111111114465915146", yuid_browser="mobilesafari")

testdata_mob_report = BaseLog(
    path="//home/logfeller/logs/mobreport-access-log/1d",
    date="2016-04-11",
    default_data=MOB_REPORT_LOG
)
testdata_mob_report.add_row(user_agent=ANDROID_HTC, vhost="mobile.yandex.net")
testdata_mob_report.add_row(user_agent=ANDROID_UA, vhost="mobile.chtota.net")
testdata_mob_report.add_row(user_agent=IPHONE_UA, vhost="mobile.drugoe.net")
testdata_mob_report.add_row(_date="2016-04-10", user_agent=ANDROID_HTC, vhost="mobile.yandex.net")
testdata_mob_report.add_row(_date="2016-04-10", user_agent=ANDROID_UA, vhost="mobile.chtota.net")
testdata_mob_report.add_row(_date="2016-04-10", user_agent=IPHONE_UA, vhost="mobile.drugoe.net")
testdata_mob_report.add_row(_date="2016-04-09", user_agent=ANDROID_HTC, vhost="mobile.yandex.net")
testdata_mob_report.add_row(_date="2016-04-09",user_agent=ANDROID_UA, vhost="mobile.chtota.net")
testdata_mob_report.add_row(_date="2016-04-09", user_agent=IPHONE_UA, vhost="mobile.drugoe.net")


testdata_cube_log = BaseLog(
    path="//statbox/cube/data/mobile_install",
    date="2016-04-11",
    default_data=CUBE_LOG
)
testdata_cube_log.add_row(device_id="e1b4316203309f329438048ddd54f112", platform="Android")
testdata_cube_log.add_row(device_id="30EDAB1F-92E1-47A8-A95E-A0674B36A4BA")
testdata_cube_log.add_row(device_id="BA5EBA5E-0000-0000-0000-BBBBBBBB0002")

testdata_puid_login_dict = BaseLog(
    path="//crypta/production/state/graph/dicts/passport",
    table_name="puid_login",
    default_data=PUID_LOGIN_DICT_LOG
)
testdata_puid_login_dict.add_row(id_value="6661", login="6661aaa")

testdata_postclick_log = BaseLog(
    path="//home/logfeller/logs/metrika-postclicks-log/1d",
    date="2016-04-11",
    default_data=POSTCLICK_LOG
)
testdata_postclick_log.add_row(UserID="1000011459458000", ExtPostBack="advertising_id=c994d77e-03e0-45ac-98a2-8ea855b58cee")
testdata_postclick_log.add_row(UserID="1000021459458000", ExtPostBack="mat-id=1", IDFA="BCEBAF09-2534-4027-B89A-BCCE1F1AB43A")
testdata_postclick_log.add_row(UserID="1000031459458000", ExtPostBack="adjust-adid=de9433b54a98c8dc482b85600a458ece&idfa=45B383F0-AA86-41A9-B171-BB18EBAA8B32", IDFA="45B383F0-AA86-41A9-B171-BB18EBAA8B32")
testdata_postclick_log.add_row(UserID="1000041459458000", ExtPostBack="advertising_id=c994d77e-03e0-45ac-98a2-8ea855b58cee", _date="2016-04-10")
testdata_postclick_log.add_row(UserID="1000011459458000", ExtPostBack="advertising_id=c994d77e-03e0-45ac-98a2-8ea855b58cee", _date="2016-04-09")

"advertising_id=c994d77e-03e0-45ac-98a2-8ea855b58cee"

testdata_yuid_with_all = BaseLog(
    path="//crypta/production/state/graph/dicts",
    table_name="yuid_with_all",
    default_data=YUID_WITH_ALL,
    append=True
)

testdata_yuid_with_all.add_row(yuid=vmetro_yuid1, key=vmetro_yuid1,
                               all_dates=['2016-04-10'])
testdata_yuid_with_all.add_row(yuid=vmetro_yuid2, key=vmetro_yuid2,
                               all_dates=['2016-04-10'])
testdata_yuid_with_all.add_row(yuid="157564101446625111", key="157564101446625111", yandexuid=157564101446625111, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="157564101446625112", key="157564101446625112", yandexuid=157564101446625112, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="157564101446625113", key="157564101446625113", yandexuid=157564101446625113, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="157564101446625114", key="157564101446625114", yandexuid=157564101446625114, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="157564101446625121", key="157564101446625121", yandexuid=157564101446625121, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="157564101446625122", key="157564101446625122", yandexuid=157564101446625122, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="157564101446625123", key="157564101446625123", yandexuid=157564101446625123, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="157564101446625124", key="157564101446625124", yandexuid=157564101446625124, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])

# ditmsk
testdata_yuid_with_all.add_row(yuid="1907967751360172097", key="1907967751360172097", yandexuid=1907967751360172097, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="3502086411377199278", key="3502086411377199278", yandexuid=3502086411377199278, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="1817745901457477516", key="1817745901457477516", yandexuid=1817745901457477516, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="7086307901319910628", key="7086307901319910628", yandexuid=7086307901319910628, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="8493830551509391626", key="8493830551509391626", yandexuid=8493830551509391626, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])

#did
testdata_yuid_with_all.add_row(yuid="222221455549999", ua_profile="m|phone|apple|ios|9.3.1", key="222221455549999", yandexuid=222221455549999, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="222221455548889", ua_profile="m|phone|apple|ios|9.3.1", key="222221455548889", yandexuid=222221455548889, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="222221455548887", ua_profile="m|phone|apple|ios|9.3.1", key="222221455548887", yandexuid=222221455548887, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="222221455548886", ua_profile="m|phone|apple|ios|9.3.1", key="222221455548886", yandexuid=222221455548886, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="222221455549991", ua_profile="m|phone|apple|ios|9.3.1", key="222221455549991", yandexuid=222221455549991, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="222221455548884", ua_profile="m|phone|apple|ios|9.3.1", key="222221455548884", yandexuid=222221455548884, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="2410530891459150418", ua_profile="m|phone|apple|ios|9.3.1", key="2410530891459150418", yandexuid=2410530891459150418, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="2410530891459150411", ua_profile="m|phone|apple|ios|9.3.1", key="2410530891459150411", yandexuid=2410530891459150411, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="2410530891459150413", ua_profile="m|phone|apple|ios|9.3.1", key="2410530891459150413", yandexuid=2410530891459150413, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])
testdata_yuid_with_all.add_row(yuid="2410530891459150414", ua_profile="m|phone|apple|ios|9.3.1", key="2410530891459150414", yandexuid=2410530891459150414, all_dates=['2016-04-10'], good=True, yuid_creation_date=["2016-02-10"])


testdata_dev_info_yt = BaseLog(
    path="//crypta/production/state/graph/dicts",
    table_name="dev_info_yt",
    default_data={},
    append=True
)
testdata_dev_info_yt.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae1", subkey="9223372035394559440", locale="ru-RU", device_type="phone", manufacturer="Apple", dates=["2016-04-11"], mmetric_devids="53b84e78dbf8e7aa77ac092137057bc1", os_version="9.3.1", ua_profile="m|phone|apple|ios|9.3.1")
testdata_dev_info_yt.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae2", subkey="9223372035394559441", locale="ru-RU", device_type="phone", manufacturer="Apple", dates=["2016-04-11"], mmetric_devids="53b84e78dbf8e7aa77ac092137057bc2", os_version="9.3.1", ua_profile="m|phone|apple|ios|9.3.1")
testdata_dev_info_yt.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae3", subkey="9223372035394559442", locale="ru-RU", device_type="phone", manufacturer="Apple", dates=["2016-04-11"], mmetric_devids="53b84e78dbf8e7aa77ac092137057bc3", os_version="9.3.1", ua_profile="m|phone|apple|ios|9.3.1")
testdata_dev_info_yt.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae4", subkey="9223372035394559443", locale="ru-RU", device_type="phone", manufacturer="Apple", dates=["2016-04-11"], mmetric_devids="53b84e78dbf8e7aa77ac092137057bc4", os_version="9.3.1", ua_profile="m|phone|apple|ios|9.3.1")
testdata_dev_info_yt.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae5", subkey="9223372035394559444", locale="ru-RU", device_type="phone", manufacturer="Apple", dates=["2016-04-11"], mmetric_devids="886f3cd0a0fa93a19f9d35362dcc111d", os_version="9.3.1", ua_profile="m|phone|apple|ios|9.3.1")
testdata_dev_info_yt.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae6", subkey="9223372035394559445", locale="ru-RU", device_type="phone", manufacturer="Apple", dates=["2016-04-11"], mmetric_devids="886f3cd0a0fa93a19f9d35362dcc222d", os_version="9.3.1", ua_profile="m|phone|apple|ios|9.3.1")
testdata_dev_info_yt.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae7", subkey="9223372035394559446", locale="ru-RU", device_type="phone", manufacturer="Apple", dates=["2016-04-11"], mmetric_devids="886f3cd0a0fa93a19f9d35362dcc333d", os_version="9.3.1", ua_profile="m|phone|apple|ios|9.3.1")
testdata_dev_info_yt.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae8", subkey="9223372035394559447", locale="ru-RU", device_type="phone", manufacturer="Apple", dates=["2016-04-11"], mmetric_devids="886f3cd0a0fa93a19f9d35362dcc444d", os_version="9.3.1", ua_profile="m|phone|apple|ios|9.3.1")


testdata_fuzzy_pairs = BaseLog(
    path="//crypta/production/state/prob-match",
    table_name="fuzzy_pairs_new",
    default_data=FUZZY_PAIRS,
    append=True
)

testdata_fuzzy_pairs.add_row(key="1848943511472921939_2398601481472645944")
testdata_fuzzy_pairs.add_row(key="1848943511472921939_2947837971475153894")
testdata_fuzzy_pairs.add_row(key="1858634981507855058_2357030971503056244")
testdata_fuzzy_pairs.add_row(key="1858634981507855058_8941621311501339324")
testdata_fuzzy_pairs.add_row(key="1858634981507855058_8941621311501339321")
testdata_fuzzy_pairs.add_row(key="1858635341510640946_6573432031508304404")


testdata_smart_tv_hh_pairs = BaseLog(
    path="//crypta/production/state/household2",
    table_name="smart_tv_main_yuid_pairs",
    default_data=SMART_TV_HH_PAIRS,
    append=True
)

testdata_smart_tv_hh_pairs.add_row(key="9241143761485719852_5700033171489675851")
testdata_smart_tv_hh_pairs.add_row(key="477033511460432954_1189993281430458011")
testdata_smart_tv_hh_pairs.add_row(key="9945291071518258430_1205825021490147615")


testdata_crypta_profiles_log = BaseLog(
    path="//statbox/crypta-yandexuid-profiles-log",
    date="2016-04-10",
    default_data=CRYPTA_YANDEXUID_PROFILES_LOG,
)

testdata_crypta_profiles_log.add_row(yandexuid="9945291071518258430")

testdata_sdk_log = BaseLog(
    path="//statbox/mobile-redirect-bind-id-log",
    date="2016-04-11",
    default_data=MOBILE_REDIRECT_BIND_LOG
)

testdata_sdk_log.add_row(cookies="yandexuid=1380236561466524390",
                         host="redirect.appmetrica.yandex.ru",
                         uuid="6f46d7d80cf736a7d25ef6772268b91d",
                         timestamp="2016-06-21 15:53:10",
                         timezone="+0000",
                         device_id="EA9FCA74-3D03-4238-8C1F-E078326D0B05")
testdata_sdk_log.add_row(cookies="yandexuid=6436305441466524394",
                         host="redirect.appmetrica.yandex.ru",
                         uuid="3e2b6871964bb53513eacac621970e9b",
                         timestamp="2016-06-21 15:53:14",
                         timezone="+0000",
                         device_id="909F11DB-70C4-4376-9870-FCD52B0191ED")
testdata_sdk_log.add_row(cookies="yandexuid=6599231981466524395",
                         host="redirect.appmetrica.yandex.com",
                         uuid="47add5bfa456676d02ebfe7e6ed0543b",
                         timestamp="2016-06-21 15:53:15",
                         timezone="+0000",
                         device_id="ADCE9E39-D7E4-4CD8-B91D-1F3B8B6BA1BE")
testdata_sdk_log.add_row(_date="2016-04-09", cookies="yandexuid=5046511531466502940", iso_eventtime="2016-06-21 12:55:40", uuid="b9049bfd1046210096e086e55adb6b6b", timestamp="2016-06-21 09:55:40", device_id="A5E0873B-DCB6-48F7-9F52-6B7F8FD74193")
testdata_sdk_log.add_row(_date="2016-04-09", cookies="yandexuid=5046511531466502940", iso_eventtime="2016-06-21 12:55:40", uuid="b9049bfd1046210096e086e55adb6b6b", timestamp="2016-06-21 09:55:40", device_id="A5E0873B-DCB6-48F7-9F52-6B7F8FD74193")
testdata_sdk_log.add_row(_date="2016-04-09", cookies="yandexuid=6010993001466221174", iso_eventtime="2016-06-21 12:55:42", uuid="bcaced7ed952fb86e25903257248a8d4", timestamp="2016-06-21 09:55:42", device_id="11421A51-1B88-4F6A-8C9E-11DAE5B768B8")
testdata_sdk_log.add_row(_date="2016-04-10", cookies="yandexuid=5022275111466524406", iso_eventtime="2016-06-21 18:53:26", uuid="0b2be470b9ebeabc208fe7de8ec3c10b", timestamp="2016-06-21 15:53:26", host="redirect.appmetrica.yandex.com", device_id="E92D8B3B-1898-41F8-BB0F-8494C1EFACB0")
testdata_sdk_log.add_row(_date="2016-04-10", cookies="yandexuid=5022275111466524406", iso_eventtime="2016-06-21 18:53:26", uuid="0b2be470b9ebeabc208fe7de8ec3c10b", timestamp="2016-06-21 15:53:26", host="redirect.appmetrica.yandex.com", device_id="E92D8B3B-1898-41F8-BB0F-8494C1EFACB0")
testdata_sdk_log.add_row(_date="2016-04-10", cookies="yandexuid=9362623411466524410", iso_eventtime="2016-06-21 18:53:30", uuid="7e847460ed7643df08da0b2d49c586cb", timestamp="2016-06-21 15:53:30", host="redirect.appmetrica.yandex.ru", device_id="3C791CEB-7455-4147-9A8B-94E7FC580BED")


testdata_bb_storage = BaseLog(
    path="//crypta/production/profiles/export",
    table_name="profiles_for_14days",
    default_data={"yandexuid": 2291492277554,
                  "user_age_6s": {"25_34": 0.23375399999999998957, "0_17": 0.040821999999999997177,
                                  "18_24": 0.083685999999999996501, "55_99": 0.14966999999999999749,
                                  "45_54": 0.22475100000000000633, "35_44": 0.26731300000000002282},
                  "yandex_loyalty": 0.66666599999999998083, "lal_internal": None,
                  "age_segments": {"18_24": 0.083685999999999996501, "25_34": 0.23375399999999998957,
                                   "45_99": 0.37442199999999997706, "35_44": 0.26731300000000002282,
                                   "0_17": 0.040821999999999997177}, "multiclass_segments": None,
                  "heuristic_private": None, "heuristic_internal": None, "affinitive_sites": None,
                  "top_common_site_ids": [40298240, 452665600, 242914048], "search_fraudness": 0.0,
                  "update_time": 1492377501, "top_common_sites": None,
                  "probabilistic_segments": {"319": {"0": 0.8843469999999999942}, "101": {"0": 0.0},
                                             "304": {"0": 0.83724500000000001698},
                                             "316": {"0": 0.014184999999999999692},
                                             "315": {"0": 0.072932999999999997831}, "102": {"0": 0.0},
                                             "8": {"1": 0.66666599999999998083, "0": 0.33333299999999999041},
                                             "434": {"0": 0.36271999999999998687},
                                             "435": {"0": 0.54925699999999999523}}, "lal_common": None,
                  "lal_private": None, "interests_composite": None,
                  "gender": {"m": 0.51139100000000003998, "f": 0.48860799999999998677},
                  "marketing_segments": {"38": 1.0, "22": 1.0, "96": 1.0},
                  "income_segments": {"A": 0.13852200000000000624, "C": 0.38494499999999998163,
                                      "B": 0.47653200000000001113}, "interests_longterm": None,
                  "heuristic_segments": None, "yandex_services_visits": None, "heuristic_common": None,
                  "ado_lal": {"1458822180": 91, "1458822173": 89, "1458038003": 84, "1458822188": 90, "1458803677": 87,
                              "1458030781": 84, "1458803679": 90}}
)
testdata_bb_storage.add_row(yandexuid=6513755131454170183)
testdata_bb_storage.add_row(yandexuid=8487166031445176273, gender={"m": 0.11139100000000003998, "f": 0.88860799999999998677})
testdata_bb_storage.add_row(yandexuid=69038631452506392)

# for instagram-puid test
testdata_bb_storage.add_row(yandexuid=99900011459458000)
testdata_bb_storage.add_row(yandexuid=99900021459458000)


testdata_tickets = BaseLog(
    path="//home/afisha/alet/user_actions/production",
    table_name="ticket_orders_aletuid",
    default_data=TICKETS_ORDER_LOG
)

testdata_tickets.add_row(
    user_puid='38429802', user_yandexuid='651537761454077784', action_time=1473243114571,
    service_info={"created": 1473243114572, "updated": 1473243114573, "userInfo": {
        "email": "234234@mail2.ru", "phone": "+79853254553"}, "sessionInfo": {"sessionDate": 1473243114574}})
testdata_tickets.add_row(
    user_puid='93376855', user_yandexuid='7429618261455561583', action_time=1473243114571,
    service_info={"created": 1473243114571, "updated": 1473243114571, "userInfo": {
        "email": "", "phone": "+79853254553"}, "sessionInfo": {"sessionDate": 1473243114571}})
testdata_tickets.add_row(
    user_puid='2907844', user_yandexuid='1056316461383670897', action_time=1473233114571,
    service_info={"created": 1473233114571, "updated": 1473233114571, "userInfo": {
        "email": "sdfs@mail2.ru", "phone": ""}, "sessionInfo": {"sessionDate": 1473233114571}})
testdata_tickets.add_row(
    user_puid='73086412', user_yandexuid='6558487031447442276', action_time=1463233114571,
    service_info ={"created": 1463233114571, "updated": 1463233114571, "userInfo": {
        "email": "sfdf@yandex.ru", "phone": ""}, "sessionInfo": {"sessionDate": 1463233114571}})
testdata_tickets.add_row(
    user_puid='3940302', user_yandexuid='', action_time=1473233114571,
    service_info={"created": 1473233114571, "updated": 1473233114571, "userInfo": {
        "email": "", "phone": "+79853254552"}, "sessionInfo": {"sessionDate": 1473233114571}})
testdata_tickets.add_row(
    user_puid='', user_yandexuid='7028084711356084504', action_time=1463233114571,
    service_info={"created": 1506591185953, "updated": 1506591185953, "userInfo": {
        "email": "", "phone": "+79853254551"}, "sessionInfo": {"sessionDate": 1506591185953}})


"""
For create model need:
age segment [(0, 17), (18, 24), (25, 34), (35, 44), (45, 1000)]
and
income segment [(0, 25503), (25504, 51782), (51783, MAXINT)]
"""
income_data = [
    ("06b27502fa88e45d459e10a770aaf099", 0, (1500.0, 1500.0, 1500.0)),
    ("07575519ffd68630e4cc28827112b5e1", 1, (11000.0, 11000.0, 11000.0)),
    ("09e095b02a184d924af0c61d33f3bfa0", 17, (19000.0, 19000.0, 19000.0)),
    ("0aa344455c3d9ff82bf5394106483061", 18, (1500.0, 1500.0, 1500.0)),
    ("010ca72bf270f5b7d10c5762a17b19fb", 21, (11000.0, 11000.0, 11000.0)),
    ("58ec6971daa4023454732c82751e99fa", 24, (19000.0, 19000.0, 19000.0)),
    ("0bea5d3d17301b19431f960ad763a88c", 25, (1500.0, 1500.0, 1500.0)),
    ("30EDAB1F-92E1-47A8-A95E-A0674B36A4BA", 27, (11000.0, 11000.0, 11000.0)),
    ("51B5AD57-3C4C-46E2-932E-810D3B59B2C7", 34, (19000.0, 19000.0, 19000.0)),
    ("6B12FC00-BA64-411A-B627-2F79207A447B", 35, (1500.0, 1500.0, 1500.0)),
    ("70F890A4-C735-46D4-AD93-98D7C26E90E1", 37, (11000.0, 11000.0, 11000.0)),
    ("e02d9dbd569a7551d496c2372989f64d", 44, (19000.0, 19000.0, 19000.0)),
    ("3f68302e012966002d0b82cef83788c7", 45, (1500.0, 1500.0, 1500.0)),
    ("782B819E-824B-4239-80D9-1DDD15D3B790", 71, (11000.0, 11000.0, 11000.0)),
    ("0233F335-710B-4026-86F8-F6B11D69719E", 99, (19000.0, 19000.0, 19000.0)),
]
testdata_dicts_income_data_with_dev_info = BaseLog(
                path="//crypta/production/state/graph/dicts",
                table_name="income_data_with_dev_info",
                default_data=DICTS_INCOME_DATA_WITH_DEV_INFO
    )
for rec in income_data:
    testdata_dicts_income_data_with_dev_info.add_row(aug=rec[2][0], sep=rec[2][1], oct=rec[2][2], sum=sum(rec[2]),
                                                     yob=(datetime.now() - timedelta(days=rec[1]*365)).strftime("%d.%m.%Y"),
                                                     key=rec[0],
                                                     device_id=rec[0])


testdata_dicts_passport_phone_dump_unknown = BaseLog(
                path="//crypta/production/state/graph/dicts/external_dumps",
                table_name="passport_phone_dump_unknown",
                default_data=DICTS_PASSPORT_DUMP
    )
testdata_dicts_passport_phone_dump_unknown.add_row(puid="103299945", key="103299945", id_prefix="7904", id_value="fdae68989b74ac9d653379b590d4770c")
testdata_dicts_passport_phone_dump_unknown.add_row(puid="103299945", key="103299945", id_prefix="7904", id_value="fdae68989b74ac9d653379b590d4770c")
testdata_dicts_passport_phone_dump_unknown.add_row(puid="211539243", key="211539243", id_prefix="7978", id_value="eb37f718d957ce6b72fb016fb712a0ca")
testdata_dicts_passport_phone_dump_unknown.add_row(puid="103299945", key="103299945", id_prefix="7904", id_value="fdae68989b74ac9d653379b590d4770c")
testdata_dicts_passport_phone_dump_unknown.add_row(puid="211539243", key="211539243", id_prefix="7978", id_value="eb37f718d957ce6b72fb016fb712a0ca")

testdata_dicts_passport_phone_dump_phne = BaseLog(
    path="//crypta/production/state/graph/dicts/external_dumps",
    table_name="passport_phone_phne_dump_01_11_2017",
    default_data=DICTS_PASSPORT_DUMP
)
testdata_dicts_passport_phone_dump_phne.add_row(puid="211539243", key="211539243", id_prefix="7978", id_value="eb37f718d957ce6b72fb016fb712a0ca")
testdata_dicts_passport_phone_dump_phne.add_row(puid="46178168", key="46178168", id_prefix="7911", id_value="5f82882588d42a6c11d97402c545c5a7")
testdata_dicts_passport_phone_dump_phne.add_row(puid="103299945", key="103299945", id_prefix="7904", id_value="fdae68989b74ac9d653379b590d4770c")
testdata_dicts_passport_phone_dump_phne.add_row(puid="211539243", key="211539243", id_prefix="7978", id_value="eb37f718d957ce6b72fb016fb712a0ca")
testdata_dicts_passport_phone_dump_phne.add_row(puid="46178168", key="46178168", id_prefix="7911", id_value="5f82882588d42a6c11d97402c545c5a7")
testdata_dicts_passport_phone_dump_phne.add_row(puid="38170735", key="38170735", id_prefix="7919", id_value="67d530c865bd6852a6f65e1ed62adb8e")


testdata_dicts_puid_yuid = BaseLog(
                path="//crypta/production/state/graph/dicts",
                table_name="puid_yuid",
                default_data=DICTS_PUID_YUID
    )
testdata_dicts_puid_yuid.add_row(key="311111525", value="1947874031445763853")
testdata_dicts_puid_yuid.add_row(key="311111525", value="1947874031445763853")
testdata_dicts_puid_yuid.add_row(key="311338458", value="696766411409129307")
testdata_dicts_puid_yuid.add_row(key="311111525", value="1947874031445763853")
testdata_dicts_puid_yuid.add_row(key="311338458", value="696766411409129307")
testdata_dicts_puid_yuid.add_row(key="311338458", value="8962997951442059627")
testdata_dicts_puid_yuid.add_row(key="311111525", value="1947874031445763853")
testdata_dicts_puid_yuid.add_row(key="311338458", value="696766411409129307")
testdata_dicts_puid_yuid.add_row(key="311338458", value="8962997951442059627")
testdata_dicts_puid_yuid.add_row(key="311338458", value="1275077871404239998")
testdata_dicts_puid_yuid.add_row(key="311111525", value="1947874031445763853")
testdata_dicts_puid_yuid.add_row(key="311338458", value="696766411409129307")
testdata_dicts_puid_yuid.add_row(key="311338458", value="8962997951442059627")
testdata_dicts_puid_yuid.add_row(key="311338458", value="1275077871404239998")
testdata_dicts_puid_yuid.add_row(key="311394747", value="359267081445437693")
testdata_dicts_puid_yuid.add_row(key="311111525", value="1947874031445763853")
testdata_dicts_puid_yuid.add_row(key="311338458", value="696766411409129307")
testdata_dicts_puid_yuid.add_row(key="311338458", value="8962997951442059627")
testdata_dicts_puid_yuid.add_row(key="311338458", value="1275077871404239998")
testdata_dicts_puid_yuid.add_row(key="311394747", value="359267081445437693")
testdata_dicts_puid_yuid.add_row(key="311394747", value="1505327461427036757")
testdata_dicts_puid_yuid.add_row(key="311111525", value="1947874031445763853")
testdata_dicts_puid_yuid.add_row(key="311338458", value="696766411409129307")


testdata_dicts_puid_yuid_yt = BaseLog(
                path="//crypta/production/state/graph/dicts",
                table_name="puid_yuid_yt",
                default_data=DICTS_PUID_YUID_YT
    )
testdata_dicts_puid_yuid_yt.add_row(yuid="3390117391388757081", puid="254075620", match_chain="{u'login': {u'fp': {u'a-arapowa2015': {u'2016-04-22': 173, u'2016-04-25': 156, u'2016-04-14': 77, u'2016-04-15': 7, u'2016-04-24': 60, u'2016-04-03': 27, u'2016-04-02': 54, u'2016-04-18': 154, u'2016-04-19': 46, u'2016-03-31': 16, u'2016-03-30': 32, u'2016-03-28': 89, u'2016-03-29': 66, u'2016-04-16': 44, u'2016-04-17': 21, u'2016-04-20': 10, u'2016-04-11': 2, u'2016-04-21': 54, u'2016-04-13': 61}}}}")
testdata_dicts_puid_yuid_yt.add_row(yuid="3390117391388757081", puid="254075620", match_chain="{u'login': {u'fp': {u'a-arapowa2015': {u'2016-04-22': 173, u'2016-04-25': 156, u'2016-04-14': 77, u'2016-04-15': 7, u'2016-04-24': 60, u'2016-04-03': 27, u'2016-04-02': 54, u'2016-04-18': 154, u'2016-04-19': 46, u'2016-03-31': 16, u'2016-03-30': 32, u'2016-03-28': 89, u'2016-03-29': 66, u'2016-04-16': 44, u'2016-04-17': 21, u'2016-04-20': 10, u'2016-04-11': 2, u'2016-04-21': 54, u'2016-04-13': 61}}}}")
testdata_dicts_puid_yuid_yt.add_row(yuid="5177511381442986016", puid="173066488", match_chain="{u'login': {u'fp': {u'karandeyvalentina': {u'2016-04-03': 54, u'2016-04-02': 29, u'2016-04-01': 148, u'2016-04-07': 100, u'2016-04-06': 84, u'2016-04-05': 16, u'2016-04-04': 116, u'2016-04-21': 43, u'2016-04-20': 143, u'2016-04-09': 17, u'2016-04-08': 41, u'2016-04-25': 77, u'2016-04-24': 41, u'2016-04-26': 69, u'2016-04-22': 148, u'2016-03-28': 81, u'2016-03-29': 201, u'2016-04-18': 133, u'2016-04-19': 18, u'2016-04-14': 56, u'2016-04-15': 33, u'2016-04-16': 35, u'2016-04-17': 25, u'2016-04-10': 9, u'2016-04-11': 77, u'2016-04-12': 173, u'2016-04-13': 166, u'2016-03-31': 34, u'2016-03-30': 84, u'2016-04-23': 73}}}}")
testdata_dicts_puid_yuid_yt.add_row(yuid="3390117391388757081", puid="254075620", match_chain="{u'login': {u'fp': {u'a-arapowa2015': {u'2016-04-22': 173, u'2016-04-25': 156, u'2016-04-14': 77, u'2016-04-15': 7, u'2016-04-24': 60, u'2016-04-03': 27, u'2016-04-02': 54, u'2016-04-18': 154, u'2016-04-19': 46, u'2016-03-31': 16, u'2016-03-30': 32, u'2016-03-28': 89, u'2016-03-29': 66, u'2016-04-16': 44, u'2016-04-17': 21, u'2016-04-20': 10, u'2016-04-11': 2, u'2016-04-21': 54, u'2016-04-13': 61}}}}")
testdata_dicts_puid_yuid_yt.add_row(yuid="5177511381442986016", puid="173066488", match_chain="{u'login': {u'fp': {u'karandeyvalentina': {u'2016-04-03': 54, u'2016-04-02': 29, u'2016-04-01': 148, u'2016-04-07': 100, u'2016-04-06': 84, u'2016-04-05': 16, u'2016-04-04': 116, u'2016-04-21': 43, u'2016-04-20': 143, u'2016-04-09': 17, u'2016-04-08': 41, u'2016-04-25': 77, u'2016-04-24': 41, u'2016-04-26': 69, u'2016-04-22': 148, u'2016-03-28': 81, u'2016-03-29': 201, u'2016-04-18': 133, u'2016-04-19': 18, u'2016-04-14': 56, u'2016-04-15': 33, u'2016-04-16': 35, u'2016-04-17': 25, u'2016-04-10': 9, u'2016-04-11': 77, u'2016-04-12': 173, u'2016-04-13': 166, u'2016-03-31': 34, u'2016-03-30': 84, u'2016-04-23': 73}}}}")

# for instagram-puid test
testdata_dicts_puid_yuid_yt.add_row(yuid="99900011459458000", puid="9990001", match_chain="{u'login': {u'fp': {u'test_ista_plogin1': {u'2016-04-03': 50, u'2016-04-02': 55}}}}")
testdata_dicts_puid_yuid_yt.add_row(yuid="99900021459458000", puid="9990002", match_chain="{u'login': {u'fp': {u'test_ista_plogin2': {u'2016-04-03': 50, u'2016-04-02': 55}}}}")


testdata_dicts_yuid_regs = BaseLog(
                path="//crypta/production/state/graph/dicts",
                table_name="yuid_regs",
                default_data=DICTS_YUID_REGS
    )
testdata_dicts_yuid_regs.add_row(key="9119007301455357385", value="67|2016-03-26:313,2016-04-02:3,2016-03-29:25,2016-03-22:78,2016-03-21:9,2016-04-01:4,2016-03-23:20,2016-03-19:1,2016-03-18:32,2016-04-05:170,2016-03-30:4,2016-04-07:32,2016-03-17:74,2016-03-16:15,2016-04-12:25")
testdata_dicts_yuid_regs.add_row(key="9119007301455357385", value="67|2016-03-26:313,2016-04-02:3,2016-03-29:25,2016-03-22:78,2016-03-21:9,2016-04-01:4,2016-03-23:20,2016-03-19:1,2016-03-18:32,2016-04-05:170,2016-03-30:4,2016-04-07:32,2016-03-17:74,2016-03-16:15,2016-04-12:25")
testdata_dicts_yuid_regs.add_row(key="912067061435494047", value="21619|2016-03-16:11,2016-03-18:3,2016-04-12:14,2016-03-30:45")
testdata_dicts_yuid_regs.add_row(key="9119007301455357385", value="67|2016-03-26:313,2016-04-02:3,2016-03-29:25,2016-03-22:78,2016-03-21:9,2016-04-01:4,2016-03-23:20,2016-03-19:1,2016-03-18:32,2016-04-05:170,2016-03-30:4,2016-04-07:32,2016-03-17:74,2016-03-16:15,2016-04-12:25")
testdata_dicts_yuid_regs.add_row(key="912067061435494047", value="21619|2016-03-16:11,2016-03-18:3,2016-04-12:14,2016-03-30:45")
testdata_dicts_yuid_regs.add_row(key="2341942641448250325", value="65|2016-04-02:13,2016-04-01:102,2016-04-07:39,2016-04-06:10,2016-04-05:54,2016-04-04:22,2016-04-08:81,2016-03-20:43,2016-03-21:56,2016-03-22:45,2016-03-23:66,2016-03-24:23,2016-03-25:31,2016-03-26:161,2016-03-27:44,2016-03-28:35,2016-03-29:76,2016-04-10:96,2016-04-11:43,2016-04-12:67,2016-03-19:72,2016-03-18:57,2016-03-31:67,2016-03-30:57,2016-03-15:23,2016-03-14:29,2016-03-17:54,2016-03-16:53")
testdata_dicts_yuid_regs.add_row(key="9119007301455357385", value="67|2016-03-26:313,2016-04-02:3,2016-03-29:25,2016-03-22:78,2016-03-21:9,2016-04-01:4,2016-03-23:20,2016-03-19:1,2016-03-18:32,2016-04-05:170,2016-03-30:4,2016-04-07:32,2016-03-17:74,2016-03-16:15,2016-04-12:25")
testdata_dicts_yuid_regs.add_row(key="912067061435494047", value="21619|2016-03-16:11,2016-03-18:3,2016-04-12:14,2016-03-30:45")
testdata_dicts_yuid_regs.add_row(key="2341942641448250325", value="65|2016-04-02:13,2016-04-01:102,2016-04-07:39,2016-04-06:10,2016-04-05:54,2016-04-04:22,2016-04-08:81,2016-03-20:43,2016-03-21:56,2016-03-22:45,2016-03-23:66,2016-03-24:23,2016-03-25:31,2016-03-26:161,2016-03-27:44,2016-03-28:35,2016-03-29:76,2016-04-10:96,2016-04-11:43,2016-04-12:67,2016-03-19:72,2016-03-18:57,2016-03-31:67,2016-03-30:57,2016-03-15:23,2016-03-14:29,2016-03-17:54,2016-03-16:53")
testdata_dicts_yuid_regs.add_row(key="2342505821375978805", value="2|2016-04-03:36,2016-03-20:18,2016-04-02:47,2016-03-19:26,2016-04-09:4,2016-04-10:5;213|2016-03-19:2,2016-04-04:2,2016-03-31:1,2016-03-29:5,2016-03-30:2,2016-03-20:1,2016-03-21:3,2016-03-23:2,2016-04-07:6,2016-03-18:1,2016-04-05:2,2016-03-27:7,2016-03-28:2,2016-03-24:1,2016-03-14:2,2016-03-16:1,2016-04-11:1,2016-03-25:37")
testdata_dicts_yuid_regs.add_row(key="9119007301455357385", value="67|2016-03-26:313,2016-04-02:3,2016-03-29:25,2016-03-22:78,2016-03-21:9,2016-04-01:4,2016-03-23:20,2016-03-19:1,2016-03-18:32,2016-04-05:170,2016-03-30:4,2016-04-07:32,2016-03-17:74,2016-03-16:15,2016-04-12:25")
testdata_dicts_yuid_regs.add_row(key="912067061435494047", value="21619|2016-03-16:11,2016-03-18:3,2016-04-12:14,2016-03-30:45")


testdata_yamoney_yamoney_in_v1 = BaseLog(
                path="//crypta/production/state/graph/dicts/yamoney",
                table_name="yamoney_in_v1",
                default_data=YAMONEY_YAMONEY_IN_V1
    )
testdata_yamoney_yamoney_in_v1.add_row(phone="79196954666", PAYER_ENTITY_IS_WALLET="True", email="n.e.v.i@yandex.ru", PAYER_ENTITY_UID="341506301")
testdata_yamoney_yamoney_in_v1.add_row(phone="79196954666", PAYER_ENTITY_IS_WALLET="True", email="n.e.v.i@yandex.ru", PAYER_ENTITY_UID="341506301")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_ACCOUNT_ID="410011139750650", phone="380632759313", PAYER_ENTITY_ID="29189502", PAYER_ENTITY_IS_WALLET="True", dataopen="03.10.2011", PAYER_ENTITY_UID="136179756")
testdata_yamoney_yamoney_in_v1.add_row(phone="79196954666", PAYER_ENTITY_IS_WALLET="True", email="n.e.v.i@yandex.ru", PAYER_ENTITY_UID="341506301")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_ACCOUNT_ID="410011139750650", phone="380632759313", PAYER_ENTITY_ID="29189502", PAYER_ENTITY_IS_WALLET="True", dataopen="03.10.2011", PAYER_ENTITY_UID="136179756")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_IDENTIFIER_FIRST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_ALIVE_DAY_ID="42401", PAYER_ENTITY_IDENTIFIER="a984efb5ca7756e0cbce5a544f3b6fe283158b3b", PAYER_ENTITY_IDENTIFIER_TYPE="2", PAYER_ENTITY_ID="15992859", PAYER_ENTITY_IS_WALLET="False", PAYER_ENTITY_YANDEX_UID="124308321447141881", PAYER_ENTITY_IDENTIFIER_IS_PRIMARY="True", PAYER_ENTITY_ANONYMITY_LAST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_UID="332646036")
testdata_yamoney_yamoney_in_v1.add_row(phone="79196954666", PAYER_ENTITY_IS_WALLET="True", email="n.e.v.i@yandex.ru", PAYER_ENTITY_UID="341506301")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_ACCOUNT_ID="410011139750650", phone="380632759313", PAYER_ENTITY_ID="29189502", PAYER_ENTITY_IS_WALLET="True", dataopen="03.10.2011", PAYER_ENTITY_UID="136179756")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_IDENTIFIER_FIRST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_ALIVE_DAY_ID="42401", PAYER_ENTITY_IDENTIFIER="a984efb5ca7756e0cbce5a544f3b6fe283158b3b", PAYER_ENTITY_IDENTIFIER_TYPE="2", PAYER_ENTITY_ID="15992859", PAYER_ENTITY_IS_WALLET="False", PAYER_ENTITY_YANDEX_UID="124308321447141881", PAYER_ENTITY_IDENTIFIER_IS_PRIMARY="True", PAYER_ENTITY_ANONYMITY_LAST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_UID="332646036")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_IDENTIFIER_FIRST_DATE="2016-02-01 08:00:33.607000000", PAYER_ENTITY_ALIVE_DAY_ID="42401", PAYER_ENTITY_IDENTIFIER="asd@asd.asd", PAYER_ENTITY_IDENTIFIER_TYPE="3", PAYER_ENTITY_ID="15992859", PAYER_ENTITY_IS_WALLET="False", PAYER_ENTITY_YANDEX_UID="124308321447141881", PAYER_ENTITY_IDENTIFIER_IS_PRIMARY="False", PAYER_ENTITY_ANONYMITY_LAST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_UID="242159443")
testdata_yamoney_yamoney_in_v1.add_row(phone="79196954666", PAYER_ENTITY_IS_WALLET="True", email="n.e.v.i@yandex.ru", PAYER_ENTITY_UID="341506301")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_ACCOUNT_ID="410011139750650", phone="380632759313", PAYER_ENTITY_ID="29189502", PAYER_ENTITY_IS_WALLET="True", dataopen="03.10.2011", PAYER_ENTITY_UID="136179756")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_IDENTIFIER_FIRST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_ALIVE_DAY_ID="42401", PAYER_ENTITY_IDENTIFIER="a984efb5ca7756e0cbce5a544f3b6fe283158b3b", PAYER_ENTITY_IDENTIFIER_TYPE="2", PAYER_ENTITY_ID="15992859", PAYER_ENTITY_IS_WALLET="False", PAYER_ENTITY_YANDEX_UID="124308321447141881", PAYER_ENTITY_IDENTIFIER_IS_PRIMARY="True", PAYER_ENTITY_ANONYMITY_LAST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_UID="332646036")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_IDENTIFIER_FIRST_DATE="2016-02-01 08:00:33.607000000", PAYER_ENTITY_ALIVE_DAY_ID="42401", PAYER_ENTITY_IDENTIFIER="asd@asd.asd", PAYER_ENTITY_IDENTIFIER_TYPE="3", PAYER_ENTITY_ID="15992859", PAYER_ENTITY_IS_WALLET="False", PAYER_ENTITY_YANDEX_UID="124308321447141881", PAYER_ENTITY_IDENTIFIER_IS_PRIMARY="False", PAYER_ENTITY_ANONYMITY_LAST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_UID="242159443")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_IDENTIFIER_FIRST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_ALIVE_DAY_ID="42401", PAYER_ENTITY_IDENTIFIER="yaleksei666@yandex.ru", PAYER_ENTITY_IDENTIFIER_TYPE="3", PAYER_ENTITY_ID="15992859", PAYER_ENTITY_IS_WALLET="False", PAYER_ENTITY_YANDEX_UID="124308321447141881", PAYER_ENTITY_IDENTIFIER_IS_PRIMARY="False", PAYER_ENTITY_ANONYMITY_LAST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_UID="29534744")
testdata_yamoney_yamoney_in_v1.add_row(phone="79196954666", PAYER_ENTITY_IS_WALLET="True", email="n.e.v.i@yandex.ru", PAYER_ENTITY_UID="341506301")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_ACCOUNT_ID="410011139750650", phone="380632759313", PAYER_ENTITY_ID="29189502", PAYER_ENTITY_IS_WALLET="True", dataopen="03.10.2011", PAYER_ENTITY_UID="136179756")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_IDENTIFIER_FIRST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_ALIVE_DAY_ID="42401", PAYER_ENTITY_IDENTIFIER="a984efb5ca7756e0cbce5a544f3b6fe283158b3b", PAYER_ENTITY_IDENTIFIER_TYPE="2", PAYER_ENTITY_ID="15992859", PAYER_ENTITY_IS_WALLET="False", PAYER_ENTITY_YANDEX_UID="124308321447141881", PAYER_ENTITY_IDENTIFIER_IS_PRIMARY="True", PAYER_ENTITY_ANONYMITY_LAST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_UID="332646036")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_IDENTIFIER_FIRST_DATE="2016-02-01 08:00:33.607000000", PAYER_ENTITY_ALIVE_DAY_ID="42401", PAYER_ENTITY_IDENTIFIER="asd@asd.asd", PAYER_ENTITY_IDENTIFIER_TYPE="3", PAYER_ENTITY_ID="15992859", PAYER_ENTITY_IS_WALLET="False", PAYER_ENTITY_YANDEX_UID="124308321447141881", PAYER_ENTITY_IDENTIFIER_IS_PRIMARY="False", PAYER_ENTITY_ANONYMITY_LAST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_UID="242159443")
testdata_yamoney_yamoney_in_v1.add_row(PAYER_ENTITY_IDENTIFIER_FIRST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_ALIVE_DAY_ID="42401", PAYER_ENTITY_IDENTIFIER="yaleksei666@yandex.ru", PAYER_ENTITY_IDENTIFIER_TYPE="3", PAYER_ENTITY_ID="15992859", PAYER_ENTITY_IS_WALLET="False", PAYER_ENTITY_YANDEX_UID="124308321447141881", PAYER_ENTITY_IDENTIFIER_IS_PRIMARY="False", PAYER_ENTITY_ANONYMITY_LAST_DATE="2016-02-01 07:59:19.180000000", PAYER_ENTITY_UID="29534744")

testdata_dev_info_with_income = BaseLog(
                path="//crypta/team/ernest/CRYPTAIS-527",
                table_name="dev_info_with_income",
                default_data=DEV_INFO_WITH_INCOME
    )
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,com.yandex.browser,ru.yandex.yandexmaps,com.drweb,ru.yandex.yandexnavi,ru.yandex.fines,ru.yandex.yandexcity", uat="m|phone|samsung|android|5.0.1", income="2", model="Galaxy S4", manufacturer="Samsung", device_id="8e829e09c4ef9d68")
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,com.yandex.browser,ru.yandex.yandexmaps,com.drweb,ru.yandex.yandexnavi,ru.yandex.fines,ru.yandex.yandexcity", uat="m|phone|samsung|android|5.0.1", income="2", model="Galaxy S4", manufacturer="Samsung", device_id="8e829e09c4ef9d68")
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,ru.yandex.yandexnavi", uat="m|phone|huawei|android|5.1.1", income="2", model="Che2-L11", manufacturer="Huawei", device_id="8e85316bb84d9e48")
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,com.yandex.browser,ru.yandex.yandexmaps,com.drweb,ru.yandex.yandexnavi,ru.yandex.fines,ru.yandex.yandexcity", uat="m|phone|samsung|android|5.0.1", income="2", model="Galaxy S4", manufacturer="Samsung", device_id="8e829e09c4ef9d68")
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,ru.yandex.yandexnavi", uat="m|phone|huawei|android|5.1.1", income="2", model="Che2-L11", manufacturer="Huawei", device_id="8e85316bb84d9e48")
testdata_dev_info_with_income.add_row(apps="com.android.sharedstoragebackup,com.mediatek.lbs.em,com.vkontakte.android,ru.cian.main,com.google.android.apps.maps,com.google.android.partnersetup,com.mediatek.videoplayer,com.mediatek.schpwronoff,com.kms.free,ru.intaxi,com.google.android.onetimeinitializer,com.android.magicsmoke,com.android.packageinstaller,net.megogo.vendor,com.android.documentsui,com.google.android.googlequicksearchbox,com.android.providers.contacts,com.google.android.apps.books,com.rock.gota,com.android.wallpaper.livepicker,ru.mail,com.android.phone,com.android.backupconfirm,ru.yandex.weatherplugin,com.android.galaxy4,com.android.email,com.gismeteo.client,com.android.deskclock,com.android.videoeditor,com.yandex.browser,com.flyhelp.repair,com.android.defcontainer,com.android.providers.downloads,com.android.proxyhandler,com.android.musicvis,com.mediatek.videofavorites,com.opera.preinstall,PSB.Droid,com.mediatek.connectivity,com.android.exchange,com.mediatek.DataUsageLockScreenClient,com.android.pacprocessor,com.google.android.tag,com.android.dialer,com.cleanmaster.mguard,com.android.keychain,com.android.gallery3d,com.android.keyguard,com.google.android.marvin.talkback,com.mediatek,com.mediatek.FMRadio,com.android.systemui,com.google.android.videos,com.android.calculator2,com.android.wallpaper,com.android.inputdevices,com.google.android.apps.docs,ru.yandex.yandexmaps,com.android.wallpaper.holospiral,com.mediatek.CellConnService,com.umtgrn.pdfreader,com.android.providers.drm,com.google.android.syncadapters.contacts,com.google.android.feedback,com.android.facelock,com.mediatek.appguide.plugin,com.android.salestracking,ru.yandex.disk,com.mediatek.vlw,com.mediatek.systemupdate,com.android.browser.provider,com.mediatek.ygps,com.google.android.gsf,com.mediatek.calendarimporter,com.android.printspooler,com.mediatek.apst.target,com.android.providers.media,com.android.chrome,com.mediatek.mtklogger,com.android.providers.calendar,ru.ok.android,com.android.musicfx,ru.beeline.services,ru.sberbank.spasibo,com.android.contacts,com.google.android.gsf.login,com.android.providers.userdictionary,com.android.launcher3,com.google.android.apps.magazines,com.android.noisefield,com.estrongs.android.pop,com.android.providers.partnerbookmarks,com.android.soundrecorder,com.google.android.apps.plus,com.google.android.youtube,com.android.phasebeam,com.ijinshan.kbatterydoctor_en,com.android.simmelock,com.android.htmlviewer,com.google.android.music,com.piriform.ccleaner,ru.megafon.mlk,com.paragon.mts.ma.android,com.android.protips,com.mediatek.voicecommand,com.konka.desktimewidget,com.mediatek.systemupdate.sysoper,ru.yandex.money,com.android.settings,ru.sberbankmobile,com.android.shell,ru.yandex.searchplugin,com.android.providers.settings,ru.simpls.brs2.mobbank,com.google.android.gms,com.google.android.configupdater,com.navitel,com.mediatek.StkSelection,ru.mts.mymts,com.google.android.apps.cloudprint,com.android.externalstorage,com.google.android.tts,com.mediatek.engineermode,com.android.providers.telephony,com.android.vending,com.mediatek.voiceunlock,com.android.bluetooth,com.mediatek.thermalmanager,com.google.android.play.games,com.google.android.talk,com.ubanksu,com.google.android.inputmethod.latin,android,com.skype.raider,com.android.stk,com.google.android.calendar,com.android.certinstaller,com.google.android.backuptransport,com.android.vpndialogs,com.mediatek.bluetooth,com.megogo.application,com.google.android.gm,com.mediatek.batterywarning,com.google.android.setupwizard,com.spotoption.android.titantrade,com.ghisler.android.TotalCommander,com.android.providers.downloads.ui,com.android.mms,com.android.location.fused,com.android.providers.applications,com.opera.mini.native,com.google.android.street,ru.ntv.client,com.android.dreams.basic,com.spotoption.android.interactive_optiontarget", uat="m|phone|fly|android|4.4.2", income="1", model="Fly IQ4514 Quad", manufacturer="Fly", device_id="8e8afc6432a9953a")
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,com.yandex.browser,ru.yandex.yandexmaps,com.drweb,ru.yandex.yandexnavi,ru.yandex.fines,ru.yandex.yandexcity", uat="m|phone|samsung|android|5.0.1", income="2", model="Galaxy S4", manufacturer="Samsung", device_id="8e829e09c4ef9d68")
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,ru.yandex.yandexnavi", uat="m|phone|huawei|android|5.1.1", income="2", model="Che2-L11", manufacturer="Huawei", device_id="8e85316bb84d9e48")
testdata_dev_info_with_income.add_row(apps="com.android.sharedstoragebackup,com.mediatek.lbs.em,com.vkontakte.android,ru.cian.main,com.google.android.apps.maps,com.google.android.partnersetup,com.mediatek.videoplayer,com.mediatek.schpwronoff,com.kms.free,ru.intaxi,com.google.android.onetimeinitializer,com.android.magicsmoke,com.android.packageinstaller,net.megogo.vendor,com.android.documentsui,com.google.android.googlequicksearchbox,com.android.providers.contacts,com.google.android.apps.books,com.rock.gota,com.android.wallpaper.livepicker,ru.mail,com.android.phone,com.android.backupconfirm,ru.yandex.weatherplugin,com.android.galaxy4,com.android.email,com.gismeteo.client,com.android.deskclock,com.android.videoeditor,com.yandex.browser,com.flyhelp.repair,com.android.defcontainer,com.android.providers.downloads,com.android.proxyhandler,com.android.musicvis,com.mediatek.videofavorites,com.opera.preinstall,PSB.Droid,com.mediatek.connectivity,com.android.exchange,com.mediatek.DataUsageLockScreenClient,com.android.pacprocessor,com.google.android.tag,com.android.dialer,com.cleanmaster.mguard,com.android.keychain,com.android.gallery3d,com.android.keyguard,com.google.android.marvin.talkback,com.mediatek,com.mediatek.FMRadio,com.android.systemui,com.google.android.videos,com.android.calculator2,com.android.wallpaper,com.android.inputdevices,com.google.android.apps.docs,ru.yandex.yandexmaps,com.android.wallpaper.holospiral,com.mediatek.CellConnService,com.umtgrn.pdfreader,com.android.providers.drm,com.google.android.syncadapters.contacts,com.google.android.feedback,com.android.facelock,com.mediatek.appguide.plugin,com.android.salestracking,ru.yandex.disk,com.mediatek.vlw,com.mediatek.systemupdate,com.android.browser.provider,com.mediatek.ygps,com.google.android.gsf,com.mediatek.calendarimporter,com.android.printspooler,com.mediatek.apst.target,com.android.providers.media,com.android.chrome,com.mediatek.mtklogger,com.android.providers.calendar,ru.ok.android,com.android.musicfx,ru.beeline.services,ru.sberbank.spasibo,com.android.contacts,com.google.android.gsf.login,com.android.providers.userdictionary,com.android.launcher3,com.google.android.apps.magazines,com.android.noisefield,com.estrongs.android.pop,com.android.providers.partnerbookmarks,com.android.soundrecorder,com.google.android.apps.plus,com.google.android.youtube,com.android.phasebeam,com.ijinshan.kbatterydoctor_en,com.android.simmelock,com.android.htmlviewer,com.google.android.music,com.piriform.ccleaner,ru.megafon.mlk,com.paragon.mts.ma.android,com.android.protips,com.mediatek.voicecommand,com.konka.desktimewidget,com.mediatek.systemupdate.sysoper,ru.yandex.money,com.android.settings,ru.sberbankmobile,com.android.shell,ru.yandex.searchplugin,com.android.providers.settings,ru.simpls.brs2.mobbank,com.google.android.gms,com.google.android.configupdater,com.navitel,com.mediatek.StkSelection,ru.mts.mymts,com.google.android.apps.cloudprint,com.android.externalstorage,com.google.android.tts,com.mediatek.engineermode,com.android.providers.telephony,com.android.vending,com.mediatek.voiceunlock,com.android.bluetooth,com.mediatek.thermalmanager,com.google.android.play.games,com.google.android.talk,com.ubanksu,com.google.android.inputmethod.latin,android,com.skype.raider,com.android.stk,com.google.android.calendar,com.android.certinstaller,com.google.android.backuptransport,com.android.vpndialogs,com.mediatek.bluetooth,com.megogo.application,com.google.android.gm,com.mediatek.batterywarning,com.google.android.setupwizard,com.spotoption.android.titantrade,com.ghisler.android.TotalCommander,com.android.providers.downloads.ui,com.android.mms,com.android.location.fused,com.android.providers.applications,com.opera.mini.native,com.google.android.street,ru.ntv.client,com.android.dreams.basic,com.spotoption.android.interactive_optiontarget", uat="m|phone|fly|android|4.4.2", income="1", model="Fly IQ4514 Quad", manufacturer="Fly", device_id="8e8afc6432a9953a")
testdata_dev_info_with_income.add_row(apps="ru.yandex.yandexmaps,ru.yandex.yandexnavi", uat="m|phone|samsung|android|5.0", income="1", model="Galaxy S5 Dual SIM", manufacturer="Samsung", device_id="8e982c3c803cc9f9")
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,com.yandex.browser,ru.yandex.yandexmaps,com.drweb,ru.yandex.yandexnavi,ru.yandex.fines,ru.yandex.yandexcity", uat="m|phone|samsung|android|5.0.1", income="2", model="Galaxy S4", manufacturer="Samsung", device_id="8e829e09c4ef9d68")
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,ru.yandex.yandexnavi", uat="m|phone|huawei|android|5.1.1", income="2", model="Che2-L11", manufacturer="Huawei", device_id="8e85316bb84d9e48")
testdata_dev_info_with_income.add_row(apps="com.android.sharedstoragebackup,com.mediatek.lbs.em,com.vkontakte.android,ru.cian.main,com.google.android.apps.maps,com.google.android.partnersetup,com.mediatek.videoplayer,com.mediatek.schpwronoff,com.kms.free,ru.intaxi,com.google.android.onetimeinitializer,com.android.magicsmoke,com.android.packageinstaller,net.megogo.vendor,com.android.documentsui,com.google.android.googlequicksearchbox,com.android.providers.contacts,com.google.android.apps.books,com.rock.gota,com.android.wallpaper.livepicker,ru.mail,com.android.phone,com.android.backupconfirm,ru.yandex.weatherplugin,com.android.galaxy4,com.android.email,com.gismeteo.client,com.android.deskclock,com.android.videoeditor,com.yandex.browser,com.flyhelp.repair,com.android.defcontainer,com.android.providers.downloads,com.android.proxyhandler,com.android.musicvis,com.mediatek.videofavorites,com.opera.preinstall,PSB.Droid,com.mediatek.connectivity,com.android.exchange,com.mediatek.DataUsageLockScreenClient,com.android.pacprocessor,com.google.android.tag,com.android.dialer,com.cleanmaster.mguard,com.android.keychain,com.android.gallery3d,com.android.keyguard,com.google.android.marvin.talkback,com.mediatek,com.mediatek.FMRadio,com.android.systemui,com.google.android.videos,com.android.calculator2,com.android.wallpaper,com.android.inputdevices,com.google.android.apps.docs,ru.yandex.yandexmaps,com.android.wallpaper.holospiral,com.mediatek.CellConnService,com.umtgrn.pdfreader,com.android.providers.drm,com.google.android.syncadapters.contacts,com.google.android.feedback,com.android.facelock,com.mediatek.appguide.plugin,com.android.salestracking,ru.yandex.disk,com.mediatek.vlw,com.mediatek.systemupdate,com.android.browser.provider,com.mediatek.ygps,com.google.android.gsf,com.mediatek.calendarimporter,com.android.printspooler,com.mediatek.apst.target,com.android.providers.media,com.android.chrome,com.mediatek.mtklogger,com.android.providers.calendar,ru.ok.android,com.android.musicfx,ru.beeline.services,ru.sberbank.spasibo,com.android.contacts,com.google.android.gsf.login,com.android.providers.userdictionary,com.android.launcher3,com.google.android.apps.magazines,com.android.noisefield,com.estrongs.android.pop,com.android.providers.partnerbookmarks,com.android.soundrecorder,com.google.android.apps.plus,com.google.android.youtube,com.android.phasebeam,com.ijinshan.kbatterydoctor_en,com.android.simmelock,com.android.htmlviewer,com.google.android.music,com.piriform.ccleaner,ru.megafon.mlk,com.paragon.mts.ma.android,com.android.protips,com.mediatek.voicecommand,com.konka.desktimewidget,com.mediatek.systemupdate.sysoper,ru.yandex.money,com.android.settings,ru.sberbankmobile,com.android.shell,ru.yandex.searchplugin,com.android.providers.settings,ru.simpls.brs2.mobbank,com.google.android.gms,com.google.android.configupdater,com.navitel,com.mediatek.StkSelection,ru.mts.mymts,com.google.android.apps.cloudprint,com.android.externalstorage,com.google.android.tts,com.mediatek.engineermode,com.android.providers.telephony,com.android.vending,com.mediatek.voiceunlock,com.android.bluetooth,com.mediatek.thermalmanager,com.google.android.play.games,com.google.android.talk,com.ubanksu,com.google.android.inputmethod.latin,android,com.skype.raider,com.android.stk,com.google.android.calendar,com.android.certinstaller,com.google.android.backuptransport,com.android.vpndialogs,com.mediatek.bluetooth,com.megogo.application,com.google.android.gm,com.mediatek.batterywarning,com.google.android.setupwizard,com.spotoption.android.titantrade,com.ghisler.android.TotalCommander,com.android.providers.downloads.ui,com.android.mms,com.android.location.fused,com.android.providers.applications,com.opera.mini.native,com.google.android.street,ru.ntv.client,com.android.dreams.basic,com.spotoption.android.interactive_optiontarget", uat="m|phone|fly|android|4.4.2", income="1", model="Fly IQ4514 Quad", manufacturer="Fly", device_id="8e8afc6432a9953a")
testdata_dev_info_with_income.add_row(apps="ru.yandex.yandexmaps,ru.yandex.yandexnavi", uat="m|phone|samsung|android|5.0", income="1", model="Galaxy S5 Dual SIM", manufacturer="Samsung", device_id="8e982c3c803cc9f9")
testdata_dev_info_with_income.add_row(apps="ru.yandex.weatherplugin,ru.yandex.disk,ru.yandex.mail", uat="m|phone|samsung|android|4.1.2", income="1", model="Galaxy S3 Mini", manufacturer="Samsung", device_id="8e9f0f395fdded2a")
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,com.yandex.browser,ru.yandex.yandexmaps,com.drweb,ru.yandex.yandexnavi,ru.yandex.fines,ru.yandex.yandexcity", uat="m|phone|samsung|android|5.0.1", income="2", model="Galaxy S4", manufacturer="Samsung", device_id="8e829e09c4ef9d68")
testdata_dev_info_with_income.add_row(apps="ru.yandex.metro,ru.yandex.yandexnavi", uat="m|phone|huawei|android|5.1.1", income="2", model="Che2-L11", manufacturer="Huawei", device_id="8e85316bb84d9e48")
testdata_dev_info_with_income.add_row(apps="com.android.sharedstoragebackup,com.mediatek.lbs.em,com.vkontakte.android,ru.cian.main,com.google.android.apps.maps,com.google.android.partnersetup,com.mediatek.videoplayer,com.mediatek.schpwronoff,com.kms.free,ru.intaxi,com.google.android.onetimeinitializer,com.android.magicsmoke,com.android.packageinstaller,net.megogo.vendor,com.android.documentsui,com.google.android.googlequicksearchbox,com.android.providers.contacts,com.google.android.apps.books,com.rock.gota,com.android.wallpaper.livepicker,ru.mail,com.android.phone,com.android.backupconfirm,ru.yandex.weatherplugin,com.android.galaxy4,com.android.email,com.gismeteo.client,com.android.deskclock,com.android.videoeditor,com.yandex.browser,com.flyhelp.repair,com.android.defcontainer,com.android.providers.downloads,com.android.proxyhandler,com.android.musicvis,com.mediatek.videofavorites,com.opera.preinstall,PSB.Droid,com.mediatek.connectivity,com.android.exchange,com.mediatek.DataUsageLockScreenClient,com.android.pacprocessor,com.google.android.tag,com.android.dialer,com.cleanmaster.mguard,com.android.keychain,com.android.gallery3d,com.android.keyguard,com.google.android.marvin.talkback,com.mediatek,com.mediatek.FMRadio,com.android.systemui,com.google.android.videos,com.android.calculator2,com.android.wallpaper,com.android.inputdevices,com.google.android.apps.docs,ru.yandex.yandexmaps,com.android.wallpaper.holospiral,com.mediatek.CellConnService,com.umtgrn.pdfreader,com.android.providers.drm,com.google.android.syncadapters.contacts,com.google.android.feedback,com.android.facelock,com.mediatek.appguide.plugin,com.android.salestracking,ru.yandex.disk,com.mediatek.vlw,com.mediatek.systemupdate,com.android.browser.provider,com.mediatek.ygps,com.google.android.gsf,com.mediatek.calendarimporter,com.android.printspooler,com.mediatek.apst.target,com.android.providers.media,com.android.chrome,com.mediatek.mtklogger,com.android.providers.calendar,ru.ok.android,com.android.musicfx,ru.beeline.services,ru.sberbank.spasibo,com.android.contacts,com.google.android.gsf.login,com.android.providers.userdictionary,com.android.launcher3,com.google.android.apps.magazines,com.android.noisefield,com.estrongs.android.pop,com.android.providers.partnerbookmarks,com.android.soundrecorder,com.google.android.apps.plus,com.google.android.youtube,com.android.phasebeam,com.ijinshan.kbatterydoctor_en,com.android.simmelock,com.android.htmlviewer,com.google.android.music,com.piriform.ccleaner,ru.megafon.mlk,com.paragon.mts.ma.android,com.android.protips,com.mediatek.voicecommand,com.konka.desktimewidget,com.mediatek.systemupdate.sysoper,ru.yandex.money,com.android.settings,ru.sberbankmobile,com.android.shell,ru.yandex.searchplugin,com.android.providers.settings,ru.simpls.brs2.mobbank,com.google.android.gms,com.google.android.configupdater,com.navitel,com.mediatek.StkSelection,ru.mts.mymts,com.google.android.apps.cloudprint,com.android.externalstorage,com.google.android.tts,com.mediatek.engineermode,com.android.providers.telephony,com.android.vending,com.mediatek.voiceunlock,com.android.bluetooth,com.mediatek.thermalmanager,com.google.android.play.games,com.google.android.talk,com.ubanksu,com.google.android.inputmethod.latin,android,com.skype.raider,com.android.stk,com.google.android.calendar,com.android.certinstaller,com.google.android.backuptransport,com.android.vpndialogs,com.mediatek.bluetooth,com.megogo.application,com.google.android.gm,com.mediatek.batterywarning,com.google.android.setupwizard,com.spotoption.android.titantrade,com.ghisler.android.TotalCommander,com.android.providers.downloads.ui,com.android.mms,com.android.location.fused,com.android.providers.applications,com.opera.mini.native,com.google.android.street,ru.ntv.client,com.android.dreams.basic,com.spotoption.android.interactive_optiontarget", uat="m|phone|fly|android|4.4.2", income="1", model="Fly IQ4514 Quad", manufacturer="Fly", device_id="8e8afc6432a9953a")


testdata_bs_rtb_log = BaseLog(
                path="//statbox/bs-rtb-log",
                date="2016-04-09",
                default_data=BS_RTB_LOG
    )
testdata_bs_rtb_log.add_row(showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown", _stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown", _stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown",_stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown",_stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565:", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=1234567890&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown",_stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565:", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=http%3A%2F%2Fyandex.ru&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown",_stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565:", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(showtime="1471603241", unixtime="1471603241", pagetoken="com.cleanmaster.mguard", clid="0", bidreqid="4811716334833897187", realip="95.153.131.141", clientip="95.153.131.141", queryargs="84=1&240=1&426=7952356&324=1&329=Android&337", pageid="154738", regionid="26", clientip6="::ffff:95.153.131.141", uniqid="2129028835457769567", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500f:428d:5cff:fe34:fc4bunknown", _stbx="rt3.man--yabs-rt--bs-rtb-log:21:229037335:", referer="http://dsp.yandex.ru/", remoteip="127.0.0.1", useragent="Mozilla/5.0 (Linux; Android 5.0.1; GT-I9506 Build/LRX22C; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/51.0.2704.81 Mobile Safari/537.36", iso_eventtime="2016-08-19 13:40:41", remoteip6="::ffff:127.0.0.1", realip6="::ffff:95.153.131.141", devicetype="3", cryptaid="2129028835457769567")

testdata_bs_rtb_log.add_row(_date="2016-04-10", showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown", _stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(_date="2016-04-10", showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown", _stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(_date="2016-04-10", showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown",_stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(_date="2016-04-10", showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown",_stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565:", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(_date="2016-04-10", showtime="1471603241", unixtime="1471603241", pagetoken="com.cleanmaster.mguard", clid="0", bidreqid="4811716334833897187", realip="95.153.131.141", clientip="95.153.131.141", queryargs="84=1&240=1&426=7952356&324=1&329=Android&337", pageid="154738", regionid="26", clientip6="::ffff:95.153.131.141", uniqid="2129028835457769567", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500f:428d:5cff:fe34:fc4bunknown", _stbx="rt3.man--yabs-rt--bs-rtb-log:21:229037335:", referer="http://dsp.yandex.ru/", remoteip="127.0.0.1", useragent="Mozilla/5.0 (Linux; Android 5.0.1; GT-I9506 Build/LRX22C; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/51.0.2704.81 Mobile Safari/537.36", iso_eventtime="2016-08-19 13:40:41", remoteip6="::ffff:127.0.0.1", realip6="::ffff:95.153.131.141", devicetype="3", cryptaid="2129028835457769567")

testdata_bs_rtb_log.add_row(_date="2016-04-11", showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown", _stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(_date="2016-04-11", showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown", _stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(_date="2016-04-11", showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown",_stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(_date="2016-04-11", showtime="1471598490", unixtime="1471598490", clid="0", clientip="213.87.154.184", queryargs="240=1&426=8739185&84=2&329=Android&337=21f44ec9-7f36-4a56-a529-88326db73750&431=480&432=320&439=3cb9bf00-3459-4a6b-b419-a6e19d009099&440=com%2EkathleenOswald%2EsolitaireGooglePlay&443=com%2EkathleenOswald%2EsolitaireGooglePlay&445=IAB25%0AIAB26%0AIAB7-39%0AIAB8-18%0AIAB8-5%0AIAB9-9&486=0%2E1", pageid="168628", regionid="213", clientip6="::ffff:213.87.154.184", uniqid="1143583185446278524", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500c:428d:5cff:fe34:fc79unknown",_stbx="rt3.man--yabs-rt--bs-rtb-log:37:230757565:", referer="https://dsp.yandex.ru/", useragent="Mozilla/5.0 (Linux; Android 4.4.2; Philips V387 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36", iso_eventtime="2016-08-19 12:21:30", remoteip6="::1", devicetype="3", cryptaid="1143583185446278524")
testdata_bs_rtb_log.add_row(_date="2016-04-11", showtime="1471603241", unixtime="1471603241", pagetoken="com.cleanmaster.mguard", clid="0", bidreqid="4811716334833897187", realip="95.153.131.141", clientip="95.153.131.141", queryargs="84=1&240=1&426=7952356&324=1&329=Android&337", pageid="154738", regionid="26", clientip6="::ffff:95.153.131.141", uniqid="2129028835457769567", fraudbits="0", source_uri="prt://yabs-rt@2a02:6b8:b020:500f:428d:5cff:fe34:fc4bunknown", _stbx="rt3.man--yabs-rt--bs-rtb-log:21:229037335:", referer="http://dsp.yandex.ru/", remoteip="127.0.0.1", useragent="Mozilla/5.0 (Linux; Android 5.0.1; GT-I9506 Build/LRX22C; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/51.0.2704.81 Mobile Safari/537.36", iso_eventtime="2016-08-19 13:40:41", remoteip6="::ffff:127.0.0.1", realip6="::ffff:95.153.131.141", devicetype="3", cryptaid="2129028835457769567")


testdata_sbapi_mitb1 = BaseLog(
    path='//home/logfeller/logs/sbapi-access-mitb-log/1d',
    date="2016-04-09",
    default_data=SBAPI_MITB_LOG
)

testdata_sbapi_mitb1.add_row(data='{\\x22ui\\x22:\\x22{9E23CB5D-E100-4A11-9819-0B2189D9C7A5}\\x22,'+
                                  '\\x22yandexuids\\x22:[' +
                                  '{\\x22value\\x22:\\x221411463541466283440\\x22,\\x22browser\\x22:\\x22Firefox\\x22,\\x22id\\x22:\\x220\\x22},' +
                                  '{\\x22value\\x22:\\x221955639651466284017\\x22,\\x22browser\\x22:\\x22Google Chrome\\x22,\\x22id\\x22:\\x221\\x22},' +
                                  '{\\x22value\\x22:\\x225929486401473797289\\x22,\\x22browser\\x22:\\x22Google Chrome\\x22,\\x22id\\x22:\\x221\\x22},' +
                                  '{\\x22value\\x22:\\x223359835671473797290\\x22,\\x22browser\\x22:\\x22Google Chrome\\x22,\\x22id\\x22:\\x221\\x22},' +
                                  '{\\x22value\\x22:\\x221955639651466284017\\x22,\\x22browser\\x22:\\x22Google Chrome\\x22,\\x22id\\x22:\\x221\\x22},' +
                                  '{\\x22value\\x22:\\x229892519401469296486\\x22,\\x22browser\\x22:\\x22Opera\\x22,\\x22id\\x22:\\x223\\x22},' +
                                  '{\\x22value\\x22:\\x22111666501466278216\\x22,\\x22browser\\x22:\\x22Opera\\x22,\\x22id\\x22:\\x223\\x22},' +
                                  '{\\x22value\\x22:\\x22111666501466278216\\x22,\\x22browser\\x22:\\x22Opera\\x22,\\x22id\\x22:\\x223\\x22}' +
                                  ']}')

testdata_sbapi_mitb1.add_row(data='{\\x22ui\\x22:\\x22{9E23CB5D-E100-4A11-9819-0B2189D9C7A5}\\x22,'
                                  '\\x22yandexuids\\x22:['
                                  '{\\x22value\\x22:\\x223332342342342\\x22,\\x22browser\\x22:\\x22Firefox\\x22,\\x22id\\x22:\\x220\\x22}'
                                  ']}')

testdata_sbapi_mitb2 = BaseLog(
    path='//home/logfeller/logs/sbapi-access-mitb-log/1d',
    date="2016-04-10",
    default_data=SBAPI_MITB_LOG
)

# need second day, because one-days are private mode and thrown
testdata_sbapi_mitb2.add_row(data='{\\x22ui\\x22:\\x22{9E23CB5D-E100-4A11-9819-0B2189D9C7A5}\\x22,'
                                  '\\x22yandexuids\\x22:['
                                  '{\\x22value\\x22:\\x221411463541466283440\\x22,\\x22browser\\x22:\\x22Firefox\\x22,\\x22id\\x22:\\x220\\x22}'
                                  ']}')
testdata_sbapi_mitb2.add_row(_date='2016-04-11')


testdata_audimvideo_emails = BaseLog(
    path="//crypta/production/state/extras/reference-bases",
    table_name="audi-mvideo-emails",
    default_data=AUDIMVIDEO_EMAILS_LOG
)
testdata_audimvideo_emails.add_row(id_value="sfdf@yandex.ru")
testdata_audimvideo_emails.add_row(id_value="0.klass@mail.ru")
testdata_audimvideo_emails.add_row(id_value="000111@nemdom.mangosip.ru")
testdata_audimvideo_emails.add_row(id_value="testaudimvideo@yandex.ru")
testdata_audimvideo_emails.add_row(id_value="0012337766@mail.ru")

testdata_sber_phones = BaseLog(
    path="//crypta/production/state/extras/reference-bases",
    table_name="sberbank_phones_hash",
    default_data=SBER_PHONES_LOG
)
testdata_sber_phones.add_row(id_value="e2051594d8511d3a4e54a5c5230eefbe", id_prefix="7952")
testdata_sber_phones.add_row(id_value="cb7f477630ccfdfd58c6bbcf25aca7c5", id_prefix="7963")
testdata_sber_phones.add_row(id_value="baa3934f4c3dddb4f9a9a26f1510f08a", id_prefix="7999")
testdata_sber_phones.add_row(id_value="b68ad6b5b1864a75214d491488fd4e6b", id_prefix="7983")
testdata_sber_phones.add_row(id_value="001574c912c2a3f93dd5d4d4a73ddbf5", id_prefix="7910")

# HCB redirect pixel

mobile_redirect_log = BaseLog(
    path="//statbox/mobile-redirect-log",
    date="2016-04-11",
    default_data=MOBILE_REDIRECT_LOG
)

mobile_redirect_log.add_row(**{
    "HTTP_REFERER": "http://saratov.homecredit.ru/payment/payment2.php",
    "_logfeller_index_bucket": "//home/logfeller/index/redir/redir-log/1800-1800/1472698800/1472698800",
    "_stbx": "rt3.sas--redir--redir-log:1@@240287393@@base64:v_aLoFOOQOWutePireWejA@@1472700039027@@1472700039",
    "at": "1",
    "dtype": "ydf",
    "ip": "91.205.53.42",
    "iso_eventtime": "2016-09-01 06:20:38",
    "provider": "redir",
    "source_uri": "prt://redir@sas1-3152.search.yandex.net/usr/local/www/logs/current-redir-clickdaemon-18100",
    "timestamp": "1472700038",
    "token": "31cc39c4b9e2cf7015b328bc",
    "uah": "1513028467",
    "unixtime": "1472700038",
    "url": "",
    "user": "f2009b5f-4c87-472d-b309-6ba63ff3353c",
    "yandexuid": "5464304591466435890"
})

# instagram_id-puid and instagram_login-puid links
testdata_instagram_puid = BaseLog(
    path="//home/crypta/analytics/segments/external_data/instagram-puid",
    date="20160409",
    default_data=INSTAGRAM_PUID_LOG
)
testdata_instagram_puid.add_row(uid=9990001, message_count=22, type="id", value=3534989606)
testdata_instagram_puid.add_row(uid=9990002, message_count=21, type="username", value="test_insta_username_1")

# instagram_id-puid and instagram_login-puid links
testdata_sovetnik_2016_04_11 = BaseLog(
    path="//logs/sovetnik-users-log/1d",
    date="2016-04-11",
    default_data={}
)
testdata_sovetnik_2016_04_11.add_row(
    **{"clid": "2290154", "browser": "Yandex", "lang": "ru", "host": "sovetnik02h", "os": "Windows", "geo_id": "10309",
       "region": "RU", "type": "SOCIAL_NETWORK_PROFILE", "yandexuid": "157564101446625111",
       "transaction_id": "j8ch9d38wf5m9mgr88eqfaejlj0h6tdf",
       "source_uri": "prt://sovetnik-backend@sovetnik02h.market.yandex.net/var/log/yandex/sovetnik-backend/sovetnik-users.log",
       "ip": "185.66.252.103", "subkey": "", "date": "2017-04-11",
       "_logfeller_index_bucket": "//home/logfeller/index/sovetnik-backend/sovetnik-users-log/1800-1800/1507087500/1507087800",
       "tskv_format": "sovetnik-users-log", "id": "100014250271294", "script_version": "201710021925",
       "install_id": "undefined", "iso_eventtime": "2017-04-11 06:32:57", "is_mobile": "0", "timestamp": "1507087977",
       "client_id": "5bc759d05-e5d3-4548-ae5f-e1bf47df02b5",
       "useragent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 YaBrowser/17.9.0.2081 Yowser/2.5 Safari/537.36",
       "domain": "www.facebook.com", "unixtime": "1507087977", "locale": "ru", "_logfeller_timestamp": 1507087977,
       "_stbx": "rt3.myt--sovetnik-backend--sovetnik-users-log:0@@92200@@base64:J_9H-GYHYWQVWThOIqDePQ@@1507087977967@@1507087978@@sovetnik-users-log@@582299189",
       "aff_id": "1004", "type_sn": "FB", "url": "https://www.facebook.com/", "yandex_login": "shackirov.zhanybai"})
testdata_sovetnik_2016_04_11.add_row(
    **{"clid": "2236989", "browser": "Yandex", "lang": "ru", "host": "sovetnik02h", "os": "Windows", "geo_id": "213",
       "region": "RU", "type": "SOCIAL_NETWORK_PROFILE", "yandexuid": "157564101446625111",
       "transaction_id": "j8ch9pxwk2pkdzqopof4rzy9f8wllawg",
       "source_uri": "prt://sovetnik-backend@sovetnik02h.market.yandex.net/var/log/yandex/sovetnik-backend/sovetnik-users.log",
       "ip": "85.113.214.240", "subkey": "", "date": "2017-04-10",
       "_logfeller_index_bucket": "//home/logfeller/index/sovetnik-backend/sovetnik-users-log/1800-1800/1507087500/1507087800",
       "tskv_format": "sovetnik-users-log", "id": "528763796480", "script_version": "201710031623",
       "install_id": "undefined", "iso_eventtime": "2016-04-09 06:32:57", "is_mobile": "0", "timestamp": "1507087977",
       "client_id": "53e090abd-9edc-4ae2-8a28-287d083091ae",
       "useragent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 YaBrowser/17.9.0.2081 Yowser/2.5 Safari/537.36",
       "domain": "ok.ru", "unixtime": "1507087977", "locale": "ru", "_logfeller_timestamp": 1507087977,
       "_stbx": "rt3.myt--sovetnik-backend--sovetnik-users-log:0@@92200@@base64:J_9H-GYHYWQVWThOIqDePQ@@1507087977967@@1507087978@@sovetnik-users-log@@582299189",
       "aff_id": "1004", "type_sn": "OK", "url": "https://ok.ru/", "yandex_login": "abushova1683"})
testdata_sovetnik_2016_04_11.add_row(
    **{"clid": "2290154", "browser": "Yandex", "lang": "ru", "host": "sovetnik02h", "os": "Windows", "geo_id": "10309",
       "region": "RU", "type": "SOCIAL_NETWORK_PROFILE", "yandexuid": "157564101446625111",
       "transaction_id": "j8ch9d38wf5m9mgr88eqfaejlj0h6tdf",
       "source_uri": "prt://sovetnik-backend@sovetnik02h.market.yandex.net/var/log/yandex/sovetnik-backend/sovetnik-users.log",
       "ip": "185.66.252.103", "subkey": "", "date": "2017-04-10",
       "_logfeller_index_bucket": "//home/logfeller/index/sovetnik-backend/sovetnik-users-log/1800-1800/1507087500/1507087800",
       "tskv_format": "sovetnik-users-log", "id": "100014250271294", "script_version": "201710021925",
       "install_id": "undefined", "iso_eventtime": "2017-04-10 06:32:57", "is_mobile": "0", "timestamp": "1507087977",
       "client_id": "5bc759d05-e5d3-4548-ae5f-e1bf47df02b5",
       "useragent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 YaBrowser/17.9.0.2081 Yowser/2.5 Safari/537.36",
       "domain": "www.facebook.com", "unixtime": "1507087977", "locale": "ru", "_logfeller_timestamp": 1507087977,
       "_stbx": "rt3.myt--sovetnik-backend--sovetnik-users-log:0@@92200@@base64:J_9H-GYHYWQVWThOIqDePQ@@1507087977967@@1507087978@@sovetnik-users-log@@582299189",
       "aff_id": "1004", "type_sn": "FB", "url": "https://www.facebook.com/", "yandex_login": "shackirov.zhanybai"})


testdata_lal_manager_data_to_classify = ComplexParametersLog(
                path="//crypta/production/lal_manager",
                table_name="data_to_classify",
                default_data=LAL_MANAGER_DATA_TO_CLASSIFY
    )
testdata_lal_manager_data_to_classify.add_row(key="7065602181459497865", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224,1459497883:1388788224,1459497884:1388788224,1459497888:1388788224,1459497899:1388788224,1459497903:1399806976,1459497924:2982144,1459498085:2071493120,1459517002:1399806976,1459517012:1388788224,1459517013:1388788224,1459517014:1388788224,1459517022:1399806976,1459517065:1399806976,1459517072:1955230987,1459517123:1399806976,1459517134:1399806976,1459517151:1261654016,1459517157:742964226,1459517158:742964226,1459517178:1399806976,1459517183:1388788224,1459574033:1399806976,1459574049:2982144,1459574126:2982144,1459574843:2982144,1459576484:1399806976,1459576491:1399806976,1459576494:2074095105,1459576499:1374877440,1459576506:1374877440,1459576524:1374877440,1459576542:1374877440,1459576566:1374877440,1459577195:1374877440,1459577366:1374877440,1459577432:1374877440,1459577448:1374877440,1459577535:1374877440,1459577625:1374877440,1459577665:1374877440,1459578050:1374877440,1459578061:1374877440,1459578083:1374877440,1459578113:1374877440,1459578162:1374877440,1459578173:1374877440,1459578279:1374877440,1459578341:1374877440,1459578482:1374877440,1459578520:1374877440,1459578539:1374877440,1459578629:1374877440,1459578797:1559706880,1459578799:1783405313,1459578799:1399806976,1459579001:1374877440,1459579329:1374877440,1459579741:2982144,1459580093:1399806976,1459580098:1399806976,1459589458:1399806976,1459589492:1399806976,1459589495:1673216000,1459589497:1673216000,1459589504:715459072,1459589505:1208906240,1459589513:715459072,1459589515:2036538625,1459589534:715459072,1459589537:1858658048,1459589581:1858658048,1459589603:715459072,1459589616:715459072,1459589622:257603840,1459589642:2074095105,1459589644:1673216000,1459589652:21743873,1459589674:1497271808,1459589738:945459456,1459589781:1399806976,1459589790:863763200,1459589791:863763200,1459589797:863763200,1459590059:863763200,1459590176:863763200,1459590185:863763200,1459590254:863763200,1459590255:863763200,1459590275:863763200,1459591362:863763200,1459591380:863763200,1459591381:863763200,1459591383:863763200,1459591388:863763200,1459591392:863763200,1459591709:863763200,1459592567:1399806976,1459592600:1399806976,1459592605:2071493120,1459610949:1399806976,1459610968:1399806976,1459610993:1737924864,1459611024:1253575174,1459611025:1253575174,1459611041:1253575174,1459611497:1399806976,1459611515:1399806976,1459611594:1399806976,1459611606:1399806976,1459613084:1399806976,1459613101:1399806976,1459613112:1029721344,1459613157:1399806976,1459613182:1399806976,1459613189:1029721344,1459613289:1399806976,1459613309:1399806976,1459613312:1029721344,1459613404:1399806976,1459613426:1399806976,1459613431:1029721344,1459613554:1399806976,1459613565:1399806976,1459613568:1029721344,1459613648:1399806976,1459613691:1399806976,1459613695:1029721344,1459613775:1399806976,1459613796:1399806976,1459613799:1029721344,1459614050:1399806976,1459614069:1399806976,1459614074:1029721344,1459614445:1399806976,1459614461:1399806976,1459614466:1029721344,1459614479:1399806976,1459614900:1399806976,1459614904:1029721344,1459616519:1399806976,1459616574:1399806976,1459616579:1029721344,1459616604:1029721344,1459617167:1399806976,1459617184:1399806976,1459617191:1029721344,1459617626:1399806976,1459617672:1399806976,1459617675:1029721344,1459617905:1399806976,1459617923:1399806976,1459617959:1615831296,1459617988:1399806976,1459618216:1399806976,1459618221:1029721344,1459618577:1399806976,1459618592:1399806976,1459618617:894761216,1459618976:1399806976,1459619017:1399806976,1459619020:1029721344,1459619068:1029721344,1459619074:1772240128,1459619075:1772240128,1459619251:1399806976,1459619267:1399806976,1459619271:1029721344,1459619445:1399806976,1459619474:1399806976,1459619477:1029721344,1459620075:1399806976,1459620098:1399806976,1459620132:1399806976,1459620141:1772240128,1459620142:1772240128,1459620159:1029721344,1459620486:1399806976,1459620495:1029721344,1459620715:1399806976,1459620728:1029721344,1459620991:1399806976,1459620998:1029721344,1459621022:1943742219,1459621031:1134726656,1459621043:742964226,1459621053:1772240128,1459621054:1772240128,1459621801:1399806976,1459621836:2071493120,1459623364:556280320,1459624801:556280320,1459625009:556280320,1459626301:556280320,1459627901:556280320,1459627937:556280320,1459627973:556280320,1459686503:1399806976,1459686535:2071493120,1459688583:556280320,1459688817:556280320,1459689195:556280320,1459690117:556280320,1459691772:556280320,1459691850:556280320,1459693052:556280320,1459693807:556280320,1459694924:556280320,1459695241:556280320,1459696239:556280320,1459697133:556280320,1459699180:556280320,1459699943:556280320,1459700859:556280320,1459704735:556280320,1459705325:556280320,1459706076:556280320,1459706815:556280320,1459707542:556280320,1459708339:556280320,1459709179:556280320,1459709220:556280320,1459710033:556280320,1459710701:556280320,1459711724:556280320,1459713887:1399806976,1459713932:1399806976', u'words_count': u'124911360:1,197569792:1,254880512:7,492839936:1,626206464:1,662573824:2,692308480:1,712331520:4,800386816:1,812059648:1,859007232:1,935713792:1,954380544:1,964097536:1,970236160:1,971957248:11,992103936:1,1021715456:1,1072414464:1,1138601728:1,1225300224:2,1362326528:1,1417041920:1,1502180887:1,1581753600:1,1669560064:1,1681566208:1,1779099904:2,1885646336:1,1907852544:1,1920489729:1,2027452672:1,2056663296:18,2066058496:1,2069424640:1,2082022912:1,-2105498880:1,-1954635520:2,-1908080128:1,-1874979072:1,-1803806976:1,-1782597120:2,-1669634048:1,-1647186944:1,-1576203776:1,-1570764800:24,-1529356800:2,-1523656960:1,-1479660800:7,-1433694208:1,-1426960896:1,-1339737856:1,-1317875456:6,-1295378176:1,-1214572032:6,-1198372352:1,-1157633792:1,-1136577024:1,-1124377600:1,-1115573760:1,-897837056:26,-828156928:7,-798379520:1,-677894656:1,-667539968:1,-652350464:1,-630333184:1,-561821952:1,-381622528:1,-376268544:1,-329383680:1,-321946880:1,-309923328:1,-306145792:1,-261243889:1,-163024896:1,-157404928:1,-150570240:1,-150393856:2,-107410432:1,-105772288:1,-75572224:1,-23841024:1', u'mm_count': u'742964226:3,1737924864:1,1858658048:2,2071493120:4,1374877440:26,863763200:16,1559706880:1,1388788224:9,1253575174:3,894761216:1,1261654016:1,1673216000:3,1955230987:1,2036538625:1,1943742219:1,1615831296:1,21743873:1,556280320:33,257603840:1,945459456:1,715459072:5,2982144:5,1399806976:73,2074095105:2,1772240128:6,1783405313:1,1497271808:1,1208906240:1,1134726656:1,1029721344:23', u'offset': u'4'})
testdata_lal_manager_data_to_classify.add_row(key="5157564101446629164", subkey="1460299737", value={u'cyr_words_num': u'0;0;0;0', u'latlon': u'53183188;44997376', u'referers': u'1459188939:1751672064,1459607333:1751672064,1459628369:1751672064,1459628370:1751672064,1460137195:1751672064,1460137486:1751672064,1460137487:1751672064,1460137516:1751672064,1460281355:1751672064,1460281560:1751672064,1460281561:1751672064,1460281565:1877719809,1460281590:1751672064,1460281870:1751672064,1460281871:1751672064,1460299025:1751672064,1460299047:1751672064,1460299130:1751672064,1460299148:1751672064,1460299149:1751672064,1460299306:1751672064,1460299307:1751672064,1460299737:1751672064', u'refmirrors': u'1459188939:1751672064,1459607333:1751672064,1459628369:1751672064,1459628370:1751672064,1460137195:1751672064,1460137486:1751672064,1460137487:1751672064,1460137516:1751672064,1460281355:1751672064,1460281560:1751672064,1460281561:1751672064,1460281565:1877719809,1460281590:1751672064,1460281870:1751672064,1460281871:1751672064,1460299025:1751672064,1460299047:1751672064,1460299130:1751672064,1460299148:1751672064,1460299149:1751672064,1460299306:1751672064,1460299307:1751672064,1460299737:1751672064', u'words_num': u'0;0;0;0', u'm_count': u'1847937024:1,1877719809:3,2113601792:2,258700800:2,559688704:2,1168242944:1,1184225537:1,151918080:1,40298240:4,489716992:1,264723458:1,952305921:1,1207535619:1,718161408:1,1540143104:3,1876992000:2', u'offset': u'4', u'm_agentId': u'8', u'mm_count': u'1877719809:3,1216877830:1,258700800:2,559688704:2,1168242944:1,1184225537:1,151918080:1,40298240:4,489716992:1,1783405313:2,264723458:1,952305921:1,1207535619:1,718161408:1,1540143104:3,1876992000:2', u'mm_hits': u'1459188939:1207535619,1459607333:40298240,1459607333:1783405313,1459607333:40298240,1459628369:40298240,1459628369:1783405313,1459628370:40298240,1460137195:1184225537,1460137486:559688704,1460137487:559688704,1460137516:151918080,1460281355:952305921,1460281560:1877719809,1460281561:1877719809,1460281565:1877719809,1460281590:718161408,1460281870:1540143104,1460281871:1540143104,1460299025:1540143104,1460299047:264723458,1460299130:1168242944,1460299148:258700800,1460299149:258700800,1460299306:1876992000,1460299307:1876992000,1460299737:1216877830,1460299737:489716992', u'm_interest_time_clickstream': u'1459607333:9000090;1459607333:9000090;1459628369:9000090;1459628370:9000090;1460137486:9000654;1460137487:9000654;1460137516:9000018;1460281560:9000080,9000476,9000007;1460281561:9000080,9000476,9000007;1460281565:9000080,9000476,9000007;1460281590:9000105;1460281870:9002873,9000080,9000007;1460281871:9002873,9000080,9000007;1460299025:9002873,9000080,9000007;1460299148:9000096,9000635;1460299149:9000096,9000635;1460299306:9000096,9000635;1460299307:9000096,9000635;1460299737:9000118', u'd_count': u'0:2,1:2,11:23', u'cyr_word_len': u'0;0;0;0', u'rids': u'49:27'})
testdata_lal_manager_data_to_classify.add_row(key="2286815551454655817", subkey="1459766606", value={u'cyr_words_num': u'2;2;2;0', u'latlon': u'51471920;81694598', u'referers': u'1457246541:139536641,1457246547:139536641,1457246576:1994241792,1457246799:242914048,1457246800:1979094272,1457246806:1979094272,1457246829:1994241792,1457246842:1994241792,1457246860:1994241792,1457295557:1980929035,1458286195:1368441088,1458286210:1368441088,1458634446:1980929035,1458691506:371277318,1458713391:1913996032,1458713396:1913996032,1458713442:1913996032,1458713472:1913996032,1458713518:1913996032,1458713527:1913996032,1458713563:1913996032,1458713604:1913996032,1459379043:1913996032,1459379058:1913996032,1459379059:1913996032,1459379067:1913996032,1459379068:1913996032,1459379162:1913996032,1459379170:1913996032,1459379182:1913996032,1459379197:1913996032,1459379216:1913996032,1459379237:1913996032,1459379257:1913996032,1459379276:1913996032', u'refmirrors': u'1457246541:139536641,1457246547:139536641,1457246576:1994241792,1457246799:242914048,1457246800:242914048,1457246806:242914048,1457246829:1994241792,1457246842:1994241792,1457246860:1994241792,1457295557:1980929035,1458286195:1368441088,1458286210:1368441088,1458634446:1980929035,1458691506:371277318,1458713391:1913996032,1458713396:1913996032,1458713442:1913996032,1458713472:1913996032,1458713518:1913996032,1458713527:1913996032,1458713563:1913996032,1458713604:1913996032,1459379043:1913996032,1459379058:1913996032,1459379059:1913996032,1459379067:1913996032,1459379068:1913996032,1459379162:1913996032,1459379170:1913996032,1459379182:1913996032,1459379197:1913996032,1459379216:1913996032,1459379237:1913996032,1459379257:1913996032,1459379276:1913996032', u'words_num': u'3;3;3;0', u'm_count': u'1979094272:1,1902989829:1,371277318:3,1021476098:1,921915904:4,280836096:1,1368441088:6,242914048:2,139536641:1,1994241792:9,2037344768:1,1913996032:26', u'offset': u'11', u'm_agentId': u'8', u'mm_count': u'1902989829:1,371277318:3,1021476098:1,921915904:4,280836096:1,1368441088:6,242914048:3,139536641:1,1994241792:9,2037344768:1,1913996032:26', u'mm_hits': u'1456881330:1994241792,1457246539:139536641,1457246541:1994241792,1457246547:1994241792,1457246576:1994241792,1457246778:242914048,1457246782:242914048,1457246799:242914048,1457246800:1994241792,1457246806:1994241792,1457246829:1994241792,1457246842:1994241792,1457246860:1994241792,1457295557:280836096,1458122244:921915904,1458122245:921915904,1458222897:1902989829,1458222961:921915904,1458222962:921915904,1458286166:1368441088,1458286195:1368441088,1458286210:1368441088,1458286267:1368441088,1458286376:1368441088,1458286451:1368441088,1458634446:1021476098,1458691505:371277318,1458691506:371277318,1458691506:371277318,1458713380:1913996032,1458713391:1913996032,1458713396:1913996032,1458713442:1913996032,1458713472:1913996032,1458713518:1913996032,1458713527:1913996032,1458713563:1913996032,1458713604:1913996032,1459379038:1913996032,1459379043:1913996032,1459379058:1913996032,1459379058:1913996032,1459379059:1913996032,1459379063:1913996032,1459379067:1913996032,1459379068:1913996032,1459379080:1913996032,1459379162:1913996032,1459379170:1913996032,1459379182:1913996032,1459379197:1913996032,1459379216:1913996032,1459379237:1913996032,1459379257:1913996032,1459379276:1913996032,1459766606:2037344768', u'catalogue': u'1457246796:3665,90', u'm_interest_time_clickstream': u'1458122244:9000739,9000668;1458122245:9000668,9000156,9000018,9000437;1458222961:9000668;1458222962:9000668,9000739', u'd_count': u'0:1,11:52', u'words_count': u'234742272:1,528699392:1,1839135744:1,2105736192:1,-928841472:1', u'cyr_word_len': u'5;5;5;0', u'rids': u'73:36,76:14,11453:7', u'r_hits': u'1457246796:291384127', u'catalogue_full': u'1457246796:90-80:3665-11'})


testdata_passport_social = BaseLog(
                path="//home/passport/production/socialism/crypta-dump",
                date="2016-04-11",
                default_data=PASSPORT_SOCIAL
    )
testdata_passport_social.add_row(uid="43453761", email=u'kokourov@gmail.com', phone='b4c11119e458bc1ff36e60f66b31e57f')
testdata_passport_social.add_row(uid="43453761", provider_id="2", userid='4657466', email=u'kokourov@gmail.com', phone='6a8a244553d8676d8fef4351712ec5fc')
testdata_passport_social.add_row(uid="34138394", email=u'ps5957466@yandex.ru', phone='4b52d13c66075ad12683daaa05ee9cba')
testdata_passport_social.add_row(uid="43453762", email=u'kokourov@gmail.com', phone='c616eef1826f1fde81bc4016af84c159')
testdata_passport_social.add_row(uid="34138394", email=u'ps5957466@yandex.ru')
testdata_passport_social.add_row(uid="34138394", provider_id="1", email=u'ps5957466@yandex.ru')
testdata_passport_social.add_row(uid="43453763", provider_id="1", userid='4657454', email=u'ps5957466@yandex.ru')
testdata_passport_social.add_row(uid="43453769", provider_id="1", userid='4657452')




testdata_webvisor_copy_1460163600 = ComplexParametersLog(
                path="//crypta/production/storage/fresh/webvisor_copy",
                table_name="1460163600",
                default_data=WEBVISOR_COPY
    )
testdata_webvisor_copy_1460163600.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460163600.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460163600.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")
testdata_webvisor_copy_1460163600.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460163600.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")


testdata_webvisor_copy_1460250000 = ComplexParametersLog(
                path="//crypta/production/storage/fresh/webvisor_copy",
                table_name="1460250000",
                default_data=WEBVISOR_COPY
    )
testdata_webvisor_copy_1460250000.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460250000.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460250000.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")
testdata_webvisor_copy_1460250000.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460250000.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")


testdata_webvisor_copy_1460336400 = ComplexParametersLog(
                path="//crypta/production/storage/fresh/webvisor_copy",
                table_name="1460336400",
                default_data=WEBVISOR_COPY
    )
testdata_webvisor_copy_1460336400.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460336400.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460336400.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")
testdata_webvisor_copy_1460336400.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460336400.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")


testdata_webvisor_copy_1460529096 = ComplexParametersLog(
                path="//crypta/production/storage/fresh/webvisor_copy",
                table_name="1460529096",
                default_data=WEBVISOR_COPY
    )
testdata_webvisor_copy_1460529096.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460529096.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460529096.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")
testdata_webvisor_copy_1460529096.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_copy_1460529096.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")


testdata_webvisor_1460163600 = ComplexParametersLog(
                path="//crypta/production/storage/fresh/webvisor",
                table_name="1460163600",
                default_data=WEBVISOR_COPY
    )
testdata_webvisor_1460163600.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460163600.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460163600.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")
testdata_webvisor_1460163600.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460163600.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")

testdata_webvisor_1460250000 = ComplexParametersLog(
                path="//crypta/production/storage/fresh/webvisor",
                table_name="1460250000",
                default_data=WEBVISOR_COPY
    )
testdata_webvisor_1460250000.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460250000.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460250000.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")
testdata_webvisor_1460250000.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460250000.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")

testdata_webvisor_1460336400 = ComplexParametersLog(
                path="//crypta/production/storage/fresh/webvisor",
                table_name="1460336400",
                default_data=WEBVISOR_COPY
    )
testdata_webvisor_1460336400.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460336400.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460336400.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")
testdata_webvisor_1460336400.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460336400.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")

testdata_webvisor_1460529096 = ComplexParametersLog(
                path="//crypta/production/storage/fresh/webvisor",
                table_name="1460529096",
                default_data=WEBVISOR_COPY
    )
testdata_webvisor_1460529096.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460529096.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460529096.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")
testdata_webvisor_1460529096.add_row(value={u'url': u'https://optimoney.ru/zayavka?utm_source=linkprofit&utm_medium=cpa&utm_campaign=optimoney&wm_id=777&wm_chan=777_search4007477240', u'email': u'kiv271087@mail.ru', u'ts': u'1460527615'}, subkey="1460527615", key="2501055761455360720")
testdata_webvisor_1460529096.add_row(value={u'email_id': u'login', u'email_name': u'UserName', u'url': u'http://localhost:5710/Cabinet/Photos/?company_id=2537664', u'ts': u'1460527616', u'email': u'testings_for_work2@mail.ru'}, subkey="1460527616", key="216107801460014517")


testdata_all_radius_ips_date = BaseLog(
                path="//crypta/production/state/radius/log/2016-04-11",
                table_name="all_radius_ips",
                default_data={}
    )
testdata_all_radius_ips_date.add_row(ip="217.118.90.186")
testdata_all_radius_ips_date.add_row(ip="217.118.90.186")
testdata_all_radius_ips_date.add_row(ip="176.52.102.148")
testdata_all_radius_ips_date.add_row(ip="85.174.38.23")
testdata_all_radius_ips_date.add_row(ip="85.174.38.23")
testdata_all_radius_ips_date.add_row(ip="85.174.38.25")
testdata_all_radius_ips_date.add_row(ip="85.174.38.33")
testdata_all_radius_ips_date.add_row(ip="85.174.38.33")
testdata_all_radius_ips_date.add_row(ip="85.174.38.25")
testdata_all_radius_ips_date.add_row(ip="176.59.7.165")


testdata_radius_log = BaseLog(
                path="//crypta/production/state/radius/log/2016-04-11",
                table_name="radius_log",
                default_data=RADIUS_LOG
    )
testdata_radius_log.add_row(ip="217.118.90.186", login="login-10")
testdata_radius_log.add_row(ip="217.118.90.186", login="login-10")
testdata_radius_log.add_row(ip="176.52.102.148", login="login-37")
testdata_radius_log.add_row(ip="85.174.38.23", login="mail_login")
testdata_radius_log.add_row(ip="85.174.38.25", login="mail_login2")
testdata_radius_log.add_row(ip="85.174.38.25", login="mail_login_mob")
testdata_radius_log.add_row(ip="85.174.38.33", login="WatchRadius")
testdata_radius_log.add_row(ip="85.174.38.33", login="WatchRadius2")
testdata_radius_log.add_row(ip="85.174.38.23", login="login-1")
testdata_radius_log.add_row(ip="213.149.4.236", login="login-5")
testdata_radius_log.add_row(ip="176.59.7.165", login="login-10")


testdata_log_all_radius_ips = BaseLog(
                path="//crypta/production/state/radius/log",
                table_name="all_radius_ips",
                default_data={}
    )
testdata_log_all_radius_ips.add_row(ip="217.118.90.186")
testdata_log_all_radius_ips.add_row(ip="217.118.90.186")
testdata_log_all_radius_ips.add_row(ip="176.52.102.148")
testdata_log_all_radius_ips.add_row(ip="85.174.38.23")
testdata_log_all_radius_ips.add_row(ip="85.174.38.23")
testdata_log_all_radius_ips.add_row(ip="85.174.38.23")
testdata_log_all_radius_ips.add_row(ip="85.174.38.25")
testdata_log_all_radius_ips.add_row(ip="85.174.38.25")
testdata_log_all_radius_ips.add_row(ip="85.174.38.33")
testdata_log_all_radius_ips.add_row(ip="85.174.38.33")
testdata_log_all_radius_ips.add_row(ip="176.59.7.165")


testdata_dicts_dev_info = ComplexParametersLog(
                path="//crypta/production/state/graph/dicts",
                table_name="dev_info",
                default_data=DICTS_DEV_INFO
    )
testdata_dicts_dev_info.add_row(key="31b332e66c971b9e94ddcc921de85eb7", value={u'mmetric_devids': u'31b332e66c971b9e94ddcc921de85eb7', u'screen_width': u'960', u'ua_profile': u'm|phone|samsung|android|4.4.2', u'apps': u'ru.yandex.searchplugin,com.avito.android,com.edadeal.android', u'connection_hist': u'cell:189,wifi:398', u'os_version': u'4.4.2', u'device_type': u'phone', u'google_adv_id': u'fcbed30d-c9a1-45d3-867e-1c47921b817e', u'model': u'Galaxy S4 Mini', u'manufacturer': u'Samsung', u'android_id': u'10bd82293264b388', u'screen_height': u'540'})
testdata_dicts_dev_info.add_row(key="31b332e66c971b9e94ddcc921de85eb7", value={u'mmetric_devids': u'31b332e66c971b9e94ddcc921de85eb7', u'screen_width': u'960', u'ua_profile': u'm|phone|samsung|android|4.4.2', u'apps': u'ru.yandex.searchplugin,com.avito.android,com.edadeal.android', u'connection_hist': u'cell:189,wifi:398', u'os_version': u'4.4.2', u'device_type': u'phone', u'google_adv_id': u'fcbed30d-c9a1-45d3-867e-1c47921b817e', u'model': u'Galaxy S4 Mini', u'manufacturer': u'Samsung', u'android_id': u'10bd82293264b388', u'screen_height': u'540'})
testdata_dicts_dev_info.add_row(key="32364d94bc020a2366adbc3b69cde858", value={u'mmetric_devids': u'32364d94bc020a2366adbc3b69cde858', u'screen_width': u'1280', u'ua_profile': u'm|phone|un|android|4.1.2', u'apps': u'ru.yandex.weatherplugin,ru.yandex.yandexnavi', u'connection_hist': u'cell:2,wifi:12', u'os_version': u'4.1.2', u'device_type': u'phone', u'google_adv_id': u'06edf5c0-39e3-4389-88af-497d6f9b139c', u'model': u'ZP950H', u'manufacturer': u'ZWX', u'timestamp_10m': u'1460886600', u'android_id': u'a3bbe9f2af3c9d49', u'screen_height': u'720'})
testdata_dicts_dev_info.add_row(key="31b332e66c971b9e94ddcc921de85eb7", value={u'mmetric_devids': u'31b332e66c971b9e94ddcc921de85eb7', u'screen_width': u'960', u'ua_profile': u'm|phone|samsung|android|4.4.2', u'apps': u'ru.yandex.searchplugin,com.avito.android,com.edadeal.android', u'connection_hist': u'cell:189,wifi:398', u'os_version': u'4.4.2', u'device_type': u'phone', u'google_adv_id': u'fcbed30d-c9a1-45d3-867e-1c47921b817e', u'model': u'Galaxy S4 Mini', u'manufacturer': u'Samsung', u'android_id': u'10bd82293264b388', u'screen_height': u'540'})
testdata_dicts_dev_info.add_row(key="32364d94bc020a2366adbc3b69cde858", value={u'mmetric_devids': u'32364d94bc020a2366adbc3b69cde858', u'screen_width': u'1280', u'ua_profile': u'm|phone|un|android|4.1.2', u'apps': u'ru.yandex.weatherplugin,ru.yandex.yandexnavi', u'connection_hist': u'cell:2,wifi:12', u'os_version': u'4.1.2', u'device_type': u'phone', u'google_adv_id': u'06edf5c0-39e3-4389-88af-497d6f9b139c', u'model': u'ZP950H', u'manufacturer': u'ZWX', u'timestamp_10m': u'1460886600', u'android_id': u'a3bbe9f2af3c9d49', u'screen_height': u'720'})


testdata_dicts_yuid_with_all_good = BaseLog(
                path="//crypta/production/state/graph/dicts",
                table_name="yuid_with_all_good",
                default_data=DICTS_YUID_WITH_ALL_GOOD
    )
testdata_dicts_yuid_with_all_good.add_row(reg_fp_dates="{u'47': {u'2016-04-07': 21, u'2016-04-09': 1, u'2016-04-08': 99, u'2016-04-10': 28, u'2016-04-11': 478, u'2016-04-12': 9}}", age="0.150995,0.697246,0.110961,0.028282,0.012513", ip_fp_dates="{u'5.164.250.199': {u'2016-04-08': 99, u'2016-04-07': 21}, u'5.164.235.154': {u'2016-04-09': 1, u'2016-04-10': 28, u'2016-04-11': 478, u'2016-04-12': 9}}", sex="0.954289,0.04571", browser_version="16.3.0.7146", income="0.011687,0.577247,0.411065", yuid="9062563711460046733", ua="Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7146 Yowser/2.5 Safari/537.36", ua_profile="d|desk|windows|10.0", browser="yandexbrowser")
testdata_dicts_yuid_with_all_good.add_row(reg_fp_dates="{u'47': {u'2016-04-07': 21, u'2016-04-09': 1, u'2016-04-08': 99, u'2016-04-10': 28, u'2016-04-11': 478, u'2016-04-12': 9}}", age="0.150995,0.697246,0.110961,0.028282,0.012513", ip_fp_dates="{u'5.164.250.199': {u'2016-04-08': 99, u'2016-04-07': 21}, u'5.164.235.154': {u'2016-04-09': 1, u'2016-04-10': 28, u'2016-04-11': 478, u'2016-04-12': 9}}", sex="0.954289,0.04571", browser_version="16.3.0.7146", income="0.011687,0.577247,0.411065", yuid="9062563711460046733", ua="Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7146 Yowser/2.5 Safari/537.36", ua_profile="d|desk|windows|10.0", browser="yandexbrowser")
testdata_dicts_yuid_with_all_good.add_row(reg_fp_dates="{u'47': {u'2016-04-07': 21, u'2016-04-09': 1, u'2016-04-08': 99, u'2016-04-10': 28, u'2016-04-11': 478, u'2016-04-12': 9}}", age="0.150995,0.697246,0.110961,0.028282,0.012513", ip_fp_dates="{u'5.164.250.199': {u'2016-04-08': 99, u'2016-04-07': 21}, u'5.164.235.154': {u'2016-04-09': 1, u'2016-04-10': 28, u'2016-04-11': 478, u'2016-04-12': 9}}", sex="0.954289,0.04571", browser_version="16.3.0.7146", income="0.011687,0.577247,0.411065", yuid="9062563711460046733", ua="Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7146 Yowser/2.5 Safari/537.36", ua_profile="d|desk|windows|10.0", browser="yandexbrowser")


testdata_sbapi_lookup_access_log = BaseLog(
                path="//statbox/sbapi-lookup-access-log",
                date="2016-04-09",
                default_data=SBAPI_LOOKUP_ACCESS_LOG
    )
testdata_sbapi_lookup_access_log.add_row(status="200", user_agent="Mozilla/5.0 (iPad; CPU OS 9_0_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) YaBrowser/16.2.0.6967.11 Mobile/13A452 Safari/601.1", iso_eventtime="2016-04-09 23:09:33", request_time="0.001", timestamp="09/Apr/2016:23:09:33", source_uri="prt://extdata@man1-6606.search.yandex.net/usr/local/www/logs/current-sba-11900-access.log", request="/urlinfo?pver=1.0&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&brandID=yandex&brclid=2092368&post=0&ver=47.0.2526.6967&referer=&brl=ru&uuid=202e825ff99eb18a6e586260a5635eab&yasoft=ipad.yabrowser&yandexuid=2969624891454329934", _stbx="rt3.man--extdata--sbapi-lookup-access-log:9:31639479", method="POST")
testdata_sbapi_lookup_access_log.add_row(status="200", user_agent="Mozilla/5.0 (iPad; CPU OS 9_0_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) YaBrowser/16.2.0.6967.11 Mobile/13A452 Safari/601.1", iso_eventtime="2016-04-09 23:09:33", request_time="0.001", timestamp="09/Apr/2016:23:09:33", source_uri="prt://extdata@man1-6606.search.yandex.net/usr/local/www/logs/current-sba-11900-access.log", request="/urlinfo?pver=1.0&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&brandID=yandex&brclid=2092368&post=0&ver=47.0.2526.6967&referer=&brl=ru&uuid=202e825ff99eb18a6e586260a5635eab&yasoft=ipad.yabrowser&yandexuid=2969624891454329934", _stbx="rt3.man--extdata--sbapi-lookup-access-log:9:31639479:", method="POST")
testdata_sbapi_lookup_access_log.add_row(status="200", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) YaBrowser/16.2.0.6967.10 Mobile/13D15 Safari/601.1", iso_eventtime="2016-04-09 23:09:18", request_time="0.001", timestamp="09/Apr/2016:23:09:18", source_uri="prt://extdata@ws40-157.yandex.ru/usr/local/www/logs/current-sba-7640-access.log", request="/urlinfo?pver=1.0&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&brandID=yandex&brclid=2035230&post=0&ver=47.0.2526.6967&referer=http%3A%2F%2Fyandex.ru%2Fsearch%2Ftouch%2F%253Ftext%253D%2525D0%2525B6%2525D0%2525B0%2525D0%2525BB%2525D1%25258E%2525D0%2525B7%2525D0%2525B8%252520%2525D0%2525BD%2525D0%2525B0%252520%2525D0%2525BE%2525D1%252582%2525D0%2525BA%2525D0%2525B8%2525D0%2525B4%2525D0%2525BD%2525D0%2525BE%2525D0%2525B5%252520%2525D0%2525BE%2525D0%2525BA%2525D0%2525BD%2525D0%2525BE%2526clid%253D2160746%2526brorich%253D1%2526lr%253D193&brl=ru&uuid=b3ea30a423c1edf922ca66a1a06a4a49&yasoft=iphone.yabrowser&yandexuid=1448840131444464872", extdata_client_ip="128.71.70.145", balancer_ip="2a02:6b8:0:f1e::5ff:c609", _stbx="rt3.iva--extdata--sbapi-lookup-access-log:3:27440357:", method="POST")
testdata_sbapi_lookup_access_log.add_row(status="200", user_agent="Mozilla/5.0 (iPad; CPU OS 9_0_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) YaBrowser/16.2.0.6967.11 Mobile/13A452 Safari/601.1", iso_eventtime="2016-04-09 23:09:33", request_time="0.001", timestamp="09/Apr/2016:23:09:33", source_uri="prt://extdata@man1-6606.search.yandex.net/usr/local/www/logs/current-sba-11900-access.log", request="/urlinfo?pver=1.0&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&brandID=yandex&brclid=2092368&post=0&ver=47.0.2526.6967&referer=&brl=ru&uuid=202e825ff99eb18a6e586260a5635eab&yasoft=ipad.yabrowser&yandexuid=2969624891454329934", _stbx="rt3.man--extdata--sbapi-lookup-access-log:9:31639479:", method="POST")
testdata_sbapi_lookup_access_log.add_row(status="200", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) YaBrowser/16.2.0.6967.10 Mobile/13D15 Safari/601.1", iso_eventtime="2016-04-09 23:09:18", request_time="0.001", timestamp="09/Apr/2016:23:09:18", source_uri="prt://extdata@ws40-157.yandex.ru/usr/local/www/logs/current-sba-7640-access.log", request="/urlinfo?pver=1.0&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&brandID=yandex&brclid=2035230&post=0&ver=47.0.2526.6967&referer=http%3A%2F%2Fyandex.ru%2Fsearch%2Ftouch%2F%253Ftext%253D%2525D0%2525B6%2525D0%2525B0%2525D0%2525BB%2525D1%25258E%2525D0%2525B7%2525D0%2525B8%252520%2525D0%2525BD%2525D0%2525B0%252520%2525D0%2525BE%2525D1%252582%2525D0%2525BA%2525D0%2525B8%2525D0%2525B4%2525D0%2525BD%2525D0%2525BE%2525D0%2525B5%252520%2525D0%2525BE%2525D0%2525BA%2525D0%2525BD%2525D0%2525BE%2526clid%253D2160746%2526brorich%253D1%2526lr%253D193&brl=ru&uuid=b3ea30a423c1edf922ca66a1a06a4a49&yasoft=iphone.yabrowser&yandexuid=1448840131444464872", extdata_client_ip="128.71.70.145", balancer_ip="2a02:6b8:0:f1e::5ff:c609", _stbx="rt3.iva--extdata--sbapi-lookup-access-log:3:27440357:", method="POST")

testdata_sbapi_lookup_access_log.add_row(_date="2016-04-10", status="200", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) YaBrowser/16.2.0.3537.10 Mobile/13D15 Safari/601.1", iso_eventtime="2016-04-10 02:12:31", request_time="0.001", timestamp="10/Apr/2016:02:12:31", source_uri="prt://extdata@sas1-2794.search.yandex.net/usr/local/www/logs/current-sba-14080-access.log", request="/urlinfo?pver=1.0&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&brandID=yandex&brclid=1955450&post=0&ver=47.0.2526.3537&referer=http%3A%2F%2Fyandex.ru%2Fsearch%2Ftouch%2F%253Ftext%253D%2525D0%2525BD%2525D0%2525B5%2525D1%252583%2525D0%2525B6%2525D0%2525B5%2525D0%2525BB%2525D0%2525B8%2526clid%253D2160746%2526brorich%253D1%2526lr%253D10719&brl=ru&uuid=e43fbc12224f226098292a98ce7dafa4&yasoft=iphone.yabrowser&yandexuid=1222393021392990407", _stbx="rt3.sas--extdata--sbapi-lookup-access-log:5:63371911:>", method="POST")
testdata_sbapi_lookup_access_log.add_row(_date="2016-04-10", status="200", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) YaBrowser/16.2.0.3537.10 Mobile/13D15 Safari/601.1", iso_eventtime="2016-04-10 02:12:31", request_time="0.001", timestamp="10/Apr/2016:02:12:31", source_uri="prt://extdata@sas1-2794.search.yandex.net/usr/local/www/logs/current-sba-14080-access.log", request="/urlinfo?pver=1.0&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&brandID=yandex&brclid=1955450&post=0&ver=47.0.2526.3537&referer=http%3A%2F%2Fyandex.ru%2Fsearch%2Ftouch%2F%253Ftext%253D%2525D0%2525BD%2525D0%2525B5%2525D1%252583%2525D0%2525B6%2525D0%2525B5%2525D0%2525BB%2525D0%2525B8%2526clid%253D2160746%2526brorich%253D1%2526lr%253D10719&brl=ru&uuid=e43fbc12224f226098292a98ce7dafa4&yasoft=iphone.yabrowser&yandexuid=1222393021392990407", _stbx="rt3.sas--extdata--sbapi-lookup-access-log:5:63371911:", method="POST")
testdata_sbapi_lookup_access_log.add_row(_date="2016-04-10", status="200", user_agent="Mozilla/5.0 (iPad; CPU OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) YaBrowser/16.2.0.4965.11 Mobile/13E238 Safari/601.1", iso_eventtime="2016-04-10 23:39:59", request_time="0.001", timestamp="10/Apr/2016:23:39:59", source_uri="prt://extdata@ws40-270.yandex.ru/usr/local/www/logs/current-sba-7640-access.log", request="/urlinfo?pver=1.0&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&brandID=yandex&brclid=1955450&post=0&ver=47.0.2526.4965&referer=&brl=ru&uuid=37959e8c4c187a79765f6ce867e026af&yasoft=ipad.yabrowser&yandexuid=9191478421436994279", extdata_client_ip="77.94.189.216", balancer_ip="2a02:6b8:b000:614:922b:34ff:fecf:3c7e", _stbx="rt3.iva--extdata--sbapi-lookup-access-log:7:28572886:", method="POST")

testdata_sbapi_lookup_access_log.add_row(_date="2016-04-11", status="204", user_agent="Mozilla/5.0 (iPad; CPU OS 8_1_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) YaBrowser/15.4.2272.3000.11 Mobile/12B440 Safari/600.1.4", iso_eventtime="2016-04-11 16:16:11", request_time="0.002", timestamp="11/Apr/2016:16:16:11", source_uri="prt://extdata@ws36-005.yandex.ru/usr/local/www/logs/current-sba-7640-access.log", request="/lookup?pver=3.60&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&url=http://m.outletvillage-bd.com/index.php%3Fid%3D241%26L%3D1%26uid%3D2108&brandID=yandex&brclid=1955452&post=0&nav=b&ver=41.0.2272.118&referer=http%3A%2F%2Fyandex.ru%2Fclck%2Fjsredir%253Ffrom%253Dyandex.ru%25253Bpadsearch%25253Bweb%25253B%25253B%2526text%253D%2526etext%253D1021.CSt_hCZwfAbcgsLQbPrlcTfiaTJnFXtKwIGhrljDQPVMl8cgmGJ6Jqu5Gg5Q0xf797nxpN20hZASdhu_Nn3pdA.099b994cadead976559b7954b4964a8ed2fa15d8%2526uuid%253D%2526state%253DPEtFfuTeVD5kpHnK9lio9QkU1tHIaqSGgLvu8tWxgFMpARjLsh_HvKB7meR8kCfYozrghFPTsOBIhctM7N0VThQbavs1Irkr%2526data%253DUlNrNmk5WktYejR0eWJFYk1LdmtxckpjZXVLSGtPQ0tuV1J0Rnk2ejVMZ2tKQmU0RjVWYVl1RkxJb0t3YVV2SnhsM1NObVBjaEJXblA5ejVYWm5MWUdKQVB3NnZVSEdzaXQ4UUtyNDdkZWt4SG5tbXp5dGdMZw%2526b64e%253D2%2526sign%253Db6c426bf612e30bbed1035e942804c09%2526keyno%253D0%2526cst%253DAiuY0DBWFJ5fN_r-AEszk1ULmEETiONPovclksWeh1mf85LePs-x419aww8f2LKWU25fBr5bIDGtzmiKmhGanRf1cBnsjFoBr3375PtVAC0FTEHkiKqZODFuw15miKYlhZa_1tpkc_Imz3lPaYBZLSzaWcb7PWhRNcXYNJDKzsP0BVtPDkcj0_1D353MYvAk%2526ref%253DcM777e4sMOAycdZhdUbYHnZeTopSOZlKfLucdwQFJoAlKFDZ0IuSW2-Y8KEjDBb6MkhFqlOdwOwZd1hRQf3sD5Rx64Qq0gJL9UNLAOBwWlmPVNuNPSZDlxG_CJ1VFXkc66YVFYpeS5C-z46P7Xizczl0gH4n1wbHstfbB5HT9B9fbqFNmxHH-HaSyFHdhmYJQyXJ-459s1Mpy7yQZga6TzXxMpbOQX8N0QqANJ-H7GFLq5DSGsunKbMfIDvFK7Pa_Dfd-KEMStdO3HJo2N91nA1VCaBlFkHFrjXrEWMTsdISPjW-ebCXX58h-ymVOYlLb-F5SuIEK660y4naZwQXEMkLLv_lc8nlcg3LMVRZ5bQ8bDXWUvicyWmkGhN8CHymxRYqkqaW5_SQz1jlZrt_fw%2526l10n%253Dru%2526cts%253D1460380540651&brl=ru&uuid=99b61890edd65286ea1c276e6af6d4ed&yasoft=ipad.yabrowser&yandexuid=1260800651387382150", _stbx="rt3.fol--extdata--sbapi-lookup-access-log:1:14490260:", method="GET")
testdata_sbapi_lookup_access_log.add_row(_date="2016-04-11", status="204", user_agent="Mozilla/5.0 (iPad; CPU OS 8_1_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) YaBrowser/15.4.2272.3000.11 Mobile/12B440 Safari/600.1.4", iso_eventtime="2016-04-11 16:16:11", request_time="0.002", timestamp="11/Apr/2016:16:16:11", source_uri="prt://extdata@ws36-005.yandex.ru/usr/local/www/logs/current-sba-7640-access.log", request="/lookup?pver=3.60&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&url=http://m.outletvillage-bd.com/index.php%3Fid%3D241%26L%3D1%26uid%3D2108&brandID=yandex&brclid=1955452&post=0&nav=b&ver=41.0.2272.118&referer=http%3A%2F%2Fyandex.ru%2Fclck%2Fjsredir%253Ffrom%253Dyandex.ru%25253Bpadsearch%25253Bweb%25253B%25253B%2526text%253D%2526etext%253D1021.CSt_hCZwfAbcgsLQbPrlcTfiaTJnFXtKwIGhrljDQPVMl8cgmGJ6Jqu5Gg5Q0xf797nxpN20hZASdhu_Nn3pdA.099b994cadead976559b7954b4964a8ed2fa15d8%2526uuid%253D%2526state%253DPEtFfuTeVD5kpHnK9lio9QkU1tHIaqSGgLvu8tWxgFMpARjLsh_HvKB7meR8kCfYozrghFPTsOBIhctM7N0VThQbavs1Irkr%2526data%253DUlNrNmk5WktYejR0eWJFYk1LdmtxckpjZXVLSGtPQ0tuV1J0Rnk2ejVMZ2tKQmU0RjVWYVl1RkxJb0t3YVV2SnhsM1NObVBjaEJXblA5ejVYWm5MWUdKQVB3NnZVSEdzaXQ4UUtyNDdkZWt4SG5tbXp5dGdMZw%2526b64e%253D2%2526sign%253Db6c426bf612e30bbed1035e942804c09%2526keyno%253D0%2526cst%253DAiuY0DBWFJ5fN_r-AEszk1ULmEETiONPovclksWeh1mf85LePs-x419aww8f2LKWU25fBr5bIDGtzmiKmhGanRf1cBnsjFoBr3375PtVAC0FTEHkiKqZODFuw15miKYlhZa_1tpkc_Imz3lPaYBZLSzaWcb7PWhRNcXYNJDKzsP0BVtPDkcj0_1D353MYvAk%2526ref%253DcM777e4sMOAycdZhdUbYHnZeTopSOZlKfLucdwQFJoAlKFDZ0IuSW2-Y8KEjDBb6MkhFqlOdwOwZd1hRQf3sD5Rx64Qq0gJL9UNLAOBwWlmPVNuNPSZDlxG_CJ1VFXkc66YVFYpeS5C-z46P7Xizczl0gH4n1wbHstfbB5HT9B9fbqFNmxHH-HaSyFHdhmYJQyXJ-459s1Mpy7yQZga6TzXxMpbOQX8N0QqANJ-H7GFLq5DSGsunKbMfIDvFK7Pa_Dfd-KEMStdO3HJo2N91nA1VCaBlFkHFrjXrEWMTsdISPjW-ebCXX58h-ymVOYlLb-F5SuIEK660y4naZwQXEMkLLv_lc8nlcg3LMVRZ5bQ8bDXWUvicyWmkGhN8CHymxRYqkqaW5_SQz1jlZrt_fw%2526l10n%253Dru%2526cts%253D1460380540651&brl=ru&uuid=99b61890edd65286ea1c276e6af6d4ed&yasoft=ipad.yabrowser&yandexuid=1260800651387382150", _stbx="rt3.fol--extdata--sbapi-lookup-access-log:1:14490260:", method="GET")
testdata_sbapi_lookup_access_log.add_row(_date="2016-04-11", status="204", user_agent="Mozilla/5.0 (iPad; CPU OS 8_1_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) YaBrowser/15.4.2272.3000.11 Mobile/12B440 Safari/600.1.4", iso_eventtime="2016-04-11 21:25:44", request_time="0.003", timestamp="11/Apr/2016:21:25:44", source_uri="prt://extdata@man1-3978.search.yandex.net/usr/local/www/logs/current-sba-11900-access.log", request="/lookup?pver=3.60&client=api&apikey=015462076831a0a73d5e9f37bc64656e736d720000e60ba1724cd09fb7&url=http://7days.ru/news/anastasiya-stotskaya-popala-v-avariyu.htm&brandID=yandex&brclid=1955452&post=0&ver=41.0.2272.118&referer=http%3A%2F%2F7days.ru%2F&brl=ru&uuid=99b61890edd65286ea1c276e6af6d4ed&yasoft=ipad.yabrowser&yandexuid=1260800651387382150", balancer_ip="2a02:6b8:0:149b::57fa:f349", _stbx="rt3.man--extdata--sbapi-lookup-access-log:3:31746988:", upstream_response_time="0.003", method="GET")

testdata_statbox_sql_passport_accounts = ComplexParametersLog(
                path="//statbox",
                table_name="sql_passport_accounts",
                default_data=STATBOX_SQL_PASSPORT_ACCOUNTS
    )
testdata_statbox_sql_passport_accounts.add_row(key="64045043", value={u'login': u'Lagutin2008', u'uid': u'64045043'})
testdata_statbox_sql_passport_accounts.add_row(key="64045043", value={u'login': u'Lagutin2008', u'uid': u'64045044'})
testdata_statbox_sql_passport_accounts.add_row(key="64178081", value={u'login': u'WatchRadiusMob', u'uid': u'64178081', u'karma': u'6000'})
testdata_statbox_sql_passport_accounts.add_row(key="64045043", value={u'login': u'ankekaterina', u'uid': u'64045043'})
testdata_statbox_sql_passport_accounts.add_row(key="64178081", value={u'login': u'ya-eli', u'uid': u'64178081', u'karma': u'6000'})
testdata_statbox_sql_passport_accounts.add_row(key="64252556", value={u'login': u'darken-ral', u'uid': u'64252556', u'karma': u'6000'})


testdata_bar_navig_log = BaseLog(
                path="//statbox/bar-navig-log",
                date="2016-04-09",
                default_data=BAR_NAVIG_LOG
    )
testdata_bar_navig_log.add_row(iso_eventtime="2016-04-09 10:20:43", yasoft="android.yabrowser", unixtime="1460186443", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&csrc=12&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=100663045&httpstatus=200&post=0&psu=7621727070167934961&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-1618_1039-1312_1040-6872_1040.906-9802_1041-1493_1041.906-4423&title=%D0%AF%D0%BD%D0%B4%D0%B5%D0%BA%D1%81&tv=6&url=http%3A%2F%2Fwww.yandex.ru%2F&uuid=69434b21a08207525a39df84707bdd30&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@imgs28-005.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:21:71556040:")
testdata_bar_navig_log.add_row(iso_eventtime="2016-04-09 10:20:43", yasoft="android.yabrowser", unixtime="1460186443", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&csrc=12&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=100663045&httpstatus=200&post=0&psu=7621727070167934961&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-1618_1039-1312_1040-6872_1040.906-9802_1041-1493_1041.906-4423&title=%D0%AF%D0%BD%D0%B4%D0%B5%D0%BA%D1%81&tv=6&url=http%3A%2F%2Fwww.yandex.ru%2F&uuid=69434b21a08207525a39df84707bdd30&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@imgs28-005.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:21:71556040:")
testdata_bar_navig_log.add_row(iso_eventtime="2016-04-09 10:20:54", yasoft="android.yabrowser", unixtime="1460186454", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=1297626946&httpstatus=200&p1=1237771847509542750145075881094348583&p2=2709134678478331740139314909851386159&post=0&psu=2114098526131764109&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-0_1039-728_1040-1558_1040.906-2286_1041-190_1041.906-918&title=text&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@ws39-452.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:29:75573403:")
testdata_bar_navig_log.add_row(iso_eventtime="2016-04-09 10:20:43", yasoft="android.yabrowser", unixtime="1460186443", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&csrc=12&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=100663045&httpstatus=200&post=0&psu=7621727070167934961&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-1618_1039-1312_1040-6872_1040.906-9802_1041-1493_1041.906-4423&title=%D0%AF%D0%BD%D0%B4%D0%B5%D0%BA%D1%81&tv=6&url=http%3A%2F%2Fwww.yandex.ru%2F&uuid=69434b21a08207525a39df84707bdd30&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@imgs28-005.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:21:71556040:")
testdata_bar_navig_log.add_row(iso_eventtime="2016-04-09 10:20:54", yasoft="android.yabrowser", unixtime="1460186454", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=1297626946&httpstatus=200&p1=1237771847509542750145075881094348583&p2=2709134678478331740139314909851386159&post=0&psu=2114098526131764109&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-0_1039-728_1040-1558_1040.906-2286_1041-190_1041.906-918&title=testtext&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@ws39-452.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:29:75573403:")

testdata_bar_navig_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 10:20:43", yasoft="android.yabrowser", unixtime="1460236986", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&csrc=12&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=100663045&httpstatus=200&post=0&psu=7621727070167934961&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-1618_1039-1312_1040-6872_1040.906-9802_1041-1493_1041.906-4423&title=%D0%AF%D0%BD%D0%B4%D0%B5%D0%BA%D1%81&tv=6&url=http%3A%2F%2Fwww.yandex.ru%2F&uuid=69434b21a08207525a39df84707bdd30&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@imgs28-005.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:21:71556040:")
testdata_bar_navig_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 10:20:43", yasoft="android.yabrowser", unixtime="1460236986", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&csrc=12&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=100663045&httpstatus=200&post=0&psu=7621727070167934961&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-1618_1039-1312_1040-6872_1040.906-9802_1041-1493_1041.906-4423&title=%D0%AF%D0%BD%D0%B4%D0%B5%D0%BA%D1%81&tv=6&url=http%3A%2F%2Fwww.yandex.ru%2F&uuid=69434b21a08207525a39df84707bdd30&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@imgs28-005.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:21:71556040:")
testdata_bar_navig_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 10:20:54", yasoft="android.yabrowser", unixtime="1460236986", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=1297626946&httpstatus=200&p1=1237771847509542750145075881094348583&p2=2709134678478331740139314909851386159&post=0&psu=2114098526131764109&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-0_1039-728_1040-1558_1040.906-2286_1041-190_1041.906-918&title=text&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@ws39-452.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:29:75573403:")
testdata_bar_navig_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 10:20:43", yasoft="android.yabrowser", unixtime="1460236986", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&csrc=12&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=100663045&httpstatus=200&post=0&psu=7621727070167934961&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-1618_1039-1312_1040-6872_1040.906-9802_1041-1493_1041.906-4423&title=%D0%AF%D0%BD%D0%B4%D0%B5%D0%BA%D1%81&tv=6&url=http%3A%2F%2Fwww.yandex.ru%2F&uuid=69434b21a08207525a39df84707bdd30&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@imgs28-005.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:21:71556040:")
testdata_bar_navig_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 10:20:54", yasoft="android.yabrowser", unixtime="1460236986", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=1297626946&httpstatus=200&p1=1237771847509542750145075881094348583&p2=2709134678478331740139314909851386159&post=0&psu=2114098526131764109&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-0_1039-728_1040-1558_1040.906-2286_1041-190_1041.906-918&title=testtext&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@ws39-452.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:29:75573403:")

testdata_bar_navig_log.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 10:20:43", yasoft="android.yabrowser", unixtime="1460378335", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&csrc=12&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=100663045&httpstatus=200&post=0&psu=7621727070167934961&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-1618_1039-1312_1040-6872_1040.906-9802_1041-1493_1041.906-4423&title=%D0%AF%D0%BD%D0%B4%D0%B5%D0%BA%D1%81&tv=6&url=http%3A%2F%2Fwww.yandex.ru%2F&uuid=69434b21a08207525a39df84707bdd30&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@imgs28-005.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:21:71556040:")
testdata_bar_navig_log.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 10:20:43", yasoft="android.yabrowser", unixtime="1460378335", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&csrc=12&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=100663045&httpstatus=200&post=0&psu=7621727070167934961&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-1618_1039-1312_1040-6872_1040.906-9802_1041-1493_1041.906-4423&title=%D0%AF%D0%BD%D0%B4%D0%B5%D0%BA%D1%81&tv=6&url=http%3A%2F%2Fwww.yandex.ru%2F&uuid=69434b21a08207525a39df84707bdd30&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@imgs28-005.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:21:71556040:")
testdata_bar_navig_log.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 10:20:54", yasoft="android.yabrowser", unixtime="1460378335", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=1297626946&httpstatus=200&p1=1237771847509542750145075881094348583&p2=2709134678478331740139314909851386159&post=0&psu=2114098526131764109&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-0_1039-728_1040-1558_1040.906-2286_1041-190_1041.906-918&title=text&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@ws39-452.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:29:75573403:")
testdata_bar_navig_log.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 10:20:43", yasoft="android.yabrowser", unixtime="1460378335", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&csrc=12&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=100663045&httpstatus=200&post=0&psu=7621727070167934961&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-1618_1039-1312_1040-6872_1040.906-9802_1041-1493_1041.906-4423&title=%D0%AF%D0%BD%D0%B4%D0%B5%D0%BA%D1%81&tv=6&url=http%3A%2F%2Fwww.yandex.ru%2F&uuid=69434b21a08207525a39df84707bdd30&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@imgs28-005.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:21:71556040:")
testdata_bar_navig_log.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 10:20:54", yasoft="android.yabrowser", unixtime="1460378335", yandexuid="1747090401445659068", http_params="brandID=yandex&brclid=1&brl=ru&deviceid=2bc55f53bdb8b23ac06f441b85ac576e&eid=apk.1%3Bod.1%3Bpdb.0%3Bpwf.2%3Bsap.0%3Btsc.1%3Btuc.1&hip=1297626946&httpstatus=200&p1=1237771847509542750145075881094348583&p2=2709134678478331740139314909851386159&post=0&psu=2114098526131764109&r1=pecbpavgrxidsjudjqeqgfevpojmdfrueqwcsyibohqjlphevgegekhbdansprqskrsuasbmcvixoaaxdplxwfxsebxafuabtcfaf0a6181b02225412fdf23b1ffea09a2d&referer=http%3A%2F%2Fwww.yandex.ru%2F&show=1&t=1037-0_1038-0_1039-728_1040-1558_1040.906-2286_1041-190_1041.906-918&title=testtext&ver=16.2.0.5397&yasoft=android.yabrowser", ip="37.29.41.1", source_uri="prt://bar_navig@ws39-452.yandex.ru/usr/local/www/logs/current-spy-barnav-9200", _stbx="rt3.fol--bar_navig--bar-navig-log:29:75573403:")


testdata_sendr_click_log = BaseLog(
                path="//statbox/sendr-click-log",
                date="2016-04-09",
                default_data=SENDR_CLICK_LOG
    )
testdata_sendr_click_log.add_row(cookies="{u'zm': u'm-white_bender.flex.webp.css-https%3Awww_zNa-f_5uJcPTYK6A_vgZjL6hOW8%3Al', u'yandex_login': u'dr-ops', u'yabs-frequency': u'/4/0W0c09aMKrTXRr1N/paMmSAWaP_H4i72S95N7Ch1md2H7iYHoS9maDQyaSd2C93KFBd9mZ2HrGoXoS70abKbxC6Xp97m000ETGh1mM2HLFJwmSAWaOF8vi72e9600/', u'yandexuid': u'1480112581366481068', u'_ym_isad': u'2', u'yandex_gid': u'213', u'L': u'AVp4eVBcTGMLcGt5YlxCeX52dQFhU0wHCz9pDkNB.1465073028.12447.381002.d6de77e2c5809114b67ae1c21af0ab07', u'fuid01': u'5172d9154f757487.ibgLSKzpvKwsB3aCqORHuidWd4ihqQKwi90AyHzTEJrgS9V0p5jCS1HSjaVrvZVPtCXGuRT4VOxUcsS_tUP6PS-5PYu0ScAbpxlH7-hXeEdtNJa2L7cKuJwRGnX8is_p', u'yp': u'1724776959.multib.1#1469172237.ww.1#2147483647.ygo.1%3A213#1480841015.szm.1_00%3A1366x768%3A1366x599#1495982635.dsws.56#1495982635.dswa.0#1495982635.dwss.53#1495911986.st_soft_stripe_s.22#1495567726.st_set_s.23#1490692704.st_promobar_s.5#1495911817.st_home_s.9#1493320294.st_set_home_s.4#1467135531.cnps.9003677093%3Amax#1493378279.dwws.1#1495913898.dwys.1#1496176342.st_browser_s.3#1495993017.st_vb_s.2#1780433028.udn.cDpkci1vcHM%3D', u'ys': u'wprid.1465072337122033-11560178426718612591346519-myt1-2097#udn.cDpkci1vcHM%3D', u'my': u'YygDQoDVNzYBAQA=', u'_ym_uid': u'1465073018333340054'}", user_agent="Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36", iso_eventtime="2016-06-04 23:48:29", unixtime="1465073309", source_uri="prt://sendr@delivery1h.cmail.yandex.net/var/log/yandex/sendr/click.log", email="dr.ops@yandex.ru", yandexuid="1480112581366481068", allowed="True", event="click", _stbx="rt3.fol--other--other:34:435147338:")
testdata_sendr_click_log.add_row(cookies="{u'zm': u'm-white_bender.flex.webp.css-https%3Awww_zNa-f_5uJcPTYK6A_vgZjL6hOW8%3Al', u'yandex_login': u'dr-ops', u'yabs-frequency': u'/4/0W0c09aMKrTXRr1N/paMmSAWaP_H4i72S95N7Ch1md2H7iYHoS9maDQyaSd2C93KFBd9mZ2HrGoXoS70abKbxC6Xp97m000ETGh1mM2HLFJwmSAWaOF8vi72e9600/', u'yandexuid': u'1480112581366481068', u'_ym_isad': u'2', u'yandex_gid': u'213', u'L': u'AVp4eVBcTGMLcGt5YlxCeX52dQFhU0wHCz9pDkNB.1465073028.12447.381002.d6de77e2c5809114b67ae1c21af0ab07', u'fuid01': u'5172d9154f757487.ibgLSKzpvKwsB3aCqORHuidWd4ihqQKwi90AyHzTEJrgS9V0p5jCS1HSjaVrvZVPtCXGuRT4VOxUcsS_tUP6PS-5PYu0ScAbpxlH7-hXeEdtNJa2L7cKuJwRGnX8is_p', u'yp': u'1724776959.multib.1#1469172237.ww.1#2147483647.ygo.1%3A213#1480841015.szm.1_00%3A1366x768%3A1366x599#1495982635.dsws.56#1495982635.dswa.0#1495982635.dwss.53#1495911986.st_soft_stripe_s.22#1495567726.st_set_s.23#1490692704.st_promobar_s.5#1495911817.st_home_s.9#1493320294.st_set_home_s.4#1467135531.cnps.9003677093%3Amax#1493378279.dwws.1#1495913898.dwys.1#1496176342.st_browser_s.3#1495993017.st_vb_s.2#1780433028.udn.cDpkci1vcHM%3D', u'ys': u'wprid.1465072337122033-11560178426718612591346519-myt1-2097#udn.cDpkci1vcHM%3D', u'my': u'YygDQoDVNzYBAQA=', u'_ym_uid': u'1465073018333340054'}", user_agent="Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36", iso_eventtime="2016-06-04 23:48:29", unixtime="1465073309", source_uri="prt://sendr@delivery1h.cmail.yandex.net/var/log/yandex/sendr/click.log", email="dr.ops@yandex.ru", yandexuid="1480112581366481068", allowed="True", event="click", _stbx="rt3.fol--other--other:34:435147338:")
testdata_sendr_click_log.add_row(cookies="{}", user_agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/32.0.1700.2 Safari/537.36", iso_eventtime="2016-06-04 23:26:12", parsed="False", unixtime="1465071972", source_uri="prt://other@5.255.227.160unknown", campaign_id="None", email="None", user_ip="185.30.176.26", allowed="None", event="px", _stbx="rt3.sas--other--other:17:455305112:")
testdata_sendr_click_log.add_row(cookies="{u'zm': u'm-white_bender.flex.webp.css-https%3Awww_zNa-f_5uJcPTYK6A_vgZjL6hOW8%3Al', u'yandex_login': u'dr-ops', u'yabs-frequency': u'/4/0W0c09aMKrTXRr1N/paMmSAWaP_H4i72S95N7Ch1md2H7iYHoS9maDQyaSd2C93KFBd9mZ2HrGoXoS70abKbxC6Xp97m000ETGh1mM2HLFJwmSAWaOF8vi72e9600/', u'yandexuid': u'1480112581366481068', u'_ym_isad': u'2', u'yandex_gid': u'213', u'L': u'AVp4eVBcTGMLcGt5YlxCeX52dQFhU0wHCz9pDkNB.1465073028.12447.381002.d6de77e2c5809114b67ae1c21af0ab07', u'fuid01': u'5172d9154f757487.ibgLSKzpvKwsB3aCqORHuidWd4ihqQKwi90AyHzTEJrgS9V0p5jCS1HSjaVrvZVPtCXGuRT4VOxUcsS_tUP6PS-5PYu0ScAbpxlH7-hXeEdtNJa2L7cKuJwRGnX8is_p', u'yp': u'1724776959.multib.1#1469172237.ww.1#2147483647.ygo.1%3A213#1480841015.szm.1_00%3A1366x768%3A1366x599#1495982635.dsws.56#1495982635.dswa.0#1495982635.dwss.53#1495911986.st_soft_stripe_s.22#1495567726.st_set_s.23#1490692704.st_promobar_s.5#1495911817.st_home_s.9#1493320294.st_set_home_s.4#1467135531.cnps.9003677093%3Amax#1493378279.dwws.1#1495913898.dwys.1#1496176342.st_browser_s.3#1495993017.st_vb_s.2#1780433028.udn.cDpkci1vcHM%3D', u'ys': u'wprid.1465072337122033-11560178426718612591346519-myt1-2097#udn.cDpkci1vcHM%3D', u'my': u'YygDQoDVNzYBAQA=', u'_ym_uid': u'1465073018333340054'}", user_agent="Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36", iso_eventtime="2016-06-04 23:48:29", unixtime="1465073309", source_uri="prt://sendr@delivery1h.cmail.yandex.net/var/log/yandex/sendr/click.log", email="dr.ops@yandex.ru", yandexuid="1480112581366481068", allowed="True", event="click", _stbx="rt3.fol--other--other:34:435147338:")
testdata_sendr_click_log.add_row(cookies="{}", user_agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/32.0.1700.2 Safari/537.36", iso_eventtime="2016-06-04 23:26:12", parsed="False", unixtime="1465071972", source_uri="prt://other@5.255.227.160unknown", campaign_id="None", email="None", user_ip="185.30.176.26", allowed="None", event="px", _stbx="rt3.sas--other--other:17:455305112:")

testdata_sendr_click_log.add_row(_date="2016-04-10", cookies="{}", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Mobile/13F69", iso_eventtime="2016-06-05 15:50:20", unixtime="1465131020", source_uri="prt://sendr@delivery2j.cmail.yandex.net/var/log/yandex/sendr/click.log", email="kir-roor@yandex.ru", allowed="None", event="px", _stbx="rt3.iva--other--other:113:63431154:")
testdata_sendr_click_log.add_row(_date="2016-04-10", cookies="{}", user_agent="Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Mobile/13F69", iso_eventtime="2016-06-05 15:50:20", unixtime="1465131020", source_uri="prt://sendr@delivery2j.cmail.yandex.net/var/log/yandex/sendr/click.log", email="kir-roor@yandex.ru", allowed="None", event="px", _stbx="rt3.iva--other--other:113:63431154:")
testdata_sendr_click_log.add_row(_date="2016-04-10", cookies="{}", user_agent="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/32.0.1700.2 Safari/537.36", iso_eventtime="2016-06-05 20:19:24", parsed="False", unixtime="1465147164", source_uri="prt://sendr@delivery1h.cmail.yandex.net/var/log/yandex/sendr/click.log", campaign_id="None", email="None", user_ip="188.93.56.130", allowed="None", event="px", _stbx="rt3.fol--other--other:70:70501591:")

testdata_sendr_click_log.add_row(_date="2016-04-11", cookies="{}", user_agent="Mozilla/5.0 (Windows NT 5.1; rv:11.0) Gecko Firefox/11.0 (via ggpht.com GoogleImageProxy)", iso_eventtime="2016-06-06 21:50:12", unixtime="1465239012", source_uri="prt://sendr@delivery1p.cmail.yandex.net/var/log/yandex/sendr/click.log", email="roman.slepnev@gmail.com", allowed="None", event="px", _stbx="rt3.fol--other--other:109:46136683:")
testdata_sendr_click_log.add_row(_date="2016-04-11", cookies="{}", user_agent="Mozilla/5.0 (Windows NT 5.1; rv:11.0) Gecko Firefox/11.0 (via ggpht.com GoogleImageProxy)", iso_eventtime="2016-06-06 21:50:12", unixtime="1465239012", source_uri="prt://sendr@delivery1p.cmail.yandex.net/var/log/yandex/sendr/click.log", email="roman.slepnev@gmail.com", allowed="None", event="px", _stbx="rt3.fol--other--other:109:46136683:")
testdata_sendr_click_log.add_row(_date="2016-04-11", cookies="{}", user_agent="Mozilla/5.0 (compatible; YandexImageResizer/2.0; +http://yandex.com/bots)", iso_eventtime="2016-06-06 23:37:02", unixtime="1465245422", source_uri="prt://sendr@delivery1m.cmail.yandex.net/var/log/yandex/sendr/click.log", campaign_id="1709", email="aSEXeich@yandex.ru", user_ip="5.255.206.198", allowed="None", event="px", _stbx="rt3.fol--other--other:16:443249642:")


testdata_yabs_event_log = ComplexParametersLog(
                path="//statbox/yabs-event-log",
                date="2016-04-11",
                default_data=YABS_EVENT_LOG
    )
testdata_yabs_event_log.add_row(key="prt://yabs@yabs14e.stat.yandex.net/opt/statbox/yabs/log/RotateEventLog 2016-04-11 15:38:33", value={u'region_id': u'41', u'showtime': u'2016-04-11 15:38:31', u'clientip6': u'\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\xff\xffM(t\x05', u'searchquerymd5': u'10699064016333422656', u'placeid': u'542', u'hitlogid': u'1869168397186238676', u'bannerid': u'1400383501', u'pageid': u'126291', u'selecttype': u'12', u'slotid': u'2', u'browsername': u'Chrome', u'_stbx': u'rt3.iva--yabs--yabs-raw-event-log:27:12052685:V\xfe\x8f\x05T\x01\\0\\0:\xff\xff\xff\xff\xff\xff\xff\xff:\x10.\xf0!\xbe\xcd\xe2E[\x96\xec\xea.$\xfcW8', u'eventid': u'176322721', u'eventtime': u'2016-04-11 15:38:33', u'timestamp': u'2016-04-11 15:41:04', u'yandexuid': u'1928469811458377730', u'urlmd5': u'7368518069129110579', u'detaileddevicetype': u'Windows', u'position': u'2', u'experimentbits': u'10468982784', u'typeid': u'2', u'billcost': u'165200', u'gender': u'1', u'age': u'2', u'logid': u'1869168995499248410', u'devicetype': u'6', u'options': u'flat-page,stationary-connection', u'cryptaid': u'2005777053446928205'})
testdata_yabs_event_log.add_row(key="prt://yabs@yabs14e.stat.yandex.net/opt/statbox/yabs/log/RotateEventLog 2016-04-11 15:38:33", value={u'region_id': u'41', u'showtime': u'2016-04-11 15:38:31', u'clientip6': u'\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\xff\xffM(t\x05', u'searchquerymd5': u'10699064016333422656', u'placeid': u'542', u'hitlogid': u'1869168397186238676', u'bannerid': u'1400383501', u'pageid': u'126291', u'selecttype': u'12', u'slotid': u'2', u'browsername': u'Chrome', u'_stbx': u'rt3.iva--yabs--yabs-raw-event-log:27:12052685:V\xfe\x8f\x05T\x01\\0\\0:\xff\xff\xff\xff\xff\xff\xff\xff:\x10.\xf0!\xbe\xcd\xe2E[\x96\xec\xea.$\xfcW8', u'eventid': u'176322721', u'eventtime': u'2016-04-11 15:38:33', u'timestamp': u'2016-04-11 15:41:04', u'yandexuid': u'1928469811458377730', u'urlmd5': u'7368518069129110579', u'detaileddevicetype': u'Windows', u'position': u'2', u'experimentbits': u'10468982784', u'typeid': u'2', u'billcost': u'165200', u'gender': u'1', u'age': u'2', u'logid': u'1869168995499248410', u'devicetype': u'6', u'options': u'flat-page,stationary-connection', u'cryptaid': u'2005777053446928205'})
testdata_yabs_event_log.add_row(key="prt://yabs@yabs12e.stat.yandex.net/opt/statbox/yabs/log/RotateEventLog 2016-04-11 10:06:11", value={u'domainid': u'14547009', u'region_id': u'35', u'yabs_id': u'2016041107090403', u'qtailid': u'18142666557541994932', u'showtime': u'2016-04-11 10:06:07', u'clientip6': u'\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\xff\xff>\xb7~t', u'searchquerymd5': u'0', u'placeid': u'542', u'rank': u'457', u'realcost': u'4244406', u'hitlogid': u'1863940168287259275', u'bannerid': u'1294844133', u'categoryid': u'72', u'orderid': u'8078160', u'experimentbits': u'830002429952', u'pageid': u'148945', u'tagid': u'2', u'slotid': u'1', u'underflow': u'381421333', u'phraseid': u'107287643', u'sourcecost': u'5000000', u'options': u'dsp,right-side,guarantee,picture,commerce,flat-page,stationary-connection', u'_stbx': u'rt3.iva--yabs--yabs-raw-event-log:24:12150298:*E\x96\x04T\x01\\0\\0:\xff\xff\xff\xff\xff\xff\xff\xff:\x10\\\\O\x07\xf1\xa7\x1eH&\x84+\xf3\x9e\xbd\xe6\xf3e', u'groupexportid': u'1261629705', u'relevance': u'17007', u'ip_numeric': u'1052212852', u'browsername': u'AndroidBrowser', u'eventid': u'932221890', u'realcostcur': u'0', u'eventtime': u'2016-04-11 10:06:11', u'testtag': u'1442928321', u'timestamp': u'2016-04-11 10:09:04', u'yandexuid': u'1340579471430338605', u'sourcecostcur': u'0', u'yabs_id_timestamp': u'2016-04-11 10:09:04', u'urlmd5': u'2364301865727137318', u'detaileddevicetype': u'Android', u'position': u'1', u'statisticregionid': u'35', u'jointime': u'1460366923', u'parentbannerid': u'1294608897', u'urlclusterid': u'1489450000', u'typeid': u'2', u'hostid': u'612', u'billcost': u'1900000', u'gender': u'1', u'age': u'2', u'groupbannerid': u'1261629705', u'logid': u'1863941211631387236', u'eventhash': u'15295164934366677373', u'eventcostcur': u'0', u'parentexportid': u'1760528772', u'devicetype': u'3', u'selecttype': u'26', u'cryptaid': u'1340579473430338605'})
testdata_yabs_event_log.add_row(key="prt://yabs@yabs14e.stat.yandex.net/opt/statbox/yabs/log/RotateEventLog 2016-04-11 15:38:33", value={u'region_id': u'41', u'showtime': u'2016-04-11 15:38:31', u'clientip6': u'\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\xff\xffM(t\x05', u'searchquerymd5': u'10699064016333422656', u'placeid': u'542', u'hitlogid': u'1869168397186238676', u'bannerid': u'1400383501', u'pageid': u'126291', u'selecttype': u'12', u'slotid': u'2', u'browsername': u'Chrome', u'_stbx': u'rt3.iva--yabs--yabs-raw-event-log:27:12052685:V\xfe\x8f\x05T\x01\\0\\0:\xff\xff\xff\xff\xff\xff\xff\xff:\x10.\xf0!\xbe\xcd\xe2E[\x96\xec\xea.$\xfcW8', u'eventid': u'176322721', u'eventtime': u'2016-04-11 15:38:33', u'timestamp': u'2016-04-11 15:41:04', u'yandexuid': u'1928469811458377730', u'urlmd5': u'7368518069129110579', u'detaileddevicetype': u'Windows', u'position': u'2', u'experimentbits': u'10468982784', u'typeid': u'2', u'billcost': u'165200', u'gender': u'1', u'age': u'2', u'logid': u'1869168995499248410', u'devicetype': u'6', u'options': u'flat-page,stationary-connection', u'cryptaid': u'2005777053446928205'})
testdata_yabs_event_log.add_row(key="prt://yabs@yabs12e.stat.yandex.net/opt/statbox/yabs/log/RotateEventLog 2016-04-11 10:06:11", value={u'domainid': u'14547009', u'region_id': u'35', u'yabs_id': u'2016041107090403', u'qtailid': u'18142666557541994932', u'showtime': u'2016-04-11 10:06:07', u'clientip6': u'\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\xff\xff>\xb7~t', u'searchquerymd5': u'0', u'placeid': u'542', u'rank': u'457', u'realcost': u'4244406', u'hitlogid': u'1863940168287259275', u'bannerid': u'1294844133', u'categoryid': u'72', u'orderid': u'8078160', u'experimentbits': u'830002429952', u'pageid': u'148945', u'tagid': u'2', u'slotid': u'1', u'underflow': u'381421333', u'phraseid': u'107287643', u'sourcecost': u'5000000', u'options': u'dsp,right-side,guarantee,picture,commerce,flat-page,stationary-connection', u'_stbx': u'rt3.iva--yabs--yabs-raw-event-log:24:12150298:*E\x96\x04T\x01\\0\\0:\xff\xff\xff\xff\xff\xff\xff\xff:\x10\\\\O\x07\xf1\xa7\x1eH&\x84+\xf3\x9e\xbd\xe6\xf3e', u'groupexportid': u'1261629705', u'relevance': u'17007', u'ip_numeric': u'1052212852', u'browsername': u'AndroidBrowser', u'eventid': u'932221890', u'realcostcur': u'0', u'eventtime': u'2016-04-11 10:06:11', u'testtag': u'1442928321', u'timestamp': u'2016-04-11 10:09:04', u'yandexuid': u'1340579471430338605', u'sourcecostcur': u'0', u'yabs_id_timestamp': u'2016-04-11 10:09:04', u'urlmd5': u'2364301865727137318', u'detaileddevicetype': u'Android', u'position': u'1', u'statisticregionid': u'35', u'jointime': u'1460366923', u'parentbannerid': u'1294608897', u'urlclusterid': u'1489450000', u'typeid': u'2', u'hostid': u'612', u'billcost': u'1900000', u'gender': u'1', u'age': u'2', u'groupbannerid': u'1261629705', u'logid': u'1863941211631387236', u'eventhash': u'15295164934366677373', u'eventcostcur': u'0', u'parentexportid': u'1760528772', u'devicetype': u'3', u'selecttype': u'26', u'cryptaid': u'1340579473430338605'})
testdata_yabs_event_log.add_row(key="prt://yabs@yabs13e.stat.yandex.net/opt/statbox/yabs/log/RotateEventLog 2016-04-11 15:51:27", value={u'domainid': u'0', u'region_id': u'213', u'yabs_id': u'2016041112523903', u'qtailid': u'0', u'showtime': u'2016-04-11 15:51:27', u'clientip6': u'\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\xff\xff_T\xa4/', u'searchquerymd5': u'0', u'placeid': u'1135', u'rank': u'0', u'realcost': u'0', u'hitlogid': u'1869371818197912568', u'bannerid': u'1131203000', u'resourceno': u'7', u'categoryid': u'0', u'orderid': u'7478443', u'experimentbits': u'0', u'pageid': u'60', u'tagid': u'0', u'slotid': u'3', u'underflow': u'0', u'phraseid': u'0', u'resourcetype': u'2', u'sourcecost': u'0', u'options': u'yclid,stationary-connection', u'_stbx': u'rt3.iva--yabs--yabs-raw-event-log:5:12192005:4%\xae\x05T\x01\\0\\0:\xff\xff\xff\xff\xff\xff\xff\xff:\x10\x97g\xf8\\\\\xe2\x13E\x16\xb4\x91\x818aS\x1dA', u'groupexportid': u'0', u'ip_numeric': u'1599382575', u'browsername': u'MobileSafari', u'eventid': u'65880020', u'realcostcur': u'0', u'eventtime': u'2016-04-11 15:51:27', u'testtag': u'0', u'timestamp': u'2016-04-11 15:52:39', u'yandexuid': u'365183551352369623', u'sourcecostcur': u'0', u'yabs_id_timestamp': u'2016-04-11 15:52:39', u'urlmd5': u'0', u'detaileddevicetype': u'iOS', u'position': u'1', u'statisticregionid': u'213', u'jointime': u'1460385443', u'urlclusterid': u'0', u'typeid': u'0', u'hostid': u'9711', u'billcost': u'0', u'gender': u'1', u'age': u'1', u'groupbannerid': u'0', u'logid': u'1869371908351855787', u'eventhash': u'1178879412025230583', u'eventcostcur': u'0', u'devicetype': u'3', u'selecttype': u'0', u'cryptaid': u'365183555352369623'})
testdata_yabs_event_log.add_row(key="prt://yabs@yabs14e.stat.yandex.net/opt/statbox/yabs/log/RotateEventLog 2016-04-11 15:38:33", value={u'region_id': u'41', u'showtime': u'2016-04-11 15:38:31', u'clientip6': u'\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\xff\xffM(t\x05', u'searchquerymd5': u'10699064016333422656', u'placeid': u'542', u'hitlogid': u'1869168397186238676', u'bannerid': u'1400383501', u'pageid': u'126291', u'selecttype': u'12', u'slotid': u'2', u'browsername': u'Chrome', u'_stbx': u'rt3.iva--yabs--yabs-raw-event-log:27:12052685:V\xfe\x8f\x05T\x01\\0\\0:\xff\xff\xff\xff\xff\xff\xff\xff:\x10.\xf0!\xbe\xcd\xe2E[\x96\xec\xea.$\xfcW8', u'eventid': u'176322721', u'eventtime': u'2016-04-11 15:38:33', u'timestamp': u'2016-04-11 15:41:04', u'yandexuid': u'1928469811458377730', u'urlmd5': u'7368518069129110579', u'detaileddevicetype': u'Windows', u'position': u'2', u'experimentbits': u'10468982784', u'typeid': u'2', u'billcost': u'165200', u'gender': u'1', u'age': u'2', u'logid': u'1869168995499248410', u'devicetype': u'6', u'options': u'flat-page,stationary-connection', u'cryptaid': u'2005777053446928205'})
testdata_yabs_event_log.add_row(key="prt://yabs@yabs12e.stat.yandex.net/opt/statbox/yabs/log/RotateEventLog 2016-04-11 10:06:11", value={u'domainid': u'14547009', u'region_id': u'35', u'yabs_id': u'2016041107090403', u'qtailid': u'18142666557541994932', u'showtime': u'2016-04-11 10:06:07', u'clientip6': u'\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\xff\xff>\xb7~t', u'searchquerymd5': u'0', u'placeid': u'542', u'rank': u'457', u'realcost': u'4244406', u'hitlogid': u'1863940168287259275', u'bannerid': u'1294844133', u'categoryid': u'72', u'orderid': u'8078160', u'experimentbits': u'830002429952', u'pageid': u'148945', u'tagid': u'2', u'slotid': u'1', u'underflow': u'381421333', u'phraseid': u'107287643', u'sourcecost': u'5000000', u'options': u'dsp,right-side,guarantee,picture,commerce,flat-page,stationary-connection', u'_stbx': u'rt3.iva--yabs--yabs-raw-event-log:24:12150298:*E\x96\x04T\x01\\0\\0:\xff\xff\xff\xff\xff\xff\xff\xff:\x10\\\\O\x07\xf1\xa7\x1eH&\x84+\xf3\x9e\xbd\xe6\xf3e', u'groupexportid': u'1261629705', u'relevance': u'17007', u'ip_numeric': u'1052212852', u'browsername': u'AndroidBrowser', u'eventid': u'932221890', u'realcostcur': u'0', u'eventtime': u'2016-04-11 10:06:11', u'testtag': u'1442928321', u'timestamp': u'2016-04-11 10:09:04', u'yandexuid': u'1340579471430338605', u'sourcecostcur': u'0', u'yabs_id_timestamp': u'2016-04-11 10:09:04', u'urlmd5': u'2364301865727137318', u'detaileddevicetype': u'Android', u'position': u'1', u'statisticregionid': u'35', u'jointime': u'1460366923', u'parentbannerid': u'1294608897', u'urlclusterid': u'1489450000', u'typeid': u'2', u'hostid': u'612', u'billcost': u'1900000', u'gender': u'1', u'age': u'2', u'groupbannerid': u'1261629705', u'logid': u'1863941211631387236', u'eventhash': u'15295164934366677373', u'eventcostcur': u'0', u'parentexportid': u'1760528772', u'devicetype': u'3', u'selecttype': u'26', u'cryptaid': u'1340579473430338605'})
testdata_yabs_event_log.add_row(key="prt://yabs@yabs13e.stat.yandex.net/opt/statbox/yabs/log/RotateEventLog 2016-04-11 15:51:27", value={u'domainid': u'0', u'region_id': u'213', u'yabs_id': u'2016041112523903', u'qtailid': u'0', u'showtime': u'2016-04-11 15:51:27', u'clientip6': u'\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\xff\xff_T\xa4/', u'searchquerymd5': u'0', u'placeid': u'1135', u'rank': u'0', u'realcost': u'0', u'hitlogid': u'1869371818197912568', u'bannerid': u'1131203000', u'resourceno': u'7', u'categoryid': u'0', u'orderid': u'7478443', u'experimentbits': u'0', u'pageid': u'60', u'tagid': u'0', u'slotid': u'3', u'underflow': u'0', u'phraseid': u'0', u'resourcetype': u'2', u'sourcecost': u'0', u'options': u'yclid,stationary-connection', u'_stbx': u'rt3.iva--yabs--yabs-raw-event-log:5:12192005:4%\xae\x05T\x01\\0\\0:\xff\xff\xff\xff\xff\xff\xff\xff:\x10\x97g\xf8\\\\\xe2\x13E\x16\xb4\x91\x818aS\x1dA', u'groupexportid': u'0', u'ip_numeric': u'1599382575', u'browsername': u'MobileSafari', u'eventid': u'65880020', u'realcostcur': u'0', u'eventtime': u'2016-04-11 15:51:27', u'testtag': u'0', u'timestamp': u'2016-04-11 15:52:39', u'yandexuid': u'365183551352369623', u'sourcecostcur': u'0', u'yabs_id_timestamp': u'2016-04-11 15:52:39', u'urlmd5': u'0', u'detaileddevicetype': u'iOS', u'position': u'1', u'statisticregionid': u'213', u'jointime': u'1460385443', u'urlclusterid': u'0', u'typeid': u'0', u'hostid': u'9711', u'billcost': u'0', u'gender': u'1', u'age': u'1', u'groupbannerid': u'0', u'logid': u'1869371908351855787', u'eventhash': u'1178879412025230583', u'eventcostcur': u'0', u'devicetype': u'3', u'selecttype': u'0', u'cryptaid': u'365183555352369623'})
testdata_yabs_event_log.add_row(key="prt://yabs@yabs03f.stat.yandex.net/opt/statbox/yabs/log/RotateEventLog 2016-04-11 20:39:12", value={u'domainid': u'18665695', u'region_id': u'213', u'yabs_id': u'2016041117404403', u'qtailid': u'7071883643875815859', u'showtime': u'2016-04-11 20:39:09', u'clientip6': u'\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\xff\xff_\xa5\x16\xf7', u'searchquerymd5': u'0', u'placeid': u'542', u'rank': u'1907', u'realcost': u'1012440', u'hitlogid': u'1873896922175245588', u'bannerid': u'1063706770', u'categoryid': u'333', u'orderid': u'7204786', u'experimentbits': u'841008283648', u'pageid': u'21753', u'tagid': u'1073743127', u'slotid': u'2', u'underflow': u'1723946594', u'phraseid': u'4343373', u'sourcecost': u'786667', u'options': u'picture,commerce,flat-page,stationary-connection', u'_stbx': u'rt3.myt--yabs--yabs-raw-event-log:16:562:\xd40\x8d\x06T\x01\\0\\0:\xff\xff\xff\xff\xff\xff\xff\xff:\x10(z!f\xb2CO\xb1\x9b/\xfa\xe9\x1c\xd7\xce\xe7', u'groupexportid': u'1087385993', u'relevance': u'54635', u'ip_numeric': u'1604654839', u'browsername': u'MSIE', u'eventid': u'1391470122', u'realcostcur': u'257400', u'eventtime': u'2016-04-11 20:39:12', u'testtag': u'58739393', u'timestamp': u'2016-04-11 20:40:44', u'yandexuid': u'1748232901455365413', u'sourcecostcur': u'200000', u'yabs_id_timestamp': u'2016-04-11 20:40:44', u'urlmd5': u'0', u'detaileddevicetype': u'Windows', u'position': u'1', u'statisticregionid': u'213', u'jointime': u'1460399696', u'parentbannerid': u'1063706771', u'urlclusterid': u'0', u'typeid': u'2', u'hostid': u'8730', u'billcost': u'944000', u'gender': u'-1', u'age': u'-1', u'groupbannerid': u'1087385993', u'logid': u'1873897611816077817', u'eventhash': u'13279689994073235547', u'eventcostcur': u'240000', u'parentexportid': u'1491794347', u'devicetype': u'7', u'selecttype': u'92', u'cryptaid': u'1603280000000038867'})


testdata_crypta_rt_geo_log = BaseLog(
                path="//statbox/crypta-rt-geo-log",
                date="2016-04-09",
                default_data=CRYPTA_RT_GEO_LOG
    )
testdata_crypta_rt_geo_log.add_row(acc="100", iso_eventtime="2016-04-09 10:11:47", uuid="552d417a51f793e4b5ded9a19aa08622", cid="1602040000000166461", unixtime="1460185907", source_uri="prt://rtcrypta@storm01e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="44.78818555360001", ip="217.13.91.184", geo_source_types="mobile_metrics,ipgeo", lat="48.78049483120001", now="1460185924", type="mobile_metrics_identified", yauid="601826891455541112", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:2:124133337:")
testdata_crypta_rt_geo_log.add_row(acc="175", iso_eventtime="2016-04-09 10:11:47", uuid="552d417a51f793e4b5ded9a19aa08622", cid="1602040000000166461", unixtime="1460185907", source_uri="prt://rtcrypta@storm01e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="44.78818555360001", ip="31.128.146.113", geo_source_types="mobile_metrics,metrics,ipgeo,bar", lat="48.78049483120001", now="1460185924", type="mobile_metrics_identified", yauid="601826891455541112", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:2:124133337:")
testdata_crypta_rt_geo_log.add_row(acc="505", iso_eventtime="2016-04-09 10:26:23", uuid="552d417a51f793e4b5ded9a19aa08622", cid="1602040000000166461", unixtime="1460186783", source_uri="prt://rtcrypta@storm01e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="44.78818555360001", ip="217.13.91.184", geo_source_types="mobile_metrics,ipgeo", lat="48.78049483120001", now="1460186827", type="mobile_metrics_identified", yauid="1167671261428166806", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:1:133763997:")
testdata_crypta_rt_geo_log.add_row(acc="1005", iso_eventtime="2016-04-09 10:11:47", uuid="552d417a51f793e4b5ded9a19aa08622", cid="1602040000000166461", unixtime="1460185907", source_uri="prt://rtcrypta@storm01e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="44.78818555360001", ip="85.174.38.23", geo_source_types="mobile_metrics,ipgeo", lat="48.78049483120001", now="1460185924", type="map_navig_identified", yauid="1167671261428166806", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:2:124133337:")
testdata_crypta_rt_geo_log.add_row(acc="10001", iso_eventtime="2016-04-09 10:26:23", uuid="552d417a51f793e4b5ded9a19aa08622", cid="1602040000000166461", unixtime="1460186783", source_uri="prt://rtcrypta@storm01e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="44.78818555360001", ip="217.13.91.184", geo_source_types="mobile_metrics,ipgeo", lat="48.78049483120001", now="1460186827", type="metrics_raw", yauid="601826891455541113", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:1:133763997:")

testdata_crypta_rt_geo_log.add_row(_date="2016-04-10", acc="71", iso_eventtime="2016-04-10 01:46:12", uuid="dbd9e0b1ce69e8e188de9888e9d0aca6", cid="1604020000000540842", unixtime="1460241972", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.4445734", ip="188.123.230.137", geo_source_types="mobile_metrics", lat="55.6779104", now="1460242006", type="mobile_metrics_identified", yauid="601826891455541114", _stbx="rt3.man--rtcrypta--crypta-rt-geo-log:2:172260:")
testdata_crypta_rt_geo_log.add_row(_date="2016-04-10", acc="151", iso_eventtime="2016-04-10 01:46:12", uuid="dbd9e0b1ce69e8e188de9888e9d0aca6", cid="1604020000000540842", unixtime="1460241972", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.4445734", ip="217.13.91.184", geo_source_types="mobile_metrics,metrics,ipgeo,bar", lat="55.6779104", now="1460242006", type="mobile_metrics_identified", yauid="601826891455541114", _stbx="rt3.man--rtcrypta--crypta-rt-geo-log:2:172260:")
testdata_crypta_rt_geo_log.add_row(_date="2016-04-10", acc="511", iso_eventtime="2016-04-10 01:56:24", uuid="dbd9e0b1ce69e8e188de9888e9d0aca6", cid="1604020000000540842", unixtime="1460242584", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.4447186", ip="217.13.91.184", geo_source_types="mobile_metrics,metrics,ipgeo,bar", lat="55.6778428", now="1460242586", type="map_navig_identified", yauid="101826891455542223", _stbx="rt3.man--rtcrypta--crypta-rt-geo-log:2:172423:")
testdata_crypta_rt_geo_log.add_row(_date="2016-04-10", acc="1499", iso_eventtime="2016-04-10 01:46:12", uuid="dbd9e0b1ce69e8e188de9888e9d0aca6", cid="1604020000000540842", unixtime="1460241972", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.4445734", ip="217.13.91.184", geo_source_types="mobile_metrics", lat="55.6779104", now="1460242006", type="metrics_raw", yauid="601826891455541115", _stbx="rt3.man--rtcrypta--crypta-rt-geo-log:2:172260:")
testdata_crypta_rt_geo_log.add_row(_date="2016-04-10", acc="12000", iso_eventtime="2016-04-10 01:56:24", uuid="dbd9e0b1ce69e8e188de9888e9d0aca6", cid="1604020000000540842", unixtime="1460242584", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.4447186", ip="85.174.38.23", geo_source_types="mobile_metrics", lat="55.6778428", now="1460242586", type="metrics_raw", yauid="1726075371455990918", _stbx="rt3.man--rtcrypta--crypta-rt-geo-log:2:172423:")

testdata_crypta_rt_geo_log.add_row(_date="2016-04-11", acc="101", iso_eventtime="2016-04-11 21:35:58", uuid="021979592b36831fde8070bbb557b329", cid="181746585406122669", unixtime="1460399758", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.035312075896584", ip="178.217.100.100", geo_source_types="mobile_metrics,ipgeo", lat="55.600606393677324", now="1460399818", type="mobile_metrics_identified", yauid="1748232901455365413", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:1:134712536:")
testdata_crypta_rt_geo_log.add_row(_date="2016-04-11", acc="149", iso_eventtime="2016-04-11 21:35:58", uuid="021979592b36831fde8070bbb557b329", cid="181746585406122669", unixtime="1460399758", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.035312075896584", ip="178.217.100.100", geo_source_types="mobile_metrics,ipgeo", lat="55.600606393677324", now="1460399818", type="mobile_metrics_identified", yauid="601826891455541115", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:1:134712536:")
testdata_crypta_rt_geo_log.add_row(_date="2016-04-11", acc="499", iso_eventtime="2016-04-11 21:35:58", uuid="021979592b36831fde8070bbb557b329", cid="181746585406122669", unixtime="1460399758", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.035312075896584", ip="217.13.91.184", geo_source_types="mobile_metrics,ipgeo", lat="55.600606393677324", now="1460399818", type="mobile_metrics_identified", yauid="601826891455541115", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:1:134712536:")
testdata_crypta_rt_geo_log.add_row(_date="2016-04-11", acc="999", iso_eventtime="2016-04-11 21:35:58", uuid="021979592b36831fde8070bbb557b329", cid="181746585406122669", unixtime="1460399758", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.035312075896584", ip="217.13.91.184", geo_source_types="mobile_metrics,metrics,ipgeo,bar", lat="55.600606393677324", now="1460399823", type="map_navig_identified", yauid="1726075371455990918", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:1:134712540:")
testdata_crypta_rt_geo_log.add_row(_date="2016-04-11", acc="9999", iso_eventtime="2016-04-11 21:35:58", uuid="021979592b36831fde8070bbb557b329", cid="181746585406122669", unixtime="1460399758", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.035312075896584", ip="85.174.38.23", geo_source_types="mobile_metrics,ipgeo", lat="55.600606393677324", now="1460399818", type="map_navig_identified", yauid="601826891455541114", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:1:134712536:")
testdata_crypta_rt_geo_log.add_row(_date="2016-04-11", acc="11999", iso_eventtime="2016-04-11 21:35:58", uuid="021979592b36831fde8070bbb557b329", cid="181746585406122669", unixtime="1460399758", source_uri="prt://rtcrypta@storm07e.rtcrypta.yandex.net/var/log/storm/statbox/rt-geo-log/push-client", lon="37.035312075896584", ip="217.13.91.184", geo_source_types="mobile_metrics,ipgeo", lat="55.600606393677324", now="1460399823", type="metrics_raw", yauid="101826891455542222", _stbx="rt3.iva--rtcrypta--crypta-rt-geo-log:1:134712540:")


testdata_iscrypta_matching_log = BaseLog(
                path="//statbox/iscrypta-matching-log",
                date="2016-04-09",
                default_data=ISCRYPTA_MATCHING_LOG
    )
testdata_iscrypta_matching_log.add_row(iso_eventtime="2016-04-09 16:31:06", uuid="bb35f489f1ceccf89579a11f92377746", unixtime="1460208666", source_uri="prt://iscrypta@idserv07e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", puid="376701270", deviceid="21f44ec9-7f36-4a56-a529-88326db73750", type="puid-uuid", _stbx="rt3.iva--other--other:116:40511769:")
testdata_iscrypta_matching_log.add_row(iso_eventtime="2016-04-09 16:31:06", uuid="bb35f489f1ceccf89579a11f92377746", unixtime="1460208666", source_uri="prt://iscrypta@idserv07e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", puid="376701270", deviceid="21f44ec9-7f36-4a56-a529-88326db73750", type="puid-uuid", _stbx="rt3.iva--other--other:116:40511769:")
testdata_iscrypta_matching_log.add_row(iso_eventtime="2016-04-09 16:31:08", uuid="bb35f489f1ceccf89579a11f92377746", unixtime="1460208668", source_uri="prt://iscrypta@idserv07e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", puid="376701270", deviceid="21f44ec9-7f36-4a56-a529-88326db73750", type="puid-uuid", _stbx="rt3.iva--other--other:116:40511775:")
testdata_iscrypta_matching_log.add_row(iso_eventtime="2016-04-09 16:31:06", uuid="bb35f489f1ceccf89579a11f92377746", unixtime="1460208666", source_uri="prt://iscrypta@idserv07e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", puid="376701270", deviceid="21f44ec9-7f36-4a56-a529-88326db73750", type="puid-uuid", _stbx="rt3.iva--other--other:116:40511769:")
testdata_iscrypta_matching_log.add_row(iso_eventtime="2016-04-09 16:31:08", uuid="bb35f489f1ceccf89579a11f92377746", unixtime="1460208668", source_uri="prt://iscrypta@idserv07e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", puid="376701270", deviceid="21f44ec9-7f36-4a56-a529-88326db73750", type="puid-uuid", _stbx="rt3.iva--other--other:116:40511775:")

testdata_iscrypta_matching_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 23:16:03", unixtime="1460319363", source_uri="prt://iscrypta@idserv10e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", _stbx="rt3.man--other--other:107:10852315:")
testdata_iscrypta_matching_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 23:16:03", unixtime="1460319363", source_uri="prt://iscrypta@idserv10e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", _stbx="rt3.man--other--other:107:10852315:")
testdata_iscrypta_matching_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 11:48:37", unixtime="1460278117", source_uri="prt://iscrypta@idserv11e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", _stbx="rt3.iva--other--other:31:641684539:")
testdata_iscrypta_matching_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 23:16:03", unixtime="1460319363", source_uri="prt://iscrypta@idserv10e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", _stbx="rt3.man--other--other:107:10852315:")
testdata_iscrypta_matching_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 11:48:37", unixtime="1460278117", source_uri="prt://iscrypta@idserv11e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", _stbx="rt3.iva--other--other:31:641684539:")

testdata_iscrypta_matching_log.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 01:01:46", uuid="bb35f489f1ceccf89579a11f92377746", unixtime="1460325706", source_uri="prt://iscrypta@idserv10e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", puid="376701270", deviceid="21f44ec9-7f36-4a56-a529-88326db73750", type="puid-uuid", _stbx="rt3.man--other--other:107:10860977:")
testdata_iscrypta_matching_log.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 01:01:46", uuid="bb35f489f1ceccf89579a11f92377746", unixtime="1460325706", source_uri="prt://iscrypta@idserv10e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", puid="376701270", deviceid="21f44ec9-7f36-4a56-a529-88326db73750", type="puid-uuid", _stbx="rt3.man--other--other:107:10860977:")
testdata_iscrypta_matching_log.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 17:14:20", uuid="bb35f489f1ceccf89579a11f92377746", unixtime="1460384060", source_uri="prt://iscrypta@idserv07e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", puid="376701270", deviceid="21f44ec9-7f36-4a56-a529-88326db73750", type="puid-uuid", _stbx="rt3.iva--other--other:49:639890816:")
testdata_iscrypta_matching_log.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 01:01:46", uuid="bb35f489f1ceccf89579a11f92377746", unixtime="1460325706", source_uri="prt://iscrypta@idserv10e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", puid="376701270", deviceid="21f44ec9-7f36-4a56-a529-88326db73750", type="puid-uuid", _stbx="rt3.man--other--other:107:10860977:")
testdata_iscrypta_matching_log.add_row(_date="2016-04-11", iso_eventtime="2016-04-11 17:14:20", uuid="bb35f489f1ceccf89579a11f92377746", unixtime="1460384060", source_uri="prt://iscrypta@idserv07e.rtcrypta.yandex.net/var/log/crypta-ident/iscrypta-matching.log", puid="376701270", deviceid="21f44ec9-7f36-4a56-a529-88326db73750", type="puid-uuid", _stbx="rt3.iva--other--other:49:639890816:")


testdata_mobile_tracking_log = BaseLog(
                path="//home/logfeller/logs/metrika-mobile-install-log/1d",
                date="2016-04-09",
                default_data=MOBILE_TRACKING_LOG
    )
testdata_mobile_tracking_log.add_row(UUID='021979592b36831fde8070bbb557b329', RegionID="213", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460223976", DeviceIDHash="9493461388394930183", ClickTimestamp="1460223976", timestamp="2016-04-09 17:46:56", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Mobile/12H321", ClientIP="::ffff:85.31.113.126", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:57980", ReceiveTimestamp="1460223976", DeviceType="TABLET", OSVersion="8.4.1", iso_eventtime="2016-04-09 20:46:56", YandexUidRu="8622478831441691934", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-09 20:46:16", Manufacturer="Apple")
testdata_mobile_tracking_log.add_row(UUID='021979592b36831fde8070bbb557b329', RegionID="213", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460223976", DeviceIDHash="9493461388394930183", ClickTimestamp="1460223976", timestamp="2016-04-09 17:46:56", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Mobile/12H321", ClientIP="::ffff:85.31.113.126", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:57980", ReceiveTimestamp="1460223976", DeviceType="TABLET", OSVersion="8.4.1", iso_eventtime="2016-04-09 20:46:56", YandexUidRu="8622478831441691934", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-09 20:46:16", Manufacturer="Apple")
testdata_mobile_tracking_log.add_row(UUID='021979592b36831fde8070bbb557b329', RegionID="213", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460223976", DeviceIDHash="9493461388394930183", ClickTimestamp="1460223976", timestamp="2016-04-09 17:46:56", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Mobile/12H321", ClientIP="::ffff:85.31.113.126", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:57980:", ReceiveTimestamp="1460223976", DeviceType="TABLET", UniqueClickID="10847448833746539528", YMTrackingID="10847448833746539528", OSVersion="8.4.1", iso_eventtime="2016-04-09 20:46:56", YandexUidRu="8622478831441691934", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-09 20:46:16", Manufacturer="Apple")
testdata_mobile_tracking_log.add_row(UUID='bb35f489f1ceccf89579a11f92377746', RegionID="213", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460223976", DeviceIDHash="9493461388394930183", ClickTimestamp="1460223976", timestamp="2016-04-09 17:46:56", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Mobile/12H321", ClientIP="::ffff:85.31.113.126", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:57980", ReceiveTimestamp="1460223976", DeviceType="TABLET", OSVersion="8.4.1", iso_eventtime="2016-04-09 20:46:56", YandexUidRu="8622478831441691934", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-09 20:46:16", Manufacturer="Apple")
testdata_mobile_tracking_log.add_row(UUID='bb35f489f1ceccf89579a11f92377746', RegionID="213", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460223976", DeviceIDHash="9493461388394930183", ClickTimestamp="1460223976", timestamp="2016-04-09 17:46:56", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Mobile/12H321", ClientIP="::ffff:85.31.113.126", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:57980:", ReceiveTimestamp="1460223976", DeviceType="TABLET", UniqueClickID="10847448833746539528", YMTrackingID="10847448833746539528", OSVersion="8.4.1", iso_eventtime="2016-04-09 20:46:56", YandexUidRu="8622478831441691934", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-09 20:46:16", Manufacturer="Apple")
testdata_mobile_tracking_log.add_row(_date="2016-04-10", UUID='021979592b36831fde8070bbb557b329', RegionID="213", Model="Galaxy A3", APIKey="106400", AppPlatform="android", StartTimestamp="1460315530", DeviceIDHash="5575590620955852110", ClickTimestamp="1460315530", timestamp="2016-04-10 19:12:51", UrlParameters_Values="['dzen-couple-t2','ru','neYB']", UserAgent="Mozilla/5.0 (Linux; Android 5.0.2; SM-A300F Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.83 Mobile Safari/537.36", ClientIP="::ffff:109.173.43.153", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:67659:", ReceiveTimestamp="1460315530", source_uri="prt://mobmetrika@mtcalclog03e.yandex.ru/opt/statbox_export_mobile/mobile-clicks.log", DeviceType="PHONE", OSVersion="5.0.2", iso_eventtime="2016-04-10 22:12:51", YandexUidRu="1469860561425943192", ReceiveTimeZone="0", UrlParameters_Keys="['creative','geo','target']", StartTime="2016-04-10 22:12:10", EventType="EVENT_AD_CLICK", Manufacturer="Samsung")
testdata_mobile_tracking_log.add_row(_date="2016-04-10", UUID='021979592b36831fde8070bbb557b329', RegionID="213", Model="Galaxy A3", APIKey="106400", AppPlatform="android", StartTimestamp="1460315530", DeviceIDHash="5575590620955852110", ClickTimestamp="1460315530", timestamp="2016-04-10 19:12:51", UrlParameters_Values="['dzen-couple-t2','ru','neYB']", UserAgent="Mozilla/5.0 (Linux; Android 5.0.2; SM-A300F Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.83 Mobile Safari/537.36", ClientIP="::ffff:109.173.43.153", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:67659:", ReceiveTimestamp="1460315530", source_uri="prt://mobmetrika@mtcalclog03e.yandex.ru/opt/statbox_export_mobile/mobile-clicks.log", DeviceType="PHONE", OSVersion="5.0.2", iso_eventtime="2016-04-10 22:12:51", YandexUidRu="1469860561425943192", ReceiveTimeZone="0", UrlParameters_Keys="['creative','geo','target']", StartTime="2016-04-10 22:12:10", EventType="EVENT_AD_CLICK", Manufacturer="Samsung")
testdata_mobile_tracking_log.add_row(_date="2016-04-10", UUID='021979592b36831fde8070bbb557b329', RequestHeaders_Names="['Accept-Language','Upgrade-Insecure-Requests','User-Agent','Host','Accept-Encoding','Referer','Cookie','Connection','Accept']", ClickReceiveTimestamp="1460315531", RegionID="213", ClickDateTime="2016-04-10 22:12:11", Model="Galaxy A3", APIKey="106400", AppPlatform="android", StartTimestamp="1460315531", DeviceIDHash="1955956076350024385", ClickTimestamp="1460315531", timestamp="2016-04-10 19:12:51", UrlParameters_Values="['dzen-couple-t2','ru','neYB']", UserAgent="Mozilla/5.0 (Linux; Android 5.0.2; SM-A300F Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.83 Mobile Safari/537.36", ClientIP="::ffff:109.173.43.153", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:67659:", ReceiveTimestamp="1460315531", source_uri="prt://mobmetrika@mtcalclog03e.yandex.ru/opt/statbox_export_mobile/mobile-clicks.log", DeviceType="PHONE", UniqueClickID="11378786936113604095", YMTrackingID="11378786936113604095", OSVersion="5.0.2", iso_eventtime="2016-04-10 22:12:51", RequestHeaders_Values="['ru-RU,ru;q=0.8,en-US;q=0.6,en;q=0.4','1','Mozilla/5.0 (Linux; Android 5.0.2; SM-A300F Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.83 Mobile Safari/537.36','redirect.appmetrica.yandex.com','gzip, deflate, sdch','http://www.yandex.ru/','yandexuid=1469860561425943192; referrer=106400:ym_tracking_id=9873201554416477753','close','text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8']", YandexUidRu="1469860561425943192", ReceiveTimeZone="0", UrlParameters_Keys="['creative','geo','target']", StartTime="2016-04-10 22:12:11", EventType="EVENT_AD_CLICK", Manufacturer="Samsung")
testdata_mobile_tracking_log.add_row(_date="2016-04-10", UUID='bb35f489f1ceccf89579a11f92377746', RegionID="213", Model="Galaxy A3", APIKey="106400", AppPlatform="android", StartTimestamp="1460315530", DeviceIDHash="5575590620955852110", ClickTimestamp="1460315530", timestamp="2016-04-10 19:12:51", UrlParameters_Values="['dzen-couple-t2','ru','neYB']", UserAgent="Mozilla/5.0 (Linux; Android 5.0.2; SM-A300F Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.83 Mobile Safari/537.36", ClientIP="::ffff:109.173.43.153", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:67659:", ReceiveTimestamp="1460315530", source_uri="prt://mobmetrika@mtcalclog03e.yandex.ru/opt/statbox_export_mobile/mobile-clicks.log", DeviceType="PHONE", OSVersion="5.0.2", iso_eventtime="2016-04-10 22:12:51", YandexUidRu="1469860561425943192", ReceiveTimeZone="0", UrlParameters_Keys="['creative','geo','target']", StartTime="2016-04-10 22:12:10", EventType="EVENT_AD_CLICK", Manufacturer="Samsung")
testdata_mobile_tracking_log.add_row(_date="2016-04-10", UUID='bb35f489f1ceccf89579a11f92377746', RequestHeaders_Names="['Accept-Language','Upgrade-Insecure-Requests','User-Agent','Host','Accept-Encoding','Referer','Cookie','Connection','Accept']", ClickReceiveTimestamp="1460315531", RegionID="213", ClickDateTime="2016-04-10 22:12:11", Model="Galaxy A3", APIKey="106400", AppPlatform="android", StartTimestamp="1460315531", DeviceIDHash="1955956076350024385", ClickTimestamp="1460315531", timestamp="2016-04-10 19:12:51", UrlParameters_Values="['dzen-couple-t2','ru','neYB']", UserAgent="Mozilla/5.0 (Linux; Android 5.0.2; SM-A300F Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.83 Mobile Safari/537.36", ClientIP="::ffff:109.173.43.153", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:67659:", ReceiveTimestamp="1460315531", source_uri="prt://mobmetrika@mtcalclog03e.yandex.ru/opt/statbox_export_mobile/mobile-clicks.log", DeviceType="PHONE", UniqueClickID="11378786936113604095", YMTrackingID="11378786936113604095", OSVersion="5.0.2", iso_eventtime="2016-04-10 22:12:51", RequestHeaders_Values="['ru-RU,ru;q=0.8,en-US;q=0.6,en;q=0.4','1','Mozilla/5.0 (Linux; Android 5.0.2; SM-A300F Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.83 Mobile Safari/537.36','redirect.appmetrica.yandex.com','gzip, deflate, sdch','http://www.yandex.ru/','yandexuid=1469860561425943192; referrer=106400:ym_tracking_id=9873201554416477753','close','text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8']", YandexUidRu="1469860561425943192", ReceiveTimeZone="0", UrlParameters_Keys="['creative','geo','target']", StartTime="2016-04-10 22:12:11", EventType="EVENT_AD_CLICK", Manufacturer="Samsung")
testdata_mobile_tracking_log.add_row(_date="2016-04-11", UUID='021979592b36831fde8070bbb557b329', RegionID="43", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460408301", DeviceIDHash="18053039941442816448", ClickTimestamp="1460408301", timestamp="2016-04-11 20:58:33", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13E238 Safari/601.1", ClientIP="::ffff:94.180.135.227", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:77394:", ReceiveTimestamp="1460408301", DeviceType="TABLET", OSVersion="9.3.1", iso_eventtime="2016-04-11 23:58:33", YandexUidRu="8265280551449681819", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-11 23:58:21", Manufacturer="Apple")
testdata_mobile_tracking_log.add_row(_date="2016-04-11", UUID='021979592b36831fde8070bbb557b329', RegionID="43", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460408301", DeviceIDHash="18053039941442816448", ClickTimestamp="1460408301", timestamp="2016-04-11 20:58:33", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13E238 Safari/601.1", ClientIP="::ffff:94.180.135.227", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:77394:", ReceiveTimestamp="1460408301", DeviceType="TABLET", OSVersion="9.3.1", iso_eventtime="2016-04-11 23:58:33", YandexUidRu="8265280551449681819", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-11 23:58:21", Manufacturer="Apple")
testdata_mobile_tracking_log.add_row(_date="2016-04-11", UUID='021979592b36831fde8070bbb557b329', RegionID="43", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460408301", DeviceIDHash="18053039941442816448", ClickTimestamp="1460408301", timestamp="2016-04-11 20:58:33", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13E238 Safari/601.1", ClientIP="::ffff:94.180.135.227", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:77394:", ReceiveTimestamp="1460408301", DeviceType="TABLET", UniqueClickID="1429741381819109728", YMTrackingID="1429741381819109728", OSVersion="9.3.1", iso_eventtime="2016-04-11 23:58:33", YandexUidRu="8265280551449681819", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-11 23:58:21", Manufacturer="Apple")
testdata_mobile_tracking_log.add_row(_date="2016-04-11", UUID='bb35f489f1ceccf89579a11f92377746', RegionID="43", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460408301", DeviceIDHash="18053039941442816448", ClickTimestamp="1460408301", timestamp="2016-04-11 20:58:33", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13E238 Safari/601.1", ClientIP="::ffff:94.180.135.227", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:77394:", ReceiveTimestamp="1460408301", DeviceType="TABLET", OSVersion="9.3.1", iso_eventtime="2016-04-11 23:58:33", YandexUidRu="8265280551449681819", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-11 23:58:21", Manufacturer="Apple")
testdata_mobile_tracking_log.add_row(_date="2016-04-11", UUID='bb35f489f1ceccf89579a11f92377746', RegionID="43", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460408301", DeviceIDHash="18053039941442816448", ClickTimestamp="1460408301", timestamp="2016-04-11 20:58:33", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13E238 Safari/601.1", ClientIP="::ffff:94.180.135.227", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:77394:", ReceiveTimestamp="1460408301", DeviceType="TABLET", UniqueClickID="1429741381819109728", YMTrackingID="1429741381819109728", OSVersion="9.3.1", iso_eventtime="2016-04-11 23:58:33", YandexUidRu="8265280551449681819", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-11 23:58:21", Manufacturer="Apple")


testdata_mobile_tracking_private_log = BaseLog(
    path="//home/logfeller/logs/metrika-mobile-install-private-log/1d",
    date="2016-04-11",
    default_data=MOBILE_TRACKING_PRIVATE_LOG
)
testdata_mobile_tracking_private_log.add_row(UUID='3e2b6871964bb53513eacac621970e9b', RegionID="213", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460223976", DeviceIDHash="9493461388394930183", ClickTimestamp="1460223976", timestamp="2016-04-09 17:46:56", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Mobile/12H321", ClientIP="::ffff:85.31.113.126", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:57980", ReceiveTimestamp="1460223976", DeviceType="TABLET", OSVersion="8.4.1", iso_eventtime="2016-04-09 20:46:56", YandexUidRu="8622478831441691934", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-09 20:46:16", Manufacturer="Apple")
testdata_mobile_tracking_private_log.add_row(_date="2016-04-10", UUID='3e2b6871964bb53513eacac621970e9b', RegionID="213", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460223976", DeviceIDHash="9493461388394930183", ClickTimestamp="1460223976", timestamp="2016-04-09 17:46:56", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Mobile/12H321", ClientIP="::ffff:85.31.113.126", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:57980", ReceiveTimestamp="1460223976", DeviceType="TABLET", OSVersion="8.4.1", iso_eventtime="2016-04-09 20:46:56", YandexUidRu="8622478831441691934", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-09 20:46:16", Manufacturer="Apple")
testdata_mobile_tracking_private_log.add_row(_date="2016-04-09", UUID='3e2b6871964bb53513eacac621970e9b', RegionID="213", Model="iPad", APIKey="29733", AppPlatform="iOS", StartTimestamp="1460223976", DeviceIDHash="9493461388394930183", ClickTimestamp="1460223976", timestamp="2016-04-09 17:46:56", UrlParameters_Values="['click','ru.yandex.mail']", UserAgent="Mozilla/5.0 (iPad; CPU OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Mobile/12H321", ClientIP="::ffff:85.31.113.126", _stbx="rt3.iva--mobmetrika--mobile-clicks-log:0:57980", ReceiveTimestamp="1460223976", DeviceType="TABLET", OSVersion="8.4.1", iso_eventtime="2016-04-09 20:46:56", YandexUidRu="8622478831441691934", UrlParameters_Keys="['action','app_id']", StartTime="2016-04-09 20:46:16", Manufacturer="Apple")


testdata_oauth_log = BaseLog(
                path="//statbox/oauth-log",
                date="2016-04-09",
                default_data=OAUTH_LOG
    )
testdata_oauth_log.add_row(uid="92742990", unixtime="1460196263", create_time="2016-02-09 21:51:35", source_uri="prt://oauth@oauth-nb4.yandex.net/var/log/yandex/oauth-server/statbox.log", _stbx="rt3.fol--oauth--oauth-log:1:164887069:", timestamp="2016-04-09 13:04:23", expire_time="2017-04-07 01:32:56", device_id="4ee6905fdb60242e183809c98969e12b", iso_eventtime="2016-04-09 13:04:23")
testdata_oauth_log.add_row(uid="92742990", unixtime="1460196263", create_time="2016-02-09 21:51:35", source_uri="prt://oauth@oauth-nb4.yandex.net/var/log/yandex/oauth-server/statbox.log", _stbx="rt3.fol--oauth--oauth-log:1:164887069:", timestamp="2016-04-09 13:04:23", expire_time="2017-04-07 01:32:56", device_id="4ee6905fdb60242e183809c98969e12b", iso_eventtime="2016-04-09 13:04:23")
testdata_oauth_log.add_row(uid="376701270", unixtime="1460196264", app_id="ru.yandex.taxi", mode="issue_token", create_time="2016-04-09 08:53:11", iso_eventtime="2016-04-09 13:04:24", uuid="bb35f489f1ceccf89579a11f92377746", app_platform="Android 4.4.2 (REL)", user_ip="::ffff:213.87.135.117", _stbx="rt3.fol--oauth--oauth-log:1:164887079:", token_id="224453705", device_id="001c18cba26966f27792ccc532358d42", deviceid="001c18cba26966f27792ccc532358d42", scopes="mobile:all,yataxi:pay,yataxi:read,yataxi:write", timestamp="2016-04-09 13:04:24", source_uri="prt://oauth@oauth-nb4.yandex.net/var/log/yandex/oauth-server/statbox.log", client_id="22d873ed2ea14b93a36a0f5a07026458", expire_time="2017-04-09 13:04:17", manufacturer="Philips", device_name="Philips V387", issue_time="2016-04-09 13:04:17", request_id="465acd27fe7123913c68ba438039eb7d", model="Philips V387")
testdata_oauth_log.add_row(uid="92742990", unixtime="1460196263", create_time="2016-02-09 21:51:35", source_uri="prt://oauth@oauth-nb4.yandex.net/var/log/yandex/oauth-server/statbox.log", _stbx="rt3.fol--oauth--oauth-log:1:164887069:3", timestamp="2016-04-09 13:04:23", expire_time="2017-04-07 01:32:56", device_id="4ee6905fdb60242e183809c98969e12b", iso_eventtime="2016-04-09 13:04:23")
testdata_oauth_log.add_row(uid="376701270", unixtime="1460196264", app_id="ru.yandex.taxi", mode="issue_token", create_time="2016-04-09 08:53:11", iso_eventtime="2016-04-09 13:04:24", uuid="bb35f489f1ceccf89579a11f92377746", app_platform="Android 4.4.2 (REL)", user_ip="::ffff:213.87.135.117", _stbx="rt3.fol--oauth--oauth-log:1:164887079:", token_id="224453705", device_id="001c18cba26966f27792ccc532358d42", deviceid="001c18cba26966f27792ccc532358d42", scopes="mobile:all,yataxi:pay,yataxi:read,yataxi:write", timestamp="2016-04-09 13:04:24", source_uri="prt://oauth@oauth-nb4.yandex.net/var/log/yandex/oauth-server/statbox.log", client_id="22d873ed2ea14b93a36a0f5a07026458", expire_time="2017-04-09 13:04:17", manufacturer="Philips", device_name="Philips V387", issue_time="2016-04-09 13:04:17", request_id="465acd27fe7123913c68ba438039eb7d", model="Philips V387")

testdata_oauth_log.add_row(_date="2016-04-10", uid="376701270", unixtime="1460300844", app_id="ru.yandex.taxi", create_time="2016-04-09 08:53:11", iso_eventtime="2016-04-10 18:07:24", uuid="bb35f489f1ceccf89579a11f92377746", app_platform="Android 4.4.2 (REL)", _stbx="rt3.fol--oauth--oauth-log:1:165449797:", device_id="001c18cba26966f27792ccc532358d42", deviceid="001c18cba26966f27792ccc532358d42", timestamp="2016-04-10 18:07:24", source_uri="prt://oauth@oauth-na5.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-10 18:06:25", manufacturer="Philips", model="Philips V387")
testdata_oauth_log.add_row(_date="2016-04-10", uid="376701270", unixtime="1460300844", app_id="ru.yandex.taxi", create_time="2016-04-09 08:53:11", iso_eventtime="2016-04-10 18:07:24", uuid="bb35f489f1ceccf89579a11f92377746", app_platform="Android 4.4.2 (REL)", _stbx="rt3.fol--oauth--oauth-log:1:165449797:", device_id="001c18cba26966f27792ccc532358d42", deviceid="001c18cba26966f27792ccc532358d42", timestamp="2016-04-10 18:07:24", source_uri="prt://oauth@oauth-na5.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-10 18:06:25", manufacturer="Philips", model="Philips V387")
testdata_oauth_log.add_row(_date="2016-04-10", uid="376701270", unixtime="1460300844", app_id="ru.yandex.taxi", create_time="2016-04-09 08:53:11", consumer_ip="2a02:6b8:0:c05::105a", iso_eventtime="2016-04-10 18:07:24", uuid="bb35f489f1ceccf89579a11f92377746", app_platform="Android 4.4.2 (REL)", _stbx="rt3.fol--oauth--oauth-log:1:165449797:", device_id="001c18cba26966f27792ccc532358d42", deviceid="001c18cba26966f27792ccc532358d42", timestamp="2016-04-10 18:07:24", source_uri="prt://oauth@oauth-na5.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-10 18:06:25", manufacturer="Philips", request_id="840c43fcb990972a55c426c65e5b3aab", model="Philips V387")
testdata_oauth_log.add_row(_date="2016-04-10", uid="376701270", unixtime="1460300844", app_id="ru.yandex.taxi", create_time="2016-04-09 08:53:11", iso_eventtime="2016-04-10 18:07:24", uuid="bb35f489f1ceccf89579a11f92377746", app_platform="Android 4.4.2 (REL)", _stbx="rt3.fol--oauth--oauth-log:1:165449797:", device_id="001c18cba26966f27792ccc532358d42", deviceid="001c18cba26966f27792ccc532358d42", timestamp="2016-04-10 18:07:24", source_uri="prt://oauth@oauth-na5.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-10 18:06:25", manufacturer="Philips", model="Philips V387")
testdata_oauth_log.add_row(_date="2016-04-10", uid="376701270", unixtime="1460300844", app_id="ru.yandex.taxi", create_time="2016-04-09 08:53:11", consumer_ip="2a02:6b8:0:c05::105a", iso_eventtime="2016-04-10 18:07:24", uuid="bb35f489f1ceccf89579a11f92377746", app_platform="Android 4.4.2 (REL)", _stbx="rt3.fol--oauth--oauth-log:1:165449797:", device_id="001c18cba26966f27792ccc532358d42", deviceid="001c18cba26966f27792ccc532358d42", timestamp="2016-04-10 18:07:24", source_uri="prt://oauth@oauth-na5.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-10 18:06:25", manufacturer="Philips", request_id="840c43fcb990972a55c426c65e5b3aab", model="Philips V387")

testdata_oauth_log.add_row(_date="2016-04-11", unixtime="1460349281", iso_eventtime="2016-04-11 07:34:41", _stbx="rt3.iva--oauth--oauth-log:0:166691226:", timestamp="2016-04-11 07:34:41", source_uri="prt://oauth@oauth-i4.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-11 07:34:36")
testdata_oauth_log.add_row(_date="2016-04-11", unixtime="1460349281", iso_eventtime="2016-04-11 07:34:41", _stbx="rt3.iva--oauth--oauth-log:0:166691226:", timestamp="2016-04-11 07:34:41", source_uri="prt://oauth@oauth-i4.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-11 07:34:36")
testdata_oauth_log.add_row(_date="2016-04-11", unixtime="1460348228", consumer_ip="2a02:6b8:0:c05::105a", iso_eventtime="2016-04-11 07:17:08", _stbx="rt3.fol--oauth--oauth-log:0:155588658:", timestamp="2016-04-11 07:17:08", source_uri="prt://oauth@oauth-na3.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-11 07:16:11", issue_time="2016-04-11 07:16:11", request_id="c885087d4cb0c0418db8707c8dc7c8f6")
testdata_oauth_log.add_row(_date="2016-04-11", unixtime="1460349281", iso_eventtime="2016-04-11 07:34:41", _stbx="rt3.iva--oauth--oauth-log:0:166691226:", timestamp="2016-04-11 07:34:41", source_uri="prt://oauth@oauth-i4.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-11 07:34:36")
testdata_oauth_log.add_row(_date="2016-04-11", unixtime="1460348228", consumer_ip="2a02:6b8:0:c05::105a", iso_eventtime="2016-04-11 07:17:08", _stbx="rt3.fol--oauth--oauth-log:0:155588658:", timestamp="2016-04-11 07:17:08", source_uri="prt://oauth@oauth-na3.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-11 07:16:11", issue_time="2016-04-11 07:16:11", request_id="c885087d4cb0c0418db8707c8dc7c8f6")
testdata_oauth_log.add_row(_date="2016-04-11", unixtime="1460348229", consumer_ip="2a02:6b8:0:c05::105a", iso_eventtime="2016-04-11 07:17:09", _stbx="rt3.fol--oauth--oauth-log:0:155588666:", timestamp="2016-04-11 07:17:09", source_uri="prt://oauth@oauth-na3.yandex.net/var/log/yandex/oauth-server/statbox.log", expire_time="2017-04-11 07:16:11", issue_time="2016-04-11 07:16:11", request_id="9eb5877bbdd40795ed9ed87c6037b6d8")


testdata_redir_log = ComplexParametersLog(
                path="//statbox/redir-log",
                date="2016-04-09",
                default_data=REDIR_LOG
    )
testdata_redir_log.add_row(key="prt://redir@sas1-2631.search.yandex.net/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-09 18:35:45", value={u'ver': u'4875', u'HTTP_REFERER': u'https://yandex.ru/search/?lr=39&clid=2163430&msid=22882.7835.1460214250.85039&text=%D0%BA%D0%B8%D0%BD%D0%BE%D0%B3%D0%BE&suggest_reqid=312576068144429607843208967368320&csg=2123%2C3126%2C4%2C5%2C1%2C0%2C0&uuid=202e825ff99eb18a6e586260a5635eab', u'url': u'//yandex.ru/', u'unixtime': u'1460216145', u'ids': u'23421,23471,23095,23258,22688,23176,23574,23668,23644,23084,10326,23280', u'_stbx': u'rt3.sas--redir--redir-log:10:163782180:', u'path': u'690.781.2033', u'reg': u'39'})
testdata_redir_log.add_row(key="prt://redir@sas1-2631.search.yandex.net/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-09 18:35:45", value={u'ver': u'4875', u'HTTP_REFERER': u'https://yandex.ru/search/?lr=39&clid=2163430&msid=22882.7835.1460214250.85039&text=%D0%BA%D0%B8%D0%BD%D0%BE%D0%B3%D0%BE&suggest_reqid=312576068144429607843208967368320&csg=2123%2C3126%2C4%2C5%2C1%2C0%2C0&uuid=bf62d1b137388c21ddb64090dd02c94c', u'url': u'//yandex.ru/', u'unixtime': u'1460216145', u'ids': u'23421,23471,23095,23258,22688,23176,23574,23668,23644,23084,10326,23280', u'_stbx': u'rt3.sas--redir--redir-log:10:163782180:', u'path': u'690.781.2033', u'reg': u'39'})
testdata_redir_log.add_row(key="prt://redir@sas1-4857.search.yandex.net/usr/local/www/logs/current-redir-clickdaemon-18101 2016-04-09 11:11:51", value={u'ver': u'4875', u'mc': u'0', u'HTTP_REFERER': u'https://yandex.ru/search/?from=chromesearch&clid=2196598&text=%D0%B0%D0%BB%D0%B8%D1%8D%D0%BA%D1%81%D0%BF%D1%80%D0%B5%D1%81%D1%81&redircnt=1460189502.1', u'cts': u'1460189489412', u'url': u'http://ru.aliexpress.com/', u'unixtime': u'1460189511', u'vars': u'-post=bno,-main=yaca,84=85,-source=web', u'ids': u'23668,23644,23084,10326,23280', u'reqid': u'1460189503336646-5409348811413397083241496-sas1-2711', u'at': u'4', u'path': u'80.22.82', u'keyno': u'0', u'slots': u'23421,0,35;23471,0,75;23095,0,85;23408,0,56;23677,0,44;23176,0,91;23574,0,65;23063,0,97;23668,0,31;23644,0,65;23084,0,64;10326,0,84;23280,0,73', u'reg': u'39', u'_stbx': u'rt3.sas--redir--redir-log:1:167963449:'})
testdata_redir_log.add_row(key="prt://redir@sas1-2631.search.yandex.net/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-09 18:35:45", value={u'ver': u'4875', u'HTTP_REFERER': u'https://yandex.ru/search/?lr=39&clid=2163430&msid=22882.7835.1460214250.85039&text=%D0%BA%D0%B8%D0%BD%D0%BE%D0%B3%D0%BE&suggest_reqid=312576068144429607843208967368320&csg=2123%2C3126%2C4%2C5%2C1%2C0%2C0', u'url': u'//yandex.ru/', u'unixtime': u'1460216145', u'ids': u'23421,23471,23095,23258,22688,23176,23574,23668,23644,23084,10326,23280', u'_stbx': u'rt3.sas--redir--redir-log:10:163782180:', u'path': u'690.781.2033', u'reg': u'39'})
testdata_redir_log.add_row(key="prt://redir@sas1-4857.search.yandex.net/usr/local/www/logs/current-redir-clickdaemon-18101 2016-04-09 11:11:51", value={u'ver': u'4875', u'mc': u'0', u'HTTP_REFERER': u'https://yandex.ru/search/?from=chromesearch&clid=2196598&text=%D0%B0%D0%BB%D0%B8%D1%8D%D0%BA%D1%81%D0%BF%D1%80%D0%B5%D1%81%D1%81&redircnt=1460189502.1', u'cts': u'1460189489412', u'url': u'http://ru.aliexpress.com/', u'unixtime': u'1460189511', u'vars': u'-post=bno,-main=yaca,84=85,-source=web', u'ids': u'23668,23644,23084,10326,23280', u'reqid': u'1460189503336646-5409348811413397083241496-sas1-2711', u'at': u'4', u'path': u'80.22.82', u'keyno': u'0', u'slots': u'23421,0,35;23471,0,75;23095,0,85;23408,0,56;23677,0,44;23176,0,91;23574,0,65;23063,0,97;23668,0,31;23644,0,65;23084,0,64;10326,0,84;23280,0,73', u'reg': u'39', u'_stbx': u'rt3.sas--redir--redir-log:1:167963449:'})

testdata_redir_log.add_row(_date="2016-04-10", key="prt://redir@sas1-3801.search.yandex.net/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-10 10:31:26", value={u'HTTP_REFERER': u'http://www.horseclubs.ru/konyushni-moskvy/?lr=39&clid=2163430&uuid=202e825ff99eb18a6e586260a5635eab', u'cid': u'72717', u'url': u'https://maps.yandex.ru/', u'ip': u'195.16.111.5', u'yandexuid': u'4540183161455570421', u'rnd': u'0.7699978421280393', u'_stbx': u'rt3.fol--redir--redir-log:', u'unixtime': u'1460273486', u'path': u'2_0.326.596'})
testdata_redir_log.add_row(_date="2016-04-10", key="prt://redir@sas1-3801.search.yandex.net/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-10 10:31:26", value={u'HTTP_REFERER': u'http://www.horseclubs.ru/konyushni-moskvy/?lr=39&clid=2163430&uuid=bf62d1b137388c21ddb64090dd02c94c', u'cid': u'72717', u'url': u'https://maps.yandex.ru/', u'ip': u'195.16.111.5', u'yandexuid': u'4540183161455570421', u'rnd': u'0.7699978421280393', u'_stbx': u'rt3.fol--redir--redir-log:', u'unixtime': u'1460273486', u'path': u'2_0.326.596'})
testdata_redir_log.add_row(_date="2016-04-10", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-10 13:35:31", value={u'HTTP_REFERER': u'https://yandex.ru/search/?text=aa&lr=35&uuid=202e825ff99eb18a6e586260a5635eab', u'vars': u'-reqid=1460282091738633-796277-vsearch24-44-ATOMS-distr_serp,-showid=040217301460282091738633796277,-bannerid=pf000208,-score=11490,-product=home,-eventtype=show', u'cid': u'198', u'url': u'data=url', u'ip': u'62.183.125.140', u'yandexuid': u'7368530241456335273', u'pid': u'198', u'rnd': u'1460284525839', u'uah': u'1287692101', u'_stbx': u'rt3.fol--redir--redir-log:', u'unixtime': u'1460284531', u'path': u'tech.portal-ads.promofooter'})
testdata_redir_log.add_row(_date="2016-04-10", key="prt://redir@sas1-3801.search.yandex.net/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-10 10:31:26", value={u'HTTP_REFERER': u'http://www.horseclubs.ru/konyushni-moskvy', u'cid': u'72717', u'url': u'https://maps.yandex.ru/', u'ip': u'195.16.111.5', u'yandexuid': u'4540183161455570421', u'rnd': u'0.7699978421280393', u'_stbx': u'rt3.fol--redir--redir-log:', u'unixtime': u'1460273486', u'path': u'2_0.326.596'})
testdata_redir_log.add_row(_date="2016-04-10", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-10 13:35:31", value={u'HTTP_REFERER': u'https://yandex.ru/search/?text=aalr=35&uuid=13cc284f279bd1702a1adb429ba68298', u'vars': u'-reqid=1460282091738633-796277-vsearch24-44-ATOMS-distr_serp,-showid=040217301460282091738633796277,-bannerid=pf000208,-score=11490,-product=home,-eventtype=show', u'cid': u'198', u'url': u'data=url', u'ip': u'62.183.125.140', u'yandexuid': u'7368530241456335273', u'pid': u'198', u'rnd': u'1460284525839', u'uah': u'1287692101', u'_stbx': u'rt3.fol--redir--redir-log:2:244626296:', u'unixtime': u'1460284531', u'path': u'tech.portal-ads.promofooter'})

testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 11:15:27", value={u'HTTP_REFERER': u'http://yandex.ru/search/touch/?text=bb&clid=2160746&brorich=0&lr=193&uuid=202e825ff99eb18a6e586260a5635eab', u'cid': u'72202', u'unixtime': u'1460362527', u'_stbx': u'rt3.fol--redir--redir-log:15:245540942:', u'ip': u'128.70.8.104', u'path': u'690.1033'})
testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 11:15:27", value={u'HTTP_REFERER': u'http://yandex.ru/search/touch/?text=%D0%BB%D0%BE%D0%B1%D0%B8%D0%BE%20%D0%B8%D0%B7%20%D1%84%D0%B0%D1%81%D0%BE%D0%BB%D0%B8%20%D1%80%D0%B5%D1%86%D0%B5%D0%BF%D1%82%D1%8B%20%D1%81%20%D1%84%D0%BE%D1%82%D0%BE&clid=2160746&brorich=0&lr=193&uuid=bf62d1b137388c21ddb64090dd02c94c', u'cid': u'72202', u'unixtime': u'1460362527', u'_stbx': u'rt3.fol--redir--redir-log:15:245540942:', u'ip': u'128.70.8.104', u'path': u'690.1033'})
testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 23:05:09", value={u'HTTP_REFERER': u'https://yandex.ru/images/touch/search?source=wiz&p=0&text=%D1%82%D0%B0%D1%80%D1%85%D0%B0%D0%BD%D0%BA%D1%83%D1%82%20%D0%BA%D1%80%D1%8B%D0%BC%20%D1%84%D0%BE%D1%82%D0%BE&img_url=http%3A%2F%2Fcs624927.vk.me%2Fv624927980%2F3ab7a%2FgG8Hqf_mWjc.jpg&pos=6&rpt=simage&uuid=202e825ff99eb18a6e586260a5635eab', u'vars': u'143=28.277.584.153.1201,287=193,1042=Mozilla%2F5.0%20(iPhone%3B%20CPU%20iPhone%20OS%209_3_1%20like%20Mac%20OS%20X)%20AppleWebKit%2F601.1.46%20(KHTML%2C%20like%20Gecko)%20YaBrowser%2F16.2.0.6967.10%20Mobile%2F13E238%20Safari%2F601.1,1201.906=612,1201.789=426', u'cid': u'72202', u'ip': u'128.70.8.104', u'serpid': u'oo3kKbKSAqgLW6CzPB-ktA', u'reqid': u'undefined', u'_stbx': u'rt3.fol--redir--redir-log:14:250982586:', u'unixtime': u'1460405109', u'path': u'690.1201'})
testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 11:15:27", value={u'HTTP_REFERER': u'http://yandex.ru/search/touch/?text=%D0%BB%D0%BE%D0%B1%D0%B8%D0%BE%20%D0%B8%D0%B7%20%D1%84%D0%B0%D1%81%D0%BE%D0%BB%D0%B8%20%D1%80%D0%B5%D1%86%D0%B5%D0%BF%D1%82%D1%8B%20%D1%81%20%D1%84%D0%BE%D1%82%D0%BE&clid=2160746&brorich=0&lr=193&uuid=13cc284f279bd1702a1adb429ba68298', u'cid': u'72202', u'unixtime': u'1460362527', u'_stbx': u'rt3.fol--redir--redir-log:15:245540942:', u'ip': u'128.70.8.104', u'path': u'690.1033'})
testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 23:05:09", value={u'HTTP_REFERER': u'https://yandex.ru/images/touch/search?source=wiz&p=0&text=%D1%82%D0%B0%D1%80%D1%85%D0%B0%D0%BD%D0%BA%D1%83%D1%82%20%D0%BA%D1%80%D1%8B%D0%BC%20%D1%84%D0%BE%D1%82%D0%BE&img_url=http%3A%2F%2Fcs624927.vk.me%2Fv624927980%2F3ab7a%2FgG8Hqf_mWjc.jpg&pos=6&rpt=simage&uuid=202e825ff99eb18a6e586260a5635eab', u'vars': u'143=28.277.584.153.1201,287=193,1042=Mozilla%2F5.0%20(iPhone%3B%20CPU%20iPhone%20OS%209_3_1%20like%20Mac%20OS%20X)%20AppleWebKit%2F601.1.46%20(KHTML%2C%20like%20Gecko)%20YaBrowser%2F16.2.0.6967.10%20Mobile%2F13E238%20Safari%2F601.1,1201.906=612,1201.789=426', u'cid': u'72202', u'ip': u'128.70.8.104', u'serpid': u'oo3kKbKSAqgLW6CzPB-ktA', u'reqid': u'undefined', u'_stbx': u'rt3.fol--redir--redir-log:14:250982586:', u'unixtime': u'1460405109', u'path': u'690.1201'})
# test_extract_uuid_from_redirlog
uuid_contain_trash = "111e825ff99eb18a6e586260a5635eab"
uuid_first_pos = "222e825ff99eb18a6e586260a5635eab"
uuid_last_pos = "333e825ff99eb18a6e586260a5635eab"
uuid_mid_pos = "444e825ff99eb18a6e586260a5635eab"
uuid_contains_hyphens = "555e825ff99eb18a6e586260a5635eab"
uuid_bad_len = "6666e825ff99eb18a6e586260a5635eab"
testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 11:15:27", value={u'HTTP_REFERER': u'http://yandex.ru/search/touch/?text=bb&clid=2160746&brorich=0&lr=193&uuid=%22%5C%22%5C%5C%5C%22%5C' + uuid_contain_trash, u'cid': u'72202', u'unixtime': u'1460362527', u'_stbx': u'rt3.fol--redir--redir-log:15:245540942:', u'ip': u'128.70.8.104', u'path': u'690.1033'})
testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 11:15:27", value={u'HTTP_REFERER': u'http://yandex.ru/search/touch/?uuid=' + uuid_first_pos +'&text=bb&clid=2160746&brorich=0&lr=193', u'cid': u'72202', u'unixtime': u'1460362527', u'_stbx': u'rt3.fol--redir--redir-log:15:245540942:', u'ip': u'128.70.8.104', u'path': u'690.1033'})
testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 11:15:27", value={u'HTTP_REFERER': u'http://yandex.ru/search/touch/?text=bb&clid=2160746&brorich=0&lr=193&uuid=' + uuid_last_pos, u'cid': u'72202', u'unixtime': u'1460362527', u'_stbx': u'rt3.fol--redir--redir-log:15:245540942:', u'ip': u'128.70.8.104', u'path': u'690.1033'})
testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 11:15:27", value={u'HTTP_REFERER': u'http://yandex.ru/search/touch/?text=bb&clid=2160746&uuid=' + uuid_mid_pos + '&lr=193', u'cid': u'72202', u'unixtime': u'1460362527', u'_stbx': u'rt3.fol--redir--redir-log:15:245540942:', u'ip': u'128.70.8.104', u'path': u'690.1033'})
testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 11:15:27", value={u'HTTP_REFERER': u'http://yandex.ru/search/touch/?text=bb&clid=2160746&brorich=0&lr=193&uuid=555e825ff-99eb18a6-e586260-a563-5eab', u'cid': u'72202', u'unixtime': u'1460362527', u'_stbx': u'rt3.fol--redir--redir-log:15:245540942:', u'ip': u'128.70.8.104', u'path': u'690.1033'})
testdata_redir_log.add_row(_date="2016-04-11", key="prt://redir@imgs28-111.yandex.ru/usr/local/www/logs/current-redir-clickdaemon-18100 2016-04-11 11:15:27", value={u'HTTP_REFERER': u'http://yandex.ru/search/touch/?text=bb&clid=2160746&brorich=0&lr=193&uuid=' + uuid_bad_len, u'cid': u'72202', u'unixtime': u'1460362527', u'_stbx': u'rt3.fol--redir--redir-log:15:245540942:', u'ip': u'128.70.8.104', u'path': u'690.1033'})

testdata_passport_log = BaseLog(
                path="//statbox/passport-log",
                date="2016-04-09",
                default_data=PASSPORT_LOG
    )
testdata_passport_log.add_row(ip="83.220.236.189", py="1", unixtime="1460220106", source_uri="prt://passport@passport-i3.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="8981408931460006183", _stbx="rt3.fol--passport--passport-log:0:543229519:", referer="http://www.yandex.ru/", iso_eventtime="2016-04-09 19:41:46", type="password", user_agent="Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 625) like iPhone OS 7_0_3 Mac OS X AppleWebKit/537 (KHTML, like Gecko) Mobile Safari/537", action="submitted", input_login="mouradian")
testdata_passport_log.add_row(ip="83.220.236.189", py="1", unixtime="1460220106", source_uri="prt://passport@passport-i3.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="8981408931460006183", _stbx="rt3.fol--passport--passport-log:0:543229519:", referer="http://www.yandex.ru/", iso_eventtime="2016-04-09 19:41:46", type="password", user_agent="Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 625) like iPhone OS 7_0_3 Mac OS X AppleWebKit/537 (KHTML, like Gecko) Mobile Safari/537", action="submitted", input_login="mouradian")
testdata_passport_log.add_row(uid="15033290", ip="83.220.236.189", py="1", unixtime="1460220106", source_uri="prt://passport@passport-i3.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="8981408931460006183", _stbx="rt3.fol--passport--passport-log:0:543229519:", iso_eventtime="2016-04-09 19:41:46", user_agent="Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 625) like iPhone OS 7_0_3 Mac OS X AppleWebKit/537 (KHTML, like Gecko) Mobile Safari/537", action="ufo_profile_checked", input_login="mouradian")
testdata_passport_log.add_row(ip="83.220.236.189", py="1", unixtime="1460220106", source_uri="prt://passport@passport-i3.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="8981408931460006183", _stbx="rt3.fol--passport--passport-log:0:543229519:", referer="http://www.yandex.ru/", iso_eventtime="2016-04-09 19:41:46", type="password", user_agent="Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 625) like iPhone OS 7_0_3 Mac OS X AppleWebKit/537 (KHTML, like Gecko) Mobile Safari/537", action="submitted", input_login="mouradian")
testdata_passport_log.add_row(uid="15033290", ip="83.220.236.189", py="1", unixtime="1460220106", source_uri="prt://passport@passport-i3.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="8981408931460006183", _stbx="rt3.fol--passport--passport-log:0:543229519:", iso_eventtime="2016-04-09 19:41:46", user_agent="Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 625) like iPhone OS 7_0_3 Mac OS X AppleWebKit/537 (KHTML, like Gecko) Mobile Safari/537", action="ufo_profile_checked", input_login="mouradian")
testdata_passport_log.add_row(_date="2016-04-10", ip="94.199.75.12", py="1", unixtime="1460273882", source_uri="prt://passport@passport-m1.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="1622768111453529338", _stbx="rt3.sas--passport--passport-log:0:327527491:", referer="https://www.yandex.ru/", iso_eventtime="2016-04-10 10:38:02", type="password", user_agent="Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.110 Safari/537.36", action="submitted", input_login="stasi1979")
testdata_passport_log.add_row(_date="2016-04-10", ip="94.199.75.12", py="1", unixtime="1460273882", source_uri="prt://passport@passport-m1.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="1622768111453529338", _stbx="rt3.sas--passport--passport-log:0:327527491:", referer="https://www.yandex.ru/", iso_eventtime="2016-04-10 10:38:02", type="password", user_agent="Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.110 Safari/537.36", action="submitted", input_login="stasi1979")
testdata_passport_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 10:38:02", uid="103411294", user_agent="Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.110 Safari/537.36", ip="94.199.75.12", yandexuid="1622768111453529338", py="1", action="ufo_profile_checked", input_login="stasi1979", source_uri="prt://passport@passport-m1.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", unixtime="1460273882", _stbx="rt3.sas--passport--passport-log:0:327527491:")
testdata_passport_log.add_row(_date="2016-04-10", ip="94.199.75.12", py="1", unixtime="1460273882", source_uri="prt://passport@passport-m1.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="1622768111453529338", _stbx="rt3.sas--passport--passport-log:0:327527491:", referer="https://www.yandex.ru/", iso_eventtime="2016-04-10 10:38:02", type="password", user_agent="Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.110 Safari/537.36", action="submitted", input_login="stasi1979")
testdata_passport_log.add_row(_date="2016-04-10", iso_eventtime="2016-04-10 10:38:02", uid="103411294", user_agent="Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.110 Safari/537.36", ip="94.199.75.12", yandexuid="1622768111453529338", py="1", action="ufo_profile_checked", input_login="stasi1979", source_uri="prt://passport@passport-m1.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", unixtime="1460273882", _stbx="rt3.sas--passport--passport-log:0:327527491:")
testdata_passport_log.add_row(_date="2016-04-11", ip="188.16.109.151", py="1", unixtime="1460388396", source_uri="prt://passport@passport-m4.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="7646818301458902093", _stbx="rt3.sas--passport--passport-log:0:328726763:", referer="https://mail.yandex.ru/", iso_eventtime="2016-04-11 18:26:36", type="password", user_agent="Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7596 Yowser/2.5 Safari/537.36", action="submitted", input_login="perschina.olga2012")
testdata_passport_log.add_row(_date="2016-04-11", ip="188.16.109.151", py="1", unixtime="1460388396", source_uri="prt://passport@passport-m4.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="7646818301458902093", _stbx="rt3.sas--passport--passport-log:0:328726763:", referer="https://mail.yandex.ru/", iso_eventtime="2016-04-11 18:26:36", type="password", user_agent="Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7596 Yowser/2.5 Safari/537.36", action="submitted", input_login="perschina.olga2012")
testdata_passport_log.add_row(_date="2016-04-11", uid="115536749", ip="188.16.109.151", py="1", unixtime="1460388396", source_uri="prt://passport@passport-m4.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="7646818301458902093", _stbx="rt3.sas--passport--passport-log:0:328726763:", iso_eventtime="2016-04-11 18:26:36", user_agent="Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7596 Yowser/2.5 Safari/537.36", action="ufo_profile_checked", input_login="perschina.olga2012")
testdata_passport_log.add_row(_date="2016-04-11", ip="188.16.109.151", py="1", unixtime="1460388396", source_uri="prt://passport@passport-m4.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="7646818301458902093", _stbx="rt3.sas--passport--passport-log:0:328726763:", referer="https://mail.yandex.ru/", iso_eventtime="2016-04-11 18:26:36", type="password", user_agent="Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7596 Yowser/2.5 Safari/537.36", action="submitted", input_login="perschina.olga2012")
testdata_passport_log.add_row(_date="2016-04-11", uid="115536749", ip="188.16.109.151", py="1", unixtime="1460388396", source_uri="prt://passport@passport-m4.yandex.net/var/log/yandex/passport-api/statbox/statbox.log", yandexuid="7646818301458902093", _stbx="rt3.sas--passport--passport-log:0:328726763:", iso_eventtime="2016-04-11 18:26:36", user_agent="Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 YaBrowser/16.3.0.7596 Yowser/2.5 Safari/537.36", action="ufo_profile_checked", input_login="perschina.olga2012")


testdata_dicts_yuid_ids = ComplexParametersLog(
                path="//crypta/production/state/graph/dicts",
                table_name="yuid_ids",
                default_data=DICTS_YUID_IDS
    )
testdata_dicts_yuid_ids.add_row(key="9731293591459364411", value={u'i': u'89.169.227.155', u'l': u'test111', u'f': u'7607980141459364414'})
testdata_dicts_yuid_ids.add_row(key="9731293591459364433", value={u'i': u'89.169.227.155', u'l': u'test222', u'f': u'7607980141459364414'})
testdata_dicts_yuid_ids.add_row(key="9731293591459364422", value={u'i': u'109.187.225.69', u'l': u'test111', u'm': u'test1112@mail.ru', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="157564101446629164", value={u'i': u'89.169.227.155', u'm': u'test333@mail.ru', u'f': u'7607980141459364414'})
testdata_dicts_yuid_ids.add_row(key="7065602181459497865", value={u'i': u'109.187.225.69', u'l': u'test222', u'm': u'test555@mail.ru', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="9731293591459364477", value={u'i': u'128.68.157.190,176.15.188.224', u'l': u'alexeylevis', u'f': u'8216267451452920616'})

testdata_dicts_yuid_ids.add_row(key="157564101446625111", value={u'i': u'109.187.225.69', u'l': u'test_login111',  u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="157564101446625112", value={u'i': u'128.68.157.190', u'l': u'test_login111', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="157564101446625113", value={u'i': u'109.187.225.69', u'l': u'test_login113', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="157564101446625114", value={u'i': u'128.68.157.190', u'l': u'test_login114', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="157564101446625121", value={u'i': u'109.187.225.69', u'l': u'test_login115', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="157564101446625122", value={u'i': u'128.68.157.190', u'l': u'test_login115', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="157564101446625123", value={u'i': u'109.187.225.69', u'l': u'test_login116', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="157564101446625124", value={u'i': u'128.68.157.190', u'l': u'test_login116', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="813903801458090754", value={u'i': u'109.187.225.69', u'l': u'test_login117',  u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="2565999051458967148", value={u'i': u'128.68.157.190', u'l': u'test_login117', u'f': u'8216267451452920616'})

testdata_dicts_yuid_ids.add_row(key="9731293591459365211", value={u'i': u'109.187.225.69', u'l': u'test_login211', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365212", value={u'i': u'128.68.157.190', u'l': u'test_login211', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365213", value={u'i': u'109.187.225.69', u'l': u'test_login213', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365214", value={u'i': u'128.68.157.190', u'l': u'test_login214', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365221", value={u'i': u'109.187.225.69', u'l': u'test_login215', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365222", value={u'i': u'128.68.157.190', u'l': u'test_login215', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365223", value={u'i': u'109.187.225.69', u'l': u'test_login216', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365224", value={u'i': u'128.68.157.190', u'l': u'test_login216', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365231", value={u'i': u'109.187.225.69', u'l': u'test_login217', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365232", value={u'i': u'128.68.157.190', u'l': u'test_login217', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365233", value={u'i': u'109.187.225.69', u'l': u'test_login218', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="9731293591459365234", value={u'i': u'128.68.157.190', u'l': u'test_login218', u'f': u'8216267451452920616'})

testdata_dicts_yuid_ids.add_row(key="7065602181459495311", value={u'i': u'109.187.225.69', u'l': u'test_login311', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495312", value={u'i': u'128.68.157.190', u'l': u'test_login311', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495313", value={u'i': u'109.187.225.69', u'l': u'test_login313', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495314", value={u'i': u'128.68.157.190', u'l': u'test_login314', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495321", value={u'i': u'109.187.225.69', u'l': u'test_login315', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495322", value={u'i': u'128.68.157.190', u'l': u'test_login315', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495323", value={u'i': u'109.187.225.69', u'l': u'test_login316', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495324", value={u'i': u'128.68.157.190', u'l': u'test_login316', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495331", value={u'i': u'109.187.225.69', u'l': u'', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495332", value={u'i': u'128.68.157.190', u'l': u'test_login317', u'f': u'8216267451452920616'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495333", value={u'i': u'109.187.225.69', u'l': u'test_login318', u'f': u'11930045191431402882'})
testdata_dicts_yuid_ids.add_row(key="7065602181459495334", value={u'i': u'128.68.157.190', u'l': u'test_login318', u'f': u'8216267451452920616'})

testdata_dicts_yuid_ua = ComplexParametersLog(
                path="//crypta/production/state/graph/dicts",
                table_name="yuid_ua",
                default_data=DICTS_YUID_UA
    )
testdata_dicts_yuid_ua.add_row(key="2565999051458967148", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="157564101446629164", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459497861", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.074077,0.925922', u'adhocs': u'8:1:950000;316:0:68355;124:0:851686;16:1:726562;16:0:273437;409:0:729761;382:1:664062;14:1:652343;14:0:347656;318:0:172573;73:0:277343;73:1:722656;361:0:777049;460:0:506400;445:0:487193;129:0:547087;400:0:872031;444:0:688856;304:0:854843;70:1:835937;435:0:589279;18:1:820312;18:0:179687;434:0:617726;343:0:1000000;23:1:683593;23:0:316406;463:0:857299;430:0:907945;8:0:50000;464:0:934493;161:0:456214;401:0:834108;429:0:231346;396:0:843414;315:0:77743;68:0:50781;68:1:949218;383:1:726562;383:0:273437;146:0:851562;146:1:148437;382:0:335937;314:0:51150;378:0:214722;44:0:164062;44:1:835937;433:0:338327;469:0:907039;126:0:854388;70:0:164062;187:0:418344', u'br': u'chrome', u'income': u'0.022308,0.896629,0.081062', u'br_v': u'51.0.2700', u'ua': DESK_UA, u'age': u'0.777638,0.162609,0.023267,0.025281,0.011203'})
testdata_dicts_yuid_ua.add_row(key="9731293591459364477", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459364411", value={u'ua_profile': u'm|phone|apple|ios|9.3.1', u'sex': u'0.074077,0.925922', u'adhocs': u'8:1:950000;316:0:68355;124:0:851686;16:1:726562;16:0:273437;409:0:729761;382:1:664062;14:1:652343;14:0:347656;318:0:172573;73:0:277343;73:1:722656;361:0:777049;460:0:506400;445:0:487193;129:0:547087;400:0:872031;444:0:688856;304:0:854843;70:1:835937;435:0:589279;18:1:820312;18:0:179687;434:0:617726;343:0:1000000;23:1:683593;23:0:316406;463:0:857299;430:0:907945;8:0:50000;464:0:934493;161:0:456214;401:0:834108;429:0:231346;396:0:843414;315:0:77743;68:0:50781;68:1:949218;383:1:726562;383:0:273437;146:0:851562;146:1:148437;382:0:335937;314:0:51150;378:0:214722;44:0:164062;44:1:835937;433:0:338327;469:0:907039;126:0:854388;70:0:164062;187:0:418344', u'br': u'chrome', u'income': u'0.022308,0.896629,0.081062', u'br_v': u'51.0.2700', u'ua': u'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2700.0 Safari/537.36', u'age': u'0.777638,0.162609,0.023267,0.025281,0.011203'})
testdata_dicts_yuid_ua.add_row(key="7065602181459497865", value={u'ua_profile': u'm|phone|apple|ios|9.3.1', u'sex': u'0.914248,0.085751', u'adhocs': u'160:0:334476;8:1:500000;316:0:21317;73:0:710937;470:0:923666;466:0:681206;421:0:290986;73:1:289062;464:0:847053;400:0:901646;444:0:945486;472:0:961301;266:0:403537;361:0:415474;445:0:705575;134:1:722656;134:0:277343;70:1:300781;116:0:490103;169:0:549689;461:0:344696;102:0:548681;408:0:776825;106:0:432535;460:0:392810;343:0:1000000;397:0:849634;70:0:699218;125:0:875019;398:0:844240;436:0:704609;474:0:925074;184:0:439486;8:0:500000;126:0:861254;223:0:573307;315:0:18632;174:0:504242;71:0:277343;71:1:722656;123:0:886892;146:0:707031;146:1:292968;382:0:101562;382:1:898437;454:0:586282;378:0:342793;17:0:167968;17:1:832031;13:0:679687;13:1:320312;263:0:418282', u'br': u'mobilesafari', u'income': u'0.003329,0.082645,0.914025', u'br_v': u'9.0', u'ua': u'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13E238 Safari/601.1', u'age': u'0.01176,0.10573,0.603281,0.232648,0.046578'})
testdata_dicts_yuid_ua.add_row(key="9731293591459364412", value={u'ua_profile': u'm|phone|apple|ios|9.3.1', u'sex': u'0.074077,0.925922', u'adhocs': u'8:1:950000;316:0:68355;124:0:851686;16:1:726562;16:0:273437;409:0:729761;382:1:664062;14:1:652343;14:0:347656;318:0:172573;73:0:277343;73:1:722656;361:0:777049;460:0:506400;445:0:487193;129:0:547087;400:0:872031;444:0:688856;304:0:854843;70:1:835937;435:0:589279;18:1:820312;18:0:179687;434:0:617726;343:0:1000000;23:1:683593;23:0:316406;463:0:857299;430:0:907945;8:0:50000;464:0:934493;161:0:456214;401:0:834108;429:0:231346;396:0:843414;315:0:77743;68:0:50781;68:1:949218;383:1:726562;383:0:273437;146:0:851562;146:1:148437;382:0:335937;314:0:51150;378:0:214722;44:0:164062;44:1:835937;433:0:338327;469:0:907039;126:0:854388;70:0:164062;187:0:418344', u'br': u'chrome', u'income': u'0.022308,0.896629,0.081062', u'br_v': u'51.0.2700', u'ua': u'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2700.0 Safari/537.36', u'age': u'0.777638,0.162609,0.023267,0.025281,0.011203'})
testdata_dicts_yuid_ua.add_row(key="9731293591459364422", value={u'ua_profile': u'm|phone|apple|ios|9.3.1', u'sex': u'0.914248,0.085751', u'adhocs': u'160:0:334476;8:1:500000;316:0:21317;73:0:710937;470:0:923666;466:0:681206;421:0:290986;73:1:289062;464:0:847053;400:0:901646;444:0:945486;472:0:961301;266:0:403537;361:0:415474;445:0:705575;134:1:722656;134:0:277343;70:1:300781;116:0:490103;169:0:549689;461:0:344696;102:0:548681;408:0:776825;106:0:432535;460:0:392810;343:0:1000000;397:0:849634;70:0:699218;125:0:875019;398:0:844240;436:0:704609;474:0:925074;184:0:439486;8:0:500000;126:0:861254;223:0:573307;315:0:18632;174:0:504242;71:0:277343;71:1:722656;123:0:886892;146:0:707031;146:1:292968;382:0:101562;382:1:898437;454:0:586282;378:0:342793;17:0:167968;17:1:832031;13:0:679687;13:1:320312;263:0:418282', u'br': u'mobilesafari', u'income': u'0.003329,0.082645,0.914025', u'br_v': u'9.0', u'ua': u'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13E238 Safari/601.1', u'age': u'0.01176,0.10573,0.603281,0.232648,0.046578'})
testdata_dicts_yuid_ua.add_row(key="9731293591459364433", value={u'ua_profile': u'm|phone|apple|ios|9.3.1', u'sex': u'0.914248,0.085751', u'adhocs': u'160:0:334476;8:1:500000;316:0:21317;73:0:710937;470:0:923666;466:0:681206;421:0:290986;73:1:289062;464:0:847053;400:0:901646;444:0:945486;472:0:961301;266:0:403537;361:0:415474;445:0:705575;134:1:722656;134:0:277343;70:1:300781;116:0:490103;169:0:549689;461:0:344696;102:0:548681;408:0:776825;106:0:432535;460:0:392810;343:0:1000000;397:0:849634;70:0:699218;125:0:875019;398:0:844240;436:0:704609;474:0:925074;184:0:439486;8:0:500000;126:0:861254;223:0:573307;315:0:18632;174:0:504242;71:0:277343;71:1:722656;123:0:886892;146:0:707031;146:1:292968;382:0:101562;382:1:898437;454:0:586282;378:0:342793;17:0:167968;17:1:832031;13:0:679687;13:1:320312;263:0:418282', u'br': u'mobilesafari', u'income': u'0.003329,0.082645,0.914025', u'br_v': u'9.0', u'ua': u'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13E238 Safari/601.1', u'age': u'0.01176,0.10573,0.603281,0.232648,0.046578'})

testdata_dicts_yuid_ua.add_row(key="1813903801458090754", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="213261281388846262", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="2263475241459074652", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})

testdata_dicts_yuid_ua.add_row(key="157564101446625111", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="157564101446625112", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="157564101446625113", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="157564101446625114", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="157564101446625121", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="157564101446625122", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="157564101446625123", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="157564101446625124", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})

testdata_dicts_yuid_ua.add_row(key="9731293591459365211", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365212", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365213", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365214", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365221", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365222", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365223", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365224", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365231", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365232", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365233", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="9731293591459365234", value={u'ua_profile': u'd|desk|windows|6.1', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'chrome', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': DESK_UA, u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})

testdata_dicts_yuid_ua.add_row(key="7065602181459495311", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495312", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495313", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495314", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495321", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495322", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495323", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495324", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495331", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495332", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495333", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})
testdata_dicts_yuid_ua.add_row(key="7065602181459495334", value={u'ua_profile': u'm|phone|samsung|android|4.1.2', u'sex': u'0.106432,0.893567', u'adhocs': u'8:1:500000;316:0:7505;168:0:335486;16:1:515625;16:0:484375;468:0:587815;467:0:958694;14:1:789062;14:0:210937;73:0:335937;73:1:664062;361:0:430685;210:0:353802;272:0:342085;397:0:862670;57:0:140625;57:1:859375;97:0:402656;435:0:526954;434:0:512537;343:0:1000000;111:0:293178;377:0:603018;371:0:175781;371:1:824218;141:1:960937;141:0:39062;8:0:500000;396:0:838881;68:0:242187;68:1:757812', u'br': u'androidbrowser', u'income': u'0.043516,0.914052,0.04243', u'br_v': u'4.1.2', u'ua': u'Mozilla/5.0 (Linux; U; Android 4.1.2; ru-ru; GT-N7000 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', u'age': u'0.093118,0.376148,0.3363,0.151685,0.042746'})


testdata_household_merged_households = BaseLog(
                path="//crypta/production/state/household",
                table_name="merged_households",
                default_data=HOUSEHOLD_MERGED_HOUSEHOLDS
    )
testdata_household_merged_households.add_row(key="1122566111", value="ym/9731293591459364411,ym/9731293591459364422")
testdata_household_merged_households.add_row(key="1122566112", value="ym/9731293591459364433,ym/7065602181459497865")
testdata_household_merged_households.add_row(key="1122566113", value="yd/7065602181459497861,ym/1624325621409573511")
testdata_household_merged_households.add_row(key="1122566114", value="yd/157564101446629161,yd/9731293591459364478,dm/6018BFA08DE41625E33C7FAFDCB13D4")
testdata_household_merged_households.add_row(key="1122566175", value="ym/9731293591459364477,yd/1284646051426666010,ym/1059214651454439421,dm/BE15F790-6B71-44F3-BD34-1EDDDB303103,yd/176838781459082658,ym/2400835231433351768,ym/4684846461349977273,yd/1052238523436679138,yd/336944681450277976")
testdata_household_merged_households.add_row(key="1122566175", value="ym/9731293591459364479,ym/413736041459401858,yd/1284646051426666010,ym/1059214651454439421,dm/BE15F790-6B71-44F3-BD34-1EDDDB303103,yd/176838781459082658,ym/2400835231433351768,ym/4684846461349977273,yd/1052238523436679138,yd/336944681450277976")
testdata_household_merged_households.add_row(key="1492844890", value="yd/1813903801458090754,ym/2565999051458967148,yd/1624325621409573523,yd/46719801416206521,yd/4654751811441543054,yd/1069844061442843407,yd/411039871458447981,yd/2150076501458361191,yd/1133725261459156746,yd/9400783831460195712,yd/2451605981458126722,yd/1584083131373517084,yd/271284541460176822,yd/9400783833460195712,yd/8095194071460195381,yd/1437384301388999287,yd/9572982351351253149")
testdata_household_merged_households.add_row(key="1122566175", value="yd/8161377521458796309,yd/157564101446629161,dm/6018BFA08DE41625E33C7FAFDCB13D4,ym/413736041459401858,yd/1284646051426666010,ym/1059214651454439421,dm/BE15F790-6B71-44F3-BD34-1EDDDB303103,yd/176838781459082658,ym/2400835231433351768,ym/4684846461349977273,yd/1052238523436679138,yd/336944681450277976")
testdata_household_merged_households.add_row(key="1492844890", value="yd/8161377521458796309,yd/157564101446629161,yd/1624325621409573523,yd/46719801416206521,yd/4654751811441543054,yd/1069844061442843407,yd/411039871458447981,yd/2150076501458361191,yd/1133725261459156746,yd/9400783831460195712,yd/2451605981458126722,yd/1584083131373517084,yd/271284541460176822,yd/9400783833460195712,yd/8095194071460195381,yd/1437384301388999287,yd/9572982351351253149")
testdata_household_merged_households.add_row(key="1055981839", value="ym/1065670901458295050,yd/5230499701379279449,ym/9027880101457534938,yd/1341221443378928243,dm/BE15F790-6B71-44F3-BD34-1EDDDB303103,yd/176838781459082658,ym/2400835231433351768,ym/4684846461349977273,yd/1052238523436679138,yd/336944681450277976")
testdata_household_merged_households.add_row(key="1492844890", value="ym/157564101446629162,yd/157564101446629161,yd/157564101446629161,yd/46719801416206521,yd/4654751811441543054,yd/1069844061442843407,yd/411039871458447981,yd/2150076501458361191,yd/1133725261459156746,yd/9400783831460195712,yd/2451605981458126722,yd/1584083131373517084,yd/271284541460176822,yd/9400783833460195712,yd/8095194071460195381,yd/1437384301388999287,yd/9572982351351253149")
testdata_household_merged_households.add_row(key="1122566175", value="ym/2263475241459074652,ym/413736041459401858,yd/1284646051426666010,ym/1059214651454439421,dm/BE15F790-6B71-44F3-BD34-1EDDDB303103,yd/176838781459082658,ym/2400835231433351768,ym/4684846461349977273,yd/1052238523436679138,yd/336944681450277976")
testdata_household_merged_households.add_row(key="1492844890", value="ym/157564101446629161,yd/157564101446629161,yd/157564101446629161,yd/46719801416206521,yd/4654751811441543054,yd/1069844061442843407,yd/411039871458447981,yd/2150076501458361191,yd/1133725261459156746,yd/9400783831460195712,yd/2451605981458126722,yd/1584083131373517084,yd/271284541460176822,yd/9400783833460195712,yd/8095194071460195381,yd/1437384301388999287,yd/9572982351351253149")
testdata_household_merged_households.add_row(key="1055981839", value="ym/1065670901458295050,yd/157564101446629161,ym/9027880101457534938,yd/1341221443378928243")
testdata_household_merged_households.add_row(key="1011941618", value="yd/157564101446629164,yd/8161377521458796309,yd/3502223981400067010,dm/6018BFA08DE41625E33C7FAFDCB13D4,yd/213261281388846262,ym/908875601455205215")
testdata_household_merged_households.add_row(key="1122566175", value="ym/157564101446629161,ym/413736041459401858,yd/1284646051426666010,ym/1059214651454439421,dm/BE15F790-6B71-44F3-BD34-1EDDDB303103,yd/176838781459082658,ym/2400835231433351768,ym/4684846461349977273,yd/1052238523436679138,yd/336944681450277976")

testdata_household_merged_households.add_row(key="1122577111", value="ym/157564101446625111,yd/157564101446625112")
testdata_household_merged_households.add_row(key="1122577112", value="ym/157564101446625113,yd/157564101446625114")
testdata_household_merged_households.add_row(key="1122577113", value="ym/157564101446625121,yd/157564101446625122")
testdata_household_merged_households.add_row(key="1122577114", value="ym/157564101446625123,yd/157564101446625124")

testdata_household_merged_households.add_row(key="1122577121", value="yd/9731293591459365211,yd/9731293591459365212")
testdata_household_merged_households.add_row(key="1122577122", value="yd/9731293591459365213,yd/9731293591459365214")
testdata_household_merged_households.add_row(key="1122577123", value="yd/9731293591459365221,yd/9731293591459365222")
testdata_household_merged_households.add_row(key="1122577124", value="yd/9731293591459365223,yd/9731293591459365224")
testdata_household_merged_households.add_row(key="1122577125", value="yd/9731293591459365231,yd/9731293591459365232")
testdata_household_merged_households.add_row(key="1122577126", value="yd/9731293591459365233,yd/9731293591459365234")

testdata_household_merged_households.add_row(key="1122577131", value="ym/7065602181459495311,ym/7065602181459495312")
testdata_household_merged_households.add_row(key="1122577132", value="ym/7065602181459495313,ym/7065602181459495314")
testdata_household_merged_households.add_row(key="1122577133", value="ym/7065602181459495321,ym/7065602181459495322")
testdata_household_merged_households.add_row(key="1122577134", value="ym/7065602181459495323,ym/7065602181459495324")
testdata_household_merged_households.add_row(key="1122577135", value="ym/7065602181459495331,ym/7065602181459495332")
testdata_household_merged_households.add_row(key="1122577136", value="ym/7065602181459495333,ym/7065602181459495334")

#for generate yuids_ids and yuids_ua
testdata_household_merged_households.add_row(key="1122568111", value="yd/1006747921438342717,ym/1000011459458000")
testdata_household_merged_households.add_row(key="1122568112", value="yd/1027173811424201060,ym/1004486441423498853")
testdata_household_merged_households.add_row(key="1122568113", value="yd/1027942781393036285,yd/1040008181447317612")
testdata_household_merged_households.add_row(key="1122568111", value="yd/1048474861449736422,yd/104970061434698726")
testdata_household_merged_households.add_row(key="1122568112", value="ym/1006790761458574232,ym/1011951401456928710")
testdata_household_merged_households.add_row(key="1122568113", value="ym/1013160111418932345,ym/1015116171458320548")


testdata_webvisor_stream_alive = ComplexParametersLog(
                path="//crypta/production/storage",
                table_name="stream_alive",
                default_data=WEBVISOR_STREAM_ALIVE
    )
testdata_webvisor_stream_alive.add_row(key="9731293591459364411", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459364422", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459364433", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459364477", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459364478", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459364479", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="157564101446629162", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="157564101446629164", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1813903801458090754", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="213261281388846262", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="2263475241459074652", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="2565999051458967148", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="3502223981400067010", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="5230499701379279449", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459497865", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="908875601455205215", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})

testdata_webvisor_stream_alive.add_row(key="157564101446625111", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="157564101446625112", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="157564101446625113", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="157564101446625114", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="157564101446625121", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="157564101446625122", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="157564101446625123", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="157564101446625124", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})

testdata_webvisor_stream_alive.add_row(key="9731293591459365211", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365212", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365213", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365214", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365221", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365222", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365223", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365224", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365231", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365232", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365233", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="9731293591459365234", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})

testdata_webvisor_stream_alive.add_row(key="7065602181459495311", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495312", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495313", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495314", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495321", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495322", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495323", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495324", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495331", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495332", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495333", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="7065602181459495334", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})


#for generate yuids_ids and yuids_ua
testdata_webvisor_stream_alive.add_row(key="1006747921438342717", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1000011459458000", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1027173811424201060", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1004486441423498853", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1027942781393036285", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1040008181447317612", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1048474861449736422", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="104970061434698726", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1006790761458574232", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1011951401456928710", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1013160111418932345", subkey="1459713932", value={u'mm_hits': u'1459497872:1399806976,1459497881:1388788224', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})
testdata_webvisor_stream_alive.add_row(key="1015116171458320548", subkey="1459713932", value={u'mm_hits': u'1459364412:1399806976,1459364492:1262482958', u'words_count': u'124911360:1,197569792:1,254880512:7', u'mm_count': u'742964226:3,1737924864:1', u'offset': u'4'})


testdata_bs_chevent_log = BaseLog(
                path="//statbox/bs-chevent-log",
                date="2016-04-11",
                default_data=BS_CHEVENT_LOG
    )
testdata_bs_chevent_log.add_row(yuid="11466630289", cryptaid="935164445413735719", clientip6="::ffff:91.122.119.89", clientip="91.122.119.89")
testdata_bs_chevent_log.add_row(_date="2016-04-10", yuid="11466630289", cryptaid="935164445413735719", clientip6="::ffff:91.122.119.89", clientip="91.122.119.89")
testdata_bs_chevent_log.add_row(_date="2016-04-09", yuid="11466630289", cryptaid="935164445413735719", clientip6="::ffff:91.122.119.89", clientip="91.122.119.89")
testdata_bs_chevent_log.add_row(_date="2016-04-08", yuid="11466630289", cryptaid="935164445413735719", clientip6="::ffff:91.122.119.89", clientip="91.122.119.89")
testdata_bs_chevent_log.add_row(_date="2016-04-07", yuid="11466630289", cryptaid="935164445413735719", clientip6="::ffff:91.122.119.89", clientip="91.122.119.89")
testdata_bs_chevent_log.add_row(_date="2016-04-06", yuid="11466630289", cryptaid="935164445413735719", clientip6="::ffff:91.122.119.89", clientip="91.122.119.89")
testdata_bs_chevent_log.add_row(_date="2016-04-05", yuid="11466630289", cryptaid="935164445413735719", clientip6="::ffff:91.122.119.89", clientip="91.122.119.89")


testdata_devid_hash = BaseLog(
                path="//crypta/production/state/graph/dicts",
                table_name="devid_hash",
                default_data={}
    )
#access
testdata_devid_hash.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae1", devidhash="4451492610968249451", mmetric_devid="53b84e78dbf8e7aa77ac092137057bc1")
testdata_devid_hash.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae2", devidhash="4451492610968249452", mmetric_devid="53b84e78dbf8e7aa77ac092137057bc2")
testdata_devid_hash.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae3", devidhash="4451492610968249453", mmetric_devid="53b84e78dbf8e7aa77ac092137057bc3")
testdata_devid_hash.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae4", devidhash="4451492610968249454", mmetric_devid="53b84e78dbf8e7aa77ac092137057bc4")

#watch
testdata_devid_hash.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae5", devidhash="4451492610968249451", mmetric_devid="886f3cd0a0fa93a19f9d35362dcc111d")
testdata_devid_hash.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae6", devidhash="4451492610968249452", mmetric_devid="886f3cd0a0fa93a19f9d35362dcc222d")
testdata_devid_hash.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae7", devidhash="4451492610968249453", mmetric_devid="886f3cd0a0fa93a19f9d35362dcc333d")
testdata_devid_hash.add_row(devid="11b22432-0112-4234-a353-c3e98c8baae8", devidhash="4451492610968249454", mmetric_devid="886f3cd0a0fa93a19f9d35362dcc444d")



testdata_idserv_access_log = BaseLog(
    path='//home/logfeller/logs/crypta-id-access-log/1d',
    date="2016-04-11",
    default_data=IDSERV_ACCESS_LOG
)

testdata_idserv_access_log.add_row(query="/identify?@client=aaaa&unknownid=Frank&yandexuid=22222222221459365211&gaid=fake-google-adv-id")
testdata_idserv_access_log.add_row(query="/identify?@client=aaaa&unknownid=Frank&yandexuid=22222222221459365211&idfa=fake-idfa&mm_device_id=mmdevid&@match_online=true")
testdata_idserv_access_log.add_row(query="/identify?yandexuid=1111111111459365211")

BLACK_LIST_KEYS = ["222564101446625991_222564101446625992",
                   "222564101446625993_222564101446625994",
                   "222564101446625995_222564101446625996"
                   "222564101446625003_222564101446625904"]
testdata_pairs_black_list = BaseLog(
                path="//crypta/production/state/graph/dicts",
                table_name="pairs_black_list",
                default_data={}
    )
for key in BLACK_LIST_KEYS:
    testdata_pairs_black_list.add_row(key=key, pair_type="black_list", st_number="NAPRIMER-1")


testdata_email_org_classification = BaseLog(
                path="//crypta/production/ids_storage/email",
                table_name="email_org_classification",
                default_data={}
    )
testdata_email_org_classification.add_row(id_value="new_email@bbb.ru", id_type="email", is_org_score="0.9285015642642975")
testdata_email_org_classification.add_row(id_value="bars12@161.ru", id_type="email", is_org_score="0.81015642642975")
testdata_email_org_classification.add_row(id_value="new_email@yandex.ru", id_type="email", is_org_score="0.3785015642642975")
testdata_email_org_classification.add_row(id_value="this_email_no_in_yuid_id@testdomain.ru", id_type="email", is_org_score="0.3785015642642975")


testdata_bs_xuniqs_log = BaseLog(
    path='//home/logfeller/logs/bs-xuniqs-log/1d',
    date='2016-04-11',
    default_data={}
)

testdata_bs_xuniqs_log.add_row(pagekeywordid='154', unixtime='1512596671', xuniqid='fakemailruguid', uniqid='8156730781512180560')
testdata_bs_xuniqs_log.add_row(pagekeywordid='39', unixtime='1512596671', xuniqid='4444441444444444', uniqid='8156730781512180560')
testdata_bs_xuniqs_log.add_row(pagekeywordid='245', unixtime='1512596671', xuniqid='23a05dbc2e9da8a0958f796c28a2519c', uniqid='8156730781512180560')
testdata_bs_xuniqs_log.add_row(pagekeywordid='302', unixtime='1512596671', xuniqid='8156730780512180560', uniqid='8156730781512180560')
testdata_bs_xuniqs_log.add_row(pagekeywordid='0', unixtime='1512596671', xuniqid='whatever', uniqid='8156730781512180560')
testdata_bs_xuniqs_log.add_row(pagekeywordid='39', unixtime='1512596671', xuniqid='8156730781512180560', uniqid='8156730781512180560')
testdata_bs_xuniqs_log.add_row(pagekeywordid='nan', unixtime='1512596671', xuniqid='13804403613570866227', uniqid='8156730781512180560')
testdata_bs_xuniqs_log.add_row(pagekeywordid='39', unixtime='1512596671', xuniqid='4444440444444444', uniqid='8156730781512180560')
testdata_bs_xuniqs_log.add_row(pagekeywordid='39', unixtime='1512596671', xuniqid='13804403613570866227', uniqid='8156730781512180560')
testdata_bs_xuniqs_log.add_row(pagekeywordid='39', unixtime='1512596671', xuniqid='8156730781512180560', uniqid='8156730780512180560')


valid_watchlog_yuid1 = testdata_watch_log.rows['//statbox/bs-watch-log/2016-04-11'][0]['uniqid']
valid_watchlog_yuid2 = testdata_watch_log.rows['//statbox/bs-watch-log/2016-04-11'][1]['uniqid']
testdata_toloka_indevice_desktop = BaseLog(
    path='//crypta/production/state/toloka/indevice_desktop',
    table_name='2016-04-11-splices',
    default_data={}
)
testdata_toloka_indevice_desktop.add_row(assignment_id="d2ff8f07-9b32-4ec9-a678-2baf8929e6fc", yuid=valid_watchlog_yuid1, user_id="293f56b76028f0f8a304df7aaf01693d", user_agent="Mozilla/5.0 (Linux; Android 7.0; SM-A720F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.111 Mobile Safari/537.36", created="2017-12-19T15:22:40.848")
testdata_toloka_indevice_desktop.add_row(assignment_id="d2ff8f07-9b32-4ec9-a678-2baf8929e6fc", yuid=valid_watchlog_yuid2, user_id="293f56b76028f0f8a304df7aaf01693d", user_agent="Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-A720F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/6.2 Chrome/56.0.2924.87 Mobile Safari/537.36", created="2017-12-19T15:22:40.848")

testdata_toloka_indevice_mobile = BaseLog(
    path='//crypta/production/state/toloka/indevice_mobile',
    table_name='2016-04-11-splices',
    default_data={}
)
testdata_toloka_indevice_mobile.add_row(assignment_id="d2ff8f07-9b32-4ec9-a678-2baf8929e6fc", yuid=valid_watchlog_yuid1, user_id="293f56b76028f0f8a304df7aaf01693d", user_agent="Mozilla/5.0 (Linux; Android 7.0; SM-A720F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.111 Mobile Safari/537.36", created="2017-12-19T15:22:40.848")
testdata_toloka_indevice_mobile.add_row(assignment_id="d2ff8f07-9b32-4ec9-a678-2baf8929e6fc", yuid=valid_watchlog_yuid2, user_id="293f56b76028f0f8a304df7aaf01693d", user_agent="Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-A720F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/6.2 Chrome/56.0.2924.87 Mobile Safari/537.36", created="2017-12-19T15:22:40.848")

testdata_toloka_crossdevice = BaseLog(
    path='//crypta/production/state/toloka/cross_device',
    table_name='2016-04-11-splices',
    default_data={}
)
testdata_toloka_crossdevice.add_row(assignment_id="d2ff8f07-9b32-4ec9-a678-2baf8929e6fc", yuid=valid_watchlog_yuid1, user_id="293f56b76028f0f8a304df7aaf01693d", user_agent="Mozilla/5.0 (Linux; Android 7.0; SM-A720F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.111 Mobile Safari/537.36", created="2017-12-19T15:22:40.848")
testdata_toloka_crossdevice.add_row(assignment_id="d2ff8f07-9b32-4ec9-a678-2baf8929e6fc", yuid=valid_watchlog_yuid2, user_id="293f56b76028f0f8a304df7aaf01693d", user_agent="Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-A720F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/6.2 Chrome/56.0.2924.87 Mobile Safari/537.36", created="2017-12-19T15:22:40.848")


testdata_toloka_households = BaseLog(
    path='//crypta/production/state/toloka/household',
    table_name='2016-04-11-households',
    default_data={}
)
testdata_toloka_households.add_row(assignment_id="bb0b4942-c3c2-450f-9c32-75166e8b7f40",
                                   personal=[
                                       [601826891455541113],
                                       [6249554188804536022]
                                   ],
                                   shared=[601826891455541113])
testdata_toloka_households.add_row(assignment_id="this doesn't matter much",
                                   personal=[
                                       [6080124334883973097]
                                   ],
                                   shared=[601826891455541114])


testdata_vertices_20 = BaseLog(
    path='//crypta/production/state/graph/v2/matching',
    table_name='vertices_no_multi_profile',
    default_data={}
)
testdata_vertices_20.add_row(id="601826891455541113",
                             id_type="yandexuid",
                             cryptaId="1(YANDEXUID)")
testdata_vertices_20.add_row(id="6249554188804536022",
                             id_type="yandexuid",
                             cryptaId="1(YANDEXUID)")
testdata_vertices_20.add_row(id="6080124334883973097",
                             id_type="yandexuid",
                             cryptaId="2(YANDEXUID)")
testdata_vertices_20.add_row(id="601826891455541114",
                             id_type="yandexuid",
                             cryptaId="3(YANDEXUID)")

testdata_avito_phone_rainbow = BaseLog(
    path='//crypta/production/state/graph/dicts',
    table_name='avito-phone-rainbow',
    default_data={}
)
testdata_avito_phone_rainbow.add_row(
    avito_hash='avito_hash1',
    phone='79087654321'
)

testdata_lf_bs_rtb = BaseLog(
    path='//home/logfeller/logs/bs-rtb-log/1d',
    table_name='2016-04-11',
    default_data={}
)
testdata_lf_bs_rtb.add_row(
    uniqid='5555551400000000',
    queryargs='245=11111111111111111111111111111111&726=avito_hash0',
    pageid='280196'
)
testdata_lf_bs_rtb.add_row(
    uniqid='5555551400000001',
    queryargs='245=22222222222222222222222222222222&727=avito_hash1',
    pageid='280196'
)
testdata_lf_bs_rtb.add_row(
    uniqid='5555551400000002',
    queryargs='245=33333333333333333333333333333333&727=avito_hash2',
    pageid='280196'
)
testdata_lf_bs_rtb.add_row(
    uniqid='5555551400000003',
    queryargs='727=avito_hash2',
    pageid='280196'
)
testdata_lf_bs_rtb.add_row(
    uniqid='5555551400000004',
    queryargs='727=avito_hash4',
    pageid='not_avito_pageid'
)


testdata_lf_bs_hit = BaseLog(
    path='//home/logfeller/logs/bs-hit-log/1d',
    table_name='2016-04-11',
    default_data={}
)
testdata_lf_bs_hit.add_row(
    uniqid='5555551400000005',
    queryargs='726=avito_hash5',
    pageid='279179'
)
testdata_lf_bs_hit.add_row(
    uniqid='5555551400000006',
    queryargs='726=' +
              hashlib.md5('testings_for_work2@mail.rufy5drs34dgh13ff').hexdigest(),  # email taken from webvisor above
    pageid='279179'
)
testdata_lf_bs_hit.add_row(
    uniqid='5555551400000007',
    queryargs='726=avito_hash1',
    pageid='279179'
)
testdata_lf_bs_hit.add_row(
    uniqid='5555551400000008',
    queryargs='726=' + hashlib.md5('login.for.avito@yandex.comfy5drs34dgh13ff').hexdigest(),
    pageid='279179'
)


partners_phone_hashes_to_find = []
partners_email_hashes_to_find = []
partners_emails_to_find = []
partners_phones_to_find = []

current_yuid_idx_added = 0
current_auto_external_id = 0


def add_yuid_with_all_row(id_type, id_value, id_value_orig=None):
    global current_yuid_idx_added
    yuid = "1195164201443702{}".format(str(current_yuid_idx_added).rjust(3, '8'))
    row_to_add = {
        "good": True,
        "yuid": yuid,
        "key": yuid,
        "yandexuid": int(yuid),
        "sources": [
            # this is quazi-sources for emails/phones not from partners
            'yamoney' if id_type == 'phone' else 'webvisor'
        ],
        id_type + "_dates": {
            id_value: {
                TEST_RUN_DATE_STR: 1
            }
        },
        id_type + "_orig": {
            id_value: id_value_orig
        },
        id_type + "_sources": {
            id_value: [
                # this is quazi-sources for emails/phones not from partners
                'yamoney' if id_type == 'phone' else 'webvisor'
            ]
        },
        "yuid_creation_date": [
            SOME_PREV_DATE
        ],
        "all_ip_dates": [
            TEST_RUN_DATE_STR
        ],
        "all_id_dates": [
            TEST_RUN_DATE_STR
        ],
        "all_dates": [
            TEST_RUN_DATE_STR
        ]
    }
    testdata_yuid_with_all.add_row(**row_to_add)
    current_yuid_idx_added += 1
    print "Adding to yuid_with_all:", row_to_add


# Iterate partners dump data (@d-sun-d dicts format)
# https://github.yandex-team.ru/x-products/xprod-partners-data/blob/master/partners_data/audience.py#L105
# https://wiki.yandex-team.ru/x-products/RealTimeTriggers/Arxitektura/API/audience/?from=%252Fx-products%252FRealTimeTriggers%252FArxitektura%252FAPI%252Fauditiry%252F

found_data = []

with open(os.path.join(dir_path, PARTNERS_AUDIENCE_FIXTURES_PATH)) as f:
    partners_audience_fixture = json.load(f)

for table_name, table_data in sorted(partners_audience_fixture.iteritems()):
    white_email_processor = white.WhiteEmail('email')
    white_phone_processor = white.WhitePhone('phone')
    partner_table = SingleTableLog(
        path=table_name,
        default_data={},
        append=True
    )
    for rec in table_data:
        partner_table.add_row(**rec)
        print "Adding to {}:".format(table_name), rec
        found_email_hashes = {}
        found_phone_hashes = {}
        for rec_email in rec.get("emails", []):
            if 'email' in rec_email:
                white_email = white_email_processor.process(rec_email['email'])
                found_email_hashes[white_email['email_hash']] = rec_email['email']
            elif 'id_value' in rec_email:
                found_email_hashes[rec_email['id_value']] = rec_email.get('email')

        for rec_phone in rec.get("phones", []):
            if 'phone' in rec_phone:
                white_phone = white_phone_processor.process(rec_phone['phone'])
                found_phone_hashes[white_phone['phone_hash']] = rec_phone['phone']
            elif 'id_value' in rec_phone:
                found_phone_hashes[rec_phone['id_value']] = rec_phone.get('phone')

        found_data.append({
            "email_hashes": found_email_hashes,
            "phone_hashes": found_phone_hashes
        })


with open(os.path.join(dir_path, PARTNERS_FLAT_FIXTURES_PATH)) as f:
    partners_flat_fixture = json.load(f)

for table_idx, (table_name, table_data) in enumerate(sorted(partners_flat_fixture.iteritems())):
    white_email_processor = white.WhiteEmail('email')
    white_phone_processor = white.WhitePhone('phone')
    external_ids = []
    found_email_hashes_by_external_id = collections.defaultdict(dict)
    found_phone_hashes_by_external_id = collections.defaultdict(dict)
    partner_table = SingleTableLog(
        path=table_name,
        default_data={},
        append=True
    )
    for rec_idx, rec in enumerate(table_data):
        print "Adding to {}:".format(table_name), rec
        partner_table.add_row(**rec)
        external_id = rec.get("external_id")
        if external_id is None:
            external_id = "42_{}_42_{}".format(table_idx, rec_idx)
        external_ids.append(external_id)
        for email in (list(rec.get("emails", [])) + ([rec["email"]] if rec.get("email") else [])):
            white_email = white_email_processor.process(email)
            found_email_hashes_by_external_id[external_id][white_email['email_hash']] = white_email['email_orig']
        for phone in (list(rec.get("phones", [])) + ([rec["phone"]] if rec.get("phone") else [])):
            white_phone = white_phone_processor.process(phone)
            found_phone_hashes_by_external_id[external_id][white_phone['phone_hash']] = white_phone['phone_orig']

    for external_id in external_ids:
        found_data.append({
            "email_hashes": found_email_hashes_by_external_id.get(external_id, {}),
            "phone_hashes": found_phone_hashes_by_external_id.get(external_id, {})
        })

# Add some hook ids to yuid_with_all
for idx, rec in enumerate(found_data):
    found_email_hashes = rec['email_hashes']
    found_phone_hashes = rec['phone_hashes']

    if (not len(found_email_hashes)) and (not len(found_phone_hashes)):
        continue

    if len(found_phone_hashes) and (not len(found_email_hashes)):
        hook_hash = sorted(found_phone_hashes.keys())[0]
        hook_value_orig = found_phone_hashes[hook_hash]
        add_yuid_with_all_row(id_type='phone', id_value=hook_hash, id_value_orig=hook_value_orig)
    elif len(found_email_hashes) and (not len(found_phone_hashes)):
        hook_hash = sorted(found_email_hashes.keys())[0]
        hook_value_orig = found_email_hashes[hook_hash]
        add_yuid_with_all_row(id_type='email', id_value=hook_hash, id_value_orig=hook_value_orig)
    elif idx % 2 == 0:
        # Add phone hook
        hook_hash = sorted(found_phone_hashes.keys())[0]
        hook_value_orig = found_phone_hashes[hook_hash]
        add_yuid_with_all_row(id_type='phone', id_value=hook_hash, id_value_orig=hook_value_orig)
    else:
        # Add email hook
        hook_hash = sorted(found_email_hashes.keys())[0]
        hook_value_orig = found_email_hashes[hook_hash]
        add_yuid_with_all_row(id_type='email', id_value=hook_hash, id_value_orig=hook_value_orig)

    we = white.WhiteEmail()
    partners_email_hashes_to_find.extend([k for k in sorted(found_email_hashes.keys()) if k != hook_hash])
    partners_emails_to_find.extend([
        we.process(found_email_hashes[other_hash])["value"] for other_hash in [k for k in sorted(found_email_hashes.keys()) if k != hook_hash]
    ])

    wp = white.WhitePhone()
    partners_phone_hashes_to_find.extend([k for k in sorted(found_phone_hashes.keys()) if k != hook_hash])
    partners_phones_to_find.extend([
        wp.process(found_phone_hashes[other_hash])["value"] for other_hash in [k for k in sorted(found_phone_hashes.keys()) if k != hook_hash]
    ])

# People search fixture
with open(os.path.join(dir_path, PEOPLE_SEARCH_FIXTURES_PATH)) as f:
    people_search_fixture = json.load(f)

for table_name, table_data in people_search_fixture.iteritems():
    table = SingleTableLog(
        path=table_name,
        default_data={}
    )
    for rec in table_data:
        table.add_row(**rec)
