import argparse
import logging

from crypta.dmp.adobe.bin.common.python import config_fields
from crypta.dmp.common import calc_sizes
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser(description="Calc yandexuid sizes and merge it with meta")
    parser.add_argument("--config", help="Config file path", required=True, type=yaml_config.load)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    logger.info("args: %s", args)
    config = args.config

    calc_sizes.run(
        yt_proxy=config[config_fields.YT_PROXY],
        yt_pool=config[config_fields.YT_POOL],
        yt_tmp_dir=config[config_fields.YT_TMP_DIR],
        meta_table=config[config_fields.META_TABLE],
        meta_with_sizes_table=config[config_fields.OUT_META_TABLE],
        yandexuid_bindings_table=config[config_fields.FILTERED_YANDEXUID_BINDINGS_TABLE]
    )
