#include "bindings_diff.h"

using namespace NCrypta::NDmp::NAdobe;

TBindingsDiff::TBindingsDiff(TString&& id, ui64 timestamp, TSegmentIds&& addedSegments, TSegmentIds&& removedSegments)
    : Id(std::move(id))
    , Timestamp(timestamp)
    , AddedSegments(std::move(addedSegments))
    , RemovedSegments(std::move(removedSegments))
{}

bool TBindingsDiff::operator==(const TBindingsDiff& rhs) const {
    return (Id == rhs.Id) && (Timestamp == rhs.Timestamp) && (AddedSegments == rhs.AddedSegments) && (RemovedSegments == rhs.RemovedSegments);
}

bool TBindingsDiff::operator!=(const TBindingsDiff& rhs) const {
    return !(*this == rhs);
}
