#pragma once

#include <crypta/dmp/common/data/segment_id.h>

#include <util/generic/set.h>
#include <util/generic/string.h>


namespace NCrypta::NDmp::NAdobe {
    struct TBindingsDiff {
        TBindingsDiff() = default;
        explicit TBindingsDiff(TString&& id, ui64 timestamp, TSegmentIds&& addedSegments, TSegmentIds&& removedSegments);

        bool operator==(const TBindingsDiff& rhs) const;
        bool operator!=(const TBindingsDiff& rhs) const;

        TString Id;
        ui64 Timestamp = 0;
        TSegmentIds AddedSegments;
        TSegmentIds RemovedSegments;
    };
}
