#include "bindings_diff_fields.h"
#include "bindings_diff_serializer.h"

#include <crypta/dmp/common/data/bindings_id_fields.h>

using namespace NCrypta::NDmp;
using namespace NAdobe;
using namespace NBindingsDiffFields;
using namespace NBindingsIdFields;

namespace {
    TSegmentIds ConvertSegmentsList(const NYT::TNode& node, const TString& fieldName) {
        TSegmentIds res;

        const auto& nodeMap = node.AsMap();
        const auto iter = nodeMap.find(fieldName);

        if (iter != nodeMap.end() && !iter->second.IsNull()) {
            for (const auto& segment : iter->second.AsList()) {
                res.insert(segment.AsUint64());
            }
        }
        return res;
    }
}

NYT::TNode NBindingsDiffSerializer::Serialize(const TBindingsDiff& bindingsDiff) {
    NYT::TNode addedSegments = NYT::TNode::CreateList();
    for (const auto& segment : bindingsDiff.AddedSegments) {
        addedSegments.Add(segment);
    }

    NYT::TNode removedSegments = NYT::TNode::CreateList();
    for (const auto& segment : bindingsDiff.RemovedSegments) {
        removedSegments.Add(segment);
    }

    NYT::TNode node;
    node[ID] = bindingsDiff.Id;
    node[TIMESTAMP] = bindingsDiff.Timestamp;
    if (!addedSegments.AsList().empty()) {
        node[ADDED_SEGMENTS] = std::move(addedSegments);
    }
    if (!removedSegments.AsList().empty()) {
        node[REMOVED_SEGMENTS] = std::move(removedSegments);
    }
    return node;
}

TBindingsDiff NBindingsDiffSerializer::Deserialize(const NYT::TNode& node) {
    TBindingsDiff bindingsDiff;
    bindingsDiff.Id = node.At(ID).AsString();
    bindingsDiff.Timestamp = node.At(TIMESTAMP).AsUint64();
    bindingsDiff.AddedSegments = ConvertSegmentsList(node, ADDED_SEGMENTS);
    bindingsDiff.RemovedSegments = ConvertSegmentsList(node, REMOVED_SEGMENTS);
    return bindingsDiff;
}
