#include "list_utils.h"
#include "upload_attrs_fields.h"

using namespace NCrypta;
using namespace NDmp::NAdobe;

namespace {
    ui64 GetUploadTime(const NYT::TNode& node) {
        return node.GetAttributes().At(UPLOAD_ATTRIBUTE_NAME).At(NUploadAttrsFields::TIMESTAMP).AsUint64();
    }
}

NYT::TNode::TListType NDmp::NAdobe::ListBindingsTables(NYT::IClientBasePtr client, const NYT::TYPath& path) {
    auto srcTables = client->List(path, NYT::TListOptions().AttributeFilter(NYT::TAttributeFilter().AddAttribute(UPLOAD_ATTRIBUTE_NAME)));
    Sort(srcTables, [](const auto& node1, const auto& node2) {
        return GetUploadTime(node1) < GetUploadTime(node2);
    });
    return srcTables;
}

