#include "bindings_diff_fields.h"
#include "parsed_iter_bindings_schema.h"

#include <crypta/dmp/common/data/bindings_id_fields.h>

using namespace NCrypta::NDmp;
using namespace NAdobe;
using namespace NBindingsDiffFields;
using namespace NBindingsIdFields;

NYT::TTableSchema NCrypta::NDmp::NAdobe::GetParsedIterBindingsSchema() {
    return NYT::TTableSchema().AddColumn(NYT::TColumnSchema().Name(ID).Type(NYT::VT_STRING, /*required*/ true))
                              .AddColumn(NYT::TColumnSchema().Name(TIMESTAMP).Type(NYT::VT_UINT64, /*required*/ true))
                              .AddColumn(ADDED_SEGMENTS, NYT::VT_ANY)
                              .AddColumn(REMOVED_SEGMENTS, NYT::VT_ANY)
                              .Strict(true);
}

NYT::TTableSchema NCrypta::NDmp::NAdobe::GetSortedParsedIterBindingsSchema() {
    auto schema = GetParsedIterBindingsSchema();
    schema.MutableColumns().at(0).SortOrder(NYT::SO_ASCENDING);
    return schema;
}
