import re


class Metadata(object):
    def __init__(self, destination_id, sync_mode, timestamp):
        self.destination_id = destination_id
        self.sync_mode = sync_mode
        self.timestamp = timestamp

    def __repr__(self):
        return str(self.__dict__)

    def __eq__(self, other):
        return self.__dict__ == other.__dict__


def parse(filename, extension_regexp=r"(info|sync|sync\.gz)"):
    pattern = r"^(S3)_(\d+)_(\d+)_(\w*)_(iter|full)_(\d{{13}})(-\d+)?\.{}$".format(extension_regexp)
    m = re.match(pattern, filename)
    if m is None:
        raise Exception("Invalid filename format: '{}'".format(filename))

    return Metadata(
        destination_id=int(m.group(2)),
        sync_mode=m.group(5),
        timestamp=int(m.group(6))
    )
