#include <crypta/dmp/adobe/bin/common/config_fields.h>
#include <crypta/dmp/adobe/bin/merge_yandexuid_bindings/lib/merge_yandexuid_bindings_job.h>

#include <crypta/lib/native/yt/job/runner.h>

#include <library/cpp/yaml/as/tstring.h>

using namespace NCrypta;
using namespace NDmp::NAdobe;

namespace {
    TMergeYandexuidJob::TConfig ParseConfig(const YAML::Node& yaml) {
        using namespace NConfigFields;

        TMergeYandexuidJob::TConfig config;
        config.YtProxy = yaml[YT_PROXY].as<TString>();
        config.YtPool = yaml[YT_POOL].as<TString>();

        config.InputDir = yaml[TYPED_YANDEXUID_BINDINGS_DIR].as<NYT::TYPath>();
        config.DstTable = yaml[ALL_TYPES_YANDEXUID_BINDINGS_TABLE].as<NYT::TYPath>();
        return config;
    }
}

int main(int argc, const char** argv) {
    return RunJob<TMergeYandexuidJob, ParseConfig>(argc, argv);
}
