#include "merge_yandexuid_bindings_job.h"

#include <crypta/dmp/common/data/bindings_id_fields.h>
#include <crypta/dmp/common/data/bindings_schema.h>
#include <crypta/dmp/common/merge_yandexuid_bindings/merge_yandexuid_bindings_reducer.h>
#include <crypta/lib/native/yt/utils/helpers.h>

#include <mapreduce/yt/common/config.h>
#include <mapreduce/yt/interface/client.h>
#include <util/string/vector.h>

using namespace NCrypta;
using namespace NDmp;
using namespace NAdobe;

TMergeYandexuidJob::TMergeYandexuidJob(const TConfig& config, NLog::TLogPtr log)
    : Config(config)
    , Log(log)
{
    Y_ENSURE(log != nullptr);
}

int TMergeYandexuidJob::Do() {
    auto client = NYT::CreateClient(Config.YtProxy);
    NYT::TConfig::Get()->Pool = Config.YtPool;

    const auto& srcTablesPaths = GetYtTables(client, Config.InputDir);
    Log->info("Processing tables: {}", JoinStrings(srcTablesPaths, ","));

    const auto dstTable = NYT::TRichYPath(Config.DstTable).Schema(GetYandexuidBindingsSchema())
                                                          .OptimizeFor(NYT::EOptimizeForAttr::OF_SCAN_ATTR);

    if (srcTablesPaths.size() != 1) {
        auto spec = NYT::TReduceOperationSpec().ReduceBy({NBindingsIdFields::YANDEXUID}).AddOutput<NYT::TNode>(dstTable);
        AddInputs<NYT::TNode>(spec, srcTablesPaths);
        client->Reduce(spec, new TMergeYandexuidBindingsReducer());
    } else {
        const auto& srcTablePath = srcTablesPaths.at(0);
        Log->info("Only one table found. Copying {} to {}", srcTablePath, dstTable.Path_);
        client->Copy(srcTablePath, dstTable.Path_);
    }

    Log->info("All tables successfully processed");
    return 0;
}
