#include <crypta/dmp/adobe/bin/common/config_fields.h>
#include <crypta/dmp/adobe/bin/parse_raw_bindings/lib/parse_raw_bindings_job.h>

#include <crypta/lib/native/yt/job/runner.h>

#include <library/cpp/yaml/as/tstring.h>

using namespace NCrypta;
using namespace NDmp::NAdobe;

namespace {
    TParseRawBindingsJob::TConfig ParseConfig(const YAML::Node& yaml) {
        using namespace NConfigFields;

        TParseRawBindingsJob::TConfig config;
        config.YtProxy = yaml[YT_PROXY].as<TString>();
        config.YtPool = yaml[YT_POOL].as<TString>();

        config.InputDir = yaml[RAW_EXT_ID_BINDINGS_DIR].as<NYT::TYPath>();
        config.OutputDir = yaml[PARSED_EXT_ID_BINDINGS_DIR].as<NYT::TYPath>();
        config.ErrorsDir = yaml[PARSE_BINDINGS_ERRORS_DIR].as<NYT::TYPath>();

        config.ErrorsTtl = yaml[ERRORS_TTL_DAYS].as<time_t>();
        config.ShouldDropInput = yaml[SHOULD_DROP_INPUT].as<bool>();

        return config;
    }
}

int main(int argc, const char** argv) {
    return RunJob<TParseRawBindingsJob, ParseConfig>(argc, argv);
}
