#pragma once

#include "raw_bindings_errors_fields.h"

#include <crypta/lib/native/yexception_utils/yexception_utils.h>
#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>
#include <util/generic/string.h>
#include <util/string/vector.h>
#include <util/system/types.h>

namespace NCrypta::NDmp::NAdobe {
    namespace NParseRawBindingsMapper {
        enum class EOutputTables {
            Bindings,
            Errors
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;
    }

    template<NYT::TNode(*ParseFunc)(const TString&, ui64)>
    class TParseRawBindingsMapper : public NYT::IMapper<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        TParseRawBindingsMapper() = default;

        explicit TParseRawBindingsMapper(const NParseRawBindingsMapper::TOutputIndexes& outputIndexes, ui64 timestamp)
            : OutputIndexes(outputIndexes)
            , Timestamp(timestamp)
        {}

        void Do(TReader* reader, TWriter* writer) override {
            for (; reader->IsValid(); reader->Next()) {
                const auto& rawBindings = reader->GetRow().At("raw").AsString();

                NYT::TNode outNode;
                try {
                    const auto& node = ParseFunc(rawBindings, Timestamp);
                    writer->AddRow(node, OutputIndexes[NParseRawBindingsMapper::EOutputTables::Bindings].GetRef());
                } catch (const yexception& exc) {
                    const auto node = NYT::TNode()(NRawBindingsErrorsFields::RAW, rawBindings)
                                                  (NRawBindingsErrorsFields::ERROR, RemovePathFromYexceptionMessage(exc.what()));

                    writer->AddRow(node, OutputIndexes[NParseRawBindingsMapper::EOutputTables::Errors].GetRef());
                }
            }
        }

        Y_SAVELOAD_JOB(OutputIndexes, Timestamp);

    private:
        NParseRawBindingsMapper::TOutputIndexes OutputIndexes;
        ui64 Timestamp = 0;
    };
}
