#include "raw_bindings_parse_utils.h"

#include <crypta/dmp/adobe/bin/common/bindings_diff_serializer.h>
#include <crypta/dmp/common/serializers/bindings_serializer.h>

#include <library/cpp/deprecated/split/delim_string_iter.h>
#include <util/string/split.h>

using namespace NCrypta;
using namespace NDmp;
using namespace NAdobe;

namespace {
    static constexpr char DELIMITER = ' ';

    struct TData {
        TData(TString&& id, TSegmentIds&& firstSegmentsList, TSegmentIds&& secondSegmentsList)
            : Id(std::move(id))
            , FirstSegmentsList(std::move(firstSegmentsList))
            , SecondSegmentsList(std::move(secondSegmentsList))
        {}

        TString Id;
        TSegmentIds FirstSegmentsList;
        TSegmentIds SecondSegmentsList;
    };

    TSegmentIds ParseSegmentIdsList(const TStringBuf& raw) {
        TSegmentIds res;
        if (!raw.empty()) {
            for (TDelimStringIter iter(raw, ","); iter.Valid();) {
                res.insert(iter.GetNext<TSegmentId>());
            }
        }
        return res;
    }

    TData ParseData(const TString& raw) {
        TString id;
        TStringBuf firstSegmentsList;
        TStringBuf secondSegmentsList;
        Split(raw, DELIMITER, id, firstSegmentsList, secondSegmentsList);
        return TData(std::move(id), ParseSegmentIdsList(firstSegmentsList), ParseSegmentIdsList(secondSegmentsList));
    }
}

TBindingsDiff NDmp::NAdobe::ParseRawBindingsDiff(const TString& raw, ui64 timestamp) {
    auto data = ParseData(raw);
    return TBindingsDiff(std::move(data.Id), timestamp, std::move(data.FirstSegmentsList), std::move(data.SecondSegmentsList));
}

TBindings NDmp::NAdobe::ParseRawBindings(const TString& raw, ui64 timestamp) {
    auto data = ParseData(raw);
    return TBindings(std::move(data.Id), timestamp, std::move(data.FirstSegmentsList));
}

NYT::TNode NDmp::NAdobe::ConvertRawBindingsDiffToNode(const TString& raw, ui64 timestamp) {
    return NBindingsDiffSerializer::Serialize(ParseRawBindingsDiff(raw, timestamp));
}

NYT::TNode NDmp::NAdobe::ConvertRawBindingsToNode(const TString& raw, ui64 timestamp) {
    return NIdBindingsSerializer::Serialize(ParseRawBindings(raw, timestamp));
}
