#include <crypta/dmp/adobe/bin/common/config_fields.h>
#include <crypta/dmp/adobe/bin/prepare_bindings_to_upload/lib/prepare_bindings_to_upload_job.h>
#include <crypta/lib/native/yt/job/runner.h>

#include <library/cpp/yaml/as/tstring.h>
#include <mapreduce/yt/interface/client.h>

using namespace NCrypta;
using namespace NDmp::NAdobe;

namespace {
    TPrepareBindingsToUploadJob::TConfig ParseConfig(const YAML::Node& yaml) {
        using namespace NConfigFields;

        TPrepareBindingsToUploadJob::TConfig config;
        config.YtProxy = yaml[YT_PROXY].as<TString>();
        config.YtPool = yaml[YT_POOL].as<TString>();

        config.MetaTable = yaml[META_TABLE].as<NYT::TYPath>();
        config.YandexuidBindingsTable = yaml[FILTERED_YANDEXUID_BINDINGS_TABLE].as<NYT::TYPath>();
        config.BbUploadStateTable = yaml[BB_UPLOAD_STATE_TABLE].as<NYT::TYPath>();
        config.ToBbCollectorDir = yaml[BB_COLLECTOR_FRESH_DIR].as<NYT::TYPath>();

        config.ErrorsDir = yaml[PREPARE_BINDINGS_TO_UPLOAD_ERRORS_DIR].as<NYT::TYPath>();
        config.ErrorsTtl = yaml[ERRORS_TTL_DAYS].as<time_t>();

        config.PrepareDataToBb = yaml[BB_UPLOAD_ENABLED].as<bool>();
        config.UploadTtl = yaml[BB_UPLOAD_TTL_DAYS].as<time_t>();
        config.DmpId = yaml[BB_UPLOAD_DMP_ID].as<ui64>();

        return config;
    }
}

int main(int argc, const char** argv) {
    return RunJob<TPrepareBindingsToUploadJob, ParseConfig>(argc, argv);
}
