#pragma once

#include <crypta/lib/native/log/log.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NDmp::NAdobe {
    class TPrepareBindingsToUploadJob {
    public:
        struct TConfig {
            TString YtProxy;
            TString YtPool;

            NYT::TYPath YandexuidBindingsTable;
            NYT::TYPath BbUploadStateTable;
            NYT::TYPath MetaTable;
            NYT::TYPath ToBbCollectorDir;
            NYT::TYPath ErrorsDir;
            time_t ErrorsTtl = 0;
            bool PrepareDataToBb = false;
            time_t UploadTtl = 0;
            ui64 DmpId = 0;
        };

        explicit TPrepareBindingsToUploadJob(const TConfig& config, NLog::TLogPtr log);

        int Do();

    private:
        const TConfig Config;
        NLog::TLogPtr Log;
    };
}
