#pragma once

#include <crypta/dmp/common/data/bb_upload_state.h>
#include <crypta/dmp/common/data/bindings.h>
#include <crypta/dmp/common/data/segment_id.h>
#include <crypta/lib/native/time/ttl.h>
#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>
#include <util/generic/hash_set.h>

namespace NCrypta::NDmp::NAdobe {
    class TPrepareBindingsToUploadReducer: public NYT::IReducer<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        static const ui64 YANDEXUID_BINDINGS_INDEX = 0;
        static const ui64 BB_UPLOAD_STATE_INDEX = 1;

        enum class EOutputTables {
            BbUploadState,
            ToCollector,
            Errors
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TPrepareBindingsToUploadReducer() = default;
        TPrepareBindingsToUploadReducer(const TOutputIndexes& outputIndexes, const THashSet<ui64>& segmentsIds, time_t uploadTtl, ui64 uploadTimestamp, ui64 dmpId);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(OutputIndexes, SegmentsIds, UploadTtl, UploadTimestamp, DmpId);

    private:
        bool NeedToUpload(const TBindings& bindings, const TMaybe<TBbUploadState>& bbUploadState) const;
        void WriteToCollector(TWriter* writer, const TBindings& bindings) const;
        void WriteBbUploadState(TWriter* writer, const TBbUploadState& bbUploadState) const;
        void WriteErrors(TWriter* writer, const TBindings& bindings, const TVector<TSegmentId>& unknownSegments) const;

        TOutputIndexes OutputIndexes;
        THashSet<ui64> SegmentsIds;
        TTtl UploadTtl;
        ui64 UploadTimestamp;
        ui64 DmpId;
    };
}
