import argparse
import logging
import os

import yt.wrapper as yt

from crypta.dmp.adobe.bin.common.python import config_fields
from crypta.dmp.adobe.bin.transfer_meta_to_yt.lib import transfer
from crypta.dmp.adobe.bin.transfer_meta_to_yt.lib.adobe_api_client import AdobeApiClient
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser(description="Transfer meta from Adobe to YT")
    parser.add_argument("--config", required=True, type=yaml_config.load)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    config = args.config
    logger.info(config)

    yt.config.set_proxy(config[config_fields.YT_PROXY])
    yt.config["write_retries"]["enable"] = True

    adobe_api_client = AdobeApiClient(client_id=os.environ["CRYPTA_ADOBE_API_CLIENT_ID"],
                                      secret=os.environ["CRYPTA_ADOBE_API_SECRET"],
                                      user=os.environ["CRYPTA_ADOBE_API_USER"],
                                      password=os.environ["CRYPTA_ADOBE_API_PASSWORD"])

    transfer.run(adobe_api_client,
                 yt,
                 destination_id=config[config_fields.DESTINATION_ID],
                 meta_table=config[config_fields.META_TABLE],
                 hierarchy=config[config_fields.HIERARCHY],
                 tariff=config[config_fields.TARIFF],
                 acl=config[config_fields.ACL])
